/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.managestudy.ViewStudySubjectServlet;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveStudySubjectServlet
extends SecureController {
    private static final long serialVersionUID = -8899184976727631108L;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS_SERVLET, respage.getString("current_study_locked"));
        this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS_SERVLET, respage.getString("current_study_frozen"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String studySubIdString = this.request.getParameter("id");
        String subIdString = this.request.getParameter("subjectId");
        String studyIdString = this.request.getParameter("studyId");
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        if (studySubIdString == null || studySubIdString.trim().isEmpty() || subIdString == null || subIdString.trim().isEmpty() || studyIdString == null || studyIdString.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_study_subject_to_remove"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
        } else {
            int studyId = Integer.valueOf(studyIdString.trim());
            int studySubId = Integer.valueOf(studySubIdString.trim());
            int subjectId = Integer.valueOf(subIdString.trim());
            SubjectBean subject = sdao.findByPK(subjectId);
            StudySubjectBean studySub = subdao.findByPK(studySubId);
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyBean study = studydao.findByPK(studyId);
            this.checkRoleByUserAndStudy(this.ub, study.getParentStudyId(), study.getId());
            StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
            ArrayList displayEvents = ViewStudySubjectServlet.getDisplayStudyEventsForStudySubject((StudySubjectBean)studySub, (DataSource)this.sm.getDataSource(), (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole);
            String action = this.request.getParameter("action");
            if ("confirm".equalsIgnoreCase(action)) {
                if (!studySub.getStatus().equals((Term)Status.AVAILABLE)) {
                    this.addPageMessage(respage.getString("this_subject_is_not_available_for_this_study") + " " + respage.getString("please_contact_sysadmin_for_more_information"));
                    this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
                    return;
                }
                this.request.setAttribute("subject", (Object)subject);
                this.request.setAttribute("study", (Object)study);
                this.request.setAttribute("studySub", (Object)studySub);
                this.request.setAttribute("events", (Object)displayEvents);
                this.forwardPage(Page.REMOVE_STUDY_SUBJECT);
            } else {
                logger.info("submit to remove the subject from study");
                studySub.setStatus(Status.DELETED);
                studySub.setUpdater(this.ub);
                studySub.setUpdatedDate(new Date());
                subdao.update(studySub);
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                for (int j = 0; j < displayEvents.size(); ++j) {
                    DisplayStudyEventBean dispEvent = (DisplayStudyEventBean)displayEvents.get(j);
                    StudyEventBean event = dispEvent.getStudyEvent();
                    if (event.getStatus().equals((Term)Status.DELETED)) continue;
                    event.setStatus(Status.AUTO_DELETED);
                    event.setUpdater(this.ub);
                    event.setUpdatedDate(new Date());
                    sedao.update(event);
                    ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
                    ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                    for (int k = 0; k < eventCRFs.size(); ++k) {
                        EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(k);
                        if (eventCRF.getStatus().equals((Term)Status.DELETED)) continue;
                        eventCRF.setStatus(Status.AUTO_DELETED);
                        eventCRF.setUpdater(this.ub);
                        eventCRF.setUpdatedDate(new Date());
                        ecdao.update(eventCRF);
                        ArrayList itemDatas = iddao.findAllByEventCRFId(eventCRF.getId());
                        for (int a = 0; a < itemDatas.size(); ++a) {
                            ItemDataBean item = (ItemDataBean)itemDatas.get(a);
                            if (item.getStatus().equals((Term)Status.DELETED)) continue;
                            item.setStatus(Status.AUTO_DELETED);
                            item.setUpdater(this.ub);
                            item.setUpdatedDate(new Date());
                            iddao.update(item);
                        }
                    }
                }
                String emailBody = respage.getString("the_subject") + " " + subject.getName() + " " + respage.getString("has_been_removed_from_the_study") + study.getName() + ".";
                this.addPageMessage(emailBody);
                this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
            }
        }
    }
}

