/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreCRFFromDefinitionServlet
extends SecureController {
    private static final long serialVersionUID = 5416925373611296853L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_permission_to_update_study_event_definition") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.STUDY_EVENT_DEFINITION_LIST, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        ArrayList edcs = ClassCastHelper.asArrayList((Object)this.session.getAttribute("eventDefinitionCRFs"), EventDefinitionCRFBean.class);
        String crfName = "";
        String idString = this.request.getParameter("id");
        logger.info("crf id:" + idString);
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
        this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
        if (idString == null || idString.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_restore"));
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        } else {
            int id = Integer.valueOf(idString.trim());
            for (int i = 0; i < edcs.size(); ++i) {
                EventDefinitionCRFBean edc = (EventDefinitionCRFBean)edcs.get(i);
                if (edc.getCrfId() != id) continue;
                edc.setStatus(Status.AVAILABLE);
                edc.setOldStatus(Status.DELETED);
                crfName = edc.getCrfName();
            }
            this.session.setAttribute("eventDefinitionCRFs", (Object)edcs);
            this.addPageMessage(crfName + " " + respage.getString("has_been_restored"));
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        }
    }
}

