/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.AddNewSubjectServlet;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class UpdateStudySubjectServlet
extends SecureController {
    private static final long serialVersionUID = -8773308388221272583L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        int studySubId;
        FormDiscrepancyNotes discNotes = null;
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String fromResolvingNotes = fp.getString("fromResolvingNotes", true);
        if (fromResolvingNotes == null || fromResolvingNotes.trim().isEmpty()) {
            this.session.removeAttribute("window_location");
            this.session.removeAttribute("notesTable");
            this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS_SERVLET, respage.getString("current_study_locked"));
            this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS_SERVLET, respage.getString("current_study_frozen"));
        }
        if ((studySubId = fp.getInt("id", true)) == 0) {
            this.addPageMessage(respage.getString("please_choose_study_subject_to_edit"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
        } else {
            String action = fp.getString("action", true);
            if (action == null || action.trim().isEmpty()) {
                this.addPageMessage(respage.getString("no_action_specified"));
                this.forwardPage(Page.LIST_STUDY_SUBJECTS);
                return;
            }
            StudySubjectBean sub = subdao.findByPK(studySubId);
            StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
            ArrayList groupMaps = sgmdao.findAllByStudySubject(studySubId);
            HashMap<Integer, SubjectGroupMapBean> gMaps = new HashMap<Integer, SubjectGroupMapBean>();
            for (int i = 0; i < groupMaps.size(); ++i) {
                SubjectGroupMapBean groupMap = (SubjectGroupMapBean)groupMaps.get(i);
                gMaps.put(new Integer(groupMap.getStudyGroupClassId()), groupMap);
            }
            StudyDAO stdao = new StudyDAO(this.sm.getDataSource());
            ArrayList classes = new ArrayList();
            if (!"submit".equalsIgnoreCase(action)) {
                int parentStudyId = this.currentStudy.getParentStudyId();
                if (parentStudyId > 0) {
                    StudyBean parentStudy = stdao.findByPK(parentStudyId);
                    classes = sgcdao.findAllActiveByStudy(parentStudy);
                } else {
                    classes = sgcdao.findAllActiveByStudy(this.currentStudy);
                }
                for (int i = 0; i < classes.size(); ++i) {
                    StudyGroupClassBean group = (StudyGroupClassBean)classes.get(i);
                    ArrayList studyGroups = sgdao.findAllByGroupClass(group);
                    group.setStudyGroups(studyGroups);
                    SubjectGroupMapBean gMap = (SubjectGroupMapBean)gMaps.get(new Integer(group.getId()));
                    if (gMap == null) continue;
                    group.setStudyGroupId(gMap.getStudyGroupId());
                    group.setGroupNotes(gMap.getNotes());
                }
                this.session.setAttribute("groups", (Object)classes);
            }
            if ("show".equalsIgnoreCase(action)) {
                this.session.setAttribute("studySub", (Object)sub);
                String enrollDateStr = sub.getEnrollmentDate() != null ? this.local_df.format(sub.getEnrollmentDate()) : "";
                this.session.setAttribute("enrollDateStr", (Object)enrollDateStr);
                discNotes = new FormDiscrepancyNotes();
                this.session.setAttribute("fdnotes", (Object)discNotes);
                this.forwardPage(Page.UPDATE_STUDY_SUBJECT);
            } else if ("confirm".equalsIgnoreCase(action)) {
                this.confirm(sgdao);
            } else if ("submit".equalsIgnoreCase(action)) {
                StudySubjectBean subject = (StudySubjectBean)this.session.getAttribute("studySub");
                subject.setUpdater(this.ub);
                subdao.update(subject);
                FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
                DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                AddNewSubjectServlet.saveFieldNotes((String)"enrollmentDate", (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)subject.getId(), (String)"studySub", (StudyBean)this.currentStudy);
                ArrayList groups = ClassCastHelper.asArrayList((Object)this.session.getAttribute("groups"), StudyGroupClassBean.class);
                if (!groups.isEmpty()) {
                    for (int i = 0; i < groups.size(); ++i) {
                        StudyGroupClassBean sgc = (StudyGroupClassBean)groups.get(i);
                        if (sgc.getStudyGroupId() == 0) {
                            ArrayList subjectGroups = sgmdao.findAllByStudySubject(subject.getId());
                            for (SubjectGroupMapBean groupBean : subjectGroups) {
                                sgmdao.deleteTestGroupMap(groupBean.getId());
                            }
                            continue;
                        }
                        SubjectGroupMapBean sgm = new SubjectGroupMapBean();
                        SubjectGroupMapBean gMap = (SubjectGroupMapBean)gMaps.get(new Integer(sgc.getId()));
                        sgm.setStudyGroupId(sgc.getStudyGroupId());
                        sgm.setNotes(sgc.getGroupNotes());
                        sgm.setStudyGroupClassId(sgc.getId());
                        sgm.setStudySubjectId(subject.getId());
                        sgm.setStatus(Status.AVAILABLE);
                        if (sgm.getStudyGroupId() <= 0) continue;
                        if (gMap != null && gMap.getId() > 0) {
                            sgm.setUpdater(this.ub);
                            sgm.setId(gMap.getId());
                            sgmdao.update(sgm);
                            continue;
                        }
                        sgm.setOwner(this.ub);
                        sgmdao.create(sgm);
                    }
                }
                this.addPageMessage(respage.getString("study_subject_updated_succesfully"));
                this.session.removeAttribute("studySub");
                this.session.removeAttribute("groups");
                this.session.removeAttribute("enrollDateStr");
                this.session.removeAttribute("fdnotes");
                this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            } else {
                this.addPageMessage(respage.getString("no_action_specified"));
                this.forwardPage(Page.LIST_STUDY_SUBJECTS);
                return;
            }
        }
    }

    private void confirm(StudyGroupDAO sgdao) throws Exception {
        ArrayList classes = ClassCastHelper.asArrayList((Object)this.session.getAttribute("groups"), StudyGroupClassBean.class);
        StudySubjectBean sub = (StudySubjectBean)ClassCastHelper.getAsType((Object)this.session.getAttribute("studySub"), StudySubjectBean.class);
        FormDiscrepancyNotes discNotes = (FormDiscrepancyNotes)ClassCastHelper.getAsType((Object)this.session.getAttribute("fdnotes"), FormDiscrepancyNotes.class);
        DiscrepancyValidator v = new DiscrepancyValidator(this.request, discNotes);
        FormProcessor fp = new FormProcessor(this.request);
        Date enrollDate = sub.getEnrollmentDate();
        if (this.ub.isSysAdmin() || this.currentRole.isManageStudy() || this.currentRole.isInvestigator() || this.currentStudy.getParentStudyId() > 0 && this.currentRole.isResearchAssistant() || this.currentStudy.getParentStudyId() > 0 && this.currentRole.isResearchAssistant2()) {
            v.addValidation("label", 1);
            v.addValidation("label", 47);
            v.addValidation("secondaryLabel", 47);
            String eDateString = fp.getString("enrollmentDate");
            if (eDateString != null && !eDateString.trim().isEmpty()) {
                v.addValidation("enrollmentDate", 4);
                v.alwaysExecuteLastValidation("enrollmentDate");
            }
            this.errors = v.validate();
            String label = fp.getString("label");
            if (label != null && !label.trim().isEmpty()) {
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean sub1 = ssdao.findAnotherBySameLabel(label.trim(), this.currentStudy.getId(), sub.getId());
                if (sub1.getId() == 0) {
                    sub1 = ssdao.findAnotherBySameLabelInSites(label.trim(), this.currentStudy.getId(), sub.getId());
                }
                if (sub1.getId() > 0) {
                    Validator.addError((HashMap)this.errors, (String)"label", (String)resexception.getString("subject_ID_used_by_another_choose_unique"));
                }
            }
            sub.setLabel(label);
            sub.setSecondaryLabel(fp.getString("secondaryLabel"));
            try {
                this.local_df.setLenient(false);
                enrollDate = eDateString != null && !eDateString.trim().isEmpty() ? this.local_df.parse(eDateString) : null;
            }
            catch (ParseException fe) {
                logger.warn("Enrollment Date cannot be parsed.");
            }
            sub.setEnrollmentDate(enrollDate);
        }
        String enrollDateStr = enrollDate != null ? this.local_df.format(enrollDate) : "";
        this.session.setAttribute("enrollDateStr", (Object)enrollDateStr);
        this.session.setAttribute("studySub", (Object)sub);
        if (!classes.isEmpty()) {
            for (int i = 0; i < classes.size(); ++i) {
                StudyGroupClassBean sgc = (StudyGroupClassBean)classes.get(i);
                int groupId = fp.getInt("studyGroupId" + i);
                String notes = fp.getString("notes" + i);
                v.addValidation("notes" + i, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
                sgc.setStudyGroupId(groupId);
                sgc.setGroupNotes(notes);
                if (groupId <= 0) continue;
                StudyGroupBean sgb = sgdao.findByPK(groupId);
                sgc.setStudyGroupName(sgb.getName());
            }
        }
        this.session.setAttribute("groups", (Object)classes);
        if (!this.errors.isEmpty()) {
            logger.info("has errors");
            String label = sub.getLabel();
            if (label == null || label.trim().isEmpty()) {
                this.addPageMessage(respage.getString("must_enter_subject_ID_for_identifying") + respage.getString("this_may_be_external_ID_number") + respage.getString("you_may_enter_study_subject_ID_listed") + respage.getString("study_subject_ID_should_not_contain_protected_information"));
            } else {
                StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean sub1 = subdao.findAnotherBySameLabel(label, sub.getStudyId(), sub.getId());
                if (sub1.getId() > 0) {
                    this.addPageMessage(resexception.getString("subject_ID_used_by_another_choose_unique"));
                }
            }
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.UPDATE_STUDY_SUBJECT);
        } else {
            this.forwardPage(Page.UPDATE_STUDY_SUBJECT_CONFIRM);
        }
    }
}

