/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewEventCRFServlet
extends SecureController {
    private static final long serialVersionUID = -6371577705431646195L;

    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int eventCRFId = fp.getInt("id", true);
        int studySubId = fp.getInt("studySubId", true);
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        SectionDAO secdao = new SectionDAO(this.sm.getDataSource());
        if (eventCRFId == 0) {
            this.addPageMessage(respage.getString("please_choose_an_event_CRF_to_view"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
        } else {
            StudySubjectBean studySub = subdao.findByPK(studySubId);
            this.request.setAttribute("studySub", (Object)studySub);
            EventCRFBean eventCRF = ecdao.findByPK(eventCRFId);
            CRFBean crf = cdao.findByVersionId(eventCRF.getCRFVersionId());
            this.request.setAttribute("crf", (Object)crf);
            ArrayList sections = secdao.findAllByCRFVersionId(eventCRF.getCRFVersionId());
            for (int j = 0; j < sections.size(); ++j) {
                SectionBean section = (SectionBean)sections.get(j);
                ArrayList itemData = iddao.findAllByEventCRFId(eventCRFId);
                ArrayList<DisplayItemBean> displayItemData = new ArrayList<DisplayItemBean>();
                for (int i = 0; i < itemData.size(); ++i) {
                    ItemDataBean id = (ItemDataBean)itemData.get(i);
                    DisplayItemBean dib = new DisplayItemBean();
                    ItemBean item = idao.findByPK(id.getItemId());
                    ItemFormMetadataBean ifm = ifmdao.findByItemIdAndCRFVersionId(item.getId(), eventCRF.getCRFVersionId());
                    item.setItemMeta(ifm);
                    dib.setItem(item);
                    dib.setData(id);
                    dib.setMetadata(ifm);
                    displayItemData.add(dib);
                }
                section.setItems(displayItemData);
            }
            this.request.setAttribute("sections", (Object)sections);
            this.request.setAttribute("studySubId", (Object)new Integer(studySubId).toString());
            this.forwardPage(Page.VIEW_EVENT_CRF);
        }
    }
}

