/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.submit.DisplaySubjectBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AddNewSubjectServlet
extends SecureController {
    private static final long serialVersionUID = 8547182499466284586L;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Object simpleLockObj = new Object();
    public static final String INPUT_UNIQUE_IDENTIFIER = "uniqueIdentifier";
    public static final String INPUT_DOB = "dob";
    public static final String INPUT_YOB = "yob";
    public static final String INPUT_GENDER = "gender";
    public static final String INPUT_LABEL = "label";
    public static final String INPUT_SECONDARY_LABEL = "secondaryLabel";
    public static final String INPUT_ENROLLMENT_DATE = "enrollmentDate";
    public static final String INPUT_EVENT_START_DATE = "startDate";
    public static final String INPUT_GROUP = "group";
    public static final String FORM_DISCREPANCY_NOTES_NAME = "fdnotes";
    public static final String BEAN_GROUPS = "groups";
    public static final String SUBMIT_EVENT_BUTTON = "submitEvent";
    public static final String SUBMIT_ENROLL_BUTTON = "submitEnroll";
    public static final String SUBMIT_DONE_BUTTON = "submitDone";
    public static final String EDIT_DOB = "editDob";
    public static final String EXISTING_SUB_SHOWN = "existingSubShown";
    public static final String STUDY_EVENT_DEFINITION = "studyEventDefinition";
    public static final String LOCATION = "location";
    String DOB = "";
    String YOB = "";
    String GENDER = "";
    public static final String G_WARNING = "gWarning";
    public static final String D_WARNING = "dWarning";
    public static final String Y_WARNING = "yWarning";
    boolean needUpdate;
    SubjectBean updateSubject = new SubjectBean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest() throws Exception {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_frozen"));
        StudySubjectDAO ssd = new StudySubjectDAO(this.sm.getDataSource());
        StudyDAO stdao = new StudyDAO(this.sm.getDataSource());
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        ArrayList classes = new ArrayList();
        this.panel.setStudyInfoShown(false);
        FormProcessor fp = new FormProcessor(this.request);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        int parentStudyId = this.currentStudy.getParentStudyId();
        if (parentStudyId <= 0) {
            parentStudyId = this.currentStudy.getId();
            classes = sgcdao.findAllActiveByStudy(this.currentStudy);
        } else {
            StudyBean parentStudy = stdao.findByPK(parentStudyId);
            classes = sgcdao.findAllActiveByStudy(parentStudy);
        }
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        StudyParameterValueBean parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "collectDob");
        this.currentStudy.getStudyParameterConfig().setCollectDob(parentSPV.getValue());
        parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "genderRequired");
        this.currentStudy.getStudyParameterConfig().setGenderRequired(parentSPV.getValue());
        StudyParameterValueBean checkPersonId = spvdao.findByHandleAndStudy(parentStudyId, "subjectPersonIdRequired");
        this.currentStudy.getStudyParameterConfig().setSubjectPersonIdRequired(checkPersonId.getValue());
        if (!fp.isSubmitted()) {
            if (fp.getBoolean("instr")) {
                this.session.removeAttribute("fdnotes");
                this.forwardPage(Page.INSTRUCTIONS_ENROLL_SUBJECT);
            } else {
                this.setUpBeans(classes);
                Date today = new Date(System.currentTimeMillis());
                String todayFormatted = this.local_df.format(today);
                fp.addPresetValue("enrollmentDate", todayFormatted);
                String idSetting = "";
                if (this.currentStudy.getParentStudyId() > 0) {
                    parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "subjectIdGeneration");
                    this.currentStudy.getStudyParameterConfig().setSubjectIdGeneration(parentSPV.getValue());
                }
                idSetting = this.currentStudy.getStudyParameterConfig().getSubjectIdGeneration();
                this.logger.info("subject id setting :" + idSetting);
                if (idSetting.equals("auto editable") || idSetting.equals("auto non-editable")) {
                    fp.addPresetValue("label", resword.getString("id_generated_Save_Add"));
                }
                this.setPresetValues(fp.getPresetValues());
                FormDiscrepancyNotes discNotes = new FormDiscrepancyNotes();
                this.session.setAttribute("fdnotes", (Object)discNotes);
                this.forwardPage(Page.ADD_NEW_SUBJECT);
            }
        } else {
            String dobSetting;
            FormDiscrepancyNotes discNotes;
            if (!fp.getBoolean("existingSubShown")) {
                this.DOB = fp.getString("dob");
                this.YOB = fp.getString("yob");
                this.GENDER = fp.getString("gender");
            }
            if ((discNotes = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes")) == null) {
                discNotes = new FormDiscrepancyNotes();
            }
            DiscrepancyValidator v = new DiscrepancyValidator(this.request, discNotes);
            v.addValidation("label", 1);
            String subIdSetting = this.currentStudy.getStudyParameterConfig().getSubjectIdGeneration();
            if (!subIdSetting.equalsIgnoreCase("auto non-editable") && !subIdSetting.equalsIgnoreCase("auto editable")) {
                v.addValidation("label", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 30);
            }
            if (this.currentStudy.getStudyParameterConfig().getSubjectPersonIdRequired().equals("required")) {
                v.addValidation("uniqueIdentifier", 1);
            }
            v.addValidation("uniqueIdentifier", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
            if (!StringUtils.isBlank((String)fp.getString("secondaryLabel"))) {
                v.addValidation("secondaryLabel", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 30);
            }
            if ((dobSetting = this.currentStudy.getStudyParameterConfig().getCollectDob()).equals("1")) {
                v.addValidation("dob", 4);
                if (!StringUtils.isBlank((String)fp.getString("INPUT_DOB"))) {
                    v.alwaysExecuteLastValidation("dob");
                }
                v.addValidation("dob", 28);
            } else if (dobSetting.equals("2")) {
                v.addValidation("yob", 10);
                v.alwaysExecuteLastValidation("yob");
                v.addValidation("yob", 18, NumericComparisonOperator.GREATER_THAN_OR_EQUAL_TO, 1000);
                Date today = new Date();
                Calendar c = Calendar.getInstance();
                c.setTime(today);
                int currentYear = c.get(1);
                v.addValidation("yob", 18, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, currentYear);
            } else {
                this.logger.info("should read this only if DOB not used");
            }
            ArrayList<String> acceptableGenders = new ArrayList<String>();
            acceptableGenders.add("m");
            acceptableGenders.add("f");
            if (!this.currentStudy.getStudyParameterConfig().getGenderRequired().equals("false")) {
                v.addValidation("gender", 14, acceptableGenders);
            }
            v.addValidation("enrollmentDate", 4);
            v.alwaysExecuteLastValidation("enrollmentDate");
            v.addValidation("enrollmentDate", 28);
            boolean locationError = false;
            if (fp.getBoolean("addWithEvent")) {
                v.addValidation("startDate", 4);
                v.alwaysExecuteLastValidation("startDate");
                if (this.currentStudy.getStudyParameterConfig().getEventLocationRequired().equalsIgnoreCase("required")) {
                    v.addValidation("location", 1);
                    locationError = true;
                }
            }
            HashMap errors = v.validate();
            SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
            String uniqueIdentifier = fp.getString("uniqueIdentifier");
            SubjectBean subjectWithSameId = new SubjectBean();
            boolean showExistingRecord = false;
            if (!uniqueIdentifier.equals("")) {
                boolean subjectWithSameIdInCurrentStudyTree = false;
                subjectWithSameId = sdao.findByUniqueIdentifierAndStudy(uniqueIdentifier, this.currentStudy.getId());
                if (subjectWithSameId.isActive()) {
                    Validator.addError((HashMap)errors, (String)"uniqueIdentifier", (String)(resexception.getString("subject_with_person_ID") + " " + uniqueIdentifier + " " + resexception.getString("is_already_enrolled_in_this_study")));
                    subjectWithSameIdInCurrentStudyTree = true;
                    this.logger.info("just added unique id in study tree");
                } else {
                    subjectWithSameId = sdao.findByUniqueIdentifierAndParentStudy(uniqueIdentifier, this.currentStudy.getId());
                    if (subjectWithSameId.isActive()) {
                        StudySubjectBean ssub = ssd.findBySubjectIdAndStudy(subjectWithSameId.getId(), this.currentStudy);
                        StudyBean site = stdao.findByPK(ssub.getStudyId());
                        Validator.addError((HashMap)errors, (String)"uniqueIdentifier", (String)(resexception.getString("this_subject_person_ID") + " " + uniqueIdentifier + resexception.getString("has_already_enrolled_site") + site.getName() + resexception.getString("of_current_study_need_to_move") + resexception.getString("please_have_user_manage_privileges")));
                        subjectWithSameIdInCurrentStudyTree = true;
                    } else {
                        subjectWithSameId = sdao.findByUniqueIdentifierAndStudy(uniqueIdentifier, this.currentStudy.getParentStudyId());
                        if (subjectWithSameId.isActive()) {
                            Validator.addError((HashMap)errors, (String)"uniqueIdentifier", (String)(resexception.getString("this_subject_with_person_ID") + " " + uniqueIdentifier + resexception.getString("has_already_enrolled_parent_study")));
                            subjectWithSameIdInCurrentStudyTree = true;
                        } else {
                            subjectWithSameId = sdao.findByUniqueIdentifierAndParentStudy(uniqueIdentifier, this.currentStudy.getParentStudyId());
                            if (subjectWithSameId.isActive()) {
                                Validator.addError((HashMap)errors, (String)"uniqueIdentifier", (String)(resexception.getString("this_subject_with_person_ID") + " " + uniqueIdentifier + resexception.getString("has_already_enrolled_site_study")));
                                subjectWithSameIdInCurrentStudyTree = true;
                            }
                        }
                    }
                }
                if (!subjectWithSameIdInCurrentStudyTree && (subjectWithSameId = sdao.findByUniqueIdentifier(uniqueIdentifier)).isActive()) {
                    showExistingRecord = true;
                }
            }
            String label = fp.getString("label");
            String personId = fp.getString("uniqueIdentifier");
            String secondaryLable = fp.getString("secondaryLabel");
            if (label.contains("<") || label.contains(">")) {
                Validator.addError((HashMap)errors, (String)"label", (String)resexception.getString("study_subject_id_can_not_contain_html_lessthan_or_greaterthan_elements"));
            }
            if (secondaryLable.contains("<") || secondaryLable.contains(">")) {
                Validator.addError((HashMap)errors, (String)"secondaryLabel", (String)resexception.getString("secondary_id_can_not_contain_html_lessthan_or_greaterthan_elements"));
            }
            if (personId.contains("<") || personId.contains(">")) {
                Validator.addError((HashMap)errors, (String)"uniqueIdentifier", (String)resexception.getString("person_id_can_not_contain_html_lessthan_or_greaterthan_elements"));
            }
            if (!label.equalsIgnoreCase(resword.getString("id_generated_Save_Add"))) {
                StudySubjectBean subjectWithSameLabel = ssd.findByLabelAndStudy(label, this.currentStudy);
                StudySubjectBean subjectWithSameLabelInParent = new StudySubjectBean();
                if (this.currentStudy.getParentStudyId() > 0) {
                    subjectWithSameLabelInParent = ssd.findSameByLabelAndStudy(label, this.currentStudy.getParentStudyId(), 0);
                }
                if (subjectWithSameLabel.isActive() || subjectWithSameLabelInParent.isActive()) {
                    Validator.addError((HashMap)errors, (String)"label", (String)resexception.getString("another_assigned_this_ID_choose_unique"));
                }
            }
            if (!classes.isEmpty()) {
                for (int i = 0; i < classes.size(); ++i) {
                    StudyGroupClassBean sgc = (StudyGroupClassBean)classes.get(i);
                    int groupId = fp.getInt("studyGroupId" + i);
                    String notes = fp.getString("notes" + i);
                    if ("Required".equals(sgc.getSubjectAssignment()) && groupId == 0) {
                        Validator.addError((HashMap)errors, (String)("studyGroupId" + i), (String)resexception.getString("group_class_is_required"));
                    }
                    if (notes.trim().length() > 255) {
                        Validator.addError((HashMap)errors, (String)("notes" + i), (String)resexception.getString("notes_cannot_longer_255"));
                    }
                    sgc.setStudyGroupId(groupId);
                    sgc.setGroupNotes(notes);
                }
            }
            if (!errors.isEmpty()) {
                this.addPageMessage(respage.getString("there_were_some_errors_submission"));
                if (locationError) {
                    this.addPageMessage(respage.getString("location_blank_error"));
                }
                this.setInputMessages(errors);
                fp.addPresetValue("dob", fp.getString("dob"));
                fp.addPresetValue("yob", fp.getString("yob"));
                fp.addPresetValue("gender", fp.getString("gender"));
                fp.addPresetValue("uniqueIdentifier", uniqueIdentifier);
                fp.addPresetValue("label", label);
                fp.addPresetValue("secondaryLabel", fp.getString("secondaryLabel"));
                fp.addPresetValue("enrollmentDate", fp.getString("enrollmentDate"));
                fp.addPresetValue("startDate", fp.getString("startDate"));
                fp.addPresetValue("studyEventDefinition", fp.getInt("studyEventDefinition"));
                fp.addPresetValue("location", fp.getString("location"));
                fp.addPresetValue("editDob", fp.getString("editDob"));
                this.setPresetValues(fp.getPresetValues());
                this.setUpBeans(classes);
                boolean existingSubShown = fp.getBoolean("existingSubShown");
                if (!existingSubShown) {
                    String isSubjectOverlay = fp.getRequest().getParameter("subjectOverlay");
                    if (isSubjectOverlay != null) {
                        String location;
                        int eventId = fp.getInt("studyEventDefinition");
                        if (eventId < 1) {
                            Validator.addError((HashMap)errors, (String)"studyEventDefinition", (String)resexception.getString("input_not_acceptable_option"));
                        }
                        if ((location = fp.getString("location")) == null || location.trim().length() == 0) {
                            Validator.addError((HashMap)errors, (String)"location", (String)resexception.getString("field_not_blank"));
                        }
                        this.request.setAttribute("showOverlay", (Object)true);
                        this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
                    } else {
                        this.forwardPage(Page.ADD_NEW_SUBJECT);
                    }
                } else {
                    this.forwardPage(Page.ADD_EXISTING_SUBJECT);
                }
            } else {
                String[] subjectFields;
                StudySubjectBean studySubject = new StudySubjectBean();
                SubjectBean subject = new SubjectBean();
                boolean existingSubShown = fp.getBoolean("existingSubShown");
                if (showExistingRecord && !existingSubShown) {
                    String y;
                    this.needUpdate = false;
                    subject = subjectWithSameId;
                    Calendar cal = Calendar.getInstance();
                    int year = 0;
                    if (subject.getDateOfBirth() != null) {
                        cal.setTime(subject.getDateOfBirth());
                        year = cal.get(1);
                        fp.addPresetValue("dob", this.local_df.format(subject.getDateOfBirth()));
                    } else {
                        fp.addPresetValue("dob", "");
                    }
                    if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("1") && !subject.isDobCollected()) {
                        fp.addPresetValue("dob", fp.getString("dob"));
                    }
                    fp.addPresetValue("yob", String.valueOf(year));
                    if (!this.currentStudy.getStudyParameterConfig().getGenderRequired().equals("false")) {
                        fp.addPresetValue("gender", subject.getGender() + "");
                    } else {
                        fp.addPresetValue("gender", "");
                    }
                    if (!label.equalsIgnoreCase(resword.getString("id_generated_Save_Add"))) {
                        fp.addPresetValue("label", label);
                    }
                    fp.addPresetValue("secondaryLabel", fp.getString("secondaryLabel"));
                    fp.addPresetValue("enrollmentDate", fp.getString("enrollmentDate"));
                    fp.addPresetValue("startDate", fp.getString("startDate"));
                    fp.addPresetValue("uniqueIdentifier", subject.getUniqueIdentifier());
                    this.setPresetValues(fp.getPresetValues());
                    this.setUpBeans(classes);
                    int warningCount = 0;
                    if (this.currentStudy.getStudyParameterConfig().getGenderRequired().equalsIgnoreCase("true")) {
                        if (String.valueOf(subjectWithSameId.getGender()).equals(" ")) {
                            fp.addPresetValue("gWarning", "emptytrue");
                            fp.addPresetValue("gender", this.GENDER);
                            this.needUpdate = true;
                            this.updateSubject = subjectWithSameId;
                            this.updateSubject.setGender(this.GENDER.toCharArray()[0]);
                            ++warningCount;
                        } else if (!String.valueOf(subjectWithSameId.getGender()).equals(this.GENDER)) {
                            fp.addPresetValue("gWarning", "true");
                            ++warningCount;
                        } else {
                            fp.addPresetValue("gWarning", "false");
                        }
                    } else {
                        fp.addPresetValue("gWarning", "false");
                    }
                    if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
                        if (!subjectWithSameId.isDobCollected()) {
                            this.needUpdate = true;
                            this.updateSubject = subjectWithSameId;
                            this.updateSubject.setDobCollected(true);
                            if (subjectWithSameId.getDateOfBirth() == null) {
                                fp.addPresetValue("dob", this.DOB);
                                this.updateSubject.setDateOfBirth(new Date(this.DOB));
                            } else {
                                y = String.valueOf(subjectWithSameId.getDateOfBirth()).split("\\-")[0];
                                String[] d = this.DOB.split("\\/");
                                if (!y.equals("0001")) {
                                    if (!y.equals(d[2])) {
                                        fp.addPresetValue("dWarning", "dobYearWrong");
                                        fp.addPresetValue("dob", d[0] + "/" + d[1] + "/" + y);
                                        this.updateSubject.setDateOfBirth(sdf.parse(d[0] + "/" + d[1] + "/" + y));
                                    } else {
                                        fp.addPresetValue("dWarning", "dobUsed");
                                        fp.addPresetValue("dob", this.DOB);
                                        this.updateSubject.setDateOfBirth(sdf.parse(this.DOB));
                                    }
                                } else {
                                    fp.addPresetValue("dWarning", "emptyD");
                                    fp.addPresetValue("dob", this.DOB);
                                    this.updateSubject.setDateOfBirth(sdf.parse(this.DOB));
                                }
                            }
                            ++warningCount;
                        } else if (!this.local_df.format(subjectWithSameId.getDateOfBirth()).toString().equals(this.DOB)) {
                            fp.addPresetValue("dWarning", "currentDOBWrong");
                            ++warningCount;
                        } else {
                            fp.addPresetValue("dWarning", "false");
                        }
                    } else if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
                        y = String.valueOf(subjectWithSameId.getDateOfBirth()).split("\\-")[0];
                        if (!y.equals("0001")) {
                            if (!y.equals(this.YOB)) {
                                fp.addPresetValue("yWarning", "yobWrong");
                                ++warningCount;
                            } else {
                                fp.addPresetValue("yWarning", "false");
                            }
                        } else {
                            this.needUpdate = true;
                            this.updateSubject = subjectWithSameId;
                            fp.addPresetValue("yWarning", "yearEmpty");
                            fp.addPresetValue("yob", this.YOB);
                            this.updateSubject.setDateOfBirth(sdf.parse("01/01/" + this.YOB));
                            ++warningCount;
                        }
                    } else {
                        fp.addPresetValue("yWarning", "false");
                    }
                    if (warningCount > 0) {
                        warningCount = 0;
                        this.forwardPage(Page.ADD_EXISTING_SUBJECT);
                        return;
                    }
                }
                if (!showExistingRecord) {
                    if (!StringUtil.isBlank((String)fp.getString("gender"))) {
                        subject.setGender(fp.getString("gender").charAt(0));
                    } else {
                        subject.setGender(' ');
                    }
                    subject.setUniqueIdentifier(uniqueIdentifier);
                    if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
                        if (!StringUtil.isBlank((String)fp.getString("dob"))) {
                            subject.setDateOfBirth(fp.getDate("dob"));
                            subject.setDobCollected(true);
                        } else {
                            subject.setDateOfBirth(null);
                            subject.setDobCollected(false);
                        }
                    } else if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
                        subject.setDobCollected(false);
                        int yob = fp.getInt("yob");
                        Date fakeDate = new Date("01/01/" + yob);
                        String dobString = this.local_df.format(fakeDate);
                        try {
                            Date fakeDOB = this.local_df.parse(dobString);
                            subject.setDateOfBirth(fakeDOB);
                        }
                        catch (ParseException pe) {
                            subject.setDateOfBirth(new Date());
                            this.addPageMessage(respage.getString("problem_happened_saving_year"));
                        }
                    }
                    subject.setStatus(Status.AVAILABLE);
                    subject.setOwner(this.ub);
                    subject = sdao.create(subject);
                    if (!subject.isActive()) {
                        throw new OpenClinicaException(resexception.getString("could_not_create_subject"), "3");
                    }
                } else if (existingSubShown) {
                    if (!this.needUpdate) {
                        subject = subjectWithSameId;
                    } else {
                        this.updateSubject.setUpdater(this.ub);
                        this.updateSubject = sdao.update(this.updateSubject);
                        if (!this.updateSubject.isActive()) {
                            throw new OpenClinicaException("Could not create subject.", "5");
                        }
                        subject = this.updateSubject;
                        this.needUpdate = false;
                    }
                }
                studySubject.setSubjectId(subject.getId());
                studySubject.setStudyId(this.currentStudy.getId());
                studySubject.setLabel(fp.getString("label"));
                studySubject.setSecondaryLabel(fp.getString("secondaryLabel"));
                studySubject.setStatus(Status.AVAILABLE);
                studySubject.setEnrollmentDate(fp.getDate("enrollmentDate"));
                if (fp.getBoolean("addWithEvent")) {
                    studySubject.setEventStartDate(fp.getDate("startDate"));
                }
                studySubject.setOwner(this.ub);
                if (fp.getString("label").equalsIgnoreCase(resword.getString("id_generated_Save_Add"))) {
                    Object yob = this.simpleLockObj;
                    synchronized (yob) {
                        int nextLabel = ssd.findTheGreatestLabel() + 1;
                        studySubject.setLabel(nextLabel + "");
                        studySubject = ssd.createWithoutGroup(studySubject);
                        if (showExistingRecord && !existingSubShown) {
                            fp.addPresetValue("label", label);
                        }
                    }
                } else {
                    studySubject = ssd.createWithoutGroup(studySubject);
                }
                if (!classes.isEmpty() && studySubject.isActive()) {
                    SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
                    for (int i = 0; i < classes.size(); ++i) {
                        StudyGroupClassBean group = (StudyGroupClassBean)classes.get(i);
                        String[] map = new SubjectGroupMapBean();
                        map.setNotes(group.getGroupNotes());
                        map.setStatus(Status.AVAILABLE);
                        map.setStudyGroupId(group.getStudyGroupId());
                        map.setStudySubjectId(studySubject.getId());
                        map.setStudyGroupClassId(group.getId());
                        map.setOwner(this.ub);
                        if (map.getStudyGroupId() <= 0) continue;
                        sgmdao.create((SubjectGroupMapBean)map);
                    }
                }
                if (!studySubject.isActive()) {
                    throw new OpenClinicaException(resexception.getString("could_not_create_study_subject"), "4");
                }
                FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
                DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                for (String element : subjectFields = new String[]{"dob", "yob", "gender"}) {
                    AddNewSubjectServlet.saveFieldNotes((String)element, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)subject.getId(), (String)"subject", (StudyBean)this.currentStudy);
                }
                AddNewSubjectServlet.saveFieldNotes((String)"enrollmentDate", (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studySubject.getId(), (String)"studySub", (StudyBean)this.currentStudy);
                this.request.removeAttribute("submitted");
                this.request.setAttribute("studySubject", (Object)studySubject);
                this.request.setAttribute("requestStudySubject", (Object)"no");
                this.request.setAttribute("submitted", (Object)"0");
                this.addPageMessage(respage.getString("subject_with_unique_identifier") + studySubject.getLabel() + respage.getString("X_was_created_succesfully"));
                if (fp.getBoolean("addWithEvent")) {
                    this.createStudyEvent(fp, studySubject);
                    this.request.setAttribute("id", (Object)(studySubject.getId() + ""));
                    this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
                    return;
                }
                String submitEvent = fp.getString("submitEvent");
                String submitEnroll = fp.getString("submitEnroll");
                this.session.removeAttribute("fdnotes");
                if (!StringUtil.isBlank((String)submitEvent)) {
                    this.forwardPage(Page.CREATE_NEW_STUDY_EVENT_SERVLET);
                } else if (!StringUtil.isBlank((String)submitEnroll)) {
                    this.setUpBeans(classes);
                    Date today = new Date(System.currentTimeMillis());
                    String todayFormatted = this.local_df.format(today);
                    fp.addPresetValue("enrollmentDate", todayFormatted);
                    String idSetting = "";
                    if (this.currentStudy.getParentStudyId() > 0) {
                        parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "subjectIdGeneration");
                        this.currentStudy.getStudyParameterConfig().setSubjectIdGeneration(parentSPV.getValue());
                    }
                    idSetting = this.currentStudy.getStudyParameterConfig().getSubjectIdGeneration();
                    this.logger.info("subject id setting :" + idSetting);
                    if (idSetting.equals("auto editable") || idSetting.equals("auto non-editable")) {
                        fp.addPresetValue("label", resword.getString("id_generated_Save_Add"));
                    }
                    this.setPresetValues(fp.getPresetValues());
                    discNotes = new FormDiscrepancyNotes();
                    this.session.setAttribute("fdnotes", (Object)discNotes);
                    this.forwardPage(Page.ADD_NEW_SUBJECT);
                } else {
                    this.request.setAttribute("id", (Object)(studySubject.getId() + ""));
                    this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
                    return;
                }
            }
        }
    }

    protected void createStudyEvent(FormProcessor fp, StudySubjectBean s) throws OpenClinicaException {
        int studyEventDefinitionId = fp.getInt("studyEventDefinition");
        String location = fp.getString("location");
        Date startDate = s.getEventStartDate();
        if (studyEventDefinitionId > 0) {
            String locationTerm = resword.getString("location");
            if (location.equalsIgnoreCase(locationTerm)) {
                this.addPageMessage(restext.getString("not_a_valid_location"));
            } else {
                this.logger.info("will create event with new subject");
                StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
                StudyEventBean se = new StudyEventBean();
                se.setLocation(location);
                se.setDateStarted(startDate);
                se.setDateEnded(startDate);
                se.setOwner(this.ub);
                se.setStudyEventDefinitionId(studyEventDefinitionId);
                se.setStatus(Status.AVAILABLE);
                se.setStudySubjectId(s.getId());
                se.setSubjectEventStatus(SubjectEventStatus.SCHEDULED);
                StudyEventDefinitionBean sed = seddao.findByPK(studyEventDefinitionId);
                se.setSampleOrdinal(sedao.getMaxSampleOrdinal(sed, s) + 1);
                sedao.create(se);
            }
        } else {
            this.addPageMessage(respage.getString("no_event_sheduled_for_subject"));
        }
    }

    protected void mayProceed() throws InsufficientPermissionException {
        String exceptionName = resexception.getString("no_permission_to_add_new_subject");
        String noAccessMessage = respage.getString("may_not_add_new_subject") + " " + respage.getString("change_study_contact_sysadmin");
        if (SubmitDataServlet.maySubmitData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(noAccessMessage);
        throw new InsufficientPermissionException(Page.MENU_SERVLET, exceptionName, "1");
    }

    protected void setUpBeans(ArrayList<StudyGroupClassBean> classes) throws Exception {
        StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
        for (int i = 0; i < classes.size(); ++i) {
            StudyGroupClassBean group = classes.get(i);
            ArrayList studyGroups = sgdao.findAllByGroupClass(group);
            group.setStudyGroups(studyGroups);
        }
        this.request.setAttribute("groups", classes);
    }

    public static void saveFieldNotes(String field, FormDiscrepancyNotes notes, DiscrepancyNoteDAO dndao, int entityId, String entityType, StudyBean sb) throws OpenClinicaException {
        AddNewSubjectServlet.saveFieldNotes((String)field, (FormDiscrepancyNotes)notes, (DiscrepancyNoteDAO)dndao, (int)entityId, (String)entityType, (StudyBean)sb, (int)-1);
    }

    public static void saveFieldNotes(String field, FormDiscrepancyNotes notes, DiscrepancyNoteDAO dndao, int entityId, String entityType, StudyBean sb, int event_crf_id) throws OpenClinicaException {
        if (notes == null || dndao == null || sb == null) {
            return;
        }
        ArrayList fieldNotes = notes.getNotes(field);
        if ((fieldNotes == null || fieldNotes.size() < 1) && event_crf_id > 0) {
            fieldNotes = notes.getNotes(field);
        }
        for (int i = 0; i < fieldNotes.size(); ++i) {
            DiscrepancyNoteBean dnb = (DiscrepancyNoteBean)fieldNotes.get(i);
            dnb.setEntityId(entityId);
            dnb.setStudyId(sb.getId());
            dnb.setEntityType(entityType);
            if (dnb.getResolutionStatusId() == 0) {
                dnb.setResStatus(ResolutionStatus.NOT_APPLICABLE);
                dnb.setResolutionStatusId(ResolutionStatus.NOT_APPLICABLE.getId());
                if (!dnb.getDisType().equals((Term)DiscrepancyNoteType.REASON_FOR_CHANGE)) {
                    dnb.setResStatus(ResolutionStatus.OPEN);
                    dnb.setResolutionStatusId(ResolutionStatus.OPEN.getId());
                }
            }
            dnb = dndao.create(dnb);
            dndao.createMapping(dnb);
            if (dnb.getParentDnId() == 0) {
                dnb.setParentDnId(dnb.getId());
                dnb = dndao.create(dnb);
                dndao.createMapping(dnb);
                continue;
            }
            if (dnb.getParentDnId() <= 0) continue;
            DiscrepancyNoteBean parentNote = (DiscrepancyNoteBean)dndao.findByPK(dnb.getParentDnId());
            if (dnb.getDiscrepancyNoteTypeId() != parentNote.getDiscrepancyNoteTypeId() || dnb.getResolutionStatusId() == parentNote.getResolutionStatusId()) continue;
            parentNote.setResolutionStatusId(dnb.getResolutionStatusId());
            dndao.update(parentNote);
        }
    }

    public static void displaySubjects(ArrayList<DisplaySubjectBean> displayArray, ArrayList<SubjectBean> subjects, StudySubjectDAO ssdao, StudyDAO stdao) {
        for (int i = 0; i < subjects.size(); ++i) {
            SubjectBean subject = subjects.get(i);
            ArrayList studySubs = ssdao.findAllBySubjectId(subject.getId());
            String protocolSubjectIds = "";
            for (int j = 0; j < studySubs.size(); ++j) {
                StudySubjectBean studySub = (StudySubjectBean)studySubs.get(j);
                int studyId = studySub.getStudyId();
                StudyBean stu = stdao.findByPK(studyId);
                String protocolId = stu.getIdentifier();
                protocolSubjectIds = j == studySubs.size() - 1 ? protocolId + "-" + studySub.getLabel() : protocolId + "-" + studySub.getLabel() + ", ";
            }
            DisplaySubjectBean dsb = new DisplaySubjectBean();
            dsb.setSubject(subject);
            dsb.setStudySubjectIds(protocolSubjectIds);
            displayArray.add(dsb);
        }
    }
}

