/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.RuleValidator;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdministrativeEditingServlet
extends DataEntryServlet {
    private static final long serialVersionUID = 7651056910867103546L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdministrativeEditingServlet.class);
    Locale locale;

    protected String getServletPage(HttpServletRequest request) {
        FormProcessor fp = new FormProcessor(request);
        String tabId = fp.getString("tab", true);
        String sectionId = fp.getString("sectionId", true);
        String eventCRFId = fp.getString("eventCRFId", true);
        if (sectionId == null || sectionId.trim().isEmpty() || tabId == null || tabId.trim().isEmpty()) {
            return Page.ADMIN_EDIT_SERVLET.getFileName();
        }
        Page target = Page.ADMIN_EDIT_SERVLET;
        String s = target.getFileName().trim();
        String url = null;
        if (s.contains("?")) {
            String[] t = s.split("\\?");
            String x = "";
            String y = t[0] + "?";
            if (t.length > 1) {
                if (t[1].contains("&")) {
                    String[] ts = t[1].split("&");
                    for (int i = 0; i < ts.length; ++i) {
                        if (ts[i].contains("eventCRFId=")) {
                            ts[i] = "eventCRFId=" + eventCRFId;
                            x = x + "e";
                        } else if (ts[i].contains("sectionId=")) {
                            ts[i] = "sectionId=" + sectionId;
                            x = x + "s";
                        } else if (ts[i].contains("tab=")) {
                            ts[i] = "tab=" + tabId;
                            x = x + "t";
                        }
                        y = y + ts[i] + "&";
                    }
                } else {
                    if (t[1].contains("eventCRFId=")) {
                        t[1] = "eventCRFId=" + eventCRFId;
                        x = x + "e";
                    } else if (t[1].contains("sectionId=")) {
                        t[1] = "sectionId=" + sectionId;
                        x = x + "s";
                    } else if (t[1].contains("tab=")) {
                        t[1] = "tab=" + tabId;
                        x = x + "t";
                    }
                    y = y + t[1] + "&";
                }
                if (x.length() < 3) {
                    if (!x.contains("e")) {
                        y = y + "eventCRFId=" + eventCRFId + "&";
                    }
                    if (!x.contains("s")) {
                        y = y + "sectionId=" + sectionId + "&";
                    }
                    if (!x.contains("t")) {
                        y = y + "tab=" + tabId + "&";
                    }
                }
                url = y = y.substring(0, y.length() - 1);
            } else {
                LOGGER.info("It's a wrong servlet page:" + s);
            }
        } else {
            url = target.getFileName() + "?eventCRFId=" + eventCRFId + "&sectionId=" + sectionId + "&tab=" + tabId;
        }
        return url;
    }

    protected Page getJSPPage() {
        return Page.ADMIN_EDIT;
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        this.mayAccess(request);
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        HttpSession session = request.getSession();
        FormProcessor fp = new FormProcessor(request);
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        this.getInputBeans(request);
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        String fromResolvingNotes = fp.getString("fromResolvingNotes", true);
        if (fromResolvingNotes == null || fromResolvingNotes.trim().isEmpty()) {
            session.removeAttribute("window_location");
            session.removeAttribute("notesTable");
            this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"), request, response);
            this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_frozen"), request, response);
        }
        request.setAttribute("fromResolvingNotes", (Object)fromResolvingNotes);
        LOGGER.debug(" +++++++++++++++++++ " + ecb.getStudyEventId());
        DataEntryStage stage = ecb.getStage();
        Role r = currentRole.getRole();
        session.setAttribute("mayProcessUploading", (Object)"true");
        if (!SubmitDataServlet.maySubmitData((UserAccountBean)ub, (StudyUserRoleBean)currentRole)) {
            session.setAttribute("mayProcessUploading", (Object)"false");
            String exceptionName = resexception.getString("no_permission_validation");
            String noAccessMessage = respage.getString("not_perform_administrative_editing_CRF");
            this.addPageMessage(noAccessMessage, request);
            throw new InsufficientPermissionException(Page.MENU, exceptionName, "1");
        }
        LOGGER.info("stage name:" + stage.getName());
        if (stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE)) {
            if (r.equals((Term)Role.MONITOR)) {
                session.setAttribute("mayProcessUploading", (Object)"false");
                this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"), request);
                throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("no_permission_administrative_editing"), "1");
            }
        } else {
            session.setAttribute("mayProcessUploading", (Object)"false");
            this.addPageMessage(respage.getString("not_perform_administrative_editing_because"), request);
            throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("not_correct_stage"), "1");
        }
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setAnnotations(annotations);
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        if (dib.getData().getStatus() == null) {
            return true;
        }
        return Status.UNAVAILABLE.equals((Term)dib.getData().getStatus());
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        if (inputName == null || inputName.trim().isEmpty()) {
            dib = this.loadFormValue(dib, request);
        }
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA) || rt.equals((Term)ResponseType.FILE)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        formGroups = this.loadFormValueForItemGroup(digb, digbs, formGroups, edcb.getId(), request);
        String inputName = "";
        for (int i = 0; i < formGroups.size(); ++i) {
            DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)formGroups.get(i);
            List items = displayGroup.getItems();
            int order = displayGroup.getOrdinal();
            if (displayGroup.isAuto() && displayGroup.getFormInputOrdinal() > 0) {
                order = displayGroup.getFormInputOrdinal();
            }
            for (DisplayItemBean displayItem : items) {
                inputName = displayGroup.isAuto() ? this.getGroupItemInputName(displayGroup, order, displayItem) : this.getGroupItemManualInputName(displayGroup, order, displayItem);
                this.validateDisplayItemBean(v, displayItem, inputName, request);
            }
        }
        return formGroups;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, Boolean fireRuleValidation, ArrayList<String> messages, HttpServletRequest request) {
        if (inputName == null || inputName.trim().isEmpty()) {
            dib = this.loadFormValue(dib, request);
        }
        if (groupOrdinalPLusItemOid.containsKey(dib.getItem().getOid()) || fireRuleValidation.booleanValue()) {
            messages = messages == null ? groupOrdinalPLusItemOid.get(dib.getItem().getOid()) : messages;
            dib = this.validateDisplayItemBeanSingleCV(rv, dib, inputName, messages);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, HttpServletRequest request, HttpServletResponse response) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        formGroups = this.loadFormValueForItemGroup(digb, digbs, formGroups, edcb.getId(), request);
        String inputName = "";
        for (int i = 0; i < formGroups.size(); ++i) {
            DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)formGroups.get(i);
            List items = displayGroup.getItems();
            int order = displayGroup.getOrdinal();
            if (displayGroup.isAuto() && displayGroup.getFormInputOrdinal() > 0) {
                order = displayGroup.getFormInputOrdinal();
            }
            for (DisplayItemBean displayItem : items) {
                inputName = displayGroup.isAuto() ? this.getGroupItemInputName(displayGroup, order, displayItem) : this.getGroupItemManualInputName(displayGroup, order, displayItem);
                LOGGER.debug("THe oid is " + displayItem.getItem().getOid() + " order : " + order + " inputName : " + inputName);
                if (groupOrdinalPLusItemOid.containsKey(displayItem.getItem().getOid()) || groupOrdinalPLusItemOid.containsKey(String.valueOf(displayGroup.getIndex() + 1) + displayItem.getItem().getOid())) {
                    LOGGER.debug("IN : " + String.valueOf(displayGroup.getIndex() + 1) + displayItem.getItem().getOid());
                    this.validateDisplayItemBean(v, displayItem, inputName, rv, groupOrdinalPLusItemOid, Boolean.valueOf(true), groupOrdinalPLusItemOid.get(String.valueOf(displayGroup.getIndex() + 1) + displayItem.getItem().getOid()), request);
                    continue;
                }
                this.validateDisplayItemBean(v, displayItem, inputName, rv, groupOrdinalPLusItemOid, Boolean.valueOf(false), null, request);
            }
        }
        return formGroups;
    }

    protected Status getBlankItemStatus() {
        return Status.UNAVAILABLE;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        return Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getAnnotations();
    }

    protected boolean shouldRunRules() {
        return false;
    }

    protected boolean isAdministrativeEditing() {
        return true;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (currentStudy.getStudyParameterConfig().getAdminForcedReasonForChange().equals("true")) {
            LOGGER.debug("returning true for forced reason for change");
            return true;
        }
        return false;
    }
}

