/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.apache.commons.lang.StringUtils;

public class CreateDiscrepancyNoteServlet
extends SecureController {
    private static final long serialVersionUID = 4691058657903088336L;
    Locale locale;
    public static final String DIS_TYPES = "discrepancyTypes";
    public static final String RES_STATUSES = "resolutionStatuses";
    public static final String ENTITY_ID = "id";
    public static final String SUBJECT_ID = "subjectId";
    public static final String ITEM_ID = "itemId";
    public static final String IS_GROUP_ITEM = "isGroup";
    public static final String PARENT_ID = "parentId";
    public static final String ENTITY_TYPE = "name";
    public static final String ENTITY_COLUMN = "column";
    public static final String ENTITY_FIELD = "field";
    public static final String DIS_NOTE = "discrepancyNote";
    public static final String WRITE_TO_DB = "writeToDB";
    public static final String IS_REASON_FOR_CHANGE = "isRfc";
    public static final String PRESET_RES_STATUS = "strResStatus";
    public static final String CAN_MONITOR = "canMonitor";
    public static final String NEW_NOTE = "new";
    public static final String RES_STATUS_ID = "resStatusId";
    public static final String ERROR_FLAG = "errorFlag";
    public static final String USER_ACCOUNTS = "userAccounts";
    public static final String USER_ACCOUNT_ID = "strUserAccountId";
    public static final String SUBMITTED_USER_ACCOUNT_ID = "userAccountId";
    public static final String PRESET_USER_ACCOUNT_ID = "preUserAccountId";
    public static final String EMAIL_USER_ACCOUNT = "sendEmail";
    public static final String WHICH_RES_STATUSES = "whichResStatus";
    public static final String EVENT_CRF_ID = "eventCRFId";
    public static final String PARENT_ROW_COUNT = "rowCount";
    public String exceptionName = resexception.getString("no_permission_to_create_discrepancy_note");
    public String noAccessMessage = respage.getString("you_may_not_create_discrepancy_note") + respage.getString("change_study_contact_sysadmin");
    public static final String FLAG_DISCREPANCY_RFC = "flagDNRFC";

    protected void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.MENU_SERVLET, respage.getString("current_study_locked"));
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(this.noAccessMessage);
        throw new InsufficientPermissionException(Page.MENU, this.exceptionName, "1");
    }

    protected void processRequest() throws Exception {
        ArrayList<DiscrepancyNoteType> types2;
        ArrayList<ResolutionStatus> resStatuses;
        boolean isNotesExistInSession;
        FormDiscrepancyNotes newNotes;
        FormProcessor fp = new FormProcessor(this.request);
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
        List types = DiscrepancyNoteType.list;
        this.request.setAttribute(DIS_TYPES, (Object)types);
        this.request.setAttribute(RES_STATUSES, (Object)ResolutionStatus.list);
        boolean writeToDB = fp.getBoolean(WRITE_TO_DB, true);
        boolean isReasonForChange = fp.getBoolean(IS_REASON_FOR_CHANGE);
        int entityId = fp.getInt(ENTITY_ID);
        int subjectId = fp.getInt(SUBJECT_ID);
        int itemId = fp.getInt(ITEM_ID);
        String entityType = fp.getString(ENTITY_TYPE);
        String field = fp.getString(ENTITY_FIELD);
        String column = fp.getString(ENTITY_COLUMN);
        int parentId = fp.getInt(PARENT_ID);
        int isGroup = fp.getInt(IS_GROUP_ITEM);
        int eventCRFId = fp.getInt(EVENT_CRF_ID);
        this.request.setAttribute(EVENT_CRF_ID, (Object)new Integer(eventCRFId));
        int rowCount = fp.getInt(PARENT_ROW_COUNT);
        if (!StringUtils.isBlank((String)entityType) && "itemData".equalsIgnoreCase(entityType) && isGroup != 0 && eventCRFId != 0) {
            int ordinal_for_repeating_group_field = this.calculateOrdinal(isGroup, field, eventCRFId, rowCount);
            int writeToDBStatus = this.isWriteToDB(isGroup, field, entityId, itemId, ordinal_for_repeating_group_field, eventCRFId);
            writeToDB = writeToDBStatus == -1 ? false : (writeToDBStatus == 1 ? true : writeToDB);
        }
        boolean isInError = fp.getBoolean(ERROR_FLAG);
        boolean isNew = fp.getBoolean(NEW_NOTE);
        this.request.setAttribute(NEW_NOTE, (Object)(isNew ? "1" : "0"));
        String strResStatus = fp.getString(PRESET_RES_STATUS);
        if (!strResStatus.equals("")) {
            this.request.setAttribute(PRESET_RES_STATUS, (Object)strResStatus);
        }
        String monitor = fp.getString("monitor");
        String enterData = fp.getString("enterData");
        this.request.setAttribute("enterData", (Object)enterData);
        boolean enteringData = false;
        if (enterData != null && "1".equalsIgnoreCase(enterData)) {
            this.request.setAttribute(CAN_MONITOR, (Object)"1");
            this.request.setAttribute("monitor", (Object)monitor);
            enteringData = true;
        } else if ("1".equalsIgnoreCase(monitor)) {
            this.request.setAttribute(CAN_MONITOR, (Object)"1");
            this.request.setAttribute("monitor", (Object)monitor);
        } else {
            this.request.setAttribute(CAN_MONITOR, (Object)"0");
        }
        if ("itemData".equalsIgnoreCase(entityType) && enteringData) {
            this.request.setAttribute("enterItemData", (Object)"yes");
        }
        DateFormat dateFormatter = DateFormat.getDateInstance(2, this.locale);
        int preUserId = 0;
        if (!StringUtils.isBlank((String)entityType)) {
            if ("itemData".equalsIgnoreCase(entityType) || "itemdata".equalsIgnoreCase(entityType)) {
                ItemBean item = new ItemDAO(this.sm.getDataSource()).findByPK(itemId);
                ItemDataBean itemData = (ItemDataBean)new ItemDataDAO(this.sm.getDataSource()).findByPK(entityId);
                this.request.setAttribute("entityValue", (Object)itemData.getValue());
                this.request.setAttribute("entityName", (Object)item.getName());
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                EventCRFBean ec = ecdao.findByPK(itemData.getEventCRFId());
                preUserId = ec.getOwnerId();
            } else if ("studySub".equalsIgnoreCase(entityType)) {
                StudySubjectBean ssub = new StudySubjectDAO(this.sm.getDataSource()).findByPK(entityId);
                SubjectBean sub = new SubjectDAO(this.sm.getDataSource()).findByPK(ssub.getSubjectId());
                preUserId = ssub.getOwnerId();
                if (!StringUtils.isBlank((String)column)) {
                    if ("enrollment_date".equalsIgnoreCase(column)) {
                        if (ssub.getEnrollmentDate() != null) {
                            this.request.setAttribute("entityValue", (Object)dateFormatter.format(ssub.getEnrollmentDate()));
                        } else {
                            this.request.setAttribute("entityValue", (Object)resword.getString("N/A"));
                        }
                        this.request.setAttribute("entityName", (Object)resword.getString("enrollment_date"));
                    } else if ("gender".equalsIgnoreCase(column)) {
                        this.request.setAttribute("entityValue", (Object)(sub.getGender() + ""));
                        this.request.setAttribute("entityName", (Object)resword.getString("gender"));
                    } else if ("date_of_birth".equalsIgnoreCase(column)) {
                        if (sub.getDateOfBirth() != null) {
                            this.request.setAttribute("entityValue", (Object)dateFormatter.format(sub.getDateOfBirth()));
                        } else {
                            this.request.setAttribute("entityValue", (Object)resword.getString("N/A"));
                        }
                        this.request.setAttribute("entityName", (Object)resword.getString("date_of_birth"));
                    } else if ("unique_identifier".equalsIgnoreCase(column)) {
                        if (sub.getUniqueIdentifier() != null) {
                            this.request.setAttribute("entityValue", (Object)sub.getUniqueIdentifier());
                        }
                        this.request.setAttribute("entityName", (Object)resword.getString("unique_identifier"));
                    }
                }
            } else if ("subject".equalsIgnoreCase(entityType)) {
                SubjectBean sub = new SubjectDAO(this.sm.getDataSource()).findByPK(entityId);
                preUserId = sub.getOwnerId();
                if (!StringUtils.isBlank((String)column)) {
                    if ("gender".equalsIgnoreCase(column)) {
                        this.request.setAttribute("entityValue", (Object)(sub.getGender() + ""));
                        this.request.setAttribute("entityName", (Object)resword.getString("gender"));
                    } else if ("date_of_birth".equalsIgnoreCase(column)) {
                        if (sub.getDateOfBirth() != null) {
                            this.request.setAttribute("entityValue", (Object)dateFormatter.format(sub.getDateOfBirth()));
                        }
                        this.request.setAttribute("entityName", (Object)resword.getString("date_of_birth"));
                    } else if ("unique_identifier".equalsIgnoreCase(column)) {
                        this.request.setAttribute("entityValue", (Object)sub.getUniqueIdentifier());
                        this.request.setAttribute("entityName", (Object)resword.getString("unique_identifier"));
                    }
                }
            } else if ("studyEvent".equalsIgnoreCase(entityType)) {
                StudyEventBean se = new StudyEventDAO(this.sm.getDataSource()).findByPK(entityId);
                preUserId = se.getOwnerId();
                if (!StringUtils.isBlank((String)column)) {
                    if ("location".equalsIgnoreCase(column)) {
                        this.request.setAttribute("entityValue", (Object)(se.getLocation().equals("") || se.getLocation() == null ? resword.getString("N/A") : se.getLocation()));
                        this.request.setAttribute("entityName", (Object)resword.getString("location"));
                    } else if ("start_date".equalsIgnoreCase(column)) {
                        if (se.getDateStarted() != null) {
                            this.request.setAttribute("entityValue", (Object)dateFormatter.format(se.getDateStarted()));
                        } else {
                            this.request.setAttribute("entityValue", (Object)resword.getString("N/A"));
                        }
                        this.request.setAttribute("entityName", (Object)resword.getString("start_date"));
                    } else if ("end_date".equalsIgnoreCase(column)) {
                        if (se.getDateEnded() != null) {
                            this.request.setAttribute("entityValue", (Object)dateFormatter.format(se.getDateEnded()));
                        } else {
                            this.request.setAttribute("entityValue", (Object)resword.getString("N/A"));
                        }
                        this.request.setAttribute("entityName", (Object)resword.getString("end_date"));
                    }
                }
            } else if ("eventCrf".equalsIgnoreCase(entityType)) {
                EventCRFBean ec = new EventCRFDAO(this.sm.getDataSource()).findByPK(entityId);
                preUserId = ec.getOwnerId();
                if (!StringUtils.isBlank((String)column)) {
                    if ("date_interviewed".equals(column)) {
                        if (ec.getDateInterviewed() != null) {
                            this.request.setAttribute("entityValue", (Object)dateFormatter.format(ec.getDateInterviewed()));
                        } else {
                            this.request.setAttribute("entityValue", (Object)resword.getString("N/A"));
                        }
                        this.request.setAttribute("entityName", (Object)resword.getString("date_interviewed"));
                    } else if ("interviewer_name".equals(column)) {
                        this.request.setAttribute("entityValue", (Object)ec.getInterviewerName());
                        this.request.setAttribute("entityName", (Object)resword.getString("interviewer_name"));
                    }
                }
            }
        }
        ArrayList notes = dndao.findAllByEntityAndColumn(entityType, entityId, column);
        DiscrepancyNoteBean parent = new DiscrepancyNoteBean();
        if (parentId > 0) {
            dndao.setFetchMapping(true);
            parent = (DiscrepancyNoteBean)dndao.findByPK(parentId);
            if (parent.isActive()) {
                this.request.setAttribute("parent", (Object)parent);
            }
            dndao.setFetchMapping(false);
        }
        if ((newNotes = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes")) == null) {
            newNotes = new FormDiscrepancyNotes();
        }
        boolean bl = !newNotes.getNotes(field).isEmpty() ? true : (isNotesExistInSession = !newNotes.getNotes(eventCRFId + "_" + field).isEmpty());
        if (!notes.isEmpty() || isNotesExistInSession) {
            this.request.setAttribute("hasNotes", (Object)"yes");
        } else {
            this.request.setAttribute("hasNotes", (Object)"no");
            logger.debug("has notes:no");
        }
        if (this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            resStatuses = new ArrayList<ResolutionStatus>();
            resStatuses.add(ResolutionStatus.OPEN);
            resStatuses.add(ResolutionStatus.RESOLVED);
            this.request.setAttribute(RES_STATUSES, resStatuses);
            types2 = new ArrayList<DiscrepancyNoteType>(DiscrepancyNoteType.list);
            types2.remove(DiscrepancyNoteType.QUERY);
            this.request.setAttribute(DIS_TYPES, types2);
            this.request.setAttribute(WHICH_RES_STATUSES, (Object)"22");
        } else if (this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            resStatuses = new ArrayList();
            resStatuses.add(ResolutionStatus.OPEN);
            resStatuses.add(ResolutionStatus.UPDATED);
            resStatuses.add(ResolutionStatus.CLOSED);
            this.request.setAttribute(RES_STATUSES, resStatuses);
            this.request.setAttribute(WHICH_RES_STATUSES, (Object)"1");
            types2 = new ArrayList();
            types2.add(DiscrepancyNoteType.QUERY);
            this.request.setAttribute(DIS_TYPES, types2);
        } else {
            resStatuses = new ArrayList(ResolutionStatus.list);
            resStatuses.remove(ResolutionStatus.NOT_APPLICABLE);
            this.request.setAttribute(RES_STATUSES, resStatuses);
            this.request.setAttribute(WHICH_RES_STATUSES, (Object)"2");
        }
        if (!fp.isSubmitted()) {
            DiscrepancyNoteBean dnb = new DiscrepancyNoteBean();
            if (subjectId > 0) {
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean ssub = ssdao.findByPK(subjectId);
                dnb.setSubjectName(ssub.getName());
                dnb.setSubjectId(ssub.getId());
                dnb.setStudySub(ssub);
                StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                int parentStudyForSubject = 0;
                StudyBean studyBeanSub = studyDAO.findByPK(ssub.getStudyId());
                if (null != studyBeanSub) {
                    parentStudyForSubject = studyBeanSub.getParentStudyId();
                }
                if (ssub.getStudyId() != this.currentStudy.getId() && this.currentStudy.getId() != parentStudyForSubject) {
                    this.addPageMessage(this.noAccessMessage);
                    throw new InsufficientPermissionException(Page.MENU_SERVLET, this.exceptionName, "1");
                }
            }
            if (itemId > 0) {
                ItemBean item = new ItemDAO(this.sm.getDataSource()).findByPK(itemId);
                dnb.setEntityName(item.getName());
                this.request.setAttribute("item", (Object)item);
            }
            dnb.setEntityType(entityType);
            dnb.setColumn(column);
            dnb.setEntityId(entityId);
            dnb.setField(field);
            dnb.setParentDnId(parent.getId());
            dnb.setCreatedDate(new Date());
            if (parent.getId() == 0 || isNew) {
                if (enteringData) {
                    if (isInError) {
                        dnb.setDiscrepancyNoteTypeId(DiscrepancyNoteType.FAILEDVAL.getId());
                    } else {
                        dnb.setDiscrepancyNoteTypeId(DiscrepancyNoteType.ANNOTATION.getId());
                        dnb.setResolutionStatusId(ResolutionStatus.NOT_APPLICABLE.getId());
                    }
                    if (isReasonForChange) {
                        dnb.setDiscrepancyNoteTypeId(DiscrepancyNoteType.REASON_FOR_CHANGE.getId());
                        dnb.setResolutionStatusId(ResolutionStatus.NOT_APPLICABLE.getId());
                    }
                    this.request.setAttribute("autoView", (Object)"0");
                } else {
                    dnb.setDiscrepancyNoteTypeId(DiscrepancyNoteType.QUERY.getId());
                    if (this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
                        this.request.setAttribute("autoView", (Object)"0");
                    } else {
                        this.request.setAttribute("autoView", (Object)"1");
                        dnb.setAssignedUserId(preUserId);
                    }
                }
            } else if (parent.getDiscrepancyNoteTypeId() > 0) {
                dnb.setDiscrepancyNoteTypeId(parent.getDiscrepancyNoteTypeId());
                if ((this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2)) && this.currentStudy.getId() != this.currentStudy.getParentStudyId()) {
                    dnb.setResolutionStatusId(ResolutionStatus.RESOLVED.getId());
                    this.request.setAttribute("autoView", (Object)"0");
                } else {
                    dnb.setResolutionStatusId(ResolutionStatus.UPDATED.getId());
                }
            }
            dnb.setOwnerId(parent.getOwnerId());
            String detailedDes = fp.getString("strErrMsg");
            if (detailedDes != null) {
                dnb.setDetailedNotes(detailedDes);
                logger.debug("found strErrMsg: " + fp.getString("strErrMsg"));
            }
            if ((dnb = this.getNoteInfo(dnb)).getEventName() == null || dnb.getEventName().equals("")) {
                if (!fp.getString("eventName").equals("")) {
                    dnb.setEventName(fp.getString("eventName"));
                } else {
                    dnb.setEventName(this.getStudyEventDefinition(eventCRFId).getName());
                }
            }
            if (dnb.getEventStart() == null) {
                if (fp.getDate("eventDate") != null) {
                    dnb.setEventStart(fp.getDate("eventDate"));
                } else {
                    dnb.setEventStart(this.getStudyEvent(eventCRFId).getDateStarted());
                }
            }
            if (dnb.getCrfName() == null || dnb.getCrfName().equals("")) {
                if (!fp.getString("crfName").equals("")) {
                    dnb.setCrfName(fp.getString("crfName"));
                } else {
                    dnb.setCrfName(this.getCrf(eventCRFId).getName());
                }
            }
            this.request.setAttribute(DIS_NOTE, (Object)dnb);
            this.request.setAttribute("unlock", (Object)"0");
            this.request.setAttribute(WRITE_TO_DB, (Object)(writeToDB ? "1" : "0"));
            ArrayList userAccounts = this.generateUserAccounts(this.ub.getActiveStudyId(), subjectId);
            this.request.setAttribute(USER_ACCOUNTS, (Object)userAccounts);
            if ((this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2)) && this.currentStudy.getId() != this.currentStudy.getParentStudyId()) {
                this.request.setAttribute(USER_ACCOUNT_ID, (Object)Integer.valueOf(parent.getOwnerId()).toString());
                logger.debug("assigned owner id: " + parent.getOwnerId());
            } else if (dnb.getEventCRFId() > 0) {
                logger.debug("found a event crf id: " + dnb.getEventCRFId());
                EventCRFDAO eventCrfDAO = new EventCRFDAO(this.sm.getDataSource());
                EventCRFBean eventCrfBean = new EventCRFBean();
                eventCrfBean = eventCrfDAO.findByPK(dnb.getEventCRFId());
                this.request.setAttribute(USER_ACCOUNT_ID, (Object)Integer.valueOf(eventCrfBean.getOwnerId()).toString());
                logger.debug("assigned owner id: " + eventCrfBean.getOwnerId());
            }
            this.forwardPage(Page.ADD_DISCREPANCY_NOTE);
        } else {
            FormDiscrepancyNotes noteTree = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
            FormDiscrepancyNotes noteTree_RFC_REPEAT = (FormDiscrepancyNotes)this.session.getAttribute(FLAG_DISCREPANCY_RFC);
            if (noteTree_RFC_REPEAT == null) {
                noteTree_RFC_REPEAT = new FormDiscrepancyNotes();
            }
            if (noteTree == null) {
                noteTree = new FormDiscrepancyNotes();
                logger.debug("No note tree initailized in session");
            }
            Validator v = new Validator(this.request);
            String description = fp.getString("description");
            int typeId = fp.getInt("typeId");
            int assignedUserAccountId = fp.getInt(SUBMITTED_USER_ACCOUNT_ID);
            int resStatusId = fp.getInt(RES_STATUS_ID);
            String detailedDes = fp.getString("detailedDes");
            int sectionId = fp.getInt("sectionId");
            DiscrepancyNoteBean note = new DiscrepancyNoteBean();
            v.addValidation("description", 1);
            v.addValidation("description", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
            v.addValidation("detailedDes", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
            v.addValidation("typeId", 1);
            HashMap errors = v.validate();
            note.setDescription(description);
            note.setDetailedNotes(detailedDes);
            note.setOwner(this.ub);
            note.setOwnerId(this.ub.getId());
            note.setCreatedDate(new Date());
            note.setResolutionStatusId(resStatusId);
            note.setDiscrepancyNoteTypeId(typeId);
            note.setParentDnId(parent.getId());
            if (typeId != DiscrepancyNoteType.ANNOTATION.getId() && typeId != DiscrepancyNoteType.FAILEDVAL.getId() && typeId != DiscrepancyNoteType.REASON_FOR_CHANGE.getId()) {
                if (assignedUserAccountId > 0) {
                    note.setAssignedUserId(assignedUserAccountId);
                    logger.debug("^^^ found assigned user id: " + assignedUserAccountId);
                } else {
                    note.setAssignedUserId(parent.getOwnerId());
                    logger.debug("found user assigned id, in the PARENT OWNER ID: " + parent.getOwnerId() + " note that user assgined id did not work: " + assignedUserAccountId);
                }
            }
            note.setField(field);
            if (DiscrepancyNoteType.ANNOTATION.getId() == note.getDiscrepancyNoteTypeId()) {
                this.updateStudyEvent(entityType, entityId);
                this.updateStudySubjectStatus(entityType, entityId);
            }
            if (DiscrepancyNoteType.ANNOTATION.getId() == note.getDiscrepancyNoteTypeId() || DiscrepancyNoteType.REASON_FOR_CHANGE.getId() == note.getDiscrepancyNoteTypeId()) {
                note.setResStatus(ResolutionStatus.NOT_APPLICABLE);
                note.setResolutionStatusId(ResolutionStatus.NOT_APPLICABLE.getId());
            }
            if ((DiscrepancyNoteType.FAILEDVAL.getId() == note.getDiscrepancyNoteTypeId() || DiscrepancyNoteType.QUERY.getId() == note.getDiscrepancyNoteTypeId()) && ResolutionStatus.NOT_APPLICABLE.getId() == note.getResolutionStatusId()) {
                Validator.addError((HashMap)errors, (String)RES_STATUS_ID, (String)restext.getString("not_valid_res_status"));
            }
            if (!parent.isActive()) {
                note.setEntityId(entityId);
                note.setEntityType(entityType);
                note.setColumn(column);
            } else {
                note.setEntityId(parent.getEntityId());
                note.setEntityType(parent.getEntityType());
                if (!StringUtils.isBlank((String)parent.getColumn())) {
                    note.setColumn(parent.getColumn());
                } else {
                    note.setColumn(column);
                }
                note.setParentDnId(parent.getId());
            }
            note.setStudyId(this.currentStudy.getId());
            note = this.getNoteInfo(note);
            this.request.setAttribute(DIS_NOTE, (Object)note);
            this.request.setAttribute(WRITE_TO_DB, (Object)(writeToDB ? "1" : "0"));
            ArrayList userAccounts = this.generateUserAccounts(this.ub.getActiveStudyId(), subjectId);
            this.request.setAttribute(USER_ACCOUNT_ID, (Object)Integer.valueOf(note.getAssignedUserId()).toString());
            Role r = this.currentRole.getRole();
            if (r.equals((Term)Role.MONITOR) || r.equals((Term)Role.INVESTIGATOR) || r.equals((Term)Role.RESEARCHASSISTANT) || r.equals((Term)Role.RESEARCHASSISTANT2) || r.equals((Term)Role.COORDINATOR)) {
                this.request.setAttribute("unlock", (Object)"1");
                logger.debug("set UNLOCK to ONE");
            } else {
                this.request.setAttribute("unlock", (Object)"0");
                logger.debug("set UNLOCK to ZERO");
            }
            this.request.setAttribute(USER_ACCOUNTS, (Object)userAccounts);
            if (errors.isEmpty()) {
                if (!writeToDB) {
                    noteTree.addNote(field, note);
                    noteTree.addIdNote(note.getEntityId(), field);
                    noteTree_RFC_REPEAT.addNote("eventCRFId_" + field, note);
                    noteTree_RFC_REPEAT.addIdNote(note.getEntityId(), field);
                    this.session.setAttribute("fdnotes", (Object)noteTree);
                    this.session.setAttribute(FLAG_DISCREPANCY_RFC, (Object)noteTree_RFC_REPEAT);
                    this.manageReasonForChangeState(this.session, eventCRFId + "_" + field);
                    this.forwardPage(Page.ADD_DISCREPANCY_NOTE_DONE);
                } else {
                    int pdnId;
                    int n = pdnId = note != null ? note.getParentDnId() : 0;
                    if (pdnId > 0) {
                        logger.debug("Create:find parent note for item data:" + note.getEntityId());
                        DiscrepancyNoteBean pNote = (DiscrepancyNoteBean)dndao.findByPK(pdnId);
                        logger.debug("setting DN owner id: " + pNote.getOwnerId());
                        note.setOwnerId(pNote.getOwnerId());
                        if (note.getDiscrepancyNoteTypeId() == pNote.getDiscrepancyNoteTypeId()) {
                            if (note.getResolutionStatusId() != pNote.getResolutionStatusId()) {
                                pNote.setResolutionStatusId(note.getResolutionStatusId());
                                dndao.update(pNote);
                            }
                            if (note.getAssignedUserId() != pNote.getAssignedUserId()) {
                                pNote.setAssignedUserId(note.getAssignedUserId());
                                if (pNote.getAssignedUserId() > 0) {
                                    dndao.updateAssignedUser((EntityBean)pNote);
                                } else {
                                    dndao.updateAssignedUserToNull((EntityBean)pNote);
                                }
                            }
                        }
                    }
                    note = dndao.create(note);
                    dndao.createMapping(note);
                    this.request.setAttribute(DIS_NOTE, (Object)note);
                    if (note.getParentDnId() == 0) {
                        note.setParentDnId(note.getId());
                        note = dndao.create(note);
                        dndao.createMapping(note);
                    }
                    String field_id_for_RFC_hash = eventCRFId + "_" + field;
                    this.manageReasonForChangeState(this.session, field_id_for_RFC_hash);
                    logger.debug("found resolution status: " + note.getResolutionStatusId());
                    String email = fp.getString(EMAIL_USER_ACCOUNT);
                    logger.debug("found email: " + email);
                    if (note.getAssignedUserId() > 0 && "1".equals(email.trim()) && DiscrepancyNoteType.QUERY.getId() == note.getDiscrepancyNoteTypeId()) {
                        logger.debug("++++++ found our way here: " + note.getDiscrepancyNoteTypeId() + " id number and " + note.getDisType().getName());
                        StringBuffer message = new StringBuffer();
                        UserAccountDAO userAccountDAO = new UserAccountDAO(this.sm.getDataSource());
                        ItemDAO itemDAO = new ItemDAO(this.sm.getDataSource());
                        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                        ItemBean item = new ItemBean();
                        ItemDataBean itemData = new ItemDataBean();
                        SectionBean section = new SectionBean();
                        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                        UserAccountBean assignedUser = userAccountDAO.findByPK(note.getAssignedUserId());
                        String alertEmail = assignedUser.getEmail();
                        message.append(MessageFormat.format(respage.getString("mailDNHeader"), assignedUser.getFirstName(), assignedUser.getLastName()));
                        message.append("<A HREF='" + SQLInitServlet.getField((String)"sysURL.base") + "ViewNotes?module=submit&listNotes_f_discrepancyNoteBean.user=" + assignedUser.getName() + "&listNotes_f_entityName=" + note.getEntityName() + "'>" + SQLInitServlet.getField((String)"sysURL.base") + "</A><BR/>");
                        message.append(respage.getString("you_received_this_from"));
                        StudyBean study = studyDAO.findByPK(note.getStudyId());
                        SectionDAO sectionDAO = new SectionDAO(this.sm.getDataSource());
                        if ("itemData".equalsIgnoreCase(entityType)) {
                            itemData = (ItemDataBean)iddao.findByPK(note.getEntityId());
                            item = itemDAO.findByPK(itemData.getItemId());
                            if (sectionId > 0) {
                                section = sectionDAO.findByPK(sectionId);
                            }
                        }
                        message.append(respage.getString("email_body_separator"));
                        message.append(respage.getString("disc_note_info"));
                        message.append(respage.getString("email_body_separator"));
                        message.append(MessageFormat.format(respage.getString("mailDNParameters1"), note.getDescription(), note.getDetailedNotes(), this.ub.getName()));
                        message.append(respage.getString("email_body_separator"));
                        message.append(respage.getString("entity_information"));
                        message.append(respage.getString("email_body_separator"));
                        message.append(MessageFormat.format(respage.getString("mailDNParameters2"), study.getName(), note.getSubjectName()));
                        if (!"studySub".equalsIgnoreCase(entityType) && !"subject".equalsIgnoreCase(entityType)) {
                            message.append(MessageFormat.format(respage.getString("mailDNParameters3"), note.getEventName()));
                            if (!"studyEvent".equalsIgnoreCase(note.getEntityType())) {
                                message.append(MessageFormat.format(respage.getString("mailDNParameters4"), note.getCrfName()));
                                if (!"eventCrf".equalsIgnoreCase(note.getEntityType())) {
                                    if (sectionId > 0) {
                                        message.append(MessageFormat.format(respage.getString("mailDNParameters5"), section.getName()));
                                    }
                                    message.append(MessageFormat.format(respage.getString("mailDNParameters6"), item.getName()));
                                }
                            }
                        }
                        message.append(respage.getString("email_body_separator"));
                        message.append(MessageFormat.format(respage.getString("mailDNThanks"), study.getName()));
                        message.append(respage.getString("email_body_separator"));
                        message.append(respage.getString("disclaimer"));
                        message.append(respage.getString("email_body_separator"));
                        message.append(respage.getString("email_footer"));
                        String emailBodyString = message.toString();
                        this.sendEmail(alertEmail.trim(), EmailEngine.getAdminEmail(), MessageFormat.format(respage.getString("mailDNSubject"), study.getName(), note.getEntityName()), emailBodyString, Boolean.valueOf(true), null, null, Boolean.valueOf(true));
                    } else {
                        logger.debug("did not send email, but did save DN");
                    }
                    this.addPageMessage(respage.getString("note_saved_into_db"));
                    this.addPageMessage(respage.getString("page_close_automatically"));
                    this.forwardPage(Page.ADD_DISCREPANCY_NOTE_SAVE_DONE);
                }
            } else {
                if (parentId > 0) {
                    if (note.getResolutionStatusId() == ResolutionStatus.NOT_APPLICABLE.getId()) {
                        this.request.setAttribute("autoView", (Object)"0");
                    }
                } else if (note.getDiscrepancyNoteTypeId() == DiscrepancyNoteType.QUERY.getId()) {
                    this.request.setAttribute("autoView", (Object)"1");
                } else {
                    this.request.setAttribute("autoView", (Object)"0");
                }
                this.setInputMessages(errors);
                this.forwardPage(Page.ADD_DISCREPANCY_NOTE);
            }
        }
    }

    public static String getAddChildURL(DiscrepancyNoteBean note, ResolutionStatus preset, boolean toView) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("name=" + note.getEntityType());
        arguments.add("id=" + note.getEntityId());
        arguments.add("writeToDB=1");
        arguments.add("monitor=1");
        if (preset.isActive()) {
            arguments.add("strResStatus=" + String.valueOf(preset.getId()));
        }
        if (toView) {
            String columnValue = "".equalsIgnoreCase(note.getColumn()) ? "value" : note.getColumn();
            arguments.add("column=" + columnValue);
            arguments.add("subjectId=" + note.getSubjectId());
            arguments.add("itemId=" + note.getItemId());
            String queryString = StringUtil.join((String)"&", arguments);
            return "ViewDiscrepancyNote?" + queryString;
        }
        arguments.add("parentId=" + note.getId());
        String queryString = StringUtil.join((String)"&", arguments);
        return "CreateDiscrepancyNote?" + queryString;
    }

    private void updateStudySubjectStatus(String entityType, int entityId) {
        if ("itemData".equalsIgnoreCase(entityType)) {
            EventCRFBean ec;
            StudyEventBean event;
            int itemDataId = entityId;
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            ItemDataBean itemData = (ItemDataBean)iddao.findByPK(itemDataId);
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.sm.getDataSource());
            StudySubjectBean studySubject = studySubjectDAO.findByPK((event = svdao.findByPK((ec = ecdao.findByPK(itemData.getEventCRFId())).getStudyEventId())).getStudySubjectId());
            if (studySubject.getStatus() != null && studySubject.getStatus().equals((Term)Status.SIGNED)) {
                studySubject.setStatus(Status.AVAILABLE);
                studySubject.setUpdater(this.ub);
                studySubject.setUpdatedDate(new Date());
                studySubjectDAO.update(studySubject);
            }
            if (ec.isSdvStatus()) {
                studySubject.setStatus(Status.AVAILABLE);
                studySubject.setUpdater(this.ub);
                studySubject.setUpdatedDate(new Date());
                studySubjectDAO.update(studySubject);
                ec.setSdvStatus(false);
                ec.setSdvUpdateId(this.ub.getId());
                ecdao.update(ec);
            }
        }
    }

    private ArrayList<StudyUserRoleBean> generateUserAccounts(int studyId, int subjectId) {
        UserAccountDAO userAccountDAO = new UserAccountDAO(this.sm.getDataSource());
        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
        StudyBean subjectStudy = studyDAO.findByStudySubjectId(subjectId);
        ArrayList userAccounts = new ArrayList();
        userAccounts = this.currentStudy.getParentStudyId() > 0 ? userAccountDAO.findAllUsersByStudyOrSite(studyId, this.currentStudy.getParentStudyId(), subjectId) : (subjectStudy.getParentStudyId() > 0 ? userAccountDAO.findAllUsersByStudyOrSite(subjectStudy.getId(), subjectStudy.getParentStudyId(), subjectId) : userAccountDAO.findAllUsersByStudyOrSite(studyId, 0, subjectId));
        return userAccounts;
    }

    private void updateStudyEvent(String entityType, int entityId) {
        if ("itemData".equalsIgnoreCase(entityType)) {
            EventCRFBean ec;
            int itemDataId = entityId;
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            ItemDataBean itemData = (ItemDataBean)iddao.findByPK(itemDataId);
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            StudyEventBean event = svdao.findByPK((ec = ecdao.findByPK(itemData.getEventCRFId())).getStudyEventId());
            if (event.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED)) {
                event.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
                event.setUpdater(this.ub);
                event.setUpdatedDate(new Date());
                svdao.update(event);
            }
        } else if ("eventCrf".equalsIgnoreCase(entityType)) {
            EventCRFBean ec;
            int eventCRFId = entityId;
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            StudyEventBean event = svdao.findByPK((ec = ecdao.findByPK(eventCRFId)).getStudyEventId());
            if (event.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED)) {
                event.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
                event.setUpdater(this.ub);
                event.setUpdatedDate(new Date());
                svdao.update(event);
            }
        }
    }

    private void manageReasonForChangeState(HttpSession session, String itemDataBeanId) {
        HashMap<String, Boolean> noteSubmitted = (HashMap<String, Boolean>)session.getAttribute("note_submitted");
        if (noteSubmitted == null) {
            noteSubmitted = new HashMap<String, Boolean>();
        }
        noteSubmitted.put(itemDataBeanId, Boolean.TRUE);
        session.setAttribute("note_submitted", noteSubmitted);
    }

    private int isWriteToDB(int isGroup, String field, int item_data_id, int item_id, int ordinal_for_repeating_group_field, int event_crf_id) {
        if (item_data_id > 0 && isGroup == -1) {
            return 1;
        }
        if (item_data_id < 0 && isGroup == -1) {
            return -1;
        }
        if (isGroup == 1) {
            if (item_data_id < 0) {
                return -1;
            }
            if (item_data_id > 0) {
                if (field.contains("_0input") || field.contains("manual")) {
                    ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource(), this.locale);
                    boolean isExistInDB = iddao.isItemExists(item_id, ordinal_for_repeating_group_field, event_crf_id);
                    return isExistInDB ? 1 : -1;
                }
                if (field.contains("input")) {
                    return -1;
                }
            }
        }
        return 0;
    }

    public int calculateOrdinal(int isGroup, String field_name, int event_crf_id, int rowCount) {
        int ordinal = 0;
        int start = -1;
        int end = -1;
        if (isGroup == -1) {
            return 1;
        }
        if (field_name.contains("_0input")) {
            return 1;
        }
        try {
            if (field_name.contains("manual")) {
                start = field_name.indexOf("manual") + 5;
                end = field_name.indexOf("input");
                if (start == 4 || end == -1) {
                    return 0;
                }
                ordinal = Integer.valueOf(field_name.substring(start + 1, end));
                return ordinal + 1;
            }
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource(), this.locale);
            String[] field_name_items = field_name.split("_");
            String group_oid = field_name.substring(0, field_name.indexOf(field_name_items[field_name_items.length - 1]) - 1);
            int maxOrdinal = iddao.getMaxOrdinalForGroupByGroupOID(group_oid, event_crf_id);
            end = field_name.indexOf("input");
            start = field_name.lastIndexOf("_");
            if (end == -1 || start == -1) {
                return 0;
            }
            ordinal = Integer.valueOf(field_name.substring(start + 1, end));
            return ordinal + maxOrdinal + rowCount;
        }
        catch (NumberFormatException numberFormatException) {
            return ordinal;
        }
    }

    private StudyEventBean getStudyEvent(int eventCRFId) {
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventBean event = sedao.findByPK(this.getEventCrf(eventCRFId).getStudyEventId());
        return event;
    }

    private StudyEventDefinitionBean getStudyEventDefinition(int eventCRFId) {
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sed = seddao.findByPK(this.getStudyEvent(eventCRFId).getStudyEventDefinitionId());
        return sed;
    }

    private CRFBean getCrf(int eventCRFId) {
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionBean cv = cvdao.findByPK(this.getEventCrf(eventCRFId).getCRFVersionId());
        CRFBean c = cdao.findByPK(cv.getCrfId());
        return c;
    }

    private EventCRFBean getEventCrf(int eventCRFId) {
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        EventCRFBean ec = ecdao.findByPK(eventCRFId);
        return ec;
    }
}

