/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.io.FilenameUtils;

public class DownloadAttachedFileServlet
extends SecureController {
    private static final long serialVersionUID = 3098103596566845378L;
    private static final int BUFFER_SIZE = 4096;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.request.setAttribute("downloadStatus", (Object)"false");
        this.addPageMessage(respage.getString("you_not_have_permission_download_attached_file"));
        throw new InsufficientPermissionException(Page.DOWNLOAD_ATTACHED_FILE, resexception.getString("no_permission"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String fileName = fp.getString("fileName");
        String filePathName = "";
        File file = null;
        if (fileName != null && fileName.length() > 0) {
            String attachedStudyFileRelDir = this.currentStudy.getOid() + File.separator;
            String testName = FilenameUtils.getName((String)fileName);
            file = this.getCoreResources().getAttachedFile(testName, attachedStudyFileRelDir);
            if (file != null && file.exists()) {
                filePathName = testName;
                logger.info(this.currentStudy.getName() + " existing filePathName=" + filePathName);
            } else {
                file = null;
                int parentStudyId = this.currentStudy.getParentStudyId();
                if (this.currentStudy.isSite(parentStudyId)) {
                    attachedStudyFileRelDir = new StudyDAO(this.sm.getDataSource()).findByPK(parentStudyId).getOid() + File.separator;
                    file = this.getCoreResources().getAttachedFile(testName, attachedStudyFileRelDir);
                    if (file.exists()) {
                        filePathName = testName;
                        logger.info("parent existing filePathName=" + filePathName);
                    } else {
                        file = null;
                    }
                } else {
                    ArrayList sites = new StudyDAO(this.sm.getDataSource()).findAllByParent(this.currentStudy.getId());
                    for (StudyBean site : sites) {
                        attachedStudyFileRelDir = site.getOid() + File.separator;
                        file = this.getCoreResources().getAttachedFile(testName, attachedStudyFileRelDir);
                        if (file != null && file.exists()) {
                            filePathName = testName;
                            logger.info("site of currentStudy existing filePathName=" + filePathName);
                            break;
                        }
                        file = null;
                    }
                }
            }
        }
        logger.info("filePathName=" + filePathName + " fileName=" + fileName);
        if (file == null || !file.exists() || file.length() <= 0L) {
            this.addPageMessage("File " + filePathName + " " + respage.getString("not_exist"));
        } else {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\";");
            this.response.setContentType("application/download");
            this.response.setHeader("Pragma", "public");
            this.response.setHeader("Cache-Control", "max-age=0");
            this.response.setContentLength((int)file.length());
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                int length;
                ServletOutputStream out = this.response.getOutputStream();
                byte[] buffer = new byte[4096];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
            }
            catch (Exception ee) {
                logger.error("Input Stream is not working properly: ", (Throwable)ee);
            }
        }
    }

    private CoreResources getCoreResources() {
        return (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources");
    }
}

