/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.domain.rule.RuleSetRuleBean;
import org.akaza.openclinica.domain.rule.RulesPostImportContainer;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRuleSetXmlServlet
extends SecureController {
    protected final Logger log = LoggerFactory.getLogger(DownloadRuleSetXmlServlet.class);
    private static final long serialVersionUID = 5381321212952389008L;
    RuleSetServiceInterface ruleSetService;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    private FileWriter handleLoadCastor(FileWriter writer, RulesPostImportContainer rpic) {
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(this.getCoreResources().getURL("mappingMarshaller.xml"));
            XMLContext xmlContext = new XMLContext();
            xmlContext.addMapping(mapping);
            Marshaller marshaller = xmlContext.createMarshaller();
            marshaller.setWriter((Writer)writer);
            marshaller.marshal((Object)rpic);
            return writer;
        }
        catch (FileNotFoundException ex) {
            throw new OpenClinicaSystemException(ex.getMessage(), ex.getCause());
        }
        catch (IOException ex) {
            throw new OpenClinicaSystemException(ex.getMessage(), ex.getCause());
        }
        catch (MarshalException e) {
            throw new OpenClinicaSystemException(e.getMessage(), e.getCause());
        }
        catch (ValidationException e) {
            throw new OpenClinicaSystemException(e.getMessage(), e.getCause());
        }
        catch (MappingException e) {
            throw new OpenClinicaSystemException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new OpenClinicaSystemException(e.getMessage(), e.getCause());
        }
    }

    private RulesPostImportContainer prepareRulesPostImportRuleSetRuleContainer(String ruleSetRuleIds) {
        ArrayList<RuleSetRuleBean> ruleSetRules = new ArrayList<RuleSetRuleBean>();
        RulesPostImportContainer rpic = new RulesPostImportContainer();
        if (ruleSetRuleIds != "") {
            String[] splitExpression;
            for (String string : splitExpression = ruleSetRuleIds.split(",")) {
                RuleSetRuleBean rsr = (RuleSetRuleBean)this.getRuleSetService().getRuleSetRuleDao().findById(Integer.valueOf(string));
                ruleSetRules.add(rsr);
            }
            rpic.populate(ruleSetRules);
        }
        return rpic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest() throws Exception {
        String ruleSetRuleIds = this.request.getParameter("ruleSetRuleIds");
        String dir = SQLInitServlet.getField((String)"filePath") + "rules" + File.separator;
        Long time = System.currentTimeMillis();
        File f = new File(dir + "rules" + this.currentStudy.getOid() + "-" + time + ".xml");
        FileWriter writer = new FileWriter(f);
        this.handleLoadCastor(writer, this.prepareRulesPostImportRuleSetRuleContainer(ruleSetRuleIds));
        this.response.setHeader("Content-disposition", "attachment; filename=\"rules" + this.currentStudy.getOid() + "-" + time + ".xml\";");
        this.response.setContentType("text/xml");
        this.response.setHeader("Pragma", "public");
        ServletOutputStream op = this.response.getOutputStream();
        FilterInputStream in = null;
        try {
            int length;
            this.response.setContentType("text/xml");
            this.response.setHeader("Pragma", "public");
            this.response.setContentLength((int)f.length());
            byte[] bbuf = new byte[(int)f.length()];
            in = new DataInputStream(new FileInputStream(f));
            while (in != null && (length = ((DataInputStream)in).read(bbuf)) != -1) {
                op.write(bbuf, 0, length);
            }
            in.close();
            op.flush();
            op.close();
        }
        catch (Exception ee) {
            logger.error("Unable to process the Input processRequest: ", (Throwable)ee);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (op != null) {
                op.close();
            }
        }
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }

    private CoreResources getCoreResources() {
        return (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources");
    }
}

