/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class FindStudyEventServlet
extends SecureController {
    private static final long serialVersionUID = -3575870316292737093L;
    Locale locale;
    public static final String INPUT_BROWSEBY = "browseBy";
    public static final String INPUT_PAGENUM = "pageNum";
    public static final String INPUT_ID = "id";
    public static final String ARG_BROWSEBY_SUBJECT = "Subject";
    public static final String ARG_BROWSEBY_DEFINITION = "StudyEventDefinition";
    public static final String ARG_DISPLAY_NEXT_PAGE_YES = "yes";
    public static final String ARG_DISPLAY_NEXT_PAGE_NO = "no";
    public static final String BEAN_DISPLAY_ENTITIES = "displayEntities";
    public static final String BEAN_DISPLAY_NEXT_PAGE = "displayNextPage";
    public static final String BEAN_ENTITY_WITH_STUDY_EVENTS = "entityWithStudyEvents";
    public static final int NUM_ENTITIES_PER_PAGE = 10;

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String browseBy = fp.getString(INPUT_BROWSEBY);
        int id = fp.getInt(INPUT_ID);
        if (browseBy.equals("")) {
            this.forwardPage(Page.FIND_STUDY_EVENTS_STEP1);
        } else if (this.invalidBrowseBy(browseBy)) {
            this.addPageMessage(respage.getString("must_browse_study_events_by_subject_or_event_definition"));
            this.forwardPage(Page.FIND_STUDY_EVENTS_STEP1);
        } else if (id <= 0) {
            int pageNum = fp.getInt(INPUT_PAGENUM);
            ArrayList allDisplayEntities = new ArrayList();
            if (browseBy.equals(ARG_BROWSEBY_SUBJECT)) {
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                allDisplayEntities = ssdao.findAllWithStudyEvent(this.currentStudy);
            } else {
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
                allDisplayEntities = seddao.findAllWithStudyEvent(this.currentStudy);
            }
            if (pageNum < 0) {
                pageNum = 0;
            } else if (pageNum > allDisplayEntities.size() / 10) {
                pageNum = allDisplayEntities.size() / 10;
            }
            int firstIndex = 10 * pageNum;
            int lastIndex = 10 * (pageNum + 1);
            if (allDisplayEntities.size() > lastIndex) {
                this.request.setAttribute(BEAN_DISPLAY_NEXT_PAGE, (Object)ARG_DISPLAY_NEXT_PAGE_YES);
            } else {
                this.request.setAttribute(BEAN_DISPLAY_NEXT_PAGE, (Object)ARG_DISPLAY_NEXT_PAGE_NO);
                lastIndex = allDisplayEntities.size();
            }
            List displayEntities = allDisplayEntities.subList(firstIndex, lastIndex);
            this.request.setAttribute(INPUT_BROWSEBY, (Object)browseBy);
            this.request.setAttribute(BEAN_DISPLAY_ENTITIES, displayEntities);
            this.request.setAttribute(INPUT_PAGENUM, (Object)new Integer(pageNum));
            this.forwardPage(Page.FIND_STUDY_EVENTS_STEP2);
        } else {
            StudySubjectBean entityWithStudyEvents;
            StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
            ArrayList events = new ArrayList();
            if (browseBy.equals(ARG_BROWSEBY_SUBJECT)) {
                events = sedao.findAllByStudyAndStudySubjectId(this.currentStudy, id);
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                entityWithStudyEvents = ssdao.findByPK(id);
            } else {
                events = sedao.findAllByStudyAndEventDefinitionId(this.currentStudy, id);
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
                entityWithStudyEvents = seddao.findByPK(id);
            }
            this.request.setAttribute(INPUT_BROWSEBY, (Object)browseBy);
            this.request.setAttribute(BEAN_DISPLAY_ENTITIES, (Object)events);
            this.request.setAttribute(BEAN_ENTITY_WITH_STUDY_EVENTS, (Object)entityWithStudyEvents);
            this.forwardPage(Page.FIND_STUDY_EVENTS_STEP3);
        }
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        String exceptionName = resexception.getString("no_permission_to_submit_data");
        String noAccessMessage = respage.getString("you_may_not_submit_data_for_this_study") + respage.getString("change_study_contact_sysadmin");
        if (SubmitDataServlet.maySubmitData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(noAccessMessage);
        throw new InsufficientPermissionException(Page.MENU, exceptionName, "1");
    }

    private boolean invalidBrowseBy(String browseBy) {
        if (browseBy.equals("")) {
            return true;
        }
        return !browseBy.equals(ARG_BROWSEBY_SUBJECT) && !browseBy.equals(ARG_BROWSEBY_DEFINITION);
    }
}

