/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.ListStudySubjectTableFactory;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ListStudySubjectsServlet
extends SecureController {
    private static final long serialVersionUID = 1L;
    private StudyEventDefinitionDAO studyEventDefinitionDAO;
    private SubjectDAO subjectDAO;
    private StudySubjectDAO studySubjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyDAO studyDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private StudyGroupDAO studyGroupDAO;
    private boolean showMoreLink;
    private StudyParameterValueDAO studyParameterValueDAO;
    Locale locale;

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    protected void processRequest() throws Exception {
        this.getCrfLocker().unlockAllForUser(this.ub.getId());
        FormProcessor fp = new FormProcessor(this.request);
        this.showMoreLink = fp.getString("showMoreLink").equals("") ? true : Boolean.parseBoolean(fp.getString("showMoreLink"));
        String idSetting = this.currentStudy.getStudyParameterConfig().getSubjectIdGeneration();
        if (idSetting.equals("auto editable") || idSetting.equals("auto non-editable")) {
            this.request.setAttribute("label", (Object)resword.getString("id_generated_Save_Add"));
            fp.addPresetValue("label", resword.getString("id_generated_Save_Add"));
        }
        if (fp.getRequest().getParameter("subjectOverlay") == null) {
            Date today = new Date(System.currentTimeMillis());
            String todayFormatted = this.local_df.format(today);
            HashMap presetValues = ClassCastHelper.asHashMap((Object)this.request.getAttribute("presetValues"), String.class, Object.class);
            if (presetValues != null) {
                fp.setPresetValues(presetValues);
            }
            fp.addPresetValue("enrollmentDate", todayFormatted);
            fp.addPresetValue("startDate", todayFormatted);
            this.setPresetValues(fp.getPresetValues());
        }
        this.request.setAttribute("closeInfoShowIcons", (Object)true);
        if (fp.getString("navBar").equals("yes") && fp.getString("findSubjects_f_studySubject.label").trim().length() > 0) {
            StudySubjectBean studySubject = this.getStudySubjectDAO().findByLabelAndStudy(fp.getString("findSubjects_f_studySubject.label"), this.currentStudy);
            if (studySubject.getId() > 0) {
                this.request.setAttribute("id", (Object)new Integer(studySubject.getId()).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            } else {
                this.createTable();
            }
        } else {
            this.createTable();
        }
    }

    private void createTable() {
        ListStudySubjectTableFactory factory = new ListStudySubjectTableFactory(this.showMoreLink);
        factory.setStudyEventDefinitionDao(this.getStudyEventDefinitionDao());
        factory.setSubjectDAO(this.getSubjectDAO());
        factory.setStudySubjectDAO(this.getStudySubjectDAO());
        factory.setStudyEventDAO(this.getStudyEventDAO());
        factory.setStudyBean(this.currentStudy);
        factory.setStudyGroupClassDAO(this.getStudyGroupClassDAO());
        factory.setSubjectGroupMapDAO(this.getSubjectGroupMapDAO());
        factory.setStudyDAO(this.getStudyDAO());
        factory.setCurrentRole(this.currentRole);
        factory.setCurrentUser(this.ub);
        factory.setEventCRFDAO(this.getEventCRFDAO());
        factory.setEventDefintionCRFDAO(this.getEventDefinitionCRFDAO());
        factory.setStudyGroupDAO(this.getStudyGroupDAO());
        factory.setStudyParameterValueDAO(this.getStudyParameterValueDAO());
        String findSubjectsHtml = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("findSubjectsHtml", (Object)findSubjectsHtml);
        this.request.setAttribute("allDefsArray", (Object)super.getEventDefinitionsByCurrentStudy());
        this.request.setAttribute("studyGroupClasses", (Object)super.getStudyGroupClassesByCurrentStudy());
        FormDiscrepancyNotes discNotes = new FormDiscrepancyNotes();
        this.session.setAttribute("fdnotes", (Object)discNotes);
        this.forwardPage(Page.LIST_STUDY_SUBJECTS);
    }

    protected String getAdminServlet() {
        return "admin";
    }

    public StudyParameterValueDAO getStudyParameterValueDAO() {
        this.studyParameterValueDAO = this.studyParameterValueDAO == null ? new StudyParameterValueDAO(this.sm.getDataSource()) : this.studyParameterValueDAO;
        return this.studyParameterValueDAO;
    }

    public void setStudyParameterValueDAO(StudyParameterValueDAO studyParameterValueDAO) {
        this.studyParameterValueDAO = studyParameterValueDAO;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        this.studyEventDefinitionDAO = this.studyEventDefinitionDAO == null ? new StudyEventDefinitionDAO(this.sm.getDataSource()) : this.studyEventDefinitionDAO;
        return this.studyEventDefinitionDAO;
    }

    public SubjectDAO getSubjectDAO() {
        this.subjectDAO = this.subjectDAO == null ? new SubjectDAO(this.sm.getDataSource()) : this.subjectDAO;
        return this.subjectDAO;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        this.studySubjectDAO = this.studySubjectDAO == null ? new StudySubjectDAO(this.sm.getDataSource()) : this.studySubjectDAO;
        return this.studySubjectDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        this.studyGroupClassDAO = this.studyGroupClassDAO == null ? new StudyGroupClassDAO(this.sm.getDataSource()) : this.studyGroupClassDAO;
        return this.studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        this.subjectGroupMapDAO = this.subjectGroupMapDAO == null ? new SubjectGroupMapDAO(this.sm.getDataSource()) : this.subjectGroupMapDAO;
        return this.subjectGroupMapDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        this.studyEventDAO = this.studyEventDAO == null ? new StudyEventDAO(this.sm.getDataSource()) : this.studyEventDAO;
        return this.studyEventDAO;
    }

    public StudyDAO getStudyDAO() {
        this.studyDAO = this.studyDAO == null ? new StudyDAO(this.sm.getDataSource()) : this.studyDAO;
        return this.studyDAO;
    }

    public EventCRFDAO getEventCRFDAO() {
        this.eventCRFDAO = this.eventCRFDAO == null ? new EventCRFDAO(this.sm.getDataSource()) : this.eventCRFDAO;
        return this.eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefinitionCRFDAO() {
        this.eventDefintionCRFDAO = this.eventDefintionCRFDAO == null ? new EventDefinitionCRFDAO(this.sm.getDataSource()) : this.eventDefintionCRFDAO;
        return this.eventDefintionCRFDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        this.studyGroupDAO = this.studyGroupDAO == null ? new StudyGroupDAO(this.sm.getDataSource()) : this.studyGroupDAO;
        return this.studyGroupDAO;
    }
}

