/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.HashMap;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.pform.EnketoAPI;
import org.akaza.openclinica.web.pform.EnketoCredentials;

public class ParticipantFormServlet
extends SecureController {
    private static final long serialVersionUID = 1870794659352123090L;
    public static final String CRF_ID = "crfOID";
    public static final String FORM_URL = "formURL";

    protected void processRequest() throws Exception {
        String crf_oid = this.request.getParameter(CRF_ID);
        String formURL = null;
        if (this.currentStudy.getStudyParameterConfig().getParticipantPortal().equals("enabled")) {
            EnketoCredentials credentials = this.getCredentials();
            EnketoAPI enketo = new EnketoAPI(credentials);
            formURL = enketo.getFormPreviewURL(crf_oid);
            if (!formURL.equals("")) {
                this.response.sendRedirect(formURL);
            } else {
                if (credentials.getServerUrl() == null) {
                    this.addPageMessage(respage.getString("pform_preview_missing_url"));
                } else if (credentials.getApiKey() != null && credentials.getOcInstanceUrl() != null) {
                    this.addPageMessage(respage.getString("pform_preview_forbidden"));
                } else {
                    this.addPageMessage(respage.getString("participate_not_available"));
                }
                this.forwardPage(Page.MENU_SERVLET);
            }
        }
    }

    protected void mayProceed() throws InsufficientPermissionException {
    }

    private EnketoCredentials getCredentials() throws Exception {
        EnketoCredentials credentials = null;
        HashMap<String, EnketoCredentials> credentialsMap = (HashMap<String, EnketoCredentials>)this.session.getAttribute("EnketoCredentialsMap");
        if (credentialsMap == null) {
            credentialsMap = new HashMap<String, EnketoCredentials>();
            credentials = EnketoCredentials.getInstance((String)this.currentStudy.getOid());
            credentialsMap.put(this.currentStudy.getOid(), credentials);
            this.session.setAttribute("EnketoCredentialsMap", credentialsMap);
        } else if (credentialsMap.get(this.currentStudy.getOid()) == null) {
            credentials = EnketoCredentials.getInstance((String)this.currentStudy.getOid());
            credentialsMap.put(this.currentStudy.getOid(), credentials);
        } else {
            credentials = (EnketoCredentials)credentialsMap.get(this.currentStudy.getOid());
        }
        return credentials;
    }
}

