/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.ViewRuleAssignmentTableFactory;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.crfdata.HideCRFManager;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.service.rule.RulesPostImportContainerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewRuleAssignmentNewServlet
extends SecureController {
    private static final long serialVersionUID = 9116068126651934226L;
    protected final Logger log = LoggerFactory.getLogger(ViewRuleAssignmentNewServlet.class);
    Locale locale;
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    RuleSetServiceInterface ruleSetService;
    RulesPostImportContainerService rulesPostImportContainerService;
    ItemFormMetadataDAO itemFormMetadataDAO;
    private boolean showMoreLink;
    private boolean isDesigner;

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        this.isDesigner = fp.getString("designer").equals("") ? false : Boolean.parseBoolean(fp.getString("designer"));
        this.showMoreLink = fp.getString("showMoreLink").equals("") ? true : Boolean.parseBoolean(fp.getString("showMoreLink"));
        this.createTable();
    }

    private void createStudyEventForInfoPanel() {
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        ItemDAO itemdao = new ItemDAO(this.sm.getDataSource());
        StudyBean studyWithEventDefinitions = this.currentStudy;
        if (this.currentStudy.getParentStudyId() > 0) {
            studyWithEventDefinitions = new StudyBean();
            studyWithEventDefinitions.setId(this.currentStudy.getParentStudyId());
        }
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        ArrayList seds = seddao.findAllActiveByStudy(studyWithEventDefinitions);
        LinkedHashMap<StudyEventDefinitionBean, ArrayList> events = new LinkedHashMap<StudyEventDefinitionBean, ArrayList>();
        for (int i = 0; i < seds.size(); ++i) {
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seds.get(i);
            ArrayList crfs = crfdao.findAllActiveByDefinition(sed);
            if (this.currentStudy.getParentStudyId() > 0) {
                HideCRFManager hideCRFs = HideCRFManager.createHideCRFManager();
                crfs = hideCRFs.removeHiddenCRFBeans(studyWithEventDefinitions, sed, crfs, this.sm.getDataSource());
            }
            if (crfs.isEmpty()) continue;
            events.put(sed, crfs);
        }
        this.request.setAttribute("eventlist", events);
        this.request.setAttribute("crfCount", (Object)crfdao.getCountofActiveCRFs());
        this.request.setAttribute("itemCount", (Object)itemdao.getCountofActiveItems());
        this.request.setAttribute("ruleSetCount", (Object)this.getRuleSetService().getRuleSetDao().count(this.currentStudy));
    }

    private void createTable() {
        this.getCoreResources();
        this.getCoreResources();
        ViewRuleAssignmentTableFactory factory = new ViewRuleAssignmentTableFactory(this.showMoreLink, CoreResources.getField((String)"designer.url") + "access?host=" + this.getHostPathFromSysUrl(CoreResources.getField((String)"sysURL.base"), this.request.getContextPath()) + "&app=" + this.getContextPath(this.request), this.isDesigner);
        factory.setRuleSetService(this.getRuleSetService());
        factory.setItemFormMetadataDAO(this.getItemFormMetadataDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setCurrentUser((UserAccountBean)this.request.getSession().getAttribute("userBean"));
        String ruleAssignmentsHtml = factory.createTable(this.request, this.response).render();
        this.request.getSession().setAttribute("ruleDesignerUrl", (Object)factory.getDesingerLink());
        this.request.setAttribute("ruleAssignmentsHtml", (Object)ruleAssignmentsHtml);
        this.createStudyEventForInfoPanel();
        if (ruleAssignmentsHtml != null) {
            if (this.isDesigner) {
                this.forwardPage(Page.VIEW_RULE_SETS_DESIGNER);
            } else {
                this.forwardPage(Page.VIEW_RULE_SETS2);
            }
        }
    }

    private String getHostPathFromSysUrl(String sysURL, String contextPath) {
        return sysURL.replaceAll(contextPath + "/", "");
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath().replaceAll("/", "");
        return contextPath;
    }

    public String getHostPath(HttpServletRequest request) {
        String requestURLMinusServletPath = this.getRequestURLMinusServletPath(request);
        String hostPath = "";
        if (null != requestURLMinusServletPath) {
            hostPath = requestURLMinusServletPath.substring(0, requestURLMinusServletPath.lastIndexOf("/"));
        }
        return hostPath;
    }

    public String getRequestURLMinusServletPath(HttpServletRequest request) {
        String requestURLMinusServletPath = request.getRequestURL().toString().replaceAll(request.getServletPath(), "");
        return requestURLMinusServletPath;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }

    public ItemFormMetadataDAO getItemFormMetadataDAO() {
        this.itemFormMetadataDAO = this.itemFormMetadataDAO == null ? new ItemFormMetadataDAO(this.sm.getDataSource()) : this.itemFormMetadataDAO;
        return this.itemFormMetadataDAO;
    }

    private CoreResources getCoreResources() {
        return (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources");
    }
}

