/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.ViewRuleAssignmentRow;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.service.rule.RulesPostImportContainerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.domain.EntityBeanTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewRuleAssignmentServlet
extends SecureController {
    private static final long serialVersionUID = 9116068126651934226L;
    protected final Logger log = LoggerFactory.getLogger(ViewRuleAssignmentServlet.class);
    Locale locale;
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    RuleSetServiceInterface ruleSetService;
    RulesPostImportContainerService rulesPostImportContainerService;

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        List ruleSets = this.getRuleSetService().getRuleSetsByStudy(this.currentStudy);
        ruleSets = this.getRuleSetService().filterByStatusEqualsAvailableOnlyRuleSetRules(ruleSets);
        EntityBeanTable table = fp.getWebEntityBeanTable();
        ArrayList allRows = ViewRuleAssignmentRow.generateRowsFromBeans((List)ruleSets);
        String[] columns = new String[]{resword.getString("rule_study_event_definition"), resword.getString("CRF_name"), resword.getString("rule_group_label"), resword.getString("rule_item_name"), resword.getString("rule_rules"), resword.getString("rule_ref_oid"), resword.getString("rule_action_type"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(4);
        table.hideColumnLink(5);
        table.hideColumnLink(6);
        table.setQuery("ViewRuleAssignment", new HashMap());
        table.addLink(resword.getString("test_rule_title"), "TestRule");
        table.setRows(allRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        if (this.request.getParameter("read") != null && this.request.getParameter("read").equals("true")) {
            this.request.setAttribute("readOnly", (Object)true);
        }
        this.forwardPage(Page.VIEW_RULE_SETS);
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.INVESTIGATOR) || r.equals((Term)Role.RESEARCHASSISTANT) || r.equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }
}

