/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.dao.hibernate.EventCrfFlagDao;
import org.akaza.openclinica.dao.hibernate.EventCrfFlagWorkflowDao;
import org.akaza.openclinica.dao.hibernate.IdtViewDao;
import org.akaza.openclinica.dao.hibernate.ItemDataFlagDao;
import org.akaza.openclinica.dao.hibernate.ItemDataFlagWorkflowDao;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.datamap.EventCrfFlag;
import org.akaza.openclinica.domain.datamap.EventCrfFlagWorkflow;
import org.akaza.openclinica.domain.datamap.IdtView;
import org.akaza.openclinica.domain.datamap.ItemDataFlag;
import org.akaza.openclinica.domain.datamap.ItemDataFlagWorkflow;
import org.akaza.openclinica.domain.user.UserAccount;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"auth/api/itemdata"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class IdtViewController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ServletContext context;
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    IdtViewDao idtViewDao;
    @Autowired
    ItemDataFlagDao itemDataFlagDao;
    @Autowired
    EventCrfFlagWorkflowDao eventCrfFlagWorkflowDao;
    @Autowired
    ItemDataFlagWorkflowDao itemDataFlagWorkflowDao;
    @Autowired
    EventCrfFlagDao eventCrfFlagDao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    StudyDAO sdao;

    @RequestMapping(value={"/sdv/{filternumber}/{studyoid}/paginated"}, params={"page", "per_page"}, method={RequestMethod.GET})
    public ResponseEntity<List<IdtView>> getPaginatedIdtViewData(@PathVariable(value="filternumber") String filterNumber, @PathVariable(value="studyoid") String studyOid, @RequestParam(value="page") int page, @RequestParam(value="per_page") int per_page) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        List idtDTO = null;
        if (page == 0) {
            page = 1;
        }
        if (per_page == 0) {
            per_page = 30;
        }
        this.logger.debug("I'm in getPaginatedIdtViewData");
        StudyBean parentStudy = this.getParentStudy(studyOid);
        Integer pStudyId = parentStudy.getId();
        Integer studyId = this.getStudy(studyOid).getId();
        ArrayList studySubjects = new ArrayList();
        ArrayList studyEventDefinitions = new ArrayList();
        ArrayList crfs = new ArrayList();
        int tagId = 1;
        int filter = Integer.valueOf(filterNumber);
        if (studyId == pStudyId) {
            if (filter == 1) {
                idtDTO = this.getIdtViewDao().findFilter1(studyId.intValue(), pStudyId.intValue(), per_page, page, studySubjects, studyEventDefinitions, crfs, tagId, "OR");
            }
        } else if (filter == 1) {
            idtDTO = this.getIdtViewDao().findFilter1(studyId.intValue(), pStudyId.intValue(), per_page, page, studySubjects, studyEventDefinitions, crfs, tagId, "AND");
        }
        return new ResponseEntity(idtDTO, HttpStatus.OK);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public ResponseEntity<?> postSDVedItemDataAndEventCrfWorkflow(@RequestBody ArrayList<HashMap<String, String>> maps) throws Exception {
        int tagId = 1;
        UserAccount userAccount = null;
        HashSet<String> listOfEventCrfPaths = new HashSet<String>();
        for (HashMap<String, String> map : maps) {
            String eventCrfPath = map.get("ssOid") + "." + map.get("sedOid") + "." + map.get("eventOrdinal") + "." + map.get("crfOid");
            String itemDataPath = eventCrfPath + "." + map.get("groupOid") + "." + map.get("groupOrdinal") + "." + map.get("itemOid");
            String workflowStatus = map.get("itemDataWorkflowStatus");
            listOfEventCrfPaths.add(eventCrfPath);
            this.saveOrUpdateItemDataFlag(tagId, itemDataPath, workflowStatus);
        }
        for (String eventCrfPath : listOfEventCrfPaths) {
            this.saveOrUpdateEventCrfFlag(tagId, eventCrfPath, userAccount);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    public void saveOrUpdateItemDataFlag(int tagId, String itemDataPath, String workflowStatus) {
        ItemDataFlag itemDataFlag = null;
        ItemDataFlagWorkflow itemDataFlagWorkflow = null;
        itemDataFlag = this.getItemDataFlagDao().findByItemDataPath(tagId, itemDataPath);
        if (itemDataFlag != null) {
            itemDataFlagWorkflow = (ItemDataFlagWorkflow)this.getItemDataFlagWorkflowDao().findById(itemDataFlag.getItemDataFlagWorkflow().getId());
            itemDataFlagWorkflow.setDateUpdated(new Date());
            itemDataFlagWorkflow.setWorkflowStatus(workflowStatus);
            this.getItemDataFlagWorkflowDao().saveOrUpdate((DomainObject)itemDataFlagWorkflow);
            itemDataFlag.setDateUpdated(new Date());
            this.getItemDataFlagDao().saveOrUpdate((DomainObject)itemDataFlag);
        } else {
            itemDataFlagWorkflow = new ItemDataFlagWorkflow();
            itemDataFlagWorkflow.setDateCreated(new Date());
            itemDataFlagWorkflow.setWorkflowId("abcd");
            itemDataFlagWorkflow.setWorkflowStatus(workflowStatus);
            ItemDataFlagWorkflow idfw = (ItemDataFlagWorkflow)this.getItemDataFlagWorkflowDao().saveOrUpdate((DomainObject)itemDataFlagWorkflow);
            itemDataFlag = new ItemDataFlag();
            itemDataFlag.setPath(itemDataPath);
            itemDataFlag.setDateCreated(new Date());
            itemDataFlag.setUserAccount(null);
            itemDataFlag.setTagId(tagId);
            itemDataFlag.setItemDataFlagWorkflow(idfw);
            this.getItemDataFlagDao().saveOrUpdate((DomainObject)itemDataFlag);
        }
    }

    public void saveOrUpdateEventCrfFlag(int tagId, String eventCrfPath, UserAccount ua) {
        EventCrfFlag eventCrfFlag = null;
        EventCrfFlagWorkflow eventCrfFlagWorkflow = null;
        ArrayList itemDataFlags = (ArrayList)this.getItemDataFlagDao().findAllByEventCrfPath(tagId, eventCrfPath);
        eventCrfFlag = this.getEventCrfFlagDao().findByEventCrfPath(tagId, eventCrfPath);
        if (itemDataFlags.size() != 0) {
            if (eventCrfFlag != null) {
                eventCrfFlagWorkflow = (EventCrfFlagWorkflow)this.getEventCrfFlagWorkflowDao().findById(eventCrfFlag.getEventCrfFlagWorkflow().getId());
                eventCrfFlagWorkflow.setDateUpdated(new Date());
                this.getEventCrfFlagWorkflowDao().saveOrUpdate((DomainObject)eventCrfFlagWorkflow);
                eventCrfFlag.setDateUpdated(new Date());
                this.getEventCrfFlagDao().saveOrUpdate((DomainObject)eventCrfFlag);
            } else {
                eventCrfFlagWorkflow = new EventCrfFlagWorkflow();
                eventCrfFlagWorkflow.setDateCreated(new Date());
                eventCrfFlagWorkflow.setWorkflowId("abcd");
                EventCrfFlagWorkflow ecfw = (EventCrfFlagWorkflow)this.getEventCrfFlagWorkflowDao().saveOrUpdate((DomainObject)eventCrfFlagWorkflow);
                EventCrfFlag eventCrfFg = new EventCrfFlag();
                eventCrfFg.setPath(eventCrfPath);
                eventCrfFg.setTagId(1);
                eventCrfFg.setDateCreated(new Date());
                eventCrfFg.setUserAccount(ua);
                eventCrfFg.setEventCrfFlagWorkflow(ecfw);
                this.getEventCrfFlagDao().saveOrUpdate((DomainObject)eventCrfFg);
            }
        }
    }

    private StudyBean getStudy(String oid) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByOid(oid);
        return studyBean;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    public IdtViewDao getIdtViewDao() {
        return this.idtViewDao;
    }

    public ItemDataFlagDao getItemDataFlagDao() {
        return this.itemDataFlagDao;
    }

    public EventCrfFlagDao getEventCrfFlagDao() {
        return this.eventCrfFlagDao;
    }

    public EventCrfFlagWorkflowDao getEventCrfFlagWorkflowDao() {
        return this.eventCrfFlagWorkflowDao;
    }

    public ItemDataFlagWorkflowDao getItemDataFlagWorkflowDao() {
        return this.itemDataFlagWorkflowDao;
    }
}

