/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.odm.AdminDataReportBean;
import org.akaza.openclinica.bean.extract.odm.FullReportBean;
import org.akaza.openclinica.bean.extract.odm.MetaDataReportBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.odmbeans.ODMBean;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.domain.rule.AuditableBeanWrapper;
import org.akaza.openclinica.domain.rule.RuleBean;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleBean;
import org.akaza.openclinica.domain.rule.RulesPostImportContainer;
import org.akaza.openclinica.domain.rule.action.DiscrepancyNoteActionBean;
import org.akaza.openclinica.domain.rule.action.EmailActionBean;
import org.akaza.openclinica.domain.rule.action.EventActionBean;
import org.akaza.openclinica.domain.rule.action.EventPropertyBean;
import org.akaza.openclinica.domain.rule.action.HideActionBean;
import org.akaza.openclinica.domain.rule.action.InsertActionBean;
import org.akaza.openclinica.domain.rule.action.NotificationActionBean;
import org.akaza.openclinica.domain.rule.action.PropertyBean;
import org.akaza.openclinica.domain.rule.action.RuleActionBean;
import org.akaza.openclinica.domain.rule.action.ShowActionBean;
import org.akaza.openclinica.domain.rule.expression.Context;
import org.akaza.openclinica.domain.rule.expression.ExpressionBean;
import org.akaza.openclinica.domain.rule.expression.ExpressionObjectWrapper;
import org.akaza.openclinica.domain.rule.expression.ExpressionProcessor;
import org.akaza.openclinica.domain.rule.expression.ExpressionProcessorFactory;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.logic.odmExport.AdminDataCollector;
import org.akaza.openclinica.logic.odmExport.MetaDataCollector;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.service.rule.RulesPostImportContainerService;
import org.apache.commons.dbcp.BasicDataSource;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.openclinica.ns.response.v31.MessagesType;
import org.openclinica.ns.response.v31.Response;
import org.openclinica.ns.rules.v31.DiscrepancyNoteActionType;
import org.openclinica.ns.rules.v31.EmailActionType;
import org.openclinica.ns.rules.v31.EventActionType;
import org.openclinica.ns.rules.v31.EventDestinationType;
import org.openclinica.ns.rules.v31.HideActionType;
import org.openclinica.ns.rules.v31.InsertActionType;
import org.openclinica.ns.rules.v31.NotificationActionType;
import org.openclinica.ns.rules.v31.PropertyType;
import org.openclinica.ns.rules.v31.RuleAssignmentType;
import org.openclinica.ns.rules.v31.RuleDefType;
import org.openclinica.ns.rules.v31.RuleRefType;
import org.openclinica.ns.rules.v31.Rules;
import org.openclinica.ns.rules.v31.RunOnScheduleType;
import org.openclinica.ns.rules.v31.ShowActionType;
import org.openclinica.ns.rules.v31.TargetType;
import org.openclinica.ns.rules_test.v31.ParameterType;
import org.openclinica.ns.rules_test.v31.RulesTest;
import org.openclinica.ns.rules_test.v31.RulesTestMessagesType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/rule"})
public class RuleController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    private RuleSetRuleDao ruleSetRuleDao;
    private RuleSetServiceInterface ruleSetService;
    private RulesPostImportContainerService rulesPostImportContainerService;
    private MessageSource messageSource;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Autowired
    CoreResources coreResources;
    private static final String DUPLICATE_MESSAGE = "DUPLICATE";

    private RulesPostImportContainer mapRulesToRulesPostImportContainer(Rules rules) {
        RulesPostImportContainer rpic = new RulesPostImportContainer();
        for (RuleAssignmentType rat : rules.getRuleAssignment()) {
            TargetType targetType = rat.getTarget();
            ExpressionBean targetBean = new ExpressionBean(Context.OC_RULES_V1, targetType.getValue());
            RunOnScheduleType scheduleType = ((RuleAssignmentType)rules.getRuleAssignment().get(0)).getRunOnSchedule();
            RuleSetBean ruleSetBean = new RuleSetBean();
            ruleSetBean.setOriginalTarget(targetBean);
            if (scheduleType != null && !scheduleType.getTime().equals("")) {
                ruleSetBean.setRunTime(scheduleType.getTime());
            }
            for (RuleRefType rrt : rat.getRuleRef()) {
                ExpressionBean expressionBean;
                PropertyBean property;
                DiscrepancyNoteActionBean action;
                RuleSetRuleBean ruleSetRuleBean = new RuleSetRuleBean();
                ruleSetRuleBean.setOid(rrt.getOID());
                for (DiscrepancyNoteActionType discrepancyNoteActionType : rrt.getDiscrepancyNoteAction()) {
                    action = new DiscrepancyNoteActionBean();
                    action.setMessage(discrepancyNoteActionType.getMessage());
                    action.setExpressionEvaluatesTo(Boolean.valueOf(discrepancyNoteActionType.getIfExpressionEvaluates()));
                    action.getRuleActionRun().setInitialDataEntry(Boolean.valueOf(discrepancyNoteActionType.getRun().isInitialDataEntry()));
                    action.getRuleActionRun().setDoubleDataEntry(Boolean.valueOf(discrepancyNoteActionType.getRun().isDoubleDataEntry()));
                    action.getRuleActionRun().setAdministrativeDataEntry(Boolean.valueOf(discrepancyNoteActionType.getRun().isAdministrativeDataEntry()));
                    action.getRuleActionRun().setImportDataEntry(Boolean.valueOf(discrepancyNoteActionType.getRun().isImportDataEntry()));
                    action.getRuleActionRun().setBatch(Boolean.valueOf(discrepancyNoteActionType.getRun().isBatch()));
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                }
                for (EmailActionType emailActionType : rrt.getEmailAction()) {
                    action = new EmailActionBean();
                    action.setMessage(emailActionType.getMessage());
                    action.setTo(emailActionType.getTo());
                    action.setExpressionEvaluatesTo(Boolean.valueOf(emailActionType.getIfExpressionEvaluates()));
                    action.getRuleActionRun().setInitialDataEntry(Boolean.valueOf(emailActionType.getRun().isInitialDataEntry()));
                    action.getRuleActionRun().setDoubleDataEntry(Boolean.valueOf(emailActionType.getRun().isDoubleDataEntry()));
                    action.getRuleActionRun().setAdministrativeDataEntry(Boolean.valueOf(emailActionType.getRun().isAdministrativeDataEntry()));
                    action.getRuleActionRun().setImportDataEntry(Boolean.valueOf(emailActionType.getRun().isImportDataEntry()));
                    action.getRuleActionRun().setBatch(Boolean.valueOf(emailActionType.getRun().isBatch()));
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                }
                for (ShowActionType showActionType : rrt.getShowAction()) {
                    action = new ShowActionBean();
                    action.setMessage(showActionType.getMessage());
                    action.setExpressionEvaluatesTo(Boolean.valueOf(showActionType.getIfExpressionEvaluates()));
                    action.getRuleActionRun().setInitialDataEntry(Boolean.valueOf(showActionType.getRun().isInitialDataEntry()));
                    action.getRuleActionRun().setDoubleDataEntry(Boolean.valueOf(showActionType.getRun().isDoubleDataEntry()));
                    action.getRuleActionRun().setAdministrativeDataEntry(Boolean.valueOf(showActionType.getRun().isAdministrativeDataEntry()));
                    action.getRuleActionRun().setImportDataEntry(Boolean.valueOf(showActionType.getRun().isImportDataEntry()));
                    action.getRuleActionRun().setBatch(Boolean.valueOf(showActionType.getRun().isBatch()));
                    for (PropertyType propertyType : showActionType.getDestinationProperty()) {
                        property = new PropertyBean();
                        property.setOid(propertyType.getOID());
                        action.addProperty(property);
                    }
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                }
                for (HideActionType hideActionType : rrt.getHideAction()) {
                    action = new HideActionBean();
                    action.setMessage(hideActionType.getMessage());
                    action.setExpressionEvaluatesTo(Boolean.valueOf(hideActionType.getIfExpressionEvaluates()));
                    action.getRuleActionRun().setInitialDataEntry(Boolean.valueOf(hideActionType.getRun().isInitialDataEntry()));
                    action.getRuleActionRun().setDoubleDataEntry(Boolean.valueOf(hideActionType.getRun().isDoubleDataEntry()));
                    action.getRuleActionRun().setAdministrativeDataEntry(Boolean.valueOf(hideActionType.getRun().isAdministrativeDataEntry()));
                    action.getRuleActionRun().setImportDataEntry(Boolean.valueOf(hideActionType.getRun().isImportDataEntry()));
                    action.getRuleActionRun().setBatch(Boolean.valueOf(hideActionType.getRun().isBatch()));
                    for (PropertyType propertyType : hideActionType.getDestinationProperty()) {
                        property = new PropertyBean();
                        property.setOid(propertyType.getOID());
                        action.addProperty(property);
                    }
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                }
                for (InsertActionType insertActionType : rrt.getInsertAction()) {
                    action = new InsertActionBean();
                    action.setExpressionEvaluatesTo(Boolean.valueOf(insertActionType.getIfExpressionEvaluates()));
                    action.getRuleActionRun().setInitialDataEntry(Boolean.valueOf(insertActionType.getRun().isInitialDataEntry()));
                    action.getRuleActionRun().setDoubleDataEntry(Boolean.valueOf(insertActionType.getRun().isDoubleDataEntry()));
                    action.getRuleActionRun().setAdministrativeDataEntry(Boolean.valueOf(insertActionType.getRun().isAdministrativeDataEntry()));
                    action.getRuleActionRun().setImportDataEntry(Boolean.valueOf(insertActionType.getRun().isImportDataEntry()));
                    action.getRuleActionRun().setBatch(Boolean.valueOf(insertActionType.getRun().isBatch()));
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                    for (PropertyType propertyType : insertActionType.getDestinationProperty()) {
                        property = new PropertyBean();
                        property.setOid(propertyType.getOID());
                        property.setValue(propertyType.getValue());
                        expressionBean = new ExpressionBean(Context.OC_RULES_V1, propertyType.getValueExpression().getValue());
                        property.setValueExpression(expressionBean);
                        action.addProperty(property);
                    }
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                }
                for (EventActionType eventActionType : rrt.getEventAction()) {
                    action = new EventActionBean();
                    action.setExpressionEvaluatesTo(Boolean.valueOf(eventActionType.getIfExpressionEvaluates()));
                    action.setOc_oid_reference(eventActionType.getOID());
                    action.getRuleActionRun().setNot_started(Boolean.valueOf(eventActionType.getRunOnStatus().isNotScheduled()));
                    action.getRuleActionRun().setScheduled(Boolean.valueOf(eventActionType.getRunOnStatus().isScheduled()));
                    action.getRuleActionRun().setData_entry_started(Boolean.valueOf(eventActionType.getRunOnStatus().isDataEntryStarted()));
                    action.getRuleActionRun().setComplete(Boolean.valueOf(eventActionType.getRunOnStatus().isCompleted()));
                    action.getRuleActionRun().setSkipped(Boolean.valueOf(eventActionType.getRunOnStatus().isSkipped()));
                    action.getRuleActionRun().setStopped(Boolean.valueOf(eventActionType.getRunOnStatus().isStopped()));
                    for (EventDestinationType eventDestinationType : eventActionType.getEventDestination()) {
                        property = new EventPropertyBean();
                        property.setProperty(eventDestinationType.getProperty());
                        expressionBean = new ExpressionBean(Context.OC_RULES_V1, eventDestinationType.getValueExpression().getValue());
                        property.setValueExpression(expressionBean);
                        action.addProperty(property);
                    }
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                }
                for (NotificationActionType notificationActionType : rrt.getNotificationAction()) {
                    action = new NotificationActionBean();
                    action.setExpressionEvaluatesTo(Boolean.valueOf(notificationActionType.getIfExpressionEvaluates()));
                    action.setTo(notificationActionType.getTo());
                    action.setSubject(notificationActionType.getSubject());
                    action.setMessage(notificationActionType.getMessage());
                    ruleSetRuleBean.addAction((RuleActionBean)action);
                }
                ruleSetBean.addRuleSetRule(ruleSetRuleBean);
            }
            rpic.addRuleSet(ruleSetBean);
        }
        for (RuleDefType rdt : rules.getRuleDef()) {
            RuleBean ruleBean = new RuleBean();
            ExpressionBean ruleExpressionBean = new ExpressionBean(Context.OC_RULES_V1, rdt.getExpression().getValue());
            ruleBean.setExpression(ruleExpressionBean);
            ruleBean.setDescription(rdt.getDescription());
            ruleBean.setName(rdt.getName());
            ruleBean.setOid(rdt.getOID());
            rpic.addRuleDef(ruleBean);
        }
        return rpic;
    }

    @RequestMapping(value={"/studies/{study}/metadata"}, method={RequestMethod.GET})
    public ModelAndView studyMetadata(Model model, HttpSession session, @PathVariable(value="study") String studyOid, HttpServletResponse response) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        StudyBean currentStudy = (StudyBean)session.getAttribute("study");
        StudyDAO studyDao = new StudyDAO((DataSource)this.dataSource);
        currentStudy = studyDao.findByOid(studyOid);
        MetaDataCollector mdc = new MetaDataCollector((DataSource)this.dataSource, currentStudy, this.getRuleSetRuleDao());
        AdminDataCollector adc = new AdminDataCollector((DataSource)this.dataSource, currentStudy);
        MetaDataCollector.setTextLength((int)200);
        ODMBean odmb = mdc.getODMBean();
        odmb.setSchemaLocation("http://www.cdisc.org/ns/odm/v1.3 OpenClinica-ODM1-3-0-OC2-0.xsd");
        ArrayList<String> xmlnsList = new ArrayList<String>();
        xmlnsList.add("xmlns=\"http://www.cdisc.org/ns/odm/v1.3\"");
        xmlnsList.add("xmlns:OpenClinica=\"http://www.openclinica.org/ns/odm_ext_v130/v3.1\"");
        xmlnsList.add("xmlns:OpenClinicaRules=\"http://www.openclinica.org/ns/rules/v3.1\"");
        odmb.setXmlnsList(xmlnsList);
        odmb.setODMVersion("oc1.3");
        mdc.setODMBean(odmb);
        adc.setOdmbean(odmb);
        mdc.collectFileData();
        MetaDataReportBean metaReport = new MetaDataReportBean(mdc.getOdmStudyMap(), this.coreResources);
        metaReport.setODMVersion("oc1.3");
        metaReport.setOdmBean(mdc.getODMBean());
        metaReport.createChunkedOdmXml(Boolean.FALSE.booleanValue());
        adc.collectFileData();
        AdminDataReportBean adminReport = new AdminDataReportBean(adc.getOdmAdminDataMap());
        adminReport.setODMVersion("oc1.3");
        adminReport.setOdmBean(mdc.getODMBean());
        adminReport.createChunkedOdmXml(Boolean.FALSE.booleanValue());
        FullReportBean report = new FullReportBean();
        report.setAdminDataMap(adc.getOdmAdminDataMap());
        report.setOdmStudyMap(mdc.getOdmStudyMap());
        report.setCoreResources(this.coreResources);
        report.setOdmBean(mdc.getODMBean());
        report.setODMVersion("oc1.3");
        report.createStudyMetaOdmXml(Boolean.FALSE.booleanValue());
        response.setContentType("application/xml");
        PrintWriter out = response.getWriter();
        out.print(report.getXmlOutput().toString().trim());
        return null;
    }

    private StudyUserRoleBean getRole(UserAccountBean userAccount, StudyBean study) throws Exception {
        StudyUserRoleBean role = new StudyUserRoleBean();
        if (study == null || userAccount == null || study.getId() == 0) {
            throw new Exception();
        }
        if (userAccount.getId() > 0 && study.getId() > 0 && !study.getStatus().getName().equals("removed")) {
            role = userAccount.getRoleByStudy(study.getId());
            if (study.getParentStudyId() > 0) {
                StudyUserRoleBean roleInParent = userAccount.getRoleByStudy(study.getParentStudyId());
                role.setRole(Role.max((Role)role.getRole(), (Role)roleInParent.getRole()));
            }
        } else {
            throw new Exception();
        }
        return role;
    }

    private void mayProceed(UserAccountBean userAccount, StudyBean study) throws Exception {
        Role r = this.getRole(userAccount, study).getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        throw new Exception("Insufficient Permission");
    }

    @RequestMapping(value={"/studies/{study}/connect"}, method={RequestMethod.POST})
    @ResponseBody
    public Response create(@RequestBody Response responeType, Model model, HttpSession session, @PathVariable(value="study") String studyOid) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        StudyDAO studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean currentStudy = studyDao.findByOid(studyOid);
        UserAccountBean userAccount = this.getUserAccount();
        this.mayProceed(userAccount, currentStudy);
        Response response = new Response();
        response.setValid(Boolean.TRUE.booleanValue());
        MessagesType theMessageType = new MessagesType();
        theMessageType.setMessage("Hello");
        response.getMessages().add(theMessageType);
        this.logger.debug("RPIC READY");
        return response;
    }

    @RequestMapping(value={"/studies/{study}/validateRule"}, method={RequestMethod.POST})
    @ResponseBody
    public Response create(@RequestBody Rules rules, Model model, HttpSession session, @PathVariable(value="study") String studyOid) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        RulesPostImportContainer rpic = this.mapRulesToRulesPostImportContainer(rules);
        StudyDAO studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean currentStudy = studyDao.findByOid(studyOid);
        UserAccountBean userAccount = this.getUserAccount();
        this.mayProceed(userAccount, currentStudy);
        this.getRulePostImportContainerService(currentStudy, userAccount);
        rpic = this.getRulePostImportContainerService(currentStudy, userAccount).validateRuleDefs(rpic);
        rpic = this.getRulePostImportContainerService(currentStudy, userAccount).validateRuleSetDefs(rpic);
        Response response = new Response();
        response.setValid(Boolean.TRUE.booleanValue());
        if (rpic.getInValidRuleDefs().size() > 0 || rpic.getInValidRuleSetDefs().size() > 0) {
            MessagesType messageType;
            response.setValid(Boolean.FALSE.booleanValue());
            for (AuditableBeanWrapper beanWrapper : rpic.getInValidRuleDefs()) {
                for (String error : beanWrapper.getImportErrors()) {
                    messageType = new MessagesType();
                    messageType.setMessage(error);
                    response.getMessages().add(messageType);
                }
            }
            for (AuditableBeanWrapper beanWrapper : rpic.getInValidRuleSetDefs()) {
                for (String error : beanWrapper.getImportErrors()) {
                    messageType = new MessagesType();
                    messageType.setMessage(error);
                    response.getMessages().add(messageType);
                }
            }
        }
        this.logger.debug("RPIC READY");
        return response;
    }

    @RequestMapping(value={"/studies/{study}/validateAndSaveRule"}, method={RequestMethod.POST})
    @ResponseBody
    public Response validateAndSave(@RequestBody Rules rules, Model model, HttpSession session, @PathVariable(value="study") String studyOid, @RequestParam(value="ignoreDuplicates") Boolean ignoreDuplicates) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        RulesPostImportContainer rpic = this.mapRulesToRulesPostImportContainer(rules);
        StudyDAO studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean currentStudy = studyDao.findByOid(studyOid);
        UserAccountBean userAccount = this.getUserAccount();
        this.mayProceed(userAccount, currentStudy);
        this.getRulePostImportContainerService(currentStudy, userAccount);
        rpic = this.getRulePostImportContainerService(currentStudy, userAccount).validateRuleDefs(rpic);
        rpic = this.getRulePostImportContainerService(currentStudy, userAccount).validateRuleSetDefs(rpic);
        Response response = new Response();
        response.setValid(Boolean.TRUE.booleanValue());
        if (rpic.getInValidRuleDefs().size() > 0 || rpic.getInValidRuleSetDefs().size() > 0) {
            MessagesType messageType;
            response.setValid(Boolean.FALSE.booleanValue());
            for (AuditableBeanWrapper beanWrapper : rpic.getInValidRuleDefs()) {
                for (String error : beanWrapper.getImportErrors()) {
                    messageType = new MessagesType();
                    messageType.setMessage(error);
                    response.getMessages().add(messageType);
                }
            }
            for (AuditableBeanWrapper beanWrapper : rpic.getInValidRuleSetDefs()) {
                for (String error : beanWrapper.getImportErrors()) {
                    messageType = new MessagesType();
                    messageType.setMessage(error);
                    response.getMessages().add(messageType);
                }
            }
        } else if (rpic.getDuplicateRuleDefs().size() > 0 && !ignoreDuplicates.booleanValue()) {
            response.setValid(Boolean.FALSE.booleanValue());
            for (int i = 0; i < rpic.getDuplicateRuleDefs().size(); ++i) {
                MessagesType messageType = new MessagesType();
                messageType.setMessage(DUPLICATE_MESSAGE);
                response.getMessages().add(messageType);
            }
        } else {
            this.getRuleSetService().saveImportFromDesigner(rpic);
        }
        this.logger.debug("RPIC READY");
        return response;
    }

    @RequestMapping(value={"/studies/{study}/validateAndTestRule"}, method={RequestMethod.POST})
    @ResponseBody
    public RulesTest create(@RequestBody RulesTest ruleTest, Model model, HttpSession session, @PathVariable(value="study") String studyOid) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        RulesPostImportContainer rpic = this.mapRulesToRulesPostImportContainer(ruleTest.getRules());
        StudyDAO studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean currentStudy = studyDao.findByOid(studyOid);
        UserAccountBean userAccount = this.getUserAccount();
        this.mayProceed(userAccount, currentStudy);
        this.getRulePostImportContainerService(currentStudy, userAccount);
        rpic = this.getRulePostImportContainerService(currentStudy, userAccount).validateRuleDefs(rpic);
        rpic = this.getRulePostImportContainerService(currentStudy, userAccount).validateRuleSetDefs(rpic);
        Response response = new Response();
        response.setValid(Boolean.TRUE.booleanValue());
        if (rpic.getInValidRuleDefs().size() > 0 || rpic.getInValidRuleSetDefs().size() > 0) {
            MessagesType messageType;
            response.setValid(Boolean.FALSE.booleanValue());
            for (AuditableBeanWrapper beanWrapper : rpic.getInValidRuleDefs()) {
                for (String error : beanWrapper.getImportErrors()) {
                    messageType = new MessagesType();
                    messageType.setMessage(error);
                    response.getMessages().add(messageType);
                }
            }
            for (AuditableBeanWrapper beanWrapper : rpic.getInValidRuleSetDefs()) {
                for (String error : beanWrapper.getImportErrors()) {
                    messageType = new MessagesType();
                    messageType.setMessage(error);
                    response.getMessages().add(messageType);
                }
            }
        }
        HashMap<String, String> p = new HashMap<String, String>();
        for (ParameterType parameterType : ruleTest.getParameters()) {
            p.put(parameterType.getKey(), parameterType.getValue());
        }
        ExpressionObjectWrapper eow = new ExpressionObjectWrapper((DataSource)this.dataSource, currentStudy, ((RuleBean)rpic.getRuleDefs().get(0)).getExpression(), (RuleSetBean)rpic.getRuleSets().get(0));
        ExpressionProcessor ep = ExpressionProcessorFactory.createExpressionProcessor((ExpressionObjectWrapper)eow);
        DateTime start = new DateTime();
        HashMap result = ep.testEvaluateExpression(p);
        DateTime end = new DateTime();
        Duration dur = new Duration((ReadableInstant)start, (ReadableInstant)end);
        PeriodFormatter yearsAndMonths = new PeriodFormatterBuilder().printZeroAlways().appendSecondsWithMillis().appendSuffix(" second", " seconds").toFormatter();
        yearsAndMonths.print((ReadablePeriod)dur.toPeriod());
        ruleTest.getParameters().clear();
        for (Map.Entry entry : result.entrySet()) {
            ParameterType parameterType = new ParameterType();
            parameterType.setKey((String)entry.getKey());
            parameterType.setValue((String)entry.getValue());
            ruleTest.getParameters().add(parameterType);
        }
        RulesTestMessagesType messageType = new RulesTestMessagesType();
        messageType.setKey("duration");
        messageType.setValue(yearsAndMonths.print((ReadablePeriod)dur.toPeriod()));
        ruleTest.getRulesTestMessages().add(messageType);
        return ruleTest;
    }

    private UserAccountBean getUserAccount() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        UserAccountDAO userAccountDao = new UserAccountDAO((DataSource)this.dataSource);
        return userAccountDao.findByUserName(username);
    }

    public static boolean isAjaxRequest(String requestedWith) {
        return requestedWith != null ? "XMLHttpRequest".equals(requestedWith) : false;
    }

    public static boolean isAjaxUploadRequest(HttpServletRequest request) {
        return request.getParameter("ajaxUpload") != null;
    }

    public RuleSetServiceInterface getRuleSetService() {
        return this.ruleSetService;
    }

    @Autowired
    public void setRuleSetService(RuleSetServiceInterface ruleSetService) {
        this.ruleSetService = ruleSetService;
    }

    public RuleSetRuleDao getRuleSetRuleDao() {
        return this.ruleSetRuleDao;
    }

    @Autowired
    public void setRuleSetRuleDao(RuleSetRuleDao ruleSetRuleDao) {
        this.ruleSetRuleDao = ruleSetRuleDao;
    }

    public RulesPostImportContainerService getRulesPostImportContainerService() {
        return this.rulesPostImportContainerService;
    }

    public RulesPostImportContainerService getRulePostImportContainerService(StudyBean currentStudy, UserAccountBean userAccount) {
        Locale l = new Locale("en_US");
        this.rulesPostImportContainerService.setCurrentStudy(currentStudy);
        this.rulesPostImportContainerService.setRespage(ResourceBundleProvider.getPageMessagesBundle((Locale)l));
        this.rulesPostImportContainerService.setUserAccount(userAccount);
        return this.rulesPostImportContainerService;
    }

    @Autowired
    public void setRulesPostImportContainerService(RulesPostImportContainerService rulesPostImportContainerService) {
        this.rulesPostImportContainerService = rulesPostImportContainerService;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

