/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.controller.SidebarInit;
import org.akaza.openclinica.controller.helper.SdvFilterDataBean;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.StudyInfoPanel;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.akaza.openclinica.web.table.sdv.SubjectIdSDVFactory;
import org.jmesa.facade.TableFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="sdvController")
public class SDVController {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String SUBJECT_SDV_TABLE_ATTRIBUTE = "sdvTableAttribute";
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="sdvUtil")
    private SDVUtil sdvUtil;
    @Autowired
    @Qualifier(value="sdvFactory")
    private SubjectIdSDVFactory sdvFactory;
    @Autowired
    @Qualifier(value="sidebarInit")
    private SidebarInit sidebarInit;

    @RequestMapping(value={"/viewSubjectAggregate"})
    public ModelMap viewSubjectAggregateHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="studyId") int studyId) {
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Error while redirecting to MainMenu: ", (Throwable)e);
            }
            return null;
        }
        ModelMap gridMap = new ModelMap();
        HttpSession session = request.getSession();
        boolean showMoreLink = false;
        if (session.getAttribute("sSdvRestore") != null && session.getAttribute("sSdvRestore") == "false") {
            session.setAttribute("sSdvRestore", (Object)"true");
            showMoreLink = true;
        } else {
            showMoreLink = request.getParameter("showMoreLink") != null ? Boolean.parseBoolean(request.getParameter("showMoreLink").toString()) : (session.getAttribute("s_sdv_showMoreLink") != null ? Boolean.parseBoolean(session.getAttribute("s_sdv_showMoreLink") + "") : true);
        }
        request.setAttribute("showMoreLink", (Object)(showMoreLink + ""));
        session.setAttribute("s_sdv_showMoreLink", (Object)(showMoreLink + ""));
        request.setAttribute("studyId", (Object)studyId);
        String restore = (String)request.getAttribute("s_sdv_restore");
        restore = restore != null && restore.length() > 0 ? restore : "false";
        request.setAttribute("s_sdv_restore", (Object)restore);
        request.setAttribute("imagePathPrefix", (Object)"../");
        ArrayList pageMessages = ClassCastHelper.asArrayList((Object)request.getAttribute("pageMessages"), String.class);
        if (pageMessages == null) {
            pageMessages = new ArrayList();
        }
        request.setAttribute("pageMessages", pageMessages);
        this.sdvFactory.showMoreLink = showMoreLink;
        TableFacade facade = this.sdvFactory.createTable(request, response);
        String sdvMatrix = facade.render();
        gridMap.addAttribute(SUBJECT_SDV_TABLE_ATTRIBUTE, (Object)sdvMatrix);
        return gridMap;
    }

    @RequestMapping(value={"/viewAllSubjectSDV"})
    public ModelMap viewSubjectHandler(HttpServletRequest request, @RequestParam(value="studySubjectId") int studySubjectId, @RequestParam(value="studyId") int studyId) {
        ModelMap gridMap = new ModelMap();
        request.setAttribute("studyId", (Object)studyId);
        request.setAttribute("studySubjectId", (Object)studySubjectId);
        request.setAttribute("imagePathPrefix", (Object)"../");
        ArrayList pageMessages = ClassCastHelper.asArrayList((Object)request.getAttribute("pageMessages"), String.class);
        if (pageMessages == null) {
            pageMessages = new ArrayList();
        }
        request.setAttribute("pageMessages", pageMessages);
        String sdvMatrix = this.sdvUtil.renderSubjectsTableWithLimit(request, studyId, studySubjectId);
        gridMap.addAttribute(SUBJECT_SDV_TABLE_ATTRIBUTE, (Object)sdvMatrix);
        return gridMap;
    }

    @RequestMapping(value={"/viewAllSubjectSDVtmp"})
    public ModelMap viewAllSubjectHandler(HttpServletRequest request, @RequestParam(value="studyId") int studyId, HttpServletResponse response) {
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Error while redirecting to MainMenu: ", (Throwable)e);
            }
            return null;
        }
        ResourceBundleProvider.updateLocale((Locale)LocaleResolver.getLocale((HttpServletRequest)request));
        StudyInfoPanel panel = new StudyInfoPanel();
        panel.reset();
        HttpSession session = request.getSession();
        request.getSession().setAttribute("panel", (Object)panel);
        ModelMap gridMap = new ModelMap();
        boolean showMoreLink = false;
        if (session.getAttribute("tableFacadeRestore") != null && session.getAttribute("tableFacadeRestore") == "false") {
            session.setAttribute("tableFacadeRestore", (Object)"true");
            session.setAttribute("sSdvRestore", (Object)"false");
            showMoreLink = true;
        } else {
            showMoreLink = request.getParameter("showMoreLink") != null ? Boolean.parseBoolean(request.getParameter("showMoreLink").toString()) : (session.getAttribute("sdv_showMoreLink") != null ? Boolean.parseBoolean(session.getAttribute("sdv_showMoreLink") + "") : true);
        }
        request.setAttribute("showMoreLink", (Object)(showMoreLink + ""));
        session.setAttribute("sdv_showMoreLink", (Object)(showMoreLink + ""));
        request.setAttribute("studyId", (Object)studyId);
        String restore = (String)request.getAttribute("sdv_restore");
        restore = restore != null && restore.length() > 0 ? restore : "false";
        request.setAttribute("sdv_restore", (Object)restore);
        Integer studySubjectId = (Integer)request.getAttribute("studySubjectId");
        studySubjectId = studySubjectId == null || studySubjectId == 0 ? 0 : studySubjectId;
        request.setAttribute("studySubjectId", (Object)studySubjectId);
        ArrayList pageMessages = ClassCastHelper.asArrayList((Object)request.getAttribute("pageMessages"), String.class);
        if (pageMessages == null) {
            pageMessages = new ArrayList();
        }
        request.setAttribute("pageMessages", pageMessages);
        String sdvMatrix = this.sdvUtil.renderEventCRFTableWithLimit(request, studyId, "../");
        gridMap.addAttribute(SUBJECT_SDV_TABLE_ATTRIBUTE, (Object)sdvMatrix);
        return gridMap;
    }

    @RequestMapping(value={"/viewAllSubjectSDVform"})
    public ModelMap viewAllSubjectFormHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="studyId") int studyId) {
        ModelMap gridMap = new ModelMap();
        String pattern = "MM/dd/yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        ServletRequestDataBinder dataBinder = new ServletRequestDataBinder((Object)new SdvFilterDataBean());
        dataBinder.setAllowedFields(new String[]{"study_subject_id", "studyEventDefinition", "studyEventStatus", "eventCRFStatus", "sdvRequirement", "eventcrfSDVStatus", "startUpdatedDate", "endDate", "eventCRFName"});
        dataBinder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)sdf, true));
        dataBinder.bind((ServletRequest)request);
        request.setAttribute("studyId", (Object)studyId);
        ArrayList pageMessages = ClassCastHelper.asArrayList((Object)request.getAttribute("pageMessages"), String.class);
        if (pageMessages == null) {
            pageMessages = new ArrayList();
        }
        request.setAttribute("pageMessages", pageMessages);
        String sdvMatrix = this.sdvUtil.renderEventCRFTableWithLimit(request, studyId, "");
        gridMap.addAttribute(SUBJECT_SDV_TABLE_ATTRIBUTE, (Object)sdvMatrix);
        return gridMap;
    }

    @RequestMapping(value={"/handleSDVPost"})
    public String sdvAllSubjectsFormHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="studyId") int studyId, @RequestParam(value="redirection") String redirection, ModelMap model) {
        List eventCRFIds;
        boolean updateCRFs;
        Enumeration paramNames = ClassCastHelper.asEnumeration((Object)request.getParameterNames(), String.class);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String tmpName = "";
        while (paramNames.hasMoreElements()) {
            tmpName = (String)paramNames.nextElement();
            if (!tmpName.contains("sdvCheck_")) continue;
            parameterMap.put(tmpName, request.getParameter(tmpName));
        }
        request.setAttribute("sdv_restore", (Object)"true");
        ArrayList<String> pageMessages = new ArrayList<String>();
        if (parameterMap.isEmpty()) {
            pageMessages.add("None of the Event CRFs were selected for SDV.");
            request.setAttribute("pageMessages", pageMessages);
            this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        }
        if (updateCRFs = this.sdvUtil.setSDVerified(eventCRFIds = this.sdvUtil.getListOfSdvEventCRFIds(parameterMap.keySet()), this.getCurrentUser(request).getId(), true)) {
            pageMessages.add("The Event CRFs have been source data verified.");
        } else {
            pageMessages.add("There was a problem with submitting the Event CRF verification to the database. Is it possible that the database system is down temporarily?");
        }
        request.setAttribute("pageMessages", pageMessages);
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    @RequestMapping(value={"/handleSDVGet"})
    public String sdvOneCRFFormHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="crfId") int crfId, @RequestParam(value="redirection") String redirection, ModelMap model) {
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Error while redirecting to MainMenu: ", (Throwable)e);
            }
            return null;
        }
        ArrayList<String> pageMessages = new ArrayList<String>();
        ArrayList<Integer> eventCRFIds = new ArrayList<Integer>();
        eventCRFIds.add(crfId);
        boolean updateCRFs = this.sdvUtil.setSDVerified(eventCRFIds, this.getCurrentUser(request).getId(), true);
        if (updateCRFs) {
            pageMessages.add("The Event CRFs have been source data verified.");
        } else {
            pageMessages.add("There was a problem with submitting the Event CRF verification to the database. Is it possible that the database system is down temporarily?");
        }
        request.setAttribute("pageMessages", pageMessages);
        request.setAttribute("sdv_restore", (Object)"true");
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    @RequestMapping(value={"/handleSDVRemove"})
    public String changeSDVHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="crfId") int crfId, @RequestParam(value="redirection") String redirection, ModelMap model) {
        ArrayList<String> pageMessages = new ArrayList<String>();
        ArrayList<Integer> eventCRFIds = new ArrayList<Integer>();
        eventCRFIds.add(crfId);
        boolean updateCRFs = this.sdvUtil.setSDVerified(eventCRFIds, this.getCurrentUser(request).getId(), false);
        if (updateCRFs) {
            pageMessages.add("The application has unset SDV for the Event CRF.");
        } else {
            pageMessages.add("There was a problem with submitting the Event CRF verification to the database. Is it possible that the database system is down temporarily?");
        }
        request.setAttribute("pageMessages", pageMessages);
        request.setAttribute("sdv_restore", (Object)"true");
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    @RequestMapping(value={"/sdvStudySubject"})
    public String sdvStudySubjectHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="theStudySubjectId") int studySubjectId, @RequestParam(value="redirection") String redirection, ModelMap model) {
        ArrayList<String> pageMessages = new ArrayList<String>();
        ArrayList<Integer> studySubjectIds = new ArrayList<Integer>();
        studySubjectIds.add(studySubjectId);
        boolean updateCRFs = this.sdvUtil.setSDVStatusForStudySubjects(studySubjectIds, this.getCurrentUser(request).getId(), true);
        if (updateCRFs) {
            pageMessages.add("The Subject has been source data verified.");
        } else {
            pageMessages.add("There was a problem with submitting the Event CRF verification to the database. Is it possible that the database system is down temporarily?");
        }
        request.setAttribute("pageMessages", pageMessages);
        request.setAttribute("s_sdv_restore", (Object)"true");
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    @RequestMapping(value={"/unSdvStudySubject"})
    public String unSdvStudySubjectHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="theStudySubjectId") int studySubjectId, @RequestParam(value="redirection") String redirection, ModelMap model) {
        ArrayList<String> pageMessages = new ArrayList<String>();
        ArrayList<Integer> studySubjectIds = new ArrayList<Integer>();
        studySubjectIds.add(studySubjectId);
        boolean updateCRFs = this.sdvUtil.setSDVStatusForStudySubjects(studySubjectIds, this.getCurrentUser(request).getId(), false);
        if (updateCRFs) {
            pageMessages.add("The application has unset SDV for the Event CRF.");
        } else {
            pageMessages.add("There was a problem with submitting the Event CRF verification to the database. Is it possible that the database system is down temporarily?");
        }
        request.setAttribute("pageMessages", pageMessages);
        request.setAttribute("s_sdv_restore", (Object)"true");
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    @RequestMapping(value={"/sdvStudySubjects"})
    public String sdvStudySubjectsHandler(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="studyId") int studyId, @RequestParam(value="redirection") String redirection, ModelMap model) {
        List studySubjectIds;
        boolean updateCRFs;
        Enumeration paramNames = ClassCastHelper.asEnumeration((Object)request.getParameterNames(), String.class);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String tmpName = "";
        while (paramNames.hasMoreElements()) {
            tmpName = (String)paramNames.nextElement();
            if (!tmpName.contains("sdvCheck_")) continue;
            parameterMap.put(tmpName, request.getParameter(tmpName));
        }
        request.setAttribute("s_sdv_restore", (Object)"true");
        ArrayList<String> pageMessages = new ArrayList<String>();
        if (parameterMap.isEmpty()) {
            pageMessages.add("None of the Study Subjects were selected for SDV.");
            request.setAttribute("pageMessages", pageMessages);
            this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        }
        if (updateCRFs = this.sdvUtil.setSDVStatusForStudySubjects(studySubjectIds = this.sdvUtil.getListOfStudySubjectIds(parameterMap.keySet()), this.getCurrentUser(request).getId(), true)) {
            pageMessages.add("The Event CRFs have been source data verified.");
        } else {
            pageMessages.add("There was a problem with submitting the Event CRF verification to the database. Is it possible that the database system is down temporarily?");
        }
        request.setAttribute("pageMessages", pageMessages);
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    private UserAccountBean getCurrentUser(HttpServletRequest request) {
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        return ub;
    }

    public static void main(String[] args) throws ParseException {
        String pattern = "MM/dd/yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = sdf.parse("01/01/2007");
        System.out.println("date = " + date);
    }

    private boolean mayProceed(HttpServletRequest request) {
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        Role r = currentRole.getRole();
        return r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.MONITOR);
    }
}

