/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.UserType;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.core.EntityDAO;
import org.akaza.openclinica.dao.hibernate.AuthoritiesDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.user.AuthoritiesBean;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/auth/api/v1"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class UserAccountController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ServletContext context;
    @Autowired
    AuthoritiesDao authoritiesDao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    UserAccountDAO udao;
    StudyDAO sdao;
    StudySubjectDAO ssdao;
    UserAccountBean uBean;

    @RequestMapping(value={"/createuseraccount"}, method={RequestMethod.POST})
    public ResponseEntity<HashMap<String, Object>> createOrUpdateAccount(HttpServletRequest request, @RequestBody HashMap<String, String> map) throws Exception {
        this.logger.info("I'm in createUserAccount");
        System.out.println("I'm in createUserAccount");
        this.uBean = null;
        String username = map.get("username");
        String fName = map.get("fName");
        String lName = map.get("lName");
        String institution = map.get("institution");
        String email = map.get("email");
        String studyName = map.get("study_name");
        String roleName = map.get("role_name");
        String userType = map.get("user_type");
        String authorizeSoap = map.get("authorize_soap");
        request.setAttribute("username", (Object)username);
        request.setAttribute("fName", (Object)fName);
        request.setAttribute("lName", (Object)lName);
        request.setAttribute("institution", (Object)institution);
        request.setAttribute("email", (Object)email);
        request.setAttribute("study_name", (Object)studyName);
        request.setAttribute("role_name", (Object)roleName);
        UserAccountBean ownerUserAccount = (UserAccountBean)request.getSession().getAttribute("userBean");
        if (!(ownerUserAccount.isActive() || ownerUserAccount.isTechAdmin() && ownerUserAccount.isSysAdmin())) {
            this.logger.info("The Owner User Account is not Valid Account or Does not have Admin user type");
            System.out.println("The Owner User Account is not Valid Account or Does not have Admin user type");
            return new ResponseEntity(new HashMap(), HttpStatus.BAD_REQUEST);
        }
        String password = "";
        String passwordHash = "*";
        SecurityManager secm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
        password = secm.genPassword();
        boolean isSoap = Boolean.parseBoolean(authorizeSoap);
        passwordHash = secm.encryptPassword(password, isSoap);
        request.getSession().setAttribute(LocaleResolver.getLocaleSessionAttributeName(), (Object)new Locale("en_US"));
        Validator v = new Validator(request);
        this.addValidationToFields(v, username);
        HashMap errors = v.validate();
        if (!errors.isEmpty()) {
            this.logger.info("Validation Error: " + errors.toString());
            System.out.println("Validation Error: " + errors.toString());
            return new ResponseEntity(new HashMap(), HttpStatus.BAD_REQUEST);
        }
        StudyBean study = this.getStudyByName(studyName);
        if (!study.isActive()) {
            this.logger.info("The Study Name is not Valid");
            System.out.println("The Study Name is not Valid");
            return new ResponseEntity(new HashMap(), HttpStatus.BAD_REQUEST);
        }
        ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
        Map roleMap = this.buildRoleMap(study, resterm);
        boolean found = false;
        Role role = null;
        for (Map.Entry entry : roleMap.entrySet()) {
            if (!roleName.equalsIgnoreCase((String)entry.getValue())) continue;
            Integer key = (Integer)entry.getKey();
            role = Role.get((int)key);
            found = true;
            break;
        }
        if (!found) {
            this.logger.info("The Role is not a Valid Role for the Study or Site");
            System.out.println("The Role is not a Valid Role for the Study or Site");
            return new ResponseEntity(new HashMap(), HttpStatus.BAD_REQUEST);
        }
        found = false;
        UserType uType = null;
        ArrayList types = UserType.toArrayList();
        types.remove(UserType.INVALID);
        for (UserType type : types) {
            if (!userType.equalsIgnoreCase(type.getName())) continue;
            uType = UserType.get((int)type.getId());
            found = true;
            break;
        }
        if (!found) {
            this.logger.info("The Type is not a Valid User Type");
            System.out.println("The Type is not a Valid User Type");
            return new ResponseEntity(new HashMap(), HttpStatus.BAD_REQUEST);
        }
        this.uBean = this.buildUserAccount(username, fName, lName, password, institution, study, ownerUserAccount, email, passwordHash, Boolean.valueOf(isSoap), role, uType);
        HashMap<String, String> userDTO = null;
        UserAccountBean uaBean = this.getUserAccount(this.uBean.getName());
        if (!uaBean.isActive()) {
            this.createUserAccount(this.uBean);
            this.uBean.setUpdater(this.uBean.getOwner());
            this.updateUserAccount(this.uBean);
            this.logger.info("***New User Account is created***");
            System.out.println("***New User Account is created***");
            this.uBean.setPasswd(password);
            userDTO = new HashMap<String, String>();
            userDTO.put("username", this.uBean.getName());
            userDTO.put("password", this.uBean.getPasswd());
            userDTO.put("firstName", this.uBean.getFirstName());
            userDTO.put("lastName", this.uBean.getLastName());
            userDTO.put("apiKey", this.uBean.getApiKey());
        }
        return new ResponseEntity(userDTO, HttpStatus.OK);
    }

    private UserAccountBean buildUserAccount(String username, String fName, String lName, String password, String institution, StudyBean study, UserAccountBean ownerUserAccount, String email, String passwordHash, Boolean authorizeSoap, Role roleName, UserType userType) throws Exception {
        UserAccountBean createdUserAccountBean = new UserAccountBean();
        createdUserAccountBean.setName(username);
        createdUserAccountBean.setFirstName(fName);
        createdUserAccountBean.setLastName(lName);
        createdUserAccountBean.setEmail(username);
        createdUserAccountBean.setInstitutionalAffiliation(institution);
        createdUserAccountBean.setLastVisitDate(null);
        createdUserAccountBean.setActiveStudyId(study.getId());
        createdUserAccountBean.setPasswdTimestamp(null);
        createdUserAccountBean.setPasswdChallengeQuestion("");
        createdUserAccountBean.setPasswdChallengeAnswer("");
        createdUserAccountBean.setOwner(ownerUserAccount);
        createdUserAccountBean.setRunWebservices(Boolean.valueOf(false));
        createdUserAccountBean.setPhone("");
        createdUserAccountBean.setAccessCode("");
        createdUserAccountBean.setPasswd(password);
        createdUserAccountBean.setEmail(email);
        createdUserAccountBean.setEnableApiKey(true);
        createdUserAccountBean.setPasswd(passwordHash);
        createdUserAccountBean.setRunWebservices(authorizeSoap);
        String apiKey = null;
        while (this.isApiKeyExist(apiKey = this.getRandom32ChApiKey()).booleanValue()) {
        }
        createdUserAccountBean.setApiKey(apiKey);
        createdUserAccountBean = this.addActiveStudyRole(createdUserAccountBean, study.getId(), roleName, ownerUserAccount);
        createdUserAccountBean.addUserType(userType);
        this.authoritiesDao.saveOrUpdate((DomainObject)new AuthoritiesBean(createdUserAccountBean.getName()));
        return createdUserAccountBean;
    }

    private void createUserAccount(UserAccountBean userAccountBean) {
        this.udao = new UserAccountDAO((DataSource)this.dataSource);
        this.udao.create(userAccountBean);
    }

    private StudyBean getStudyByName(String name) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByName(name);
        return studyBean;
    }

    private UserAccountBean addActiveStudyRole(UserAccountBean createdUserAccountBean, int studyId, Role r, UserAccountBean ownerUserAccount) {
        StudyUserRoleBean studyUserRole = new StudyUserRoleBean();
        studyUserRole.setStudyId(studyId);
        studyUserRole.setRoleName(r.getName());
        studyUserRole.setStatus(Status.AVAILABLE);
        studyUserRole.setOwner(ownerUserAccount);
        createdUserAccountBean.addRole(studyUserRole);
        createdUserAccountBean.setAccountNonLocked(Boolean.valueOf(false));
        return createdUserAccountBean;
    }

    private UserAccountBean getUserAccount(String userName) {
        this.udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean userAccountBean = this.udao.findByUserName(userName);
        return userAccountBean;
    }

    private void updateUserAccount(UserAccountBean userAccountBean) {
        this.udao.update(userAccountBean);
    }

    private ArrayList<Role> getRoles() {
        ArrayList roles = Role.toArrayList();
        roles.remove(Role.ADMIN);
        return roles;
    }

    public Boolean isApiKeyExist(String uuid) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean uBean = udao.findByApiKey(uuid);
        if (uBean == null || !uBean.isActive()) {
            return false;
        }
        return true;
    }

    public String getRandom32ChApiKey() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", "");
    }

    protected UserDetails getUserDetails() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            return (UserDetails)principal;
        }
        return null;
    }

    public void addValidationToFields(Validator v, String username) {
        v.addValidation("username", 1);
        v.addValidation("username", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        if (!username.equals("root")) {
            v.addValidation("username", 16);
        }
        v.addValidation("username", 9, (EntityDAO)this.udao);
        v.addValidation("fName", 1);
        v.addValidation("fName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 50);
        v.addValidation("lName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 50);
        v.addValidation("email", 1);
        v.addValidation("email", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 120);
        v.addValidation("email", 6);
        v.addValidation("institution", 1);
        v.addValidation("institution", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
    }

    public Map<Integer, String> buildRoleMap(StudyBean study, ResourceBundle resterm) {
        LinkedHashMap<Integer, String> roleMap = new LinkedHashMap<Integer, String>();
        if (study.getParentStudyId() > 0) {
            for (Role role : this.getRoles()) {
                switch (role.getId()) {
                    case 4: {
                        roleMap.put(role.getId(), resterm.getString("site_investigator").trim());
                        break;
                    }
                    case 5: {
                        roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person").trim());
                        break;
                    }
                    case 6: {
                        roleMap.put(role.getId(), resterm.getString("site_monitor").trim());
                        break;
                    }
                    case 7: {
                        roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person2").trim());
                        break;
                    }
                }
            }
        } else {
            for (Role role : this.getRoles()) {
                switch (role.getId()) {
                    case 2: {
                        roleMap.put(role.getId(), resterm.getString("Study_Coordinator").trim());
                        break;
                    }
                    case 3: {
                        roleMap.put(role.getId(), resterm.getString("Study_Director").trim());
                        break;
                    }
                    case 4: {
                        roleMap.put(role.getId(), resterm.getString("Investigator").trim());
                        break;
                    }
                    case 5: {
                        roleMap.put(role.getId(), resterm.getString("Data_Entry_Person").trim());
                        break;
                    }
                    case 6: {
                        roleMap.put(role.getId(), resterm.getString("Monitor").trim());
                        break;
                    }
                }
            }
        }
        return roleMap;
    }
}

