/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.user;

import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.service.user.LdapUserService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="ldapUserController")
public class LdapUserController {
    private static final String PAGE_CREATE_USER_ACCOUNT = "CreateUserAccount";
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final LdapUserService ldapUserService;
    private final UserAccountDAO userAccountDao;

    @Autowired
    public LdapUserController(LdapUserService ldapUserService, UserAccountDAO userAccountDao) {
        this.ldapUserService = ldapUserService;
        this.userAccountDao = userAccountDao;
    }

    @RequestMapping(value={"/admin/listLdapUsers"})
    public ModelMap listLdapUsers(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="filter", required=false) String filter) {
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Error while redirecting to MainMenu: ", (Throwable)e);
            }
            return null;
        }
        if (!StringUtils.isEmpty((String)filter)) {
            ArrayList existingAccounts = this.userAccountDao.findAll();
            HashSet<String> existingUsernames = new HashSet<String>(existingAccounts.size());
            for (UserAccountBean existingAccount : existingAccounts) {
                existingUsernames.add(existingAccount.getName());
            }
            request.setAttribute("memberList", (Object)this.ldapUserService.listNewUsers(filter, existingUsernames));
        }
        return new ModelMap();
    }

    @RequestMapping(value={"/admin/selectLdapUser"})
    public String selectLdapUser(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dn", required=false) String dn) {
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Error while redirecting to MainMenu: ", (Throwable)e);
            }
            return null;
        }
        if (!StringUtils.isEmpty((String)dn)) {
            request.getSession().setAttribute("ldapUser", (Object)this.ldapUserService.loadUser(dn));
        }
        return "redirect:/CreateUserAccount";
    }

    private boolean mayProceed(HttpServletRequest request) {
        UserAccountBean userBean = (UserAccountBean)request.getSession().getAttribute("userBean");
        return userBean.isTechAdmin() || userBean.isSysAdmin();
    }
}

