/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.core.AuditableEntityBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.extract.ExtractBean;
import org.akaza.openclinica.bean.extract.FilterBean;
import org.akaza.openclinica.bean.managestudy.DisplayEventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.view.StudyInfoPanelLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudyInfoPanel {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    ResourceBundle resword;
    private TreeMap<String, String> data = new TreeMap();
    private ArrayList<StudyInfoPanelLine> userOrderedData = new ArrayList();
    String datePattern = "MM/dd/yyyy";
    SimpleDateFormat english_sdf = new SimpleDateFormat(this.datePattern);
    SimpleDateFormat local_sdf;
    private boolean studyInfoShown = true;
    private boolean orderedData = false;
    private boolean submitDataModule = false;
    private boolean extractData = false;
    private boolean createDataset = false;
    private boolean iconInfoShown = true;
    private boolean manageSubject = false;

    public boolean isManageSubject() {
        return this.manageSubject;
    }

    public void setManageSubject(boolean manageSubject) {
        this.manageSubject = manageSubject;
    }

    public boolean isIconInfoShown() {
        return this.iconInfoShown;
    }

    public void setIconInfoShown(boolean iconInfoShown) {
        this.iconInfoShown = iconInfoShown;
    }

    public boolean isExtractData() {
        return this.extractData;
    }

    public void setExtractData(boolean extractData) {
        this.extractData = extractData;
    }

    public boolean isSubmitDataModule() {
        return this.submitDataModule;
    }

    public void setSubmitDataModule(boolean submitDataModule) {
        this.submitDataModule = submitDataModule;
    }

    public void setData(String key, String value) {
        this.data.put(key, value);
    }

    public void removeData(String key) {
        this.data.remove(key);
    }

    public void reset() {
        this.data = new TreeMap();
        this.userOrderedData = new ArrayList();
    }

    public TreeMap<String, String> getData() {
        return this.data;
    }

    public void setData(TreeMap<String, String> data) {
        this.data = data;
    }

    public void setData(Page page, HttpSession session, HttpServletRequest request) {
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
        this.resword = ResourceBundleProvider.getWordsBundle();
        this.local_sdf = new SimpleDateFormat(ResourceBundleProvider.getFormatBundle((Locale)locale).getString("date_format_string"));
        try {
            this.setStudyInfoShown(true);
            this.setOrderedData(false);
            if (page.equals((Object)Page.CREATE_DATASET_1)) {
                this.reset();
            } else if (page.equals((Object)Page.CREATE_DATASET_2) || page.equals((Object)Page.CREATE_DATASET_EVENT_ATTR) || page.equals((Object)Page.CREATE_DATASET_SUB_ATTR) || page.equals((Object)Page.CREATE_DATASET_CRF_ATTR) || page.equals((Object)Page.CREATE_DATASET_GROUP_ATTR) || page.equals((Object)Page.CREATE_DATASET_VIEW_SELECTED)) {
                HashMap eventlist = this.getAsEventList(request.getAttribute("eventlist"));
                ArrayList displayData = this.generateEventTree(eventlist, Boolean.valueOf(true));
                this.reset();
                this.setUserOrderedData(displayData);
                this.setStudyInfoShown(false);
                this.setOrderedData(true);
                this.setCreateDataset(true);
                this.setSubmitDataModule(false);
                this.setExtractData(false);
            } else if (page.equals((Object)Page.CREATE_DATASET_3)) {
                this.reset();
                this.setStudyInfoShown(false);
                this.setOrderedData(false);
                this.setCreateDataset(true);
                this.setSubmitDataModule(false);
                this.setExtractData(false);
                DatasetBean dsb = (DatasetBean)session.getAttribute("newDataset");
                int ev_count = dsb.getItemIds().size();
                this.setData(this.resword.getString("items_selected"), new Integer(ev_count).toString());
            } else if (page.equals((Object)Page.CREATE_DATASET_4)) {
                this.reset();
                this.setStudyInfoShown(false);
                this.setOrderedData(false);
                this.setCreateDataset(true);
                this.setSubmitDataModule(false);
                this.setExtractData(false);
                this.removeData(this.resword.getString("beginning_date"));
                this.removeData(this.resword.getString("ending_date"));
                DatasetBean dsb = (DatasetBean)session.getAttribute("newDataset");
                int ev_count = dsb.getItemIds().size();
                this.setData(this.resword.getString("items_selected"), new Integer(ev_count).toString());
                if ("01/01/1900".equals(this.english_sdf.format(dsb.getDateStart()))) {
                    this.setData(this.resword.getString("beginning_date"), this.resword.getString("not_specified"));
                } else {
                    this.setData(this.resword.getString("beginning_date"), this.local_sdf.format(dsb.getDateStart()));
                }
                if ("12/31/2100".equals(this.english_sdf.format(dsb.getDateEnd()))) {
                    this.setData(this.resword.getString("ending_date"), this.resword.getString("not_specified"));
                } else {
                    this.setData(this.resword.getString("ending_date"), this.local_sdf.format(dsb.getDateEnd()));
                }
                FilterBean fb = (FilterBean)session.getAttribute("newFilter");
                if (fb != null) {
                    this.setData("Added Filter", fb.getName());
                }
            } else if (page.equals((Object)Page.APPLY_FILTER)) {
                DatasetBean dsb = (DatasetBean)session.getAttribute("newDataset");
                this.setData(this.resword.getString("beginning_date"), this.local_sdf.format(dsb.getDateStart()));
                this.setData(this.resword.getString("ending_date"), this.local_sdf.format(dsb.getDateEnd()));
            } else if (page.equals((Object)Page.CONFIRM_DATASET)) {
                this.reset();
                this.setStudyInfoShown(false);
                this.setOrderedData(false);
                this.setCreateDataset(true);
                this.setSubmitDataModule(false);
                this.setExtractData(false);
                DatasetBean dsb = (DatasetBean)session.getAttribute("newDataset");
                this.setData(this.resword.getString("dataset_name"), dsb.getName());
                this.setData(this.resword.getString("dataset_description"), dsb.getDescription());
                int ev_count = dsb.getItemIds().size();
                this.setData(this.resword.getString("items_selected"), new Integer(ev_count).toString());
                if ("01/01/1900".equals(this.english_sdf.format(dsb.getDateStart()))) {
                    this.setData(this.resword.getString("beginning_date"), this.resword.getString("not_specified"));
                } else {
                    this.setData(this.resword.getString("beginning_date"), this.local_sdf.format(dsb.getDateStart()));
                }
                if ("12/31/2100".equals(this.english_sdf.format(dsb.getDateEnd()))) {
                    this.setData(this.resword.getString("ending_date"), this.resword.getString("not_specified"));
                } else {
                    this.setData(this.resword.getString("ending_date"), this.local_sdf.format(dsb.getDateEnd()));
                }
                FilterBean fb = (FilterBean)session.getAttribute("newFilter");
                if (fb != null) {
                    this.setData(this.resword.getString("added_filter"), fb.getName());
                }
            } else if (page.equals((Object)Page.CREATE_FILTER_SCREEN_3_1)) {
                CRFVersionBean cvBean = (CRFVersionBean)session.getAttribute("cvBean");
                this.setData(this.resword.getString("CRF_version_selected"), cvBean.getName());
            } else if (page.equals((Object)Page.CREATE_FILTER_SCREEN_3_2)) {
                SectionBean secBean = (SectionBean)session.getAttribute("secBean");
                this.setData(this.resword.getString("section_selected"), secBean.getName());
                ArrayList metadatas = ClassCastHelper.getAttributeAsList((HttpServletRequest)request, (String)"metadatas", ItemFormMetadataBean.class);
                this.setData(this.resword.getString("number_of_questions"), new Integer(metadatas.size()).toString());
            } else if (!(page.equals((Object)Page.CREATE_FILTER_SCREEN_4) || page.equals((Object)Page.CREATE_FILTER_SCREEN_5) || page.equals((Object)Page.ADMIN_SYSTEM))) {
                if (page.equals((Object)Page.VIEW_STUDY_SUBJECT) || page.equals((Object)Page.LIST_EVENTS_FOR_SUBJECT)) {
                    this.reset();
                    this.setStudyInfoShown(true);
                    this.setOrderedData(true);
                    this.setExtractData(false);
                    this.setSubmitDataModule(false);
                    this.setCreateDataset(false);
                    this.setIconInfoShown(false);
                    this.setManageSubject(true);
                    request.setAttribute("showDDEIcon", (Object)Boolean.TRUE);
                } else if (page.equals((Object)Page.ENTER_DATA_FOR_STUDY_EVENT) || page.equals((Object)Page.ENTER_DATA_FOR_STUDY_EVENT_SERVLET)) {
                    StudyBean study = (StudyBean)session.getAttribute("study");
                    StudySubjectBean studySubject = (StudySubjectBean)request.getAttribute("studySubject");
                    ArrayList beans = ClassCastHelper.getAttributeAsList((HttpServletRequest)request, (String)"beans", DisplayStudyEventBean.class);
                    EventCRFBean ecb = (EventCRFBean)request.getAttribute("eventCRF");
                    this.reset();
                    this.addStudyEventTree(study, studySubject, beans, ecb, true);
                    this.setStudyInfoShown(false);
                    this.setOrderedData(true);
                    this.setSubmitDataModule(true);
                    this.setExtractData(false);
                    this.setCreateDataset(false);
                    this.setIconInfoShown(false);
                } else if (page.equals((Object)Page.INTERVIEWER) || page.equals((Object)Page.TABLE_OF_CONTENTS) || page.equals((Object)Page.TABLE_OF_CONTENTS_SERVLET) || page.equals((Object)Page.INITIAL_DATA_ENTRY) || page.equals((Object)Page.INITIAL_DATA_ENTRY_SERVLET) || page.equals((Object)Page.DOUBLE_DATA_ENTRY) || page.equals((Object)Page.DOUBLE_DATA_ENTRY_SERVLET) || page.equals((Object)Page.ADMIN_EDIT) || page.equals((Object)Page.ADMIN_EDIT_SERVLET)) {
                    StudyBean study = (StudyBean)session.getAttribute("study");
                    StudySubjectBean studySubject = (StudySubjectBean)request.getAttribute("studySubject");
                    ArrayList beans = ClassCastHelper.getAttributeAsList((HttpServletRequest)request, (String)"beans", DisplayStudyEventBean.class);
                    EventCRFBean ecb = (EventCRFBean)request.getAttribute("eventCRF");
                    this.reset();
                    this.addStudyEventTree(study, studySubject, beans, ecb, false);
                    this.setStudyInfoShown(false);
                    this.setOrderedData(true);
                    this.setSubmitDataModule(true);
                    this.setExtractData(false);
                    this.setCreateDataset(false);
                    this.setIconInfoShown(true);
                } else if (page.equals((Object)Page.EDIT_DATASET)) {
                    this.reset();
                    HashMap eventlist = this.getAsEventList(session.getAttribute("eventsForCreateDataset"));
                    ArrayList displayData = this.generateEventTree(eventlist, Boolean.valueOf(true));
                    this.setCreateDataset(true);
                    this.setOrderedData(true);
                    this.setUserOrderedData(displayData);
                    this.setStudyInfoShown(true);
                    this.setSubmitDataModule(false);
                    this.setExtractData(false);
                    DatasetBean dsb = (DatasetBean)request.getAttribute("dataset");
                    this.setData(this.resword.getString("dataset_name"), dsb.getName());
                    this.setData(this.resword.getString("date_created"), this.local_sdf.format(dsb.getCreatedDate()));
                    this.setData(this.resword.getString("dataset_owner"), dsb.getOwner().getName());
                    this.setData(this.resword.getString("date_last_run"), this.local_sdf.format(dsb.getDateLastRun()));
                } else if (page.equals((Object)Page.EXPORT_DATASETS)) {
                    this.setCreateDataset(false);
                } else if (page.equals((Object)Page.GENERATE_DATASET_HTML)) {
                    DatasetBean db = (DatasetBean)request.getAttribute("dataset");
                    ExtractBean exbean = (ExtractBean)request.getAttribute("extractBean");
                    this.reset();
                    ArrayList displayData = new ArrayList();
                    displayData = this.generateDatasetTree(exbean, db);
                    this.setUserOrderedData(displayData);
                    this.setStudyInfoShown(false);
                    this.setOrderedData(true);
                    this.setExtractData(true);
                    this.setSubmitDataModule(false);
                    this.setCreateDataset(false);
                } else if (page.equals((Object)Page.LIST_STUDY_SUBJECT) || page.equals((Object)Page.LIST_STUDY_SUBJECTS) || page.equals((Object)Page.SUBMIT_DATA) || page.equals((Object)Page.SUBMIT_DATA_SERVLET)) {
                    this.reset();
                    this.setStudyInfoShown(true);
                    this.setOrderedData(true);
                    this.setExtractData(false);
                    this.setSubmitDataModule(false);
                    this.setCreateDataset(false);
                    this.setIconInfoShown(false);
                    this.setManageSubject(true);
                    request.setAttribute("showDDEIcon", (Object)Boolean.FALSE);
                } else if (page.equals((Object)Page.VIEW_SECTION_DATA_ENTRY) || page.equals((Object)Page.VIEW_SECTION_DATA_ENTRY_SERVLET)) {
                    this.reset();
                    this.setStudyInfoShown(true);
                    this.setOrderedData(true);
                    this.setExtractData(false);
                    this.setSubmitDataModule(false);
                    this.setCreateDataset(false);
                    this.setIconInfoShown(true);
                    this.setManageSubject(false);
                } else if (page.equals((Object)Page.CREATE_SUBJECT_GROUP_CLASS) || page.equals((Object)Page.CREATE_SUBJECT_GROUP_CLASS_CONFIRM) || page.equals((Object)Page.UPDATE_SUBJECT_GROUP_CLASS) || page.equals((Object)Page.UPDATE_SUBJECT_GROUP_CLASS_CONFIRM)) {
                    this.reset();
                    this.setStudyInfoShown(true);
                    this.setOrderedData(true);
                    this.setExtractData(false);
                    this.setSubmitDataModule(false);
                    this.setCreateDataset(false);
                    this.setIconInfoShown(true);
                    this.setManageSubject(false);
                } else if (page.equals((Object)Page.VIEW_RULE_SETS2)) {
                    HashMap eventlist = this.getAsEventList(request.getAttribute("eventlist"));
                    ArrayList displayData = this.generateEventTree(eventlist, Boolean.valueOf(false));
                    this.reset();
                    this.setUserOrderedData(displayData);
                    this.setStudyInfoShown(true);
                    this.setOrderedData(true);
                    this.setCreateDataset(false);
                    this.setSubmitDataModule(false);
                    this.setExtractData(false);
                } else {
                    this.reset();
                    this.setStudyInfoShown(true);
                    this.setOrderedData(true);
                    this.setExtractData(false);
                    this.setSubmitDataModule(false);
                    this.setCreateDataset(false);
                    this.setIconInfoShown(true);
                    this.setManageSubject(false);
                }
            }
        }
        catch (Exception e) {
            this.reset();
        }
    }

    public boolean isStudyInfoShown() {
        return this.studyInfoShown;
    }

    public void setStudyInfoShown(boolean studyInfoShown) {
        this.studyInfoShown = studyInfoShown;
    }

    public boolean isOrderedData() {
        return this.orderedData;
    }

    public void setOrderedData(boolean orderedData) {
        this.orderedData = orderedData;
    }

    public ArrayList<StudyInfoPanelLine> getUserOrderedData() {
        return this.userOrderedData;
    }

    public void setUserOrderedData(ArrayList<StudyInfoPanelLine> userOrderedData) {
        this.userOrderedData = userOrderedData;
    }

    public String getStageImageText(DataEntryStage stage) {
        String answer = "";
        answer = stage.isInitialDE() ? "<img src='images/icon_InitialDE.gif' alt='Initial Data Entry'>" : (stage.isInitialDE_Complete() ? "<img src='images/icon_InitialDEcomplete.gif' alt='Initial Data Entry Complete'>" : (stage.isDoubleDE() ? "<img src='images/icon_DDE.gif' alt='Double Data Entry'>" : (stage.isDoubleDE_Complete() ? "<img src='images/icon_DEcomplete.gif' alt='Data Entry Complete'>" : (stage.isAdmin_Editing() ? "<img src='images/icon_AdminEdit.gif' alt='Administrative Editing'>" : (stage.isLocked() ? "<img src='images/icon_Locked.gif' alt='Locked'>" : "<img src='images/icon_Invalid.gif' alt='Invalid'>")))));
        return answer;
    }

    public String getTOCLink(DisplayEventCRFBean dec) {
        String answer = "";
        if (!dec.getEventCRF().getStatus().equals((Term)Status.DELETED) && !dec.getEventCRF().getStatus().equals((Term)Status.AUTO_DELETED)) {
            if (dec.isContinueInitialDataEntryPermitted()) {
                answer = "InitialDataEntry?eventCRFId=" + dec.getEventCRF().getId();
            } else if (dec.isStartDoubleDataEntryPermitted()) {
                answer = "DoubleDataEntry?eventCRFId=" + dec.getEventCRF().getId();
            } else if (dec.isContinueDoubleDataEntryPermitted()) {
                answer = "DoubleDataEntry?eventCRFId=" + dec.getEventCRF().getId();
            } else if (dec.isPerformAdministrativeEditingPermitted()) {
                answer = "AdministrativeEditing?eventCRFId=" + dec.getEventCRF().getId();
            } else if (dec.isLocked()) {
                answer = "ViewSectionDataEntry?eventDefinitionCRFId=" + dec.getEventDefinitionCRF().getId() + "&ecId=" + dec.getEventCRF().getId() + "&tabId=1";
            }
        }
        return answer;
    }

    public void addStudyEventRulesTree(StudyBean study, StudySubjectBean studySubject, ArrayList<DisplayStudyEventBean> displayStudyEventBeans, EventCRFBean ecb, boolean withLink) {
        this.setStudyInfoShown(true);
        this.setOrderedData(false);
        ArrayList displayData = new ArrayList();
        displayData = withLink ? this.generateTreeFromBeans(displayStudyEventBeans, displayData, studySubject, ecb) : this.generateTreeFromBeansWithoutLink(displayStudyEventBeans, displayData, studySubject, ecb);
        this.setUserOrderedData(displayData);
    }

    public void addStudyEventTree(StudyBean study, StudySubjectBean studySubject, ArrayList<DisplayStudyEventBean> displayStudyEventBeans, EventCRFBean ecb, boolean withLink) {
        this.setStudyInfoShown(true);
        this.setOrderedData(false);
        ArrayList displayData = new ArrayList();
        displayData = withLink ? this.generateTreeFromBeans(displayStudyEventBeans, displayData, studySubject, ecb) : this.generateTreeFromBeansWithoutLink(displayStudyEventBeans, displayData, studySubject, ecb);
        this.setUserOrderedData(displayData);
    }

    public ArrayList<StudyInfoPanelLine> generateTreeFromBeans(ArrayList<DisplayStudyEventBean> rows, ArrayList<StudyInfoPanelLine> displayData, StudySubjectBean studySubject, EventCRFBean ecb) {
        displayData.add(new StudyInfoPanelLine(this.resword.getString("study_events"), "(" + rows.size() + ")", true, false, false));
        for (DisplayStudyEventBean dseBean : rows) {
            StudyEventBean seBean = dseBean.getStudyEvent();
            if (ecb != null && ecb.getStudyEventId() == seBean.getId()) {
                displayData.add(new StudyInfoPanelLine("Study Event", seBean.getStudyEventDefinition().getName(), true, false, true));
            } else {
                displayData.add(new StudyInfoPanelLine("Study Event", seBean.getStudyEventDefinition().getName(), true, false, false));
            }
            displayData.add(new StudyInfoPanelLine("<b>Status: </b>", "<a href='EnterDataForStudyEvent?eventId=" + seBean.getId() + "'>" + seBean.getSubjectEventStatus().getName() + "</a>", false, false, false));
            ArrayList displayCRFs = dseBean.getDisplayEventCRFs();
            int count = 0;
            for (DisplayEventCRFBean dec : displayCRFs) {
                if (count == displayCRFs.size() - 1 && dseBean.getUncompletedCRFs().size() == 0) {
                    if (ecb != null && ecb.getId() == dec.getEventCRF().getId()) {
                        displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), "<span class='alert'>" + dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName() + "</span>", false, true, true));
                    } else {
                        displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), " " + dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName() + "</a>", false, true, false));
                    }
                } else if (ecb != null && ecb.getId() == dec.getEventCRF().getId()) {
                    displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), "<span class='alert'>" + dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName() + "</span>", false, false, true));
                } else {
                    displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), " " + dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName() + "</a>", false, false, false));
                }
                ++count;
            }
            count = 0;
            ArrayList uncompleted = dseBean.getUncompletedCRFs();
            for (DisplayEventDefinitionCRFBean dedc : uncompleted) {
                if (count == uncompleted.size() - 1) {
                    if (ecb != null && ecb.getId() == dedc.getEventCRF().getId() && ecb.getCrf().getId() == dedc.getEventCRF().getCrf().getId()) {
                        displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", "<span class='alert'>" + dedc.getEdc().getCrf().getName() + "</span>", false, true, true));
                    } else {
                        displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", "<span class='alert'>" + dedc.getEdc().getCrf().getName() + "</a>", false, true, false));
                    }
                } else if (ecb != null && ecb.getId() == dedc.getEventCRF().getId()) {
                    displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", "<span class='alert'>" + dedc.getEdc().getCrf().getName() + "</span>", false, false, true));
                } else {
                    displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", "<span class='alert'>" + dedc.getEdc().getCrf().getName() + "</a>", false, false, false));
                }
                ++count;
            }
        }
        return displayData;
    }

    public ArrayList<StudyInfoPanelLine> generateTreeFromBeansWithoutLink(ArrayList<DisplayStudyEventBean> rows, ArrayList<StudyInfoPanelLine> displayData, StudySubjectBean studySubject, EventCRFBean ecb) {
        displayData.add(new StudyInfoPanelLine("Study Events", "(" + rows.size() + ")", true, false, false));
        for (DisplayStudyEventBean dseBean : rows) {
            StudyEventBean seBean = dseBean.getStudyEvent();
            if (ecb != null && ecb.getStudyEventId() == seBean.getId()) {
                displayData.add(new StudyInfoPanelLine("Study Event", seBean.getStudyEventDefinition().getName(), true, false, true));
            } else {
                displayData.add(new StudyInfoPanelLine("Study Event", seBean.getStudyEventDefinition().getName(), true, false, false));
            }
            displayData.add(new StudyInfoPanelLine("<b>Status: </b>", seBean.getSubjectEventStatus().getName(), false, false, false));
            ArrayList displayCRFs = dseBean.getDisplayEventCRFs();
            int count = 0;
            for (DisplayEventCRFBean dec : displayCRFs) {
                if (count == displayCRFs.size() - 1 && dseBean.getUncompletedCRFs().size() == 0) {
                    if (ecb != null && ecb.getId() == dec.getEventCRF().getId()) {
                        displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), "<span class='alert'>" + dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName() + "</span>", false, true, true));
                    } else {
                        displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName(), false, true, false));
                    }
                } else if (ecb != null && ecb.getId() == dec.getEventCRF().getId()) {
                    displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), "<span class='alert'>" + dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName() + "</span>", false, false, true));
                } else {
                    displayData.add(new StudyInfoPanelLine("" + this.getStageImageText(dec.getStage()), dec.getEventCRF().getCrf().getName() + " " + dec.getEventCRF().getCrfVersion().getName(), false, false, false));
                }
                ++count;
            }
            count = 0;
            ArrayList uncompleted = dseBean.getUncompletedCRFs();
            for (DisplayEventDefinitionCRFBean dedc : uncompleted) {
                if (count == uncompleted.size() - 1) {
                    if (ecb != null && ecb.getId() == dedc.getEventCRF().getId() && ecb.getCrf().getId() == dedc.getEventCRF().getCrf().getId()) {
                        displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", "<span class='alert'>" + dedc.getEdc().getCrf().getName() + "</span>", false, true, true));
                    } else {
                        displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", dedc.getEdc().getCrf().getName(), false, true, false));
                    }
                } else if (ecb != null && ecb.getId() == dedc.getEventCRF().getId()) {
                    displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", "<span class='alert'>" + dedc.getEdc().getCrf().getName() + "</span>", false, false, true));
                } else {
                    displayData.add(new StudyInfoPanelLine("<img src='images/icon_NotStarted.gif' alt='Not Started'/>", dedc.getEdc().getCrf().getName(), false, false, false));
                }
                ++count;
            }
        }
        return displayData;
    }

    private ArrayList<StudyInfoPanelLine> generateDatasetTree(ExtractBean eb, DatasetBean db) {
        ArrayList<StudyInfoPanelLine> displayData = new ArrayList<StudyInfoPanelLine>();
        ArrayList seds = eb.getStudyEvents();
        for (int i = 0; i < seds.size(); ++i) {
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seds.get(i);
            String repeating = "";
            if (sed.isRepeating()) {
                repeating = " (Repeating) ";
            }
            displayData.add(new StudyInfoPanelLine("Study Event Definition", sed.getName() + repeating, true, false));
            ArrayList crfs = sed.getCrfs();
            for (int j = 0; j < crfs.size(); ++j) {
                AuditableEntityBean cb = (AuditableEntityBean)crfs.get(j);
                if (j < crfs.size() - 1 && crfs.size() > 1) {
                    displayData.add(new StudyInfoPanelLine("CRF", cb.getName() + " <b>" + ExtractBean.getSEDCRFCode((int)(i + 1), (int)(j + 1)) + "</b>", false, false));
                    continue;
                }
                displayData.add(new StudyInfoPanelLine("CRF", cb.getName() + " <b>" + ExtractBean.getSEDCRFCode((int)(i + 1), (int)(j + 1)) + "</b>", false, true));
            }
        }
        return displayData;
    }

    private ArrayList<StudyInfoPanelLine> generateEventTree(HashMap<StudyEventDefinitionBean, ArrayList<? extends AuditableEntityBean>> eventlist, Boolean isExtractData) {
        ArrayList<StudyInfoPanelLine> displayData = new ArrayList<StudyInfoPanelLine>();
        for (Map.Entry<StudyEventDefinitionBean, ArrayList<? extends AuditableEntityBean>> entry : eventlist.entrySet()) {
            StudyEventDefinitionBean sed = entry.getKey();
            displayData.add(new StudyInfoPanelLine("Definition", sed.getName(), true, false));
            ArrayList<? extends AuditableEntityBean> crfs = entry.getValue();
            int ordinal_crf = 1;
            for (int i = 0; i < crfs.size(); ++i) {
                AuditableEntityBean crf = crfs.get(i);
                if (ordinal_crf < crfs.size()) {
                    if (isExtractData.booleanValue()) {
                        displayData.add(new StudyInfoPanelLine("CRF", "<a href='SelectItems?crfId=" + crf.getId() + "&defId=" + sed.getId() + "'>" + crf.getName() + "</a>", false, false));
                    } else {
                        displayData.add(new StudyInfoPanelLine("CRF", "<a href='ViewRuleAssignment?ruleAssignments_f_crfName=" + crf.getName() + "'>" + crf.getName() + "</a>", false, false));
                    }
                } else if (isExtractData.booleanValue()) {
                    displayData.add(new StudyInfoPanelLine("CRF", "<a href='SelectItems?crfId=" + crf.getId() + "&defId=" + sed.getId() + "'>" + crf.getName() + "</a>", false, true));
                } else {
                    displayData.add(new StudyInfoPanelLine("CRF", "<a href='ViewRuleAssignment?ruleAssignments_f_studyEventDefinitionName=" + sed.getName() + "&ruleAssignments_f_crfName=" + crf.getName() + "'>" + crf.getName() + "</a>", false, true));
                }
                ++ordinal_crf;
            }
        }
        return displayData;
    }

    public boolean isCreateDataset() {
        return this.createDataset;
    }

    public void setCreateDataset(boolean createDataset) {
        this.createDataset = createDataset;
    }

    private HashMap<StudyEventDefinitionBean, ArrayList<? extends AuditableEntityBean>> getAsEventList(Object o) {
        return (HashMap)o;
    }
}

