/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.view.form.CellFactory;
import org.akaza.openclinica.view.form.CssRules;
import org.akaza.openclinica.view.form.DefaultFormBuilder;
import org.akaza.openclinica.view.form.FormBeanUtil;
import org.akaza.openclinica.view.form.RepeatManager;
import org.akaza.openclinica.view.form.ViewBuilderUtil;
import org.akaza.openclinica.view.form.ViewPersistanceHandler;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.ProcessingInstruction;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalFormBuilder
extends DefaultFormBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HorizontalFormBuilder.class);
    private List<DisplayItemGroupBean> displayItemGroups = new ArrayList();
    private SectionBean sectionBean;
    private StudyBean studyBean;
    private EventCRFBean eventCRFbean;
    private boolean isDataEntry;
    private boolean hasDbFormValues = false;
    private int tabindexSeed = 1;

    public List<DisplayItemGroupBean> getDisplayItemGroups() {
        return new ArrayList<DisplayItemGroupBean>(this.displayItemGroups);
    }

    public void setDisplayItemGroups(List<DisplayItemGroupBean> displayItems) {
        this.displayItemGroups = displayItems;
    }

    public SectionBean getSectionBean() {
        return this.sectionBean;
    }

    public void setSectionBean(SectionBean sectionBean) {
        this.sectionBean = sectionBean;
    }

    public String createMarkup() {
        ViewPersistanceHandler persistanceHandler = new ViewPersistanceHandler();
        if (this.isDataEntry) {
            persistanceHandler = new ViewPersistanceHandler();
            List itemDataBeans = persistanceHandler.fetchPersistedData(this.sectionBean.getId(), this.eventCRFbean.getId());
            if (!itemDataBeans.isEmpty()) {
                this.hasDbFormValues = true;
            }
            persistanceHandler.setItemDataBeans(itemDataBeans);
        }
        boolean hasBorders = false;
        if (this.sectionBean != null) {
            hasBorders = this.sectionBean.getBorders() > 0;
        }
        CellFactory cellFactory = new CellFactory();
        RepeatManager repeatManager = new RepeatManager();
        FormBeanUtil formUtil = new FormBeanUtil();
        ViewBuilderUtil builderUtil = new ViewBuilderUtil();
        Element divRoot = new Element("div");
        divRoot.setAttribute("id", "tableRoot");
        Document doc = new Document();
        ProcessingInstruction pi = new ProcessingInstruction("javax.xml.transform.disable-output-escaping", "");
        doc.addContent((Content)pi);
        doc.setRootElement(divRoot);
        builderUtil.showTitles(divRoot, this.getSectionBean());
        int uniqueId = 0;
        int tabindex = this.tabindexSeed;
        boolean hasDiscrepancyMgt = false;
        StudyBean studBean = this.getStudyBean();
        if (studBean != null && studBean.getStudyParameterConfig().getDiscrepancyManagement().equalsIgnoreCase("true")) {
            hasDiscrepancyMgt = true;
        }
        for (DisplayItemGroupBean displayItemGroup : this.displayItemGroups) {
            String groupHeader;
            boolean hasGroupHeader;
            boolean unGroupedTable;
            List currentDisplayItems = displayItemGroup.getItems();
            SortedMap ordinalItemDataMap = new TreeMap();
            boolean hasStoredRepeatedRows = false;
            boolean bl = unGroupedTable = displayItemGroup.getItemGroupBean().getName().equalsIgnoreCase("Ungrouped") || !displayItemGroup.getGroupMetaBean().isRepeatingGroup();
            if (this.hasDbFormValues) {
                currentDisplayItems = persistanceHandler.loadDataIntoDisplayBeans(currentDisplayItems, !unGroupedTable);
                if (!unGroupedTable && persistanceHandler.hasPersistentRepeatedRows(currentDisplayItems)) {
                    hasStoredRepeatedRows = true;
                    ordinalItemDataMap = persistanceHandler.handleExtraGroupRows();
                }
            }
            boolean bl2 = hasGroupHeader = (groupHeader = displayItemGroup.getGroupMetaBean().getHeader()) != null && groupHeader.length() > 0;
            if (hasGroupHeader) {
                Element divGroupHeader = new Element("div");
                divGroupHeader.setAttribute("class", "aka_group_header");
                Element strong = new Element("strong");
                strong.setAttribute("style", "float:none");
                strong.addContent(groupHeader);
                divGroupHeader.addContent((Content)strong);
                divRoot.addContent((Content)divGroupHeader);
            }
            Element orphanTable = null;
            if (unGroupedTable) {
                orphanTable = formUtil.createXHTMLTableFromNonGroup(currentDisplayItems, Integer.valueOf(tabindex), hasDiscrepancyMgt, this.hasDbFormValues, false);
                tabindex += currentDisplayItems.size();
                divRoot.addContent((Content)orphanTable);
                continue;
            }
            String repeatParentId = "repeatParent" + ++uniqueId;
            int repeatNumber = displayItemGroup.getGroupMetaBean().getRepeatNum();
            repeatNumber = repeatNumber > 12 ? 12 : repeatNumber;
            boolean repeatFlag = displayItemGroup.getGroupMetaBean().isRepeatingGroup();
            Element table = this.createTable();
            Element thead = this.createThead();
            table.addContent((Content)thead);
            divRoot.addContent((Content)table);
            Element thRow = new Element("tr");
            thead.addContent((Content)thRow);
            boolean hasResponseLayout = builderUtil.hasResponseLayout(currentDisplayItems);
            List thTags = repeatFlag ? this.createTheadContentsFromDisplayItems(currentDisplayItems, true, hasBorders) : this.createTheadContentsFromDisplayItems(currentDisplayItems, false, hasBorders);
            for (Element el : thTags) {
                thRow.addContent((Content)el);
            }
            if (hasResponseLayout) {
                Element thRowSubhead = new Element("tr");
                thead.addContent((Content)thRowSubhead);
                this.addResponseLayoutRow(thRowSubhead, currentDisplayItems, hasBorders);
            }
            Element tbody = this.createTbody();
            table.addContent((Content)tbody);
            Element row = new Element("tr");
            int repeatMax = displayItemGroup.getGroupMetaBean().getRepeatMax();
            int n = repeatMax = repeatMax < 1 ? 40 : repeatMax;
            if (!(!repeatFlag || this.isDataEntry && hasStoredRepeatedRows)) {
                row = repeatManager.addParentRepeatAttributes(row, repeatParentId, Integer.valueOf(repeatNumber), Integer.valueOf(repeatMax));
            }
            for (DisplayItemBean displayBean : currentDisplayItems) {
                String responseName = displayBean.getMetadata().getResponseSet().getResponseType().getName();
                if (displayBean.getMetadata().getResponseLayout().equalsIgnoreCase("horizontal") && (responseName.equalsIgnoreCase("checkbox") || responseName.equalsIgnoreCase("radio"))) {
                    Element[] elements;
                    for (Element el : elements = cellFactory.createCellContentsForChecks(responseName, displayBean, Integer.valueOf(displayBean.getMetadata().getResponseSet().getOptions().size()), Integer.valueOf(++tabindex), false, false)) {
                        el = builderUtil.setClassNames(el);
                        if (hasBorders) {
                            this.createDarkBorders(el);
                        }
                        if (repeatFlag) {
                            el = repeatManager.addChildRepeatAttributes(el, repeatParentId, Integer.valueOf(displayBean.getItem().getId()), null);
                        }
                        row.addContent((Content)el);
                    }
                    continue;
                }
                Element td = new Element("td");
                td = builderUtil.setClassNames(td);
                if (hasBorders) {
                    this.createDarkBorders(td);
                }
                td = cellFactory.createCellContents(td, responseName, displayBean, Integer.valueOf(++tabindex), hasDiscrepancyMgt, this.hasDbFormValues, false);
                if (repeatFlag) {
                    td = repeatManager.addChildRepeatAttributes(td, repeatParentId, Integer.valueOf(displayBean.getItem().getId()), null);
                }
                row.addContent((Content)td);
            }
            if (repeatFlag) {
                builderUtil.addRemoveRowControl(row, repeatParentId, hasBorders);
            }
            tbody.addContent((Content)row);
            if (hasStoredRepeatedRows) {
                List storedRepeatedRows = builderUtil.generatePersistentMatrixRows(ordinalItemDataMap, currentDisplayItems, tabindex, repeatParentId, hasDiscrepancyMgt, false, hasBorders);
                for (Element newRow : storedRepeatedRows) {
                    tbody.addContent((Content)newRow);
                }
            }
            if (!repeatFlag) continue;
            builderUtil.createAddRowControl(tbody, repeatParentId, builderUtil.calcNumberofColumns(displayItemGroup) + 1, hasBorders);
        }
        XMLOutputter outp = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setOmitDeclaration(true);
        outp.setFormat(format);
        StringWriter writer = new StringWriter();
        try {
            outp.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            logger.error("Error while writing to XML:", (Throwable)e);
        }
        return ((Object)writer).toString();
    }

    private void addResponseLayoutRow(Element thRow, List<DisplayItemBean> displayBeans, boolean hasDarkBorder) {
        Element th2;
        for (DisplayItemBean dBean : displayBeans) {
            String responseLayout;
            ItemFormMetadataBean metaBean = dBean.getMetadata();
            ResponseSetBean respBean = metaBean.getResponseSet();
            String responseName = respBean.getResponseType().getName();
            if (responseName == null) {
                responseName = "";
            }
            if ((responseLayout = metaBean.getResponseLayout()) == null) {
                responseLayout = "";
            }
            if ((responseName.equalsIgnoreCase("radio") || responseName.equalsIgnoreCase("checkbox")) && responseLayout.equalsIgnoreCase("horizontal")) {
                for (int i = 0; i < respBean.getOptions().size(); ++i) {
                    ResponseOptionBean optBean = (ResponseOptionBean)respBean.getOptions().get(i);
                    if (optBean == null) continue;
                    th2 = this.createThCell(optBean.getText(), 1);
                    if (!hasDarkBorder) continue;
                    this.createDarkBorders(th2);
                    thRow.addContent((Content)th2);
                }
                continue;
            }
            th2 = this.createThCell("", 1);
            if (!hasDarkBorder) continue;
            this.createDarkBorders(th2);
            thRow.addContent((Content)th2);
        }
        th2 = this.createThCell();
        if (hasDarkBorder) {
            this.createDarkBorders(th2);
        }
        thRow.addContent((Content)th2);
    }

    public Element createTable() {
        Element tab = super.createTable();
        return this.setClassNames(tab);
    }

    public Element createThCell(String cellText, int colSpan) {
        Element th = super.createThCell(cellText);
        if (colSpan > 1) {
            th.setAttribute("colspan", colSpan + "");
        }
        return this.setClassNames(th);
    }

    public Element createTHTagFromItemMeta(ItemFormMetadataBean itemFormBean, boolean hasDarkBorders) {
        String header;
        String responseType = itemFormBean.getResponseSet().getResponseType().getName();
        boolean hasQuestNumber = !"".equalsIgnoreCase(itemFormBean.getQuestionNumberLabel());
        Element newSpan = new Element("span");
        if (hasQuestNumber) {
            newSpan = new Element("span");
            newSpan.setAttribute("style", "margin-right:1em");
            newSpan.addContent(itemFormBean.getQuestionNumberLabel());
        }
        if ((header = itemFormBean.getHeader()) != null && header.length() == 0) {
            header = itemFormBean.getLeftItemText();
        }
        Element thTag = (responseType.equalsIgnoreCase("radio") || responseType.equalsIgnoreCase("checkbox")) && itemFormBean.getResponseLayout().equalsIgnoreCase("horizontal") ? this.createThCell(header, itemFormBean.getResponseSet().getOptions().size()) : this.createThCell(header, 1);
        if (hasDarkBorders) {
            this.createDarkBorders(thTag);
        }
        if (hasQuestNumber) {
            thTag.addContent(0, (Content)newSpan);
        }
        return thTag;
    }

    public void createDarkBorders(Element element) {
        if (element == null) {
            return;
        }
        element.removeAttribute("class");
        String cssRuleIdentifier = element.getName();
        String cssClasses = CssRules.getClassNamesForTag((String)(cssRuleIdentifier + " borders_on"));
        element.setAttribute("class", cssClasses);
    }

    public List<Element> createTheadContentsFromDisplayItems(List<DisplayItemBean> displayBeans, boolean generateExtraColumn, boolean hasDarkBorders) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (DisplayItemBean displayBean : displayBeans) {
            ItemFormMetadataBean itemFormBean = displayBean.getMetadata();
            elements.add(this.createTHTagFromItemMeta(itemFormBean, hasDarkBorders));
        }
        if (generateExtraColumn) {
            if (!hasDarkBorders) {
                elements.add(this.createThCell("", 0));
            } else {
                Element thElement = new Element("th");
                String cssClasses = CssRules.getClassNamesForTag((String)"th borders_on");
                thElement.setAttribute("class", cssClasses);
                elements.add(thElement);
            }
        }
        return elements;
    }

    public Element setClassNames(Element styledElement) {
        String cssClasses = CssRules.getClassNamesForTag((String)styledElement.getName());
        return cssClasses.length() == 0 ? styledElement : styledElement.setAttribute("class", cssClasses);
    }

    public int getTabindexSeed() {
        return this.tabindexSeed;
    }

    public void setTabindexSeed(int tabindexSeedint) {
        if (tabindexSeedint > 1) {
            this.tabindexSeed = tabindexSeedint;
        }
    }

    public boolean isDataEntry() {
        return this.isDataEntry;
    }

    public void setDataEntry(boolean dataEntry) {
        this.isDataEntry = dataEntry;
    }

    public EventCRFBean getEventCRFbean() {
        return this.eventCRFbean;
    }

    public void setEventCRFbean(EventCRFBean eventCRFbean) {
        this.eventCRFbean = eventCRFbean;
    }

    public StudyBean getStudyBean() {
        return this.studyBean;
    }

    public void setStudyBean(StudyBean studyBean) {
        this.studyBean = studyBean;
    }
}

