/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.job;

import java.util.Date;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;

public class XalanTriggerService {
    public static final String DATASET_ID = "dsId";
    public static final String EMAIL = "contactEmail";
    public static final String USER_ID = "user_id";
    public static final String XSL_FILE_PATH = "xslFilePath";
    public static final String XML_FILE_PATH = "xmlFilePath";
    public static final String SQL_FILE_PATH = "sqlFilePath";
    public static String TRIGGER_GROUP_NAME = "XalanTriggers";

    public SimpleTrigger generateXalanTrigger(String xslFile, String xmlFile, String sqlFile, int datasetId) {
        Date startDateTime = new Date(System.currentTimeMillis());
        String jobName = xmlFile + datasetId;
        SimpleTrigger simpleTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().forJob(jobName, TRIGGER_GROUP_NAME).startAt(startDateTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(1).withIntervalInSeconds(100).withMisfireHandlingInstructionNextWithExistingCount());
        simpleTrigger.getJobDataMap().put(XSL_FILE_PATH, xslFile);
        simpleTrigger.getJobDataMap().put(XML_FILE_PATH, xmlFile);
        simpleTrigger.getJobDataMap().put(SQL_FILE_PATH, sqlFile);
        return simpleTrigger;
    }
}

