/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class AuditLogStudyServlet
extends SecureController {
    private static final long serialVersionUID = -6706477718073737099L;
    Locale locale;

    public static String getLink(int userId) {
        return "AuditLogStudy";
    }

    protected void processRequest() throws Exception {
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        AuditDAO adao = new AuditDAO(this.sm.getDataSource());
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        HashMap<Integer, ArrayList> eventsHashMap = new HashMap<Integer, ArrayList>();
        HashMap studySubjectAuditsHashMap = new HashMap();
        HashMap<Integer, SubjectBean> subjectHashMap = new HashMap<Integer, SubjectBean>();
        ArrayList studySubjects = subdao.findAllByStudyOrderByLabel(this.currentStudy);
        logger.info("found " + studySubjects.size() + " study subjects");
        this.request.setAttribute("studySubjects", (Object)studySubjects);
        for (int ss = 0; ss < studySubjects.size(); ++ss) {
            ArrayList studySubjectAudits = new ArrayList();
            StudySubjectBean studySubject = (StudySubjectBean)studySubjects.get(ss);
            SubjectBean subject = sdao.findByPK(studySubject.getSubjectId());
            subjectHashMap.put(new Integer(studySubject.getId()), subject);
            StudyBean study = studydao.findByPK(studySubject.getStudyId());
            this.request.setAttribute("study", (Object)study);
            studySubjectAudits.addAll(adao.findStudySubjectAuditEvents(studySubject.getId()));
            studySubjectAudits.addAll(adao.findSubjectAuditEvents(subject.getId()));
            studySubjectAuditsHashMap.put(new Integer(studySubject.getId()), studySubjectAudits);
            ArrayList events = sedao.findAllByStudySubject(studySubject);
            for (int i = 0; i < events.size(); ++i) {
                StudyEventBean studyEvent = (StudyEventBean)events.get(i);
                studyEvent.setStudyEventDefinition(seddao.findByPK(studyEvent.getStudyEventDefinitionId()));
                studyEvent.setEventCRFs(ecdao.findAllByStudyEvent(studyEvent));
            }
            eventsHashMap.put(new Integer(studySubject.getId()), events);
        }
        this.request.setAttribute("events", eventsHashMap);
        this.request.setAttribute("studySubjectAudits", studySubjectAuditsHashMap);
        this.request.setAttribute("study", (Object)this.currentStudy);
        this.request.setAttribute("subjects", subjectHashMap);
        logger.warn("*** found servlet, sending to page ***");
        String pattn = "";
        String pattern2 = "";
        pattn = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
        pattern2 = ResourceBundleProvider.getFormatBundle().getString("date_time_format_string");
        this.request.setAttribute("dateFormatPattern", (Object)pattn);
        this.request.setAttribute("dateTimeFormatPattern", (Object)pattern2);
        this.forwardPage(Page.AUDIT_LOG_STUDY);
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }
}

