/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.AuditEventDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.AuditEventRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public class AuditLogUserServlet
extends SecureController {
    private static final long serialVersionUID = -6177899330139423029L;
    Locale locale;
    public static final String ARG_USERID = "userLogId";

    public static String getLink(int userId) {
        return "AuditLogUser?userLogId=" + userId;
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int userId = fp.getInt(ARG_USERID);
        if (userId == 0) {
            Integer userIntId = (Integer)this.session.getAttribute(ARG_USERID);
            userId = userIntId;
        } else {
            this.session.setAttribute(ARG_USERID, (Object)new Integer(userId));
        }
        AuditEventDAO aeDAO = new AuditEventDAO(this.sm.getDataSource());
        ArrayList al = aeDAO.findAllByUserId(userId);
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allRows = AuditEventRow.generateRowsFromBeans((ArrayList)al);
        String[] columns = new String[]{resword.getString("date_and_time"), resword.getString("action_message"), resword.getString("entity_operation"), resword.getString("study_site"), resword.getString("study_subject_ID"), resword.getString("changes_and_additions"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.setAscendingSort(false);
        table.hideColumnLink(1);
        table.hideColumnLink(5);
        table.hideColumnLink(6);
        table.setQuery("AuditLogUser?userLogId=" + userId, new HashMap());
        table.setRows(allRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        UserAccountDAO uadao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean uabean = uadao.findByPK(userId);
        this.request.setAttribute("auditUserBean", (Object)uabean);
        this.forwardPage(Page.AUDIT_LOG_USER);
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (!this.ub.isSysAdmin()) {
            throw new InsufficientPermissionException(Page.MENU, resexception.getString("may_not_perform_administrative_functions"), "1");
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

