/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.UserAccountRow;

public class ListUserAccountsServlet
extends SecureController {
    private static final long serialVersionUID = -7298014383987992477L;
    public static final String PATH = "ListUserAccounts";
    public static final String ARG_MESSAGE = "message";

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("you_may_not_perform_administrative_functions"));
            throw new InsufficientPermissionException(Page.ADMIN_SYSTEM_SERVLET, respage.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        UserAccountDAO userAccountDao = new UserAccountDAO(this.sm.getDataSource());
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allUsers = this.getAllUsers(userAccountDao);
        this.setStudyNamesInStudyUserRoles(allUsers);
        ArrayList allUserRows = UserAccountRow.generateRowsFromBeans((ArrayList)allUsers);
        String[] columns = new String[]{resword.getString("user_name"), resword.getString("first_name"), resword.getString("last_name"), resword.getString("status"), resword.getString("auth_type"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(5);
        table.setQuery(PATH, new HashMap());
        table.addLink(resword.getString("create_a_new_user"), "CreateUserAccount");
        table.setRows(allUserRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        String message = fp.getString(ARG_MESSAGE, true);
        this.request.setAttribute(ARG_MESSAGE, (Object)message);
        this.request.setAttribute("siteRoleMap", (Object)Role.siteRoleMap);
        this.request.setAttribute("studyRoleMap", (Object)Role.studyRoleMap);
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        if (!allUsers.isEmpty()) {
            this.setToPanel(resword.getString("users"), Integer.toString(allUsers.size()));
        }
        this.forwardPage(Page.LIST_USER_ACCOUNTS);
    }

    private ArrayList<UserAccountBean> getAllUsers(UserAccountDAO userAccountDao) {
        return userAccountDao.findAll();
    }

    private void setStudyNamesInStudyUserRoles(ArrayList<UserAccountBean> users) {
        StudyDAO studyDao = new StudyDAO(this.sm.getDataSource());
        ArrayList allStudies = studyDao.findAll();
        Map<Integer, StudyBean> studiesById = allStudies.stream().collect(Collectors.toMap(EntityBean::getId, sb -> sb));
        for (UserAccountBean user : users) {
            ArrayList roles = user.getRoles();
            for (StudyUserRoleBean studyUserRoleBean : roles) {
                StudyBean studyBean = studiesById.get(studyUserRoleBean.getStudyId());
                if (studyBean == null) continue;
                studyUserRoleBean.setParentStudyId(studyBean.getParentStudyId());
                if (studyBean.isSite(studyBean.getParentStudyId())) {
                    StudyBean parentStudyBean = studiesById.get(studyUserRoleBean.getParentStudyId());
                    studyUserRoleBean.setStudyName(parentStudyBean.getName() + " : " + studyBean.getName());
                    continue;
                }
                studyUserRoleBean.setStudyName(studyBean.getName());
            }
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

