/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.springframework.mail.MailException;

public class SendTestEmailServlet
extends SecureController {
    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("you_may_not_perform_administrative_functions"));
            throw new InsufficientPermissionException(Page.ADMIN_SYSTEM_SERVLET, respage.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        String type;
        String message = "";
        String recipient = this.sm.getUserBean().getEmail();
        try {
            this.sendEmailImpl(recipient, EmailEngine.getAdminEmail(), "[LibreClinica] Test Email", "Since you received this email, the email setup of LibreClinica works as expected.", Boolean.valueOf(false));
            type = "success";
        }
        catch (MailException e) {
            type = "error";
            message = e.getMessage();
        }
        ObjectMapper om = new ObjectMapper();
        ObjectNode res = om.createObjectNode();
        res.put("type", type);
        res.put("message", message);
        res.put("recipient", recipient);
        this.response.setContentType("application/json");
        this.response.getWriter().write(om.writeValueAsString((Object)res));
        this.response.getWriter().close();
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

