/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.akaza.openclinica.bean.core.ApplicationConstants;
import org.akaza.openclinica.control.admin.Preview;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpreadsheetPreviewNw
implements Preview {
    public static final String ITEMS = "Items";
    public static final String SECTIONS = "Sections";
    public static final String GROUPS = "Groups";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.akaza.openclinica.control.admin.SpreadsheetPreviewNw");
    private SimpleDateFormat simpleDateFormat;

    public SpreadsheetPreviewNw() {
        String pattern = "";
        pattern = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
        this.simpleDateFormat = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern) : new SimpleDateFormat("MM/dd/yyyy");
    }

    public SpreadsheetPreviewNw(SimpleDateFormat simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
    }

    public Map<String, Map> createCrfMetaObject(HSSFWorkbook workbook) {
        if (workbook == null) {
            return new HashMap<String, Map>();
        }
        HashMap<String, Map> spreadSheetMap = new HashMap<String, Map>();
        Map sections = this.createItemsOrSectionMap(workbook, SECTIONS);
        Map items = this.createItemsOrSectionMap(workbook, ITEMS);
        Map crfInfo = this.createCrfMap(workbook);
        Map groups = this.createGroupsMap(workbook);
        if (sections.isEmpty() && items.isEmpty() && crfInfo.isEmpty()) {
            return spreadSheetMap;
        }
        spreadSheetMap.put("sections", sections);
        spreadSheetMap.put("items", items);
        spreadSheetMap.put("crf_info", crfInfo);
        spreadSheetMap.put("groups", groups);
        return spreadSheetMap;
    }

    public Map<Integer, Map<String, String>> createItemsOrSectionMap(HSSFWorkbook workbook, String itemsOrSection) {
        if (workbook == null || workbook.getNumberOfSheets() == 0) {
            return new HashMap<Integer, Map<String, String>>();
        }
        if (itemsOrSection == null || !itemsOrSection.equalsIgnoreCase(ITEMS) && !itemsOrSection.equalsIgnoreCase(SECTIONS)) {
            return new HashMap<Integer, Map<String, String>>();
        }
        String[] itemHeaders = new String[]{"item_name", "description_label", "left_item_text", "units", "right_item_text", "section_label", "group_label", "header", "subheader", "parent_item", "column_number", "page_number", "question_number", "response_type", "response_label", "response_options_text", "response_values", "response_layout", "default_value", "data_type", "width_decimal", "validation", "validation_error_message", "phi", "required"};
        String[] sectionHeaders = new String[]{"section_label", "section_title", "subtitle", "instructions", "page_number", "parent_section", "borders"};
        HashMap<String, String> rowCells = new HashMap<String, String>();
        TreeMap<Integer, Map<String, String>> allRows = new TreeMap<Integer, Map<String, String>>();
        String dateFormat = "";
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = workbook.getSheetAt(i);
            String str = workbook.getSheetName(i);
            if (!str.equalsIgnoreCase(itemsOrSection)) continue;
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                HSSFRow row;
                String[] headers;
                String[] stringArray = headers = itemsOrSection.equalsIgnoreCase(ITEMS) ? itemHeaders : sectionHeaders;
                if (j > 1) {
                    rowCells = new HashMap();
                }
                if ((row = sheet.getRow(j)) == null) continue;
                for (int k = 0; k < headers.length; ++k) {
                    HSSFCell cell = row.getCell((short)k);
                    if ("default_value".equalsIgnoreCase(headers[k]) && this.isDateDatatype(headers, row) && !"".equalsIgnoreCase(this.getCellValue(cell))) {
                        try {
                            String pttrn = ApplicationConstants.getDateFormatInItemData();
                            dateFormat = new SimpleDateFormat(pttrn).format(cell.getDateCellValue());
                            rowCells.put(headers[k], dateFormat);
                        }
                        catch (Exception e) {
                            String cellVal = this.getCellValue(cell);
                            logger.info("An invalid date format was encountered when reading a default value in the spreadsheet.");
                            rowCells.put(headers[k], cellVal);
                        }
                        continue;
                    }
                    if (headers[k].equalsIgnoreCase("left_item_text") || headers[k].equalsIgnoreCase("right_item_text") || headers[k].equalsIgnoreCase("header") || headers[k].equalsIgnoreCase("subheader") || headers[k].equalsIgnoreCase("question_number") || headers[k].equalsIgnoreCase("section_title") || headers[k].equalsIgnoreCase("subtitle") || headers[k].equalsIgnoreCase("instructions") || headers[k].equalsIgnoreCase("response_options_text")) {
                        rowCells.put(headers[k], this.getCellValue(cell).replaceAll("\\\\,", "\\,"));
                        continue;
                    }
                    rowCells.put(headers[k], this.getCellValue(cell).replaceAll("\\\\,", "\\,").replaceAll("<[^>]*>", ""));
                }
                allRows.put(j, rowCells);
            }
        }
        return allRows;
    }

    private boolean isDateDatatype(String[] headers, HSSFRow row) {
        String currentDataType = "";
        if (headers == null || headers.length == 0 || row == null) {
            return false;
        }
        for (int k = 0; k < headers.length; ++k) {
            HSSFCell cell = row.getCell((short)k);
            if (!"data_type".equalsIgnoreCase(headers[k]) || !"date".equalsIgnoreCase(currentDataType = this.getCellValue(cell))) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, Map<String, String>> createGroupsMap(HSSFWorkbook workbook) {
        if (workbook == null || workbook.getNumberOfSheets() == 0) {
            return new HashMap<Integer, Map<String, String>>();
        }
        HSSFSheet sheet = workbook.getSheetAt(4);
        HSSFCell cell = sheet.getRow(1).getCell((short)0);
        String version = cell.getStringCellValue();
        String[] groupHeaders = new String[]{"group_label", "repeating_group", "group_header", "group_repeat_number", "group_repeat_max"};
        if (version.equalsIgnoreCase("Version: 2.2") || version.equalsIgnoreCase("Version: 2.5") || version.equalsIgnoreCase("Version: 3.0")) {
            groupHeaders = new String[]{"group_label", "group_header", "group_repeat_number", "group_repeat_max"};
        }
        HashMap<String, String> rowCells = new HashMap<String, String>();
        TreeMap<Integer, Map<String, String>> allRows = new TreeMap<Integer, Map<String, String>>();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            sheet = workbook.getSheetAt(i);
            String str = workbook.getSheetName(i);
            if (!str.equalsIgnoreCase(GROUPS)) continue;
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                if (j > 1) {
                    rowCells = new HashMap();
                }
                HSSFRow row = sheet.getRow(j);
                for (int k = 0; k < groupHeaders.length; ++k) {
                    cell = row.getCell((short)k);
                    if (groupHeaders[k].equalsIgnoreCase("group_header")) {
                        rowCells.put(groupHeaders[k], this.getCellValue(cell));
                        continue;
                    }
                    rowCells.put(groupHeaders[k], this.getCellValue(cell).replaceAll("<[^>]*>", ""));
                }
                allRows.put(j, rowCells);
            }
        }
        return allRows;
    }

    private String getCellValue(HSSFCell cell) {
        String val = "";
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                String stringCellValue = cell.getStringCellValue();
                return stringCellValue;
            }
            case 0: {
                val = Double.toString(cell.getNumericCellValue());
                double dphi = cell.getNumericCellValue();
                if ((dphi - (double)((int)dphi)) * 1000.0 == 0.0) {
                    val = (int)dphi + "";
                }
                return val;
            }
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case 2: {
                return cell.getCellFormula();
            }
        }
        return "";
    }

    public Map<String, String> createCrfMap(HSSFWorkbook workbook) {
        if (workbook == null || workbook.getNumberOfSheets() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> crfInfo = new HashMap<String, String>();
        String mapKey = "";
        String val = "";
        String str = "";
        String[] crfHeaders = new String[]{"crf_name", "version", "version_description", "revision_notes"};
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = workbook.getSheetAt(i);
            str = workbook.getSheetName(i);
            if (!str.equalsIgnoreCase("CRF")) continue;
            HSSFRow row = sheet.getRow(1);
            for (int k = 0; k < crfHeaders.length; ++k) {
                mapKey = crfHeaders[k];
                HSSFCell cell = row.getCell((short)k);
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case 1: {
                            String stringCellValue;
                            val = stringCellValue = cell.getStringCellValue();
                            break;
                        }
                        case 0: {
                            val = Double.toString(cell.getNumericCellValue());
                            break;
                        }
                        case 4: {
                            val = Boolean.toString(cell.getBooleanCellValue());
                            break;
                        }
                        case 2: {
                            cell.getCellFormula();
                        }
                    }
                }
                crfInfo.put(mapKey, val);
            }
        }
        return crfInfo;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.simpleDateFormat;
    }

    public void setSimpleDateFormat(SimpleDateFormat simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
    }
}

