/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewUserAccountServlet
extends SecureController {
    private static final long serialVersionUID = 2096237550544873731L;
    public static final String PATH = "ViewUserAccount";
    public static final String ARG_USER_ID = "userId";

    public static String getLink(int userId) {
        return "ViewUserAccount?userId=" + userId;
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int userId = fp.getInt(ARG_USER_ID, true);
        UserAccountDAO userDao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean user = this.getBean(userDao, userId);
        if (!user.isActive()) {
            throw new InconsistentStateException(Page.ADMIN_SYSTEM, resexception.getString("the_user_attemping_to_view_not_exists"));
        }
        this.request.setAttribute("user", (Object)user);
        String pattn = "";
        pattn = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
        this.request.setAttribute("dateFormatPattern", (Object)pattn);
        this.forwardPage(Page.VIEW_USER_ACCOUNT);
    }

    private UserAccountBean getBean(UserAccountDAO userDao, int id) {
        UserAccountBean answer = userDao.findByPK(id);
        StudyDAO studyDao = new StudyDAO(this.sm.getDataSource());
        ArrayList roles = answer.getRoles();
        for (int i = 0; i < roles.size(); ++i) {
            StudyUserRoleBean studyUserRoleBean = (StudyUserRoleBean)roles.get(i);
            StudyBean studyBean = studyDao.findByPK(studyUserRoleBean.getStudyId());
            if (studyBean != null) {
                if (studyBean.isSite(studyBean.getParentStudyId())) {
                    StudyBean parentStudyBean = studyDao.findByPK(studyBean.getParentStudyId());
                    studyUserRoleBean.setStudyName(parentStudyBean.getName() + " : " + studyBean.getName());
                } else {
                    studyUserRoleBean.setStudyName(studyBean.getName());
                }
            }
            roles.set(i, studyUserRoleBean);
        }
        answer.setRoles(roles);
        return answer;
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

