/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class EditDatasetServlet
extends SecureController {
    private static final long serialVersionUID = -6853606383296360409L;

    public static String getLink(int dsId) {
        return "EditDataset?dsId=" + dsId;
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int dsId = fp.getInt("dsId");
        DatasetBean dataset = this.initializeAttributes(dsId);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = sdao.findByPK(dataset.getStudyId());
        this.checkRoleByUserAndStudy(this.ub, study.getParentStudyId(), study.getId());
        if (study.getId() != this.currentStudy.getId() && study.getParentStudyId() != this.currentStudy.getId()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        if ((this.currentRole.isMonitor() || this.currentRole.isInvestigator()) && dataset.getOwnerId() != this.ub.getId()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        LinkedHashMap<StudyEventDefinitionBean, ArrayList> events = (LinkedHashMap<StudyEventDefinitionBean, ArrayList>)this.session.getAttribute("eventsForCreateDataset");
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        if (events == null || events.isEmpty()) {
            events = new LinkedHashMap<StudyEventDefinitionBean, ArrayList>();
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyBean studyWithEventDefinitions = this.currentStudy;
            if (this.currentStudy.getParentStudyId() > 0) {
                studyWithEventDefinitions = new StudyBean();
                studyWithEventDefinitions.setId(this.currentStudy.getParentStudyId());
            }
            ArrayList seds = seddao.findAllActiveByStudy(studyWithEventDefinitions);
            for (int i = 0; i < seds.size(); ++i) {
                StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seds.get(i);
                ArrayList crfs = crfdao.findAllActiveByDefinition(sed);
                if (crfs.isEmpty()) continue;
                events.put(sed, crfs);
            }
            if (events.isEmpty()) {
                this.addPageMessage(respage.getString("not_have_study_definitions_assigned"));
                this.forwardPage(Page.VIEW_DATASETS);
            } else {
                this.request.setAttribute("eventlist", events);
                this.session.setAttribute("eventsForCreateDataset", events);
            }
        }
        this.request.setAttribute("dataset", (Object)dataset);
        this.request.setAttribute("statuses", (Object)this.getStatuses());
        this.forwardPage(Page.EDIT_DATASET);
    }

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private ArrayList<Status> getStatuses() {
        Status[] statusesArray = new Status[]{Status.AVAILABLE, Status.PENDING, Status.PRIVATE, Status.UNAVAILABLE};
        List<Status> statuses = Arrays.asList(statusesArray);
        return new ArrayList<Status>(statuses);
    }

    public DatasetBean initializeAttributes(int datasetId) {
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        DatasetBean db = dsdao.initialDatasetData(datasetId);
        this.session.setAttribute("newDataset", (Object)db);
        this.session.setAttribute("allItems", db.getItemDefCrf().clone());
        this.session.setAttribute("allSelectedItems", db.getItemDefCrf().clone());
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        StudyBean theStudy = studydao.findByPK(this.sm.getUserBean().getActiveStudyId());
        ArrayList allSelectedGroups = sgcdao.findAllActiveByStudy(theStudy);
        ArrayList selectedSubjectGroupIds = db.getSubjectGroupIds();
        if (selectedSubjectGroupIds != null && allSelectedGroups != null) {
            block0: for (Integer id : selectedSubjectGroupIds) {
                for (int i = 0; i < allSelectedGroups.size(); ++i) {
                    if (((StudyGroupClassBean)allSelectedGroups.get(i)).getId() != id.intValue()) continue;
                    ((StudyGroupClassBean)allSelectedGroups.get(i)).setSelected(true);
                    continue block0;
                }
            }
        }
        this.session.setAttribute("allSelectedGroups", (Object)allSelectedGroups);
        return db;
    }
}

