/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DatasetRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public class ViewDatasetsServlet
extends SecureController {
    private static final long serialVersionUID = -781606214750305705L;
    Locale locale;

    public static String getLink(int dsId) {
        return "ViewDatasets?action=details&datasetId=" + dsId;
    }

    public void processRequest() throws Exception {
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        String action = this.request.getParameter("action");
        this.resetPanel();
        this.request.setAttribute("panel", (Object)this.panel);
        this.session.removeAttribute("allSelectedItems");
        this.session.removeAttribute("allSelectedGroups");
        this.session.removeAttribute("allItems");
        this.session.removeAttribute("newDataset");
        if (action == null || action.trim().isEmpty()) {
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyBean studyWithEventDefinitions = this.currentStudy;
            if (this.currentStudy.getParentStudyId() > 0) {
                studyWithEventDefinitions = new StudyBean();
                studyWithEventDefinitions.setId(this.currentStudy.getParentStudyId());
            }
            ArrayList seds = seddao.findAllActiveByStudy(studyWithEventDefinitions);
            CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
            LinkedHashMap<StudyEventDefinitionBean, ArrayList> events = new LinkedHashMap<StudyEventDefinitionBean, ArrayList>();
            for (int i = 0; i < seds.size(); ++i) {
                StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seds.get(i);
                ArrayList crfs = crfdao.findAllActiveByDefinition(sed);
                if (crfs.isEmpty()) continue;
                events.put(sed, crfs);
            }
            this.session.setAttribute("eventsForCreateDataset", events);
            FormProcessor fp = new FormProcessor(this.request);
            EntityBeanTable table = fp.getEntityBeanTable();
            ArrayList datasets = dsdao.findAllByStudyId(this.currentStudy.getId());
            ArrayList datasetRows = DatasetRow.generateRowsFromBeans((ArrayList)datasets);
            String[] columns = new String[]{resword.getString("dataset_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(5);
            table.addLink(resword.getString("show_only_my_datasets"), "ViewDatasets?action=owner&ownerId=" + this.ub.getId());
            table.addLink(resword.getString("create_dataset"), "CreateDataset");
            table.setQuery("ViewDatasets", new HashMap());
            table.setRows(datasetRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            this.forwardPage(Page.VIEW_DATASETS);
        } else if ("owner".equalsIgnoreCase(action)) {
            FormProcessor fp = new FormProcessor(this.request);
            int ownerId = fp.getInt("ownerId");
            EntityBeanTable table = fp.getEntityBeanTable();
            ArrayList datasets = dsdao.findByOwnerId(ownerId, this.currentStudy.getId());
            ArrayList datasetRows = DatasetRow.generateRowsFromBeans((ArrayList)datasets);
            String[] columns = new String[]{resword.getString("dataset_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(5);
            table.addLink(resword.getString("show_all_datasets"), "ViewDatasets");
            table.addLink(resword.getString("create_dataset"), "CreateDataset");
            table.setQuery("ViewDatasets?action=owner&ownerId=" + this.ub.getId(), new HashMap());
            table.setRows(datasetRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            this.forwardPage(Page.VIEW_DATASETS);
        } else if ("details".equalsIgnoreCase(action)) {
            FormProcessor fp = new FormProcessor(this.request);
            int datasetId = fp.getInt("datasetId");
            DatasetBean db = this.initializeAttributes(datasetId);
            StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
            StudyBean study = sdao.findByPK(db.getStudyId());
            if (study.getId() != this.currentStudy.getId() && study.getParentStudyId() != this.currentStudy.getId()) {
                this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                this.forwardPage(Page.MENU_SERVLET);
                return;
            }
            this.request.setAttribute("dataset", (Object)db);
            this.forwardPage(Page.VIEW_DATASET_DETAILS);
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (!this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) && !this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public DatasetBean initializeAttributes(int datasetId) {
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        DatasetBean db = dsdao.initialDatasetData(datasetId);
        this.session.setAttribute("newDataset", (Object)db);
        this.session.setAttribute("allItems", db.getItemDefCrf().clone());
        this.session.setAttribute("allSelectedItems", db.getItemDefCrf().clone());
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        StudyBean theStudy = studydao.findByPK(this.sm.getUserBean().getActiveStudyId());
        ArrayList allSelectedGroups = sgcdao.findAllActiveByStudy(theStudy);
        ArrayList selectedSubjectGroupIds = db.getSubjectGroupIds();
        if (selectedSubjectGroupIds != null && allSelectedGroups != null) {
            block0: for (Integer id : selectedSubjectGroupIds) {
                for (int i = 0; i < allSelectedGroups.size(); ++i) {
                    if (((StudyGroupClassBean)allSelectedGroups.get(i)).getId() != id.intValue()) continue;
                    ((StudyGroupClassBean)allSelectedGroups.get(i)).setSelected(true);
                    continue block0;
                }
            }
        }
        this.session.setAttribute("allSelectedGroups", (Object)allSelectedGroups);
        return db;
    }
}

