/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.extract.CreateDatasetServlet;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewSelectedServlet
extends SecureController {
    private static final long serialVersionUID = 5458397988268565354L;
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public void setUpStudyGroups() {
        ArrayList sgclasses = ClassCastHelper.asArrayList((Object)this.session.getAttribute("allSelectedGroups"), StudyGroupClassBean.class);
        if (sgclasses == null || sgclasses.size() == 0) {
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyGroupClassDAO sgclassdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyBean theStudy = studydao.findByPK(this.sm.getUserBean().getActiveStudyId());
            sgclasses = sgclassdao.findAllActiveByStudy(theStudy);
        }
        this.session.setAttribute("allSelectedGroups", (Object)sgclasses);
        this.session.setAttribute("numberOfStudyGroups", (Object)sgclasses.size());
        this.request.setAttribute("allSelectedGroups", (Object)sgclasses);
    }

    public void processRequest() throws Exception {
        DatasetBean db = (DatasetBean)this.session.getAttribute("newDataset");
        HashMap events = (HashMap)this.session.getAttribute("eventsForCreateDataset");
        if (events == null) {
            events = new HashMap();
        }
        this.request.setAttribute("eventlist", events);
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        ItemFormMetadataDAO imfdao = new ItemFormMetadataDAO(this.sm.getDataSource());
        ArrayList ids = CreateDatasetServlet.allSedItemIdsInStudy(events, (CRFDAO)crfdao, (ItemDAO)idao);
        this.session.setAttribute("numberOfStudyItems", (Object)new Integer(ids.size()).toString());
        ArrayList items = new ArrayList();
        if (db == null || db.getItemIds().size() == 0) {
            this.session.setAttribute("allSelectedItems", items);
            this.setUpStudyGroups();
            this.forwardPage(Page.CREATE_DATASET_VIEW_SELECTED);
            return;
        }
        items = ViewSelectedServlet.getAllSelected((DatasetBean)db, (ItemDAO)idao, (ItemFormMetadataDAO)imfdao);
        this.session.setAttribute("allSelectedItems", (Object)items);
        FormProcessor fp = new FormProcessor(this.request);
        String status = fp.getString("status");
        if (status != null && !status.trim().isEmpty() && "html".equalsIgnoreCase(status)) {
            this.forwardPage(Page.CREATE_DATASET_VIEW_SELECTED_HTML);
        } else {
            this.setUpStudyGroups();
            this.forwardPage(Page.CREATE_DATASET_VIEW_SELECTED);
        }
    }

    public static ArrayList<ItemBean> getAllSelected(DatasetBean db, ItemDAO idao, ItemFormMetadataDAO imfdao) throws Exception {
        ArrayList<ItemBean> items = new ArrayList<ItemBean>();
        ArrayList itemDefCrfs = db.getItemDefCrf();
        for (int i = 0; i < itemDefCrfs.size(); ++i) {
            ItemBean item = (ItemBean)itemDefCrfs.get(i);
            item.setSelected(true);
            ArrayList metas = imfdao.findAllByItemId(item.getId());
            item.setItemMetas(metas);
            items.add(item);
        }
        return items;
    }
}

