/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.form;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityAction;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.core.UserType;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.control.form.EanCheckDigit;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validation;
import org.akaza.openclinica.control.form.ValidatorRegularExpression;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.core.EntityDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.I18nFormatUtil;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Validator {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    Locale locale;
    ResourceBundle restext;
    ResourceBundle resexception;
    ResourceBundle resword;
    public static final ValidatorRegularExpression EMAIL = new ValidatorRegularExpression("username@institution.domain", ".+@.+\\..*");
    public static final ValidatorRegularExpression USERNAME = new ValidatorRegularExpression("at least 2 alphanumeric or underscore characters", "[A-Za-z0-9_]{2,}");
    public static final int NO_BLANKS = 1;
    public static final int IS_A_NUMBER = 2;
    public static final int IS_IN_RANGE = 3;
    public static final int IS_A_DATE = 4;
    public static final int IS_DATE_TIME = 21;
    public static final int CHECK_SAME = 5;
    public static final int IS_A_EMAIL = 6;
    public static final int LENGTH_NUMERIC_COMPARISON = 7;
    public static final int ENTITY_EXISTS = 8;
    public static final int USERNAME_UNIQUE = 9;
    public static final int IS_AN_INTEGER = 10;
    public static final int IS_A_FILE = 11;
    public static final int IS_OF_FILE_TYPE = 12;
    public static final int DATE_IS_AFTER_OR_EQUAL = 13;
    public static final int IS_IN_SET = 14;
    public static final int IS_A_PASSWORD = 15;
    public static final int IS_A_USERNAME = 16;
    public static final int IS_VALID_TERM = 17;
    public static final int COMPARES_TO_STATIC_VALUE = 18;
    public static final int ENTITY_EXISTS_IN_STUDY = 19;
    public static final int IS_A_PHONE_NUMBER = 20;
    public static final int NO_BLANKS_SET = 22;
    public static final int IN_RESPONSE_SET = 23;
    public static final int IN_RESPONSE_SET_COMMA_SEPERATED = 38;
    public static final int IN_RESPONSE_SET_SINGLE_VALUE = 24;
    public static final int MATCHES_INITIAL_DATA_ENTRY_VALUE = 25;
    public static final int IS_REQUIRED = 26;
    public static final int MATCHES_REGULAR_EXPRESSION = 27;
    public static final int DATE_IN_PAST = 28;
    public static final int CHECK_DIFFERENT = 29;
    public static final int DIFFERENT_NUMBER_OF_GROUPS_IN_DDE = 30;
    public static final int IS_A_DATE_WITHOUT_REQUIRED_CHECK = 31;
    public static final int CALCULATION_FAILED = 32;
    public static final int IS_PARTIAL_DATE = 34;
    public static final int IS_AN_RULE = 33;
    public static final int IS_VALID_WIDTH_DECIMAL = 35;
    public static final int BARCODE_EAN_13 = 36;
    public static final int TO_HIDE_CONDITIONAL_DISPLAY = 37;
    public static final int NO_SEMI_COLONS_OR_COLONS = 43;
    public static final int NO_SPACES_ALLOWED = 44;
    public static final int SUBMISSION_URL_NOT_UNIQUE = 45;
    public static final int NO_LEADING_OR_TRAILING_SPACES = 46;
    public static final int DOES_NOT_CONTAIN_HTML_LESSTHAN_GREATERTHAN_ELEMENTS = 47;
    protected String lastField;
    protected HashMap<String, ArrayList<Validation>> validations = new HashMap();
    protected HashMap<String, ArrayList<String>> errors = new HashMap();
    protected HttpServletRequest request;
    protected ResourceBundle resformat;

    public static ValidatorRegularExpression getDateRegEx() {
        ResourceBundle resformat = ResourceBundleProvider.getFormatBundle();
        return new ValidatorRegularExpression(resformat.getString("date_format"), resformat.getString("date_regexp"));
    }

    public static ValidatorRegularExpression getDateTimeRegEx() {
        ResourceBundle resformat = ResourceBundleProvider.getFormatBundle();
        return new ValidatorRegularExpression(resformat.getString("date_time_format"), resformat.getString("date_time_regexp"));
    }

    public static ValidatorRegularExpression getPhoneRegEx() {
        ResourceBundle resformat = ResourceBundleProvider.getFormatBundle();
        return new ValidatorRegularExpression(resformat.getString("phone_format"), resformat.getString("phone_regexp"));
    }

    public Validator(HttpServletRequest request) {
        this.request = request;
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)this.locale);
        this.restext = ResourceBundleProvider.getTextsBundle((Locale)this.locale);
        this.resexception = ResourceBundleProvider.getExceptionsBundle((Locale)this.locale);
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)this.locale);
        this.lastField = "";
    }

    protected ArrayList<Validation> getFieldValidations(String fieldName) {
        ArrayList fieldValidations = this.validations.containsKey(fieldName) ? (ArrayList)this.validations.get(fieldName) : new ArrayList();
        return fieldValidations;
    }

    public void addValidation(String fieldName, Validation v) {
        ArrayList fieldValidations = this.getFieldValidations(fieldName);
        fieldValidations.add(v);
        this.validations.put(fieldName, fieldValidations);
    }

    public void addValidation(String fieldName, int type) {
        Validation v = new Validation(type);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, int start, int end) {
        Validation v = new Validation(type);
        v.addArgument(start);
        v.addArgument(end);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, String dir) {
        Validation v = new Validation(type);
        v.addArgument((Object)dir);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, NumericComparisonOperator operator, int compareTo) {
        Validation v = new Validation(type);
        v.addArgument((Object)operator);
        v.addArgument(compareTo);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, AuditableEntityDAO<?> dao, StudyBean study) {
        Validation v = new Validation(type);
        v.addArgument(dao);
        v.addArgument((Object)study);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, EntityDAO<?> edao) {
        Validation v = new Validation(type);
        v.addArgument(edao);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, ArrayList<?> set) {
        Validation v = new Validation(type);
        v.addArgument(set);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, TermType termType) {
        Validation v = new Validation(type);
        v.addArgument((Object)termType);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, ResponseSetBean set) {
        Validation v = new Validation(type);
        v.addArgument((Object)set);
        this.addValidation(fieldName, v);
    }

    public void addValidation(String fieldName, int type, ItemDataBean idb, boolean isMultiple) {
        Validation v = new Validation(type);
        v.addArgument((Object)new String(idb.getValue()));
        v.addArgument(isMultiple);
        this.lastField = fieldName;
        this.addValidation(fieldName, v);
    }

    public HashMap<String, ArrayList<String>> validate() {
        for (String fieldName : this.validations.keySet()) {
            ArrayList fieldValidations = this.getFieldValidations(fieldName);
            for (int i = 0; i < fieldValidations.size(); ++i) {
                Validation v = (Validation)fieldValidations.get(i);
                this.logger.debug("fieldName=" + fieldName);
                this.validate(fieldName, v);
                if (this.errors.containsKey(fieldName)) {
                    this.logger.debug("found an error for " + fieldName + " v-type: " + v.getType() + " " + v.getErrorMessage() + ": " + this.getFieldValue(fieldName));
                    continue;
                }
                this.logger.debug("did NOT find an error for " + fieldName + " v-type: " + v.getType() + " " + v.getErrorMessage() + ": " + this.getFieldValue(fieldName));
            }
        }
        return this.errors;
    }

    public String getKeySet() {
        String retMe = "";
        for (String fieldName : this.validations.keySet()) {
            retMe = retMe + fieldName;
            ArrayList fieldValidations = this.getFieldValidations(fieldName);
            retMe = retMe + " found " + fieldValidations.size() + " field validations; ";
        }
        return retMe;
    }

    protected void addError(String fieldName, Validation v) {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        this.resexception = ResourceBundleProvider.getExceptionsBundle((Locale)this.locale);
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)this.locale);
        String errorMessage = "";
        if (v.isErrorMessageSet()) {
            errorMessage = v.getErrorMessage();
        } else {
            switch (v.getType()) {
                case 1: {
                    errorMessage = this.resexception.getString("field_not_blank");
                    break;
                }
                case 46: {
                    errorMessage = this.resexception.getString("field_no_leading_or_trailing_spaces");
                    break;
                }
                case 2: {
                    errorMessage = this.resexception.getString("field_should_number");
                    break;
                }
                case 3: {
                    float lowerBound = v.getFloat(0);
                    float upperBound = v.getFloat(1);
                    errorMessage = this.resexception.getString("input_should_be_between") + new Float(lowerBound).intValue() + " " + this.resword.getString("and") + " " + new Float(upperBound).intValue() + ".";
                    break;
                }
                case 4: {
                    errorMessage = this.resexception.getString("input_not_valid_date") + Validator.getDateRegEx().getDescription() + " " + this.resexception.getString("format1") + ".";
                    break;
                }
                case 21: {
                    errorMessage = this.resexception.getString("input_not_valid_date_time") + Validator.getDateTimeRegEx().getDescription() + " " + this.resexception.getString("format2") + ".";
                    break;
                }
                case 5: {
                    errorMessage = this.resexception.getString("anwer_not_match");
                    break;
                }
                case 6: {
                    errorMessage = this.resexception.getString("input_not_valid_email") + EMAIL.getDescription() + " " + this.resexception.getString("format3") + ".";
                    break;
                }
                case 20: {
                    errorMessage = this.resexception.getString("input_not_valid_phone") + Validator.getPhoneRegEx().getDescription() + " " + this.resexception.getString("format4") + ".";
                    break;
                }
                case 8: {
                    errorMessage = this.resexception.getString("not_select_valid_entity");
                    break;
                }
                case 19: {
                    errorMessage = this.resexception.getString("not_select_valid_entity_current_study");
                    break;
                }
                case 9: {
                    errorMessage = this.resexception.getString("username_already_exists");
                    break;
                }
                case 10: {
                    errorMessage = this.resexception.getString("input_not_integer");
                    break;
                }
                case 14: {
                    errorMessage = this.resexception.getString("input_not_acceptable_option");
                    break;
                }
                case 16: {
                    errorMessage = this.resexception.getString("input_not_valid_username") + USERNAME.getDescription() + " " + this.resexception.getString("format5") + ".";
                    break;
                }
                case 17: {
                    errorMessage = this.resexception.getString("input_invalid");
                    break;
                }
                case 18: {
                    NumericComparisonOperator operator = (NumericComparisonOperator)v.getArg(0);
                    float compareTo = v.getFloat(1);
                    errorMessage = this.resexception.getString("input_provided_is_not") + operator.getDescription() + " " + new Float(compareTo).intValue() + ".";
                    break;
                }
                case 7: {
                    NumericComparisonOperator operator2 = (NumericComparisonOperator)v.getArg(0);
                    int compareTo2 = v.getInt(1);
                    errorMessage = this.resexception.getString("input_provided_is_not") + operator2.getDescription() + " " + compareTo2 + " " + this.resword.getString("characters_long") + ".";
                    break;
                }
                case 13: {
                    String earlierDateFieldName = v.getString(0);
                    String earlierDateValue = this.getFieldValue(earlierDateFieldName);
                    if (earlierDateValue == null || earlierDateValue.equals("")) {
                        errorMessage = this.resexception.getString("input_provided_not_precede_earlier");
                        break;
                    }
                    errorMessage = this.resexception.getString("input_provided_not_precede") + earlierDateValue + ".";
                    break;
                }
                case 22: {
                    errorMessage = this.resexception.getString("must_choose_leat_one_value");
                    break;
                }
                case 23: {
                    errorMessage = this.resexception.getString("all_values_must_from_specified");
                    break;
                }
                case 38: {
                    errorMessage = this.resexception.getString("all_values_must_from_specified");
                    break;
                }
                case 24: {
                    errorMessage = this.resexception.getString("values_must_from_valid");
                    break;
                }
                case 30: {
                    errorMessage = this.resexception.getString("different_number_of_groups");
                    break;
                }
                case 25: {
                    String value = v.getString(0);
                    errorMessage = this.resexception.getString("value_not_match") + " : " + value;
                    break;
                }
                case 26: {
                    errorMessage = this.resexception.getString("input_is_required");
                    break;
                }
                case 28: {
                    errorMessage = this.resexception.getString("date_provided_not_past");
                    break;
                }
                case 27: {
                    errorMessage = this.resexception.getString("input_not_match_regular_expression") + v.getString(0) + ".";
                    break;
                }
                case 31: {
                    errorMessage = this.resexception.getString("input_not_valid_date") + Validator.getDateRegEx().getDescription() + " " + this.resexception.getString("format1") + ".";
                    break;
                }
                case 33: {
                    errorMessage = this.resexception.getString("input_not_integer");
                    break;
                }
                case 34: {
                    errorMessage = this.resexception.getString("input_not_partial_date") + " (" + this.resformat.getString("date_format_year") + ", or " + this.resformat.getString("date_format_year_month") + ", or " + this.resformat.getString("date_format_string");
                    break;
                }
                case 36: {
                    errorMessage = this.resexception.getString("input_not_barcode");
                    break;
                }
                case 37: {
                    errorMessage = v.getErrorMessage();
                    break;
                }
                case 43: {
                    errorMessage = this.resexception.getString("field_not_have_colons_or_semi");
                    break;
                }
                case 44: {
                    errorMessage = this.resexception.getString("field_no_spaces_allowed");
                    break;
                }
                case 45: {
                    errorMessage = this.resexception.getString("field_submission_url_not_unique");
                    break;
                }
                case 47: {
                    errorMessage = this.resexception.getString("id_can_not_contain_html_lessthan_or_greaterthan_elements");
                }
            }
        }
        this.addError(fieldName, errorMessage);
    }

    protected void addError(String fieldName, String errorMessage) {
        Validator.addError((HashMap)this.errors, (String)fieldName, (String)errorMessage);
    }

    public static void addError(HashMap<String, ArrayList<String>> existingErrors, String fieldName, String errorMessage) {
        ArrayList<Object> fieldErrors = existingErrors.containsKey(fieldName) ? existingErrors.get(fieldName) : new ArrayList();
        fieldErrors.add(errorMessage);
        existingErrors.put(fieldName, fieldErrors);
    }

    protected HashMap<String, ArrayList<String>> validate(String fieldName, Validation v) {
        switch (v.getType()) {
            case 1: {
                if (!this.isBlank(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 46: {
                if (!this.isLeadingTrailingSpaces(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 2: {
                if (this.isNumber(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 3: {
                float lowerBound = v.getFloat(0);
                float upperBound = v.getFloat(1);
                if (this.isInRange(fieldName, lowerBound, upperBound)) break;
                this.addError(fieldName, v);
                break;
            }
            case 4: {
                if (this.isDate(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 21: {
                if (this.isDateTime(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 5: {
                String compareField = v.getString(0);
                if (this.isSame(fieldName, compareField)) break;
                this.addError(fieldName, v);
                break;
            }
            case 6: {
                if (this.isEmail(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 20: {
                if (this.isPhoneNumber(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 8: {
                EntityDAO edao = (EntityDAO)v.getArg(0);
                if (this.entityExists(fieldName, edao)) break;
                this.addError(fieldName, v);
                break;
            }
            case 19: {
                AuditableEntityDAO dao = (AuditableEntityDAO)v.getArg(0);
                StudyBean study = (StudyBean)v.getArg(1);
                if (this.entityExistsInStudy(fieldName, dao, study)) break;
                this.addError(fieldName, v);
                break;
            }
            case 9: {
                UserAccountDAO udao = (UserAccountDAO)v.getArg(0);
                if (this.usernameUnique(fieldName, udao)) break;
                this.addError(fieldName, v);
                break;
            }
            case 10: {
                if (this.isInteger(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 14: {
                ArrayList set = ClassCastHelper.asArrayList((Object)v.getArg(0), String.class);
                if (this.isInSet(fieldName, set)) break;
                this.addError(fieldName, v);
                break;
            }
            case 16: {
                if (this.isUsername(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 17: {
                TermType termType = (TermType)v.getArg(0);
                if (this.isValidTerm(fieldName, termType)) break;
                this.addError(fieldName, v);
                break;
            }
            case 18: {
                NumericComparisonOperator operator = (NumericComparisonOperator)v.getArg(0);
                float compareTo = v.getFloat(1);
                if (this.comparesToStaticValue(fieldName, operator, compareTo)) break;
                this.addError(fieldName, v);
                break;
            }
            case 7: {
                NumericComparisonOperator operator2 = (NumericComparisonOperator)v.getArg(0);
                int compareTo2 = v.getInt(1);
                if (this.lengthComparesToStaticValue(fieldName, operator2, compareTo2)) break;
                this.addError(fieldName, v);
                break;
            }
            case 13: {
                String earlierDateFieldName = v.getString(0);
                if (this.isDateAfterOrEqual(fieldName, earlierDateFieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 22: {
                if (!this.isSetBlank(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 23: {
                ResponseSetBean rsb = (ResponseSetBean)v.getArg(0);
                if (this.isInResponseSet(fieldName, rsb, true)) break;
                this.addError(fieldName, v);
                break;
            }
            case 38: {
                ResponseSetBean rsbs = (ResponseSetBean)v.getArg(0);
                if (this.isInResponseSetCommaSeperated(fieldName, rsbs, true)) break;
                this.addError(fieldName, v);
                break;
            }
            case 24: {
                ResponseSetBean rsbSingle = (ResponseSetBean)v.getArg(0);
                if (this.isInResponseSet(fieldName, rsbSingle, false)) break;
                this.addError(fieldName, v);
                break;
            }
            case 25: {
                String oldValue = v.getString(0);
                boolean isMultiple = v.getBoolean(1);
                if (this.valueMatchesInitialValue(fieldName, oldValue, isMultiple)) break;
                this.addError(fieldName, v);
                break;
            }
            case 30: {
                this.addError(fieldName, v);
                break;
            }
            case 26: {
                if (!this.isBlank(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 28: {
                if (this.isDateInPast(fieldName, this.locale)) break;
                this.addError(fieldName, v);
                break;
            }
            case 27: {
                if (this.matchesRegex(fieldName, v.getString(0))) break;
                this.addError(fieldName, v);
                break;
            }
            case 29: {
                String old = v.getString(0);
                if (!this.isSame(fieldName, old)) break;
                this.addError(fieldName, v);
                break;
            }
            case 31: {
                if (this.isDateWithoutRequiredCheck(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 32: {
                this.addError(fieldName, v);
                break;
            }
            case 33: {
                ArrayList messages = ClassCastHelper.asArrayList((Object)v.getArg(0), String.class);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < messages.size(); ++i) {
                    sb.append((String)messages.get(i));
                    if (i != messages.size() - 1) {
                        sb.append(" , ");
                    }
                    this.logger.debug((String)messages.get(i));
                }
                v.setErrorMessage(sb.toString());
                this.addError(fieldName, v);
                break;
            }
            case 34: {
                boolean isPDate = Boolean.FALSE;
                String fieldValue = this.getFieldValue(fieldName);
                if (fieldValue != null && (StringUtil.isFormatDate((String)fieldValue, (String)this.resformat.getString("date_format_string"), (Locale)this.locale) || StringUtil.isPartialYear((String)fieldValue, (String)"yyyy", (Locale)this.locale) || StringUtil.isPartialYearMonth((String)fieldValue, (String)this.resformat.getString("date_format_year_month"), (Locale)this.locale))) {
                    isPDate = true;
                }
                if (isPDate) break;
                this.addError(fieldName, v);
                break;
            }
            case 35: {
                ArrayList params = ClassCastHelper.asArrayList((Object)v.getArg(0), String.class);
                String dataType = (String)params.get(0);
                String widthDecimal = (String)params.get(1);
                StringBuffer error = this.validateFieldWidthDecimal(fieldName, dataType, widthDecimal);
                if (error.length() <= 0) break;
                this.addError(fieldName, error.toString());
                break;
            }
            case 36: {
                EanCheckDigit eanChk = new EanCheckDigit();
                if (eanChk.isValid(this.getFieldValue(fieldName))) break;
                this.addError(fieldName, v);
                break;
            }
            case 37: {
                this.addError(fieldName, v);
                break;
            }
            case 43: {
                if (!this.isColonSemiColon(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 44: {
                if (!this.isSpacesInSubmissionUrl(fieldName)) break;
                this.addError(fieldName, v);
                break;
            }
            case 45: {
                if (this.isSubmissionUrlUnique(fieldName)) {
                    this.addError(fieldName, v);
                }
            }
            case 47: {
                if (!this.doesContainHtmlElements(fieldName)) break;
                this.addError(fieldName, v);
            }
        }
        return this.errors;
    }

    protected String getFieldValue(String fieldName) {
        return this.request.getParameter(fieldName) == null ? (this.request.getAttribute(fieldName) == null ? null : this.request.getAttribute(fieldName).toString()) : this.request.getParameter(fieldName);
    }

    protected boolean isBlank(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return true;
        }
        return fieldValue.trim().equals("");
    }

    protected boolean isLeadingTrailingSpaces(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        return fieldValue != null && !fieldValue.trim().equals(fieldValue);
    }

    protected boolean isColonSemiColon(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        return fieldValue.indexOf(";") != -1 || fieldValue.indexOf(":") != -1 || fieldValue.indexOf("*") != -1;
    }

    protected boolean isNumber(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        if (fieldValue.equals("")) {
            return true;
        }
        try {
            Float.parseFloat(fieldValue);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean isInRange(String fieldName, float lowerBound, float upperBound) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        try {
            float i = Float.parseFloat(fieldValue);
            if (i >= lowerBound && i <= upperBound) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    protected boolean isDate(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null || fieldValue.trim().isEmpty()) {
            return false;
        }
        if (!StringUtil.isDateFormatString((String)fieldValue, (String)this.resformat.getString("date_format_string"), (Locale)this.locale)) {
            return false;
        }
        SimpleDateFormat sdf = I18nFormatUtil.getDateFormat((Locale)this.locale);
        sdf.setLenient(false);
        try {
            Date date = sdf.parse(fieldValue);
            return this.isYearNotFourDigits(date);
        }
        catch (ParseException fe) {
            return false;
        }
    }

    protected boolean isDateWithoutRequiredCheck(String fieldName) {
        String fieldValue = this.request.getParameter(fieldName);
        if (fieldValue == null || fieldValue.trim().isEmpty()) {
            return true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.resformat.getString("date_format_string"), this.locale);
        sdf.setLenient(false);
        try {
            Date date = sdf.parse(fieldValue);
            return this.isYearNotFourDigits(date);
        }
        catch (ParseException fe) {
            return false;
        }
    }

    protected boolean isDateInPast(String fieldName) {
        Date d = null;
        if (fieldName != null) {
            d = FormProcessor.parseDate((String)this.getFieldValue(fieldName), (Locale)this.locale);
        }
        if (d != null) {
            Date today = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(10, 24);
            today = cal.getTime();
            if (today.compareTo(d) >= 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean isDateInPast(String fieldName, Locale locale) {
        Date d = null;
        if (fieldName != null) {
            d = FormProcessor.parseDate((String)this.getFieldValue(fieldName), (Locale)locale);
        }
        if (d != null) {
            Date today = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(10, 24);
            today = cal.getTime();
            if (today.compareTo(d) >= 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean isYearNotFourDigits(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(1) >= 1000 && c.get(1) <= 9999;
    }

    protected boolean isDateTime(String prefix) {
        String date = this.getFieldValue(prefix + "Date");
        String hour = this.getFieldValue(prefix + "Hour");
        String minute = this.getFieldValue(prefix + "Minute");
        String half = this.getFieldValue(prefix + "Half");
        if (date == null || hour == null || minute == null || half == null) {
            this.logger.info("one of the date time fields is null");
            return false;
        }
        if ("-1".equals(hour) && "-1".equals(minute) && "".equals(half)) {
            hour = "12";
            minute = "00";
            half = "am";
        }
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (minute.length() == 1) {
            minute = "0" + minute;
        }
        String fieldValue = date + " " + hour + ":" + minute + ":00 " + half;
        SimpleDateFormat sdf = new SimpleDateFormat(this.resformat.getString("date_time_format_string"), this.locale);
        sdf.setLenient(false);
        try {
            Date result = sdf.parse(fieldValue);
            return this.isYearNotFourDigits(result);
        }
        catch (Exception fe) {
            return false;
        }
    }

    protected boolean isUsername(String fieldName) {
        return this.matchesRegex(fieldName, USERNAME);
    }

    protected boolean isSame(String field1, String field2) {
        String value1 = this.getFieldValue(field1).trim();
        String value2 = this.getFieldValue(field2).trim();
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null) {
            return false;
        }
        if (value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    protected boolean isEmail(String fieldName) {
        return this.matchesRegex(fieldName, EMAIL);
    }

    protected boolean isPhoneNumber(String fieldName) {
        return this.matchesRegex(fieldName, Validator.getPhoneRegEx());
    }

    protected boolean lengthComparesToStaticValue(String fieldName, NumericComparisonOperator operator, int compareTo) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        try {
            int length = fieldValue.length();
            return this.intComparesToStaticValue(length, operator, compareTo);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isInteger(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        if (fieldValue.equals("")) {
            return true;
        }
        try {
            int n = Integer.parseInt(fieldValue);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    protected boolean isInSet(String fieldName, ArrayList<String> set) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        if (set == null) {
            return false;
        }
        return set.contains(fieldValue);
    }

    protected boolean isValidTerm(String fieldName, TermType termType) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(fieldValue);
            if (termType.equals((Term)TermType.ENTITY_ACTION)) {
                return EntityAction.contains((int)i);
            }
            if (termType.equals((Term)TermType.ROLE)) {
                return Role.contains((int)i);
            }
            if (termType.equals((Term)TermType.STATUS)) {
                return Status.contains((int)i);
            }
            if (termType.equals((Term)TermType.USER_TYPE)) {
                return UserType.contains((int)i);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean comparesToStaticValue(String fieldName, NumericComparisonOperator operator, float compareTo) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        try {
            float i = Float.parseFloat(fieldValue);
            return this.floatComparesToStaticValue(i, operator, compareTo);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean intComparesToStaticValue(int i, NumericComparisonOperator operator, int compareTo) {
        boolean compares = false;
        if (operator.equals((Term)NumericComparisonOperator.EQUALS)) {
            compares = i == compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.NOT_EQUALS)) {
            compares = i != compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.GREATER_THAN)) {
            compares = i > compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.GREATER_THAN_OR_EQUAL_TO)) {
            compares = i >= compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.LESS_THAN)) {
            compares = i < compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO)) {
            compares = i <= compareTo;
        }
        return compares;
    }

    protected boolean floatComparesToStaticValue(float i, NumericComparisonOperator operator, float compareTo) {
        boolean compares = false;
        if (operator.equals((Term)NumericComparisonOperator.EQUALS)) {
            compares = i == compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.NOT_EQUALS)) {
            compares = i != compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.GREATER_THAN)) {
            compares = i > compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.GREATER_THAN_OR_EQUAL_TO)) {
            compares = i >= compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.LESS_THAN)) {
            compares = i < compareTo;
        } else if (operator.equals((Term)NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO)) {
            compares = i <= compareTo;
        }
        return compares;
    }

    protected boolean matchesRegex(String fieldName, String regex) {
        ValidatorRegularExpression vre = new ValidatorRegularExpression(regex, regex);
        return this.matchesRegex(fieldName, vre);
    }

    protected boolean matchesRegex(String fieldName, ValidatorRegularExpression re) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        Pattern p = null;
        try {
            p = Pattern.compile(re.getRegularExpression());
        }
        catch (PatternSyntaxException pse) {
            return false;
        }
        Matcher m = p.matcher(fieldValue);
        return m.matches();
    }

    protected boolean entityExists(String fieldName, EntityDAO<?> edao) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        try {
            int id = Integer.parseInt(fieldValue);
            EntityBean e = edao.findByPK(id);
            if (!e.isActive()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean entityExistsInStudy(String fieldName, AuditableEntityDAO<?> dao, StudyBean study) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        try {
            int id = Integer.parseInt(fieldValue);
            EntityBean e = dao.findByPKAndStudy(id, study);
            if (!e.isActive()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean usernameUnique(String fieldName, UserAccountDAO udao) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return true;
        }
        try {
            UserAccountBean ub = udao.findByUserName(fieldValue);
            if (ub.isActive()) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    protected boolean isDateAfterOrEqual(String laterDateFieldName, String earlierDateFieldName) {
        Date earlierDate;
        String laterDateValue = this.getFieldValue(laterDateFieldName);
        String earlierDateValue = this.getFieldValue(earlierDateFieldName);
        if (laterDateValue == null || earlierDateValue == null) {
            return false;
        }
        Date laterDate = FormProcessor.parseDate((String)laterDateValue, (Locale)this.locale);
        return laterDate.compareTo(earlierDate = FormProcessor.parseDate((String)earlierDateValue, (Locale)this.locale)) >= 0;
    }

    protected boolean isSetBlank(String fieldName) {
        String[] fieldValues = this.request.getParameterValues(fieldName);
        return fieldValues == null || fieldValues.length == 0;
    }

    protected boolean isInResponseSet(String fieldName, ResponseSetBean set, boolean multValues) {
        String[] fieldValues;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        ArrayList options = set.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            ResponseOptionBean rob = (ResponseOptionBean)options.get(i);
            values.put(rob.getValue(), Boolean.TRUE);
        }
        if (multValues) {
            fieldValues = this.request.getParameterValues(fieldName);
        } else {
            fieldValues = new String[1];
            String fieldValue = this.getFieldValue(fieldName);
            String string = fieldValues[0] = fieldValue == null ? "" : fieldValue;
            if (fieldValues[0].equals("")) {
                return true;
            }
        }
        if (fieldValues == null) {
            return true;
        }
        for (String value : fieldValues) {
            if (value == null || values.containsKey(value)) continue;
            return false;
        }
        return true;
    }

    protected boolean isInResponseSetCommaSeperated(String fieldName, ResponseSetBean set, boolean multValues) {
        String[] fieldValues;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        ArrayList options = set.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            ResponseOptionBean rob = (ResponseOptionBean)options.get(i);
            values.put(rob.getValue(), Boolean.TRUE);
        }
        if (multValues) {
            fieldValues = this.request.getParameter(fieldName).split(",");
        } else {
            fieldValues = new String[1];
            String fieldValue = this.getFieldValue(fieldName);
            String string = fieldValues[0] = fieldValue == null ? "" : fieldValue;
        }
        if (fieldValues == null) {
            return true;
        }
        for (String value : fieldValues) {
            if (value == null || values.containsKey(value)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSpacesInSubmissionUrl(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        return fieldValue.trim().contains(" ");
    }

    protected boolean doesContainHtmlElements(String fieldName) {
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null) {
            return false;
        }
        return fieldValue.contains("<") || fieldValue.contains(">");
    }

    protected boolean isSubmissionUrlUnique(String fieldName) {
        return true;
    }

    protected boolean valueMatchesInitialValue(String fieldName, String oldValue, boolean isMultiple) {
        String fieldValue = "";
        String glue = "";
        if (isMultiple) {
            String[] fieldValues = this.request.getParameterValues(fieldName);
            if (fieldValues != null) {
                for (String element : fieldValues) {
                    fieldValue = fieldValue + glue + element;
                    glue = ",";
                }
            }
        } else {
            try {
                fieldValue = this.getFieldValue(fieldName);
            }
            catch (NullPointerException npe) {
                this.logger.info("line 1444: validator: found NPE with " + fieldName);
                return false;
            }
        }
        if (fieldValue == null) {
            return "".equals(oldValue);
        }
        this.logger.debug("value matches initial: found " + oldValue + " versus " + fieldValue);
        return fieldValue.equals(oldValue);
    }

    public void setErrorMessage(String message) {
        if (this.lastField == null) {
            return;
        }
        ArrayList fieldValidations = (ArrayList)this.validations.get(this.lastField);
        if (fieldValidations == null) {
            return;
        }
        int lastInd = fieldValidations.size() - 1;
        Validation v = (Validation)fieldValidations.get(lastInd);
        if (v == null) {
            return;
        }
        v.setErrorMessage(message);
        fieldValidations.set(lastInd, v);
        this.validations.put(this.lastField, fieldValidations);
    }

    public static Validation processCRFValidationFunction(String inputFunction) throws Exception {
        ResourceBundle resexception = ResourceBundleProvider.getExceptionsBundle();
        Validation v = null;
        if (inputFunction.equals("func: barcode(EAN-13)")) {
            v = new Validation(36);
            return v;
        }
        HashMap<String, Integer> numArgsByFunction = new HashMap<String, Integer>();
        numArgsByFunction.put("range", new Integer(2));
        numArgsByFunction.put("gt", new Integer(1));
        numArgsByFunction.put("lt", new Integer(1));
        numArgsByFunction.put("gte", new Integer(1));
        numArgsByFunction.put("lte", new Integer(1));
        numArgsByFunction.put("ne", new Integer(1));
        numArgsByFunction.put("eq", new Integer(1));
        numArgsByFunction.put("getExternalValue", new Integer(3));
        HashMap<String, Integer> valTypeByFunction = new HashMap<String, Integer>();
        valTypeByFunction.put("range", new Integer(3));
        valTypeByFunction.put("gt", new Integer(18));
        valTypeByFunction.put("lt", new Integer(18));
        valTypeByFunction.put("gte", new Integer(18));
        valTypeByFunction.put("lte", new Integer(18));
        valTypeByFunction.put("ne", new Integer(18));
        valTypeByFunction.put("eq", new Integer(18));
        HashMap<String, NumericComparisonOperator> compareOpByFunction = new HashMap<String, NumericComparisonOperator>();
        compareOpByFunction.put("gt", NumericComparisonOperator.GREATER_THAN);
        compareOpByFunction.put("lt", NumericComparisonOperator.LESS_THAN);
        compareOpByFunction.put("gte", NumericComparisonOperator.GREATER_THAN_OR_EQUAL_TO);
        compareOpByFunction.put("lte", NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO);
        compareOpByFunction.put("ne", NumericComparisonOperator.NOT_EQUALS);
        compareOpByFunction.put("eq", NumericComparisonOperator.EQUALS);
        Pattern funcPattern = Pattern.compile("func:\\s*([A-Za-z]+)\\(([^,]*)?(,[^,]*)*\\)");
        Matcher funcMatcher = funcPattern.matcher(inputFunction);
        if (!funcMatcher.matches()) {
            throw new Exception(resexception.getString("syntax_incorrect"));
        }
        String fname = funcMatcher.group(1);
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 2; i <= funcMatcher.groupCount(); ++i) {
            String arg = funcMatcher.group(i);
            if (arg == null || arg.trim().isEmpty()) continue;
            if (i >= 3) {
                arg = arg.substring(1);
            }
            arg = arg.trim();
            args.add(arg);
        }
        if (!(fname.equalsIgnoreCase("range") || fname.equalsIgnoreCase("gt") || fname.equalsIgnoreCase("lt") || fname.equalsIgnoreCase("gte") || fname.equalsIgnoreCase("lte") || fname.equalsIgnoreCase("eq") || fname.equalsIgnoreCase("ne") || fname.equalsIgnoreCase("getexternalvalue"))) {
            throw new Exception(resexception.getString("validation_column_invalid_function"));
        }
        Integer numProperArgsInFunction = (Integer)numArgsByFunction.get(fname);
        if (args.size() != numProperArgsInFunction.intValue()) {
            throw new Exception(resexception.getString("validation_column_invalid_function") + ": " + resexception.getString("number_of_arguments_incorrect"));
        }
        for (int i = 0; i < args.size(); ++i) {
            int ord = i + 1;
            try {
                Float.parseFloat((String)args.get(i));
                continue;
            }
            catch (Exception e) {
                throw new Exception(resexception.getString("validation_column_invalid_function") + ": " + resexception.getString("argument") + ord + " " + resexception.getString("is_not_a_number"));
            }
        }
        Integer valType = (Integer)valTypeByFunction.get(fname);
        v = new Validation(valType.intValue());
        if (!fname.equalsIgnoreCase("range")) {
            NumericComparisonOperator operator = (NumericComparisonOperator)compareOpByFunction.get(fname);
            v.addArgument((Object)operator);
        }
        for (int i = 0; i < args.size(); ++i) {
            float f = Float.parseFloat((String)args.get(i));
            v.addArgument(f);
        }
        return v;
    }

    public static Validation processCRFValidationRegex(String inputRegex) throws Exception {
        ResourceBundle resexception = ResourceBundleProvider.getExceptionsBundle();
        Validation v = new Validation(27);
        String finalRegexp = inputRegex.substring(7).trim();
        if ((finalRegexp = finalRegexp.substring(1, finalRegexp.length() - 1)) == null || finalRegexp.trim().isEmpty()) {
            throw new Exception(resexception.getString("regular_expression_is_blank"));
        }
        v.addArgument((Object)finalRegexp);
        return v;
    }

    public void removeFieldValidations(String fieldName) {
        if (this.validations.containsKey(fieldName)) {
            this.validations.remove(fieldName);
        }
    }

    public static StringBuffer validateWidthDecimalSetting(String widthDecimal, String dataType, boolean isCalculationItem, Locale locale) {
        StringBuffer message = new StringBuffer();
        ResourceBundle resException = ResourceBundleProvider.getExceptionsBundle((Locale)locale);
        if (Validator.validWidthDecimalPattern((String)widthDecimal, (boolean)isCalculationItem)) {
            int width = Validator.parseWidth((String)widthDecimal);
            int decimal = Validator.parseDecimal((String)widthDecimal);
            if (width > 0) {
                if ("ST".equalsIgnoreCase(dataType)) {
                    if (width > 4000) {
                        message.append(" " + dataType + " " + resException.getString("datatype_maximum_width_is") + " " + 4000 + ".");
                    }
                } else if ("INT".equalsIgnoreCase(dataType)) {
                    if (width > 10) {
                        message.append(" " + dataType + " " + resException.getString("datatype_maximum_width_is") + " " + 10 + ".");
                    }
                } else if ("REAL".equalsIgnoreCase(dataType) && width > 26) {
                    message.append(" " + dataType + " " + resException.getString("datatype_maximum_width_is") + " " + 26 + ".");
                }
            }
            if (decimal > 0) {
                if ("ST".equalsIgnoreCase(dataType)) {
                    message.append(" " + dataType + " " + resException.getString("datatype_decimal_cannot_bigger_than_0"));
                } else if ("INT".equalsIgnoreCase(dataType)) {
                    message.append(" " + dataType + " " + resException.getString("datatype_decimal_cannot_bigger_than_0"));
                } else if ("REAL".equalsIgnoreCase(dataType)) {
                    if (width > 0 && decimal >= width) {
                        message.append(" " + resException.getString("decimal_cannot_larger_than_width"));
                    }
                    if (decimal > 30) {
                        message.append(" " + resException.getString("decimal_cannot_larger_than_30"));
                    }
                }
            }
        } else {
            String s = "";
            s = isCalculationItem ? resException.getString("calculation_correct_width_decimal_pattern") : resException.getString("correct_width_decimal_pattern");
            message.append(s);
        }
        return message;
    }

    public static boolean validWidthDecimalPattern(String widthDecimal, boolean isCalculationItem) {
        String pattern = "";
        pattern = isCalculationItem ? "((w[(](d|(\\d)+)[)])|([(](d|(\\d)+)[)]))" : "((w|(\\d)+)[(](d|(\\d)+)[)])|(w|(\\d)+)|([(](d|(\\d)+)[)])";
        return Pattern.matches(pattern, widthDecimal = widthDecimal.trim());
    }

    public static int parseWidth(String widthDecimal) {
        String w = "";
        if (!(widthDecimal = widthDecimal.trim()).startsWith("(")) {
            w = widthDecimal.contains("(") ? widthDecimal.split("\\(")[0] : widthDecimal;
        }
        if (w.length() > 0) {
            return "w".equalsIgnoreCase(w) ? 0 : Integer.parseInt(w);
        }
        return 0;
    }

    public static int parseDecimal(String widthDecimal) {
        String d = "";
        if ((widthDecimal = widthDecimal.trim()).startsWith("(")) {
            d = widthDecimal.substring(1, widthDecimal.length() - 1);
        } else if (widthDecimal.contains("(")) {
            d = widthDecimal.split("\\(")[1].trim();
            d = d.substring(0, d.length() - 1);
        }
        if (d.length() > 0) {
            return "d".equalsIgnoreCase(d) ? 0 : Integer.parseInt(d);
        }
        return 0;
    }

    protected StringBuffer validateFieldWidthDecimal(String fieldName, String dataType, String widthDecimal) {
        this.logger.debug("find locale=" + this.resexception.getLocale());
        StringBuffer message = new StringBuffer();
        String fieldValue = this.getFieldValue(fieldName);
        if (fieldValue == null || fieldValue.trim().isEmpty()) {
            return message;
        }
        int width = Validator.parseWidth((String)widthDecimal);
        int decimal = Validator.parseDecimal((String)widthDecimal);
        if (width > 0) {
            if ("ST".equalsIgnoreCase(dataType)) {
                if (fieldValue.length() > width) {
                    message.append(this.resexception.getString("exceeds_width") + "=" + width + ".");
                }
            } else if ("INT".equalsIgnoreCase(dataType)) {
                if (fieldValue.length() > width) {
                    message.append(this.resexception.getString("exceeds_width") + "=" + width + ".");
                }
            } else if ("REAL".equalsIgnoreCase(dataType) && fieldValue.length() > width) {
                message.append(this.resexception.getString("exceeds_width") + "=" + width + ".");
            }
        }
        if (decimal > 0 && "REAL".equalsIgnoreCase(dataType)) {
            try {
                String temp = "";
                if (fieldValue.indexOf("-") != 0) {
                    fieldValue.replaceAll("-", "");
                }
                temp = "10" + fieldValue;
                Double d = NumberFormat.getInstance().parse(temp).doubleValue();
                if (d > 0.0 && BigDecimal.valueOf(d).scale() > decimal) {
                    message.append(this.resexception.getString("exceeds_decimal") + "=" + decimal + ".");
                }
            }
            catch (ParseException pe) {
                message.append(this.resexception.getString("should_be_real_number"));
            }
        }
        return message;
    }
}

