/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.Date;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.login.PwdChallengeQuestion;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class RequestPasswordServlet
extends SecureController {
    private static final long serialVersionUID = -6525408217441592170L;

    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        this.session.setAttribute("challengeQuestions", (Object)PwdChallengeQuestion.toArrayList());
        if (action == null || action.trim().isEmpty()) {
            this.request.setAttribute("userBean1", (Object)new UserAccountBean());
            this.forwardPage(Page.REQUEST_PWD);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmPassword();
        } else {
            this.request.setAttribute("userBean1", (Object)new UserAccountBean());
            this.forwardPage(Page.REQUEST_PWD);
        }
    }

    private void confirmPassword() throws Exception {
        UserAccountBean ubDB;
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("email", 6);
        v.addValidation("passwdChallengeQuestion", 1);
        v.addValidation("passwdChallengeAnswer", 1);
        this.errors = v.validate();
        UserAccountBean ubForm = new UserAccountBean();
        ubForm.setName(fp.getString("name"));
        ubForm.setEmail(fp.getString("email"));
        ubForm.setPasswdChallengeQuestion(fp.getString("passwdChallengeQuestion"));
        ubForm.setPasswdChallengeAnswer(fp.getString("passwdChallengeAnswer"));
        this.sm = new SessionManager(null, ubForm.getName(), SpringServletAccess.getApplicationContext((ServletContext)this.context));
        UserAccountDAO uDAO = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean updater = ubDB = uDAO.findByUserName(ubForm.getName());
        this.request.setAttribute("userBean1", (Object)ubForm);
        if (!this.errors.isEmpty()) {
            logger.info("after processing form,has errors");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.REQUEST_PWD);
        } else {
            logger.info("after processing form,no errors");
            if (ubDB.getEmail() != null && ubDB.getEmail().equalsIgnoreCase(ubForm.getEmail())) {
                logger.info("ubDB.getPasswdChallengeQuestion()" + ubDB.getPasswdChallengeQuestion());
                logger.info("ubForm.getPasswdChallengeQuestion()" + ubForm.getPasswdChallengeQuestion());
                logger.info("ubDB.getPasswdChallengeAnswer()" + ubDB.getPasswdChallengeAnswer());
                logger.info("ubForm.getPasswdChallengeAnswer()" + ubForm.getPasswdChallengeAnswer());
                if (ubDB.getPasswdChallengeQuestion().equals(ubForm.getPasswdChallengeQuestion()) && ubDB.getPasswdChallengeAnswer().equalsIgnoreCase(ubForm.getPasswdChallengeAnswer())) {
                    SecurityManager sm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
                    String newPass = sm.genPassword();
                    String newDigestPass = sm.encryptPassword(newPass, ubDB.getRunWebservices().booleanValue());
                    ubDB.setPasswd(newDigestPass);
                    ubDB.setPasswdTimestamp(null);
                    ubDB.setUpdater(updater);
                    ubDB.setLastVisitDate(new Date());
                    logger.info("user bean to be updated:" + ubDB.getId() + ubDB.getName() + ubDB.getActiveStudyId());
                    uDAO.update(ubDB);
                    this.sendPassword(newPass, ubDB);
                } else {
                    this.addPageMessage(respage.getString("your_password_not_verified_try_again"));
                    this.forwardPage(Page.REQUEST_PWD);
                }
            } else {
                this.addPageMessage(respage.getString("your_email_address_not_found_try_again"));
                this.forwardPage(Page.REQUEST_PWD);
            }
        }
    }

    private void sendPassword(String passwd, UserAccountBean ubDB) throws Exception {
        logger.info("Sending email...");
        String emailBody = "Hello, " + ubDB.getFirstName() + ", <br>" + restext.getString("this_email_is_from_openclinica_admin") + "<br>" + restext.getString("your_password_has_been_reset_as") + ": " + passwd + "<br> " + restext.getString("you_will_be_required_to_change") + " " + restext.getString("time_you_login_to_the_system") + " " + restext.getString("use_the_following_link_to_log") + ":<br> " + SQLInitServlet.getField((String)"sysURL");
        this.sendEmail(ubDB.getEmail().trim(), EmailEngine.getAdminEmail(), restext.getString("your_openclinica_password"), emailBody, Boolean.valueOf(true), respage.getString("your_password_reset_new_password_emailed"), respage.getString("your_password_not_send_due_mail_server_problem"), Boolean.valueOf(true));
        this.session.removeAttribute("challengeQuestions");
        this.forwardPage(Page.LOGIN);
    }
}

