/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudySubjectBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ViewStudySubjectServlet;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.bean.DisplayStudySubjectRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public abstract class ListStudySubjectServlet
extends SecureController {
    private static final long serialVersionUID = 6119891528224678112L;
    Locale locale;
    public static String SUBJECT_PAGE_NUMBER = "ebl_page";
    public static String PAGINATING_QUERY = "paginatingQuery";
    public static String FILTER_KEYWORD = "ebl_filterKeyword";
    public static String SEARCH_SUBMITTED = "submitted";

    public void processRequest() throws Exception {
        int i;
        StudyGroupClassBean sgc;
        boolean searchSubmitted;
        FormProcessor fp = new FormProcessor(this.request);
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        this.request.setAttribute("closeInfoShowIcons", (Object)true);
        String pageNumber = fp.getString(SUBJECT_PAGE_NUMBER);
        StringBuilder paginatingQuery = new StringBuilder("");
        String filterKeyword = fp.getString(FILTER_KEYWORD);
        String tmpSearch = fp.getString(SEARCH_SUBMITTED);
        boolean bl = searchSubmitted = tmpSearch != null && !"".equalsIgnoreCase(tmpSearch) && !"".equalsIgnoreCase(filterKeyword) && !"+".equalsIgnoreCase(filterKeyword);
        if (pageNumber != null && !"".equalsIgnoreCase(pageNumber)) {
            int tempNum = 0;
            try {
                tempNum = Integer.parseInt(pageNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (tempNum > 0) {
                paginatingQuery = new StringBuilder(SUBJECT_PAGE_NUMBER).append("=").append(pageNumber);
                paginatingQuery.append("&ebl_paginated=1");
            }
        }
        String filterKeywordURLEncode = URLEncoder.encode(filterKeyword, "UTF-8");
        if (searchSubmitted) {
            paginatingQuery.append("&ebl_sortColumnInd=0&submitted=1&ebl_sortAscending=1&ebl_filtered=1");
            paginatingQuery.append("&").append(FILTER_KEYWORD).append("=").append(filterKeywordURLEncode);
        }
        this.request.setAttribute(PAGINATING_QUERY, (Object)paginatingQuery.toString());
        StudyDAO stdao = new StudyDAO(this.sm.getDataSource());
        StudySubjectDAO sdao = new StudySubjectDAO(this.sm.getDataSource());
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
        int parentStudyId = this.currentStudy.getParentStudyId();
        ArrayList studyGroupClasses = new ArrayList();
        ArrayList allDefs = new ArrayList();
        if (parentStudyId > 0) {
            StudyBean parentStudy = stdao.findByPK(parentStudyId);
            studyGroupClasses = sgcdao.findAllActiveByStudy(parentStudy);
            allDefs = seddao.findAllActiveByStudy(parentStudy);
        } else {
            parentStudyId = this.currentStudy.getId();
            studyGroupClasses = sgcdao.findAllActiveByStudy(this.currentStudy);
            allDefs = seddao.findAllActiveByStudy(this.currentStudy);
        }
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        StudyParameterValueBean parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "collectDob");
        this.currentStudy.getStudyParameterConfig().setCollectDob(parentSPV.getValue());
        parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "genderRequired");
        this.currentStudy.getStudyParameterConfig().setGenderRequired(parentSPV.getValue());
        parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "subjectPersonIdRequired");
        this.currentStudy.getStudyParameterConfig().setSubjectPersonIdRequired(parentSPV.getValue());
        parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "subjectIdGeneration");
        this.currentStudy.getStudyParameterConfig().setSubjectIdGeneration(parentSPV.getValue());
        parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "subjectIdPrefixSuffix");
        this.currentStudy.getStudyParameterConfig().setSubjectIdPrefixSuffix(parentSPV.getValue());
        for (StudyGroupClassBean sgc2 : studyGroupClasses) {
            ArrayList groups = sgdao.findAllByGroupClass(sgc2);
            sgc2.setStudyGroups(groups);
        }
        this.request.setAttribute("studyGroupClasses", (Object)studyGroupClasses);
        this.session.setAttribute("allDefsArray", (Object)allDefs);
        this.session.setAttribute("allDefsNumber", (Object)new Integer(allDefs.size()));
        this.session.setAttribute("groupSize", (Object)new Integer(studyGroupClasses.size()));
        ArrayList subjects = sdao.findAllByStudyId(this.currentStudy.getId());
        ArrayList<DisplayStudySubjectBean> displayStudySubs = new ArrayList<DisplayStudySubjectBean>();
        for (int i2 = 0; i2 < subjects.size(); ++i2) {
            StudySubjectBean studySub = (StudySubjectBean)subjects.get(i2);
            ArrayList groups = sgmdao.findAllByStudySubject(studySub.getId());
            ArrayList<SubjectGroupMapBean> subGClasses = new ArrayList<SubjectGroupMapBean>();
            for (int j = 0; j < studyGroupClasses.size(); ++j) {
                sgc = (StudyGroupClassBean)studyGroupClasses.get(j);
                boolean hasClass = false;
                for (SubjectGroupMapBean sgmb : groups) {
                    if (!sgmb.getGroupClassName().equalsIgnoreCase(sgc.getName())) continue;
                    subGClasses.add(sgmb);
                    hasClass = true;
                    break;
                }
                if (hasClass) continue;
                subGClasses.add(new SubjectGroupMapBean());
            }
            ArrayList subEvents = new ArrayList();
            ArrayList events = sedao.findAllByStudySubject(studySub);
            for (StudyEventDefinitionBean sed : allDefs) {
                boolean hasDef = false;
                for (int k = 0; k < events.size(); ++k) {
                    StudyEventBean se = (StudyEventBean)events.get(k);
                    if (se.getStudyEventDefinitionId() != sed.getId()) continue;
                    se.setStudyEventDefinition(sed);
                    subEvents.add(se);
                    hasDef = true;
                }
                if (hasDef) continue;
                StudyEventBean blank = new StudyEventBean();
                blank.setSubjectEventStatus(SubjectEventStatus.NOT_SCHEDULED);
                blank.setStudyEventDefinitionId(sed.getId());
                blank.setStudyEventDefinition(sed);
                subEvents.add(blank);
            }
            int prevDefId = 0;
            int currDefId = 0;
            ArrayList<StudyEventBean> finalEvents = new ArrayList<StudyEventBean>();
            int repeatingNum = 1;
            StudyEventBean event = new StudyEventBean();
            for (int j = 0; j < subEvents.size(); ++j) {
                StudyEventBean se = (StudyEventBean)subEvents.get(j);
                currDefId = se.getStudyEventDefinitionId();
                if (currDefId != prevDefId) {
                    if (repeatingNum > 1) {
                        event.setRepeatingNum(repeatingNum);
                        repeatingNum = 1;
                    }
                    finalEvents.add(se);
                    event = se;
                } else {
                    ++repeatingNum;
                    event.getRepeatEvents().add(se);
                    if (j == subEvents.size() - 1) {
                        event.setRepeatingNum(repeatingNum);
                        repeatingNum = 1;
                    }
                }
                prevDefId = currDefId;
            }
            DisplayStudySubjectBean dssb = new DisplayStudySubjectBean();
            dssb.setStudyEvents(finalEvents);
            dssb.setStudySubject(studySub);
            dssb.setStudyGroups(subGClasses);
            displayStudySubs.add(dssb);
        }
        boolean isRequiredUncomplete = false;
        block9: for (DisplayStudySubjectBean subject : displayStudySubs) {
            ArrayList studyEvents = ClassCastHelper.asArrayList((Object)subject.getStudyEvents(), StudyEventBean.class);
            for (StudyEventBean event : studyEvents) {
                if (event.getSubjectEventStatus() != null && event.getSubjectEventStatus().getId() == 3) {
                    subject.setStudySignable(false);
                    continue block9;
                }
                isRequiredUncomplete = this.eventHasRequiredUncompleteCRFs(event);
                if (!isRequiredUncomplete) continue;
                subject.setStudySignable(false);
                continue block9;
            }
        }
        fp = new FormProcessor(this.request);
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allStudyRows = DisplayStudySubjectRow.generateRowsFromBeans(displayStudySubs);
        ArrayList<String> columnArray = new ArrayList<String>();
        columnArray.add(resword.getString("study_subject_ID"));
        columnArray.add(resword.getString("subject_status"));
        columnArray.add(resword.getString("OID"));
        columnArray.add(resword.getString("gender"));
        columnArray.add(resword.getString("secondary_ID"));
        for (i = 0; i < studyGroupClasses.size(); ++i) {
            sgc = (StudyGroupClassBean)studyGroupClasses.get(i);
            columnArray.add(sgc.getName());
        }
        for (i = 0; i < allDefs.size(); ++i) {
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)allDefs.get(i);
            columnArray.add(sed.getName());
        }
        columnArray.add(resword.getString("actions"));
        String[] columns = new String[columnArray.size()];
        columnArray.toArray(columns);
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.setQuery(this.getBaseURL(), new HashMap());
        table.hideColumnLink(columnArray.size() - 1);
        table.setRows(allStudyRows);
        if (filterKeyword != null && !"".equalsIgnoreCase(filterKeyword)) {
            table.setKeywordFilter(filterKeyword);
        }
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        String idSetting = this.currentStudy.getStudyParameterConfig().getSubjectIdGeneration();
        if (idSetting.equals("auto editable") || idSetting.equals("auto non-editable")) {
            this.request.setAttribute("label", (Object)resword.getString("id_generated_Save_Add"));
        }
        FormDiscrepancyNotes discNotes = new FormDiscrepancyNotes();
        this.session.setAttribute("fdnotes", (Object)discNotes);
        this.forwardPage(this.getJSP());
    }

    protected abstract String getBaseURL();

    protected abstract Page getJSP();

    private boolean eventHasRequiredUncompleteCRFs(StudyEventBean studyEvent) {
        if (studyEvent == null) {
            return false;
        }
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO eventDefinitionDAO = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList crfBeans = new ArrayList();
        crfBeans.addAll(eventCRFDAO.findAllByStudyEvent(studyEvent));
        for (EventCRFBean crfBean : crfBeans) {
            if (crfBean == null || crfBean.getCompletionStatusId() != 0 || !eventDefinitionDAO.isRequiredInDefinition(crfBean.getCRFVersionId(), studyEvent)) continue;
            return true;
        }
        return false;
    }

    public static DisplayStudyEventBean getDisplayStudyEventsForStudySubject(StudySubjectBean studySub, StudyEventBean event, DataSource ds, UserAccountBean ub, StudyUserRoleBean currentRole, StudyBean study) {
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(ds);
        EventCRFDAO ecdao = new EventCRFDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        StudyEventDefinitionBean sed = seddao.findByPK(event.getStudyEventDefinitionId());
        event.setStudyEventDefinition(sed);
        ArrayList eventDefinitionCRFs = edcdao.findAllActiveByEventDefinitionId(sed.getId());
        ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
        DisplayStudyEventBean de = new DisplayStudyEventBean();
        de.setStudyEvent(event);
        de.setDisplayEventCRFs(ViewStudySubjectServlet.getDisplayEventCRFs((DataSource)ds, (ArrayList)eventCRFs, (ArrayList)eventDefinitionCRFs, (UserAccountBean)ub, (StudyUserRoleBean)currentRole, (SubjectEventStatus)event.getSubjectEventStatus(), (StudyBean)study));
        ArrayList al = ViewStudySubjectServlet.getUncompletedCRFs((DataSource)ds, (ArrayList)eventDefinitionCRFs, (ArrayList)eventCRFs, (SubjectEventStatus)event.getSubjectEventStatus());
        de.setUncompletedCRFs(al);
        return de;
    }
}

