/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.StudyUserRoleRow;

public class ListStudyUserServlet
extends SecureController {
    private static final long serialVersionUID = -2575908192455735571L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList users = udao.findAllAssignedUsersByStudy(this.currentStudy.getId());
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allStudyUserRows = StudyUserRoleRow.generateRowsFromBeans((ArrayList)users);
        String[] columns = new String[]{resword.getString("user_name"), resword.getString("first_name"), resword.getString("last_name"), resword.getString("role"), resword.getString("study_name"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(6);
        table.setQuery("ListStudyUser", new HashMap());
        table.addLink(restext.getString("assign_new_user_to_current_study"), "AssignUserToStudy");
        table.setRows(allStudyUserRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.request.setAttribute("siteRoleMap", (Object)Role.siteRoleMap);
        this.request.setAttribute("studyRoleMap", (Object)Role.studyRoleMap);
        this.request.setAttribute("study", (Object)this.currentStudy);
        this.forwardPage(Page.LIST_USER_IN_STUDY);
    }
}

