/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.AuditEventBean;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.admin.StudyEventAuditBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DisplayEventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.admin.AuditEventDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DisplayStudyEventRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignStudySubjectServlet
extends SecureController {
    private static final long serialVersionUID = -4280235447806067251L;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        this.mayAccess();
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public static ArrayList<DisplayStudyEventBean> getDisplayStudyEventsForStudySubject(StudyBean study, StudySubjectBean studySub, DataSource ds, UserAccountBean ub, StudyUserRoleBean currentRole) {
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(ds);
        StudyEventDAO sedao = new StudyEventDAO(ds);
        EventCRFDAO ecdao = new EventCRFDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        StudySubjectDAO ssdao = new StudySubjectDAO(ds);
        ArrayList events = sedao.findAllByStudySubject(studySub);
        ArrayList<DisplayStudyEventBean> displayEvents = new ArrayList<DisplayStudyEventBean>();
        for (int i = 0; i < events.size(); ++i) {
            StudyEventBean event = (StudyEventBean)events.get(i);
            StudyEventDefinitionBean sed = seddao.findByPK(event.getStudyEventDefinitionId());
            event.setStudyEventDefinition(sed);
            ArrayList eventDefinitionCRFs = edcdao.findAllActiveByEventDefinitionId(study, sed.getId());
            ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
            DisplayStudyEventBean de = new DisplayStudyEventBean();
            de.setStudyEvent(event);
            de.setDisplayEventCRFs(SignStudySubjectServlet.getDisplayEventCRFs((StudyBean)study, (DataSource)ds, (ArrayList)eventCRFs, (UserAccountBean)ub, (StudyUserRoleBean)currentRole, (SubjectEventStatus)event.getSubjectEventStatus()));
            ArrayList al = SignStudySubjectServlet.getUncompletedCRFs((DataSource)ds, (ArrayList)eventDefinitionCRFs, (ArrayList)eventCRFs, (SubjectEventStatus)event.getSubjectEventStatus());
            SignStudySubjectServlet.populateUncompletedCRFsWithCRFAndVersions((DataSource)ds, (ArrayList)al);
            de.setUncompletedCRFs(al);
            StudySubjectBean studySubject = ssdao.findByPK(event.getStudySubjectId());
            de.setMaximumSampleOrdinal(sedao.getMaxSampleOrdinal(sed, studySubject));
            displayEvents.add(de);
        }
        return displayEvents;
    }

    public static boolean permitSign(StudySubjectBean studySub, DataSource ds) {
        boolean sign = true;
        StudyEventDAO sedao = new StudyEventDAO(ds);
        EventCRFDAO ecdao = new EventCRFDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        StudyDAO sdao = new StudyDAO(ds);
        StudyBean studyBean = sdao.findByPK(studySub.getStudyId());
        ArrayList studyEvents = sedao.findAllByStudySubject(studySub);
        block0: for (int l = 0; l < studyEvents.size(); ++l) {
            StudyEventBean studyEvent = (StudyEventBean)studyEvents.get(l);
            ArrayList eventCrfs = ecdao.findAllByStudyEvent(studyEvent);
            for (int i = 0; i < eventCrfs.size(); ++i) {
                EventCRFBean ecrf = (EventCRFBean)eventCrfs.get(i);
                EventDefinitionCRFBean edcBean = edcdao.findByStudyEventIdAndCRFVersionId(studyBean, studyEvent.getId(), ecrf.getCRFVersionId());
                if (!ecrf.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && (!ecrf.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || !edcBean.isDoubleEntry())) continue;
                sign = false;
                continue block0;
            }
        }
        return sign;
    }

    public static boolean signSubjectEvents(StudySubjectBean studySub, DataSource ds, UserAccountBean ub) {
        boolean updated = true;
        StudyEventDAO sedao = new StudyEventDAO(ds);
        ArrayList studyEvents = sedao.findAllByStudySubject(studySub);
        for (int l = 0; l < studyEvents.size(); ++l) {
            try {
                StudyEventBean studyEvent = (StudyEventBean)studyEvents.get(l);
                studyEvent.setUpdater(ub);
                studyEvent.setUpdatedDate(new Date());
                studyEvent.setSubjectEventStatus(SubjectEventStatus.SIGNED);
                sedao.update(studyEvent);
                continue;
            }
            catch (Exception ex) {
                updated = false;
            }
        }
        return updated;
    }

    public void processRequest() throws Exception {
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String action = fp.getString("action");
        int studySubId = fp.getInt("id", true);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        if (studySubId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_view"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
            return;
        }
        StudySubjectBean studySub = subdao.findByPK(studySubId);
        if (!SignStudySubjectServlet.permitSign((StudySubjectBean)studySub, (DataSource)this.sm.getDataSource())) {
            this.addPageMessage(respage.getString("subject_event_cannot_signed"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
            return;
        }
        if (action.equalsIgnoreCase("confirm")) {
            String username = this.request.getParameter("j_user");
            String password = this.request.getParameter("j_pass");
            SecurityManager securityManager = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
            UserAccountBean ub = (UserAccountBean)this.session.getAttribute("userBean");
            if (securityManager.verifyPassword(password, this.getUserDetails()) && ub.getName().equals(username)) {
                if (SignStudySubjectServlet.signSubjectEvents((StudySubjectBean)studySub, (DataSource)this.sm.getDataSource(), (UserAccountBean)ub)) {
                    studySub.setStatus(Status.SIGNED);
                    studySub.setUpdater(ub);
                    subdao.update(studySub);
                    this.addPageMessage(respage.getString("subject_event_signed"));
                    this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
                    return;
                }
                this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                this.forwardPage(Page.LIST_STUDY_SUBJECTS);
                return;
            }
            this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
            this.addPageMessage(restext.getString("password_match"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
            return;
        }
        this.request.setAttribute("studySub", (Object)studySub);
        int studyId = studySub.getStudyId();
        int subjectId = studySub.getSubjectId();
        SubjectBean subject = sdao.findByPK(subjectId);
        if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
            Date dob = subject.getDateOfBirth();
            if (dob != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(dob);
                int year = cal.get(1);
                this.request.setAttribute("yearOfBirth", (Object)new Integer(year));
            } else {
                this.request.setAttribute("yearOfBirth", (Object)"");
            }
        }
        this.request.setAttribute("subject", (Object)subject);
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = studydao.findByPK(studyId);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        study.getStudyParameterConfig().setCollectDob(spvdao.findByHandleAndStudy(studyId, "collectDob").getValue());
        if (study.getParentStudyId() > 0) {
            StudyBean parentStudy = studydao.findByPK(study.getParentStudyId());
            this.request.setAttribute("parentStudy", (Object)parentStudy);
        } else {
            this.request.setAttribute("parentStudy", (Object)new StudyBean());
        }
        ArrayList children = sdao.findAllChildrenByPK(subjectId);
        this.request.setAttribute("children", (Object)children);
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        ArrayList displayEvents = SignStudySubjectServlet.getDisplayStudyEventsForStudySubject((StudyBean)study, (StudySubjectBean)studySub, (DataSource)this.sm.getDataSource(), (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole);
        DiscrepancyNoteUtil discNoteUtil = new DiscrepancyNoteUtil();
        discNoteUtil.injectParentDiscNotesIntoDisplayStudyEvents((List)displayEvents, new HashSet(), this.sm.getDataSource(), 0);
        this.request.setAttribute("displayStudyEvents", (Object)displayEvents);
        Map discNoteByEventCRFid = discNoteUtil.createDiscNoteMapByEventCRF((List)displayEvents);
        this.request.setAttribute("discNoteByEventCRFid", (Object)discNoteByEventCRFid);
        EntityBeanTable table = fp.getEntityBeanTable();
        table.setSortingIfNotExplicitlySet(1, false);
        ArrayList allEventRows = DisplayStudyEventRow.generateRowsFromBeans((List)displayEvents);
        String[] columns = new String[]{resword.getString("event") + " (" + resword.getString("occurrence_number") + ")", resword.getString("start_date1"), resword.getString("location"), resword.getString("status"), resword.getString("actions"), resword.getString("CRFs_atrib")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(4);
        table.hideColumnLink(5);
        if (!"removed".equalsIgnoreCase(studySub.getStatus().getName()) && !"auto-removed".equalsIgnoreCase(studySub.getStatus().getName())) {
            table.addLink(resword.getString("add_new_event"), "CreateNewStudyEvent?studySubjectId=" + studySub.getId());
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("id", new Integer(studySubId).toString());
        table.setQuery("ViewStudySubject", args);
        table.setRows(allEventRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
        ArrayList groupMaps = sgmdao.findAllByStudySubject(studySubId);
        this.request.setAttribute("groups", (Object)groupMaps);
        AuditEventDAO aedao = new AuditEventDAO(this.sm.getDataSource());
        ArrayList logs = aedao.findEventStatusLogByStudySubject(studySubId);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList<StudyEventAuditBean> eventLogs = new ArrayList<StudyEventAuditBean>();
        for (int i = 0; i < logs.size(); ++i) {
            AuditEventBean avb = (AuditEventBean)logs.get(i);
            StudyEventAuditBean sea = new StudyEventAuditBean();
            sea.setAuditEvent(avb);
            StudyEventBean se = sedao.findByPK(avb.getEntityId());
            StudyEventDefinitionBean sed = seddao.findByPK(se.getStudyEventDefinitionId());
            sea.setDefinition(sed);
            String old = avb.getOldValue().trim();
            try {
                String newValue;
                if (old != null && !old.trim().isEmpty()) {
                    SubjectEventStatus oldStatus = SubjectEventStatus.get((int)new Integer(old));
                    sea.setOldSubjectEventStatus(oldStatus);
                }
                if ((newValue = avb.getNewValue().trim()) != null && !newValue.trim().isEmpty()) {
                    SubjectEventStatus newStatus = SubjectEventStatus.get((int)new Integer(newValue));
                    sea.setNewSubjectEventStatus(newStatus);
                }
            }
            catch (NumberFormatException e) {
                logger.error("Subject event status is not able to be fetched properly: ", (Throwable)e);
            }
            UserAccountBean updater = udao.findByPK(avb.getUserId());
            sea.setUpdater(updater);
            eventLogs.add(sea);
        }
        this.request.setAttribute("eventLogs", eventLogs);
        this.forwardPage(Page.SIGN_STUDY_SUBJECT);
    }

    public static ArrayList<DisplayEventCRFBean> getDisplayEventCRFs(StudyBean study, DataSource ds, ArrayList<EventCRFBean> eventCRFs, UserAccountBean ub, StudyUserRoleBean currentRole, SubjectEventStatus status) {
        ArrayList<DisplayEventCRFBean> answer = new ArrayList<DisplayEventCRFBean>();
        StudyEventDAO sedao = new StudyEventDAO(ds);
        CRFDAO cdao = new CRFDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemDataDAO iddao = new ItemDataDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        for (int i = 0; i < eventCRFs.size(); ++i) {
            EventCRFBean ecb = eventCRFs.get(i);
            int crfVersionId = ecb.getCRFVersionId();
            CRFBean cb = cdao.findByVersionId(crfVersionId);
            ecb.setCrf(cb);
            CRFVersionBean cvb = cvdao.findByPK(crfVersionId);
            ecb.setCrfVersion(cvb);
            int studyEventId = ecb.getStudyEventId();
            int studyEventDefinitionId = sedao.getDefinitionIdFromStudyEventId(studyEventId);
            EventDefinitionCRFBean edc = edcdao.findByStudyEventDefinitionIdAndCRFId(study, studyEventDefinitionId, cb.getId());
            if (status.equals((Term)SubjectEventStatus.LOCKED) || status.equals((Term)SubjectEventStatus.SKIPPED) || status.equals((Term)SubjectEventStatus.STOPPED)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (status.equals((Term)SubjectEventStatus.INVALID)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (!cb.getStatus().equals((Term)Status.AVAILABLE)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (!cvb.getStatus().equals((Term)Status.AVAILABLE)) {
                ecb.setStage(DataEntryStage.LOCKED);
            }
            if (edc == null) continue;
            DisplayEventCRFBean dec = new DisplayEventCRFBean();
            dec.setFlags(ecb, ub, currentRole, edc.isDoubleEntry());
            ArrayList idata = iddao.findAllByEventCRFId(ecb.getId());
            if (idata.isEmpty()) continue;
            answer.add(dec);
        }
        return answer;
    }

    public static ArrayList<DisplayEventDefinitionCRFBean> getUncompletedCRFs(DataSource ds, ArrayList<EventDefinitionCRFBean> eventDefinitionCRFs, ArrayList<EventCRFBean> eventCRFs, SubjectEventStatus status) {
        int i;
        HashMap<Integer, Boolean> completed = new HashMap<Integer, Boolean>();
        HashMap<Integer, EventCRFBean> startedButIncompleted = new HashMap<Integer, EventCRFBean>();
        ArrayList<DisplayEventDefinitionCRFBean> answer = new ArrayList<DisplayEventDefinitionCRFBean>();
        for (i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edcrf = eventDefinitionCRFs.get(i);
            completed.put(new Integer(edcrf.getCrfId()), Boolean.FALSE);
            startedButIncompleted.put(new Integer(edcrf.getCrfId()), new EventCRFBean());
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemDataDAO iddao = new ItemDataDAO(ds);
        for (i = 0; i < eventCRFs.size(); ++i) {
            EventCRFBean ecrf = eventCRFs.get(i);
            int crfId = cvdao.getCRFIdFromCRFVersionId(ecrf.getCRFVersionId());
            ArrayList idata = iddao.findAllByEventCRFId(ecrf.getId());
            if (!idata.isEmpty()) {
                completed.put(new Integer(crfId), Boolean.TRUE);
                continue;
            }
            startedButIncompleted.put(new Integer(crfId), ecrf);
        }
        for (i = 0; i < eventDefinitionCRFs.size(); ++i) {
            DisplayEventDefinitionCRFBean dedc = new DisplayEventDefinitionCRFBean();
            EventDefinitionCRFBean edcrf = eventDefinitionCRFs.get(i);
            dedc.setEdc(edcrf);
            if (status.equals((Term)SubjectEventStatus.LOCKED)) {
                dedc.setStatus(Status.LOCKED);
            }
            Boolean b = (Boolean)completed.get(new Integer(edcrf.getCrfId()));
            EventCRFBean ev = (EventCRFBean)startedButIncompleted.get(new Integer(edcrf.getCrfId()));
            if (b != null && b.booleanValue()) continue;
            dedc.setEventCRF(ev);
            answer.add(dedc);
        }
        return answer;
    }

    public static void populateUncompletedCRFsWithCRFAndVersions(DataSource ds, ArrayList<DisplayEventDefinitionCRFBean> uncompletedEventDefinitionCRFs) {
        CRFDAO cdao = new CRFDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        for (DisplayEventDefinitionCRFBean dedcrf : uncompletedEventDefinitionCRFs) {
            CRFBean cb = cdao.findByPK(dedcrf.getEdc().getCrfId());
            dedcrf.getEdc().setCrf(cb);
            ArrayList versions = cvdao.findAllActiveByCRF(dedcrf.getEdc().getCrfId());
            dedcrf.getEdc().setVersions(versions);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayAccess() throws InsufficientPermissionException {
        FormProcessor fp = new FormProcessor(this.request);
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        int studySubId = fp.getInt("id", true);
        if (studySubId > 0 && !this.entityIncluded(studySubId, this.ub.getName(), (AuditableEntityDAO)subdao, this.sm.getDataSource())) {
            this.addPageMessage(respage.getString("required_study_subject_not_belong"));
            throw new InsufficientPermissionException(Page.MENU, resexception.getString("entity_not_belong_studies"), "1");
        }
    }
}

