/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.Locale;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.managestudy.StudyAuditLogTableFactory;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class StudyAuditLogServlet
extends SecureController {
    private static final long serialVersionUID = 7756195048190348203L;
    Locale locale;

    public static String getLink(int userId) {
        return "AuditLogStudy";
    }

    protected void processRequest() throws Exception {
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        UserAccountDAO uadao = new UserAccountDAO(this.sm.getDataSource());
        StudyAuditLogTableFactory factory = new StudyAuditLogTableFactory();
        factory.setSubjectDao(sdao);
        factory.setStudySubjectDao(subdao);
        factory.setUserAccountDao(uadao);
        factory.setCurrentStudy(this.currentStudy);
        String auditLogsHtml = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("auditLogsHtml", (Object)auditLogsHtml);
        this.forwardPage(Page.AUDIT_LOGS_STUDY);
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }
}

