/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.DisplayEventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.managestudy.ViewStudySubjectServlet;
import org.akaza.openclinica.control.submit.AddNewSubjectServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class UpdateStudyEventServlet
extends SecureController {
    private static final long serialVersionUID = -6029524999558420563L;
    public static final String EVENT_ID = "event_id";
    public static final String STUDY_SUBJECT_ID = "ss_id";
    public static final String EVENT_BEAN = "studyEvent";
    public static final String EVENT_DEFINITION_BEAN = "eventDefinition";
    public static final String SUBJECT_EVENT_STATUS_ID = "statusId";
    public static final String INPUT_STARTDATE_PREFIX = "start";
    public static final String INPUT_ENDDATE_PREFIX = "end";
    public static final String INPUT_LOCATION = "location";
    public static final String HAS_LOCATION_NOTE = "hasLocationNote";
    public static final String HAS_START_DATE_NOTE = "hasStartDateNote";
    public static final String HAS_END_DATE_NOTE = "hasEndDateNote";
    public static final String STATUS_DN_LOCATION = "statusDnLocation";
    public static final String STATUS_DN_START_DATE = "statusDnStartDate";
    public static final String STATUS_DN_END_DATE = "statusDnEndDate";

    public void mayProceed() throws InsufficientPermissionException {
        if (SubmitDataServlet.maySubmitData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        Status s;
        FormDiscrepancyNotes discNotes = null;
        FormProcessor fp = new FormProcessor(this.request);
        int studyEventId = fp.getInt(EVENT_ID, true);
        int studySubjectId = fp.getInt(STUDY_SUBJECT_ID, true);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        String fromResolvingNotes = fp.getString("fromResolvingNotes", true);
        if (fromResolvingNotes == null || fromResolvingNotes.trim().isEmpty()) {
            this.session.removeAttribute("window_location");
            this.session.removeAttribute("notesTable");
            this.checkStudyLocked(Page.MANAGE_STUDY, respage.getString("current_study_locked"));
            this.checkStudyFrozen(Page.MANAGE_STUDY, respage.getString("current_study_frozen"));
        }
        if (studyEventId == 0 || studySubjectId == 0) {
            this.addPageMessage(respage.getString("choose_a_study_event_to_edit"));
            this.request.setAttribute("id", (Object)new Integer(studySubjectId).toString());
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            return;
        }
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        StudySubjectBean ssub = null;
        if (studySubjectId > 0) {
            ssub = ssdao.findByPK(studySubjectId);
            this.request.setAttribute("studySubject", (Object)ssub);
            this.request.setAttribute("id", (Object)(studySubjectId + ""));
        }
        if ("removed".equalsIgnoreCase((s = ssub.getStatus()).getName()) || "auto-removed".equalsIgnoreCase(s.getName())) {
            this.addPageMessage(resword.getString("study_event") + resterm.getString("could_not_be") + resterm.getString("updated") + "." + respage.getString("study_subject_has_been_deleted"));
            this.request.setAttribute("id", (Object)new Integer(studySubjectId).toString());
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
        }
        this.request.setAttribute(STUDY_SUBJECT_ID, (Object)new Integer(studySubjectId).toString());
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        EventCRFDAO ecrfdao = new EventCRFDAO(this.sm.getDataSource());
        StudyEventBean studyEvent = sedao.findByPK(studyEventId);
        studyEvent.setEventCRFs(ecrfdao.findAllByStudyEvent(studyEvent));
        ArrayList statuses = SubjectEventStatus.toArrayList();
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean studyBean = sdao.findByPK(ssub.getStudyId());
        this.checkRoleByUserAndStudy(this.ub, studyBean.getParentStudyId(), studyBean.getId());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        boolean removeSign = false;
        ArrayList eventCrfs = studyEvent.getEventCRFs();
        for (EventCRFBean ecrf : eventCrfs) {
            EventDefinitionCRFBean edcBean = edcdao.findByStudyEventIdAndCRFVersionId(studyBean, studyEventId, ecrf.getCRFVersionId());
            if (!ecrf.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && (!ecrf.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || !edcBean.isDoubleEntry())) continue;
            removeSign = true;
            break;
        }
        if (this.currentRole.isResearchAssistant()) {
            removeSign = true;
        }
        if (this.currentRole.isResearchAssistant2()) {
            removeSign = true;
        }
        if (removeSign || !this.currentRole.isInvestigator()) {
            statuses.remove(SubjectEventStatus.SIGNED);
        }
        if (!studyEvent.getSubjectEventStatus().equals((Term)SubjectEventStatus.NOT_SCHEDULED)) {
            statuses.remove(SubjectEventStatus.NOT_SCHEDULED);
        }
        if (!studyEvent.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED)) {
            statuses.remove(SubjectEventStatus.SCHEDULED);
        }
        if (studyEvent.getSubjectEventStatus().equals((Term)SubjectEventStatus.DATA_ENTRY_STARTED)) {
            statuses.remove(SubjectEventStatus.SKIPPED);
        }
        ArrayList getECRFs = studyEvent.getEventCRFs();
        EventDefinitionCRFDAO edefcrfdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList getAllECRFs = edefcrfdao.findAllByDefinition(studyBean, studyEvent.getStudyEventDefinitionId());
        logger.debug("found number of ecrfs: {}", (Object)getAllECRFs.size());
        for (EventDefinitionCRFBean ecrfBean : getAllECRFs) {
            logger.debug("found number of existing ecrfs: {}", (Object)getECRFs.size());
            if (getECRFs.isEmpty()) {
                statuses.remove(SubjectEventStatus.COMPLETED);
                statuses.remove(SubjectEventStatus.LOCKED);
            }
            for (EventCRFBean existingBean : getECRFs) {
                logger.debug("***** found: {} {} {} {} {}", new Object[]{existingBean.getCRFVersionId(), existingBean.getCrf().getId(), existingBean.getCrfVersion().getName(), existingBean.getStatus().getName(), existingBean.getStage().getName()});
                logger.debug("***** comparing above to ecrfBean.DefaultVersionID: {}", (Object)ecrfBean.getDefaultVersionId());
                if (existingBean.getStatus().equals((Term)Status.UNAVAILABLE) || !edefcrfdao.isRequiredInDefinition(existingBean.getCRFVersionId(), studyEvent)) continue;
                logger.debug("found that {} is required...", (Object)existingBean.getCrfVersion().getName());
                statuses.remove(SubjectEventStatus.COMPLETED);
                statuses.remove(SubjectEventStatus.LOCKED);
            }
        }
        if (!(this.ub.isSysAdmin() || this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR))) {
            statuses.remove(SubjectEventStatus.LOCKED);
        }
        if (studyEvent.getSubjectEventStatus().equals((Term)SubjectEventStatus.DATA_ENTRY_STARTED)) {
            statuses.remove(SubjectEventStatus.NOT_SCHEDULED);
            statuses.remove(SubjectEventStatus.SCHEDULED);
        }
        this.request.setAttribute("statuses", (Object)statuses);
        String action = fp.getString("action");
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sed = seddao.findByPK(studyEvent.getStudyEventDefinitionId());
        this.request.setAttribute(EVENT_DEFINITION_BEAN, (Object)sed);
        if (action.equalsIgnoreCase("submit")) {
            discNotes = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
            DiscrepancyValidator v = new DiscrepancyValidator(this.request, discNotes);
            SubjectEventStatus ses = SubjectEventStatus.get((int)fp.getInt(SUBJECT_EVENT_STATUS_ID));
            studyEvent.setSubjectEventStatus(ses);
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            ArrayList eventCRFs = ecdao.findAllByStudyEvent(studyEvent);
            if (ses.equals((Term)SubjectEventStatus.SKIPPED) || ses.equals((Term)SubjectEventStatus.STOPPED)) {
                studyEvent.setStatus(Status.UNAVAILABLE);
                for (EventCRFBean ecb : eventCRFs) {
                    ecb.setOldStatus(ecb.getStatus());
                    ecb.setStatus(Status.UNAVAILABLE);
                    ecb.setUpdater(this.ub);
                    ecb.setUpdatedDate(new Date());
                    ecdao.update(ecb);
                }
            } else {
                for (EventCRFBean ecb : eventCRFs) {
                    ecb.setUpdater(this.ub);
                    ecb.setUpdatedDate(new Date());
                    ecdao.update(ecb);
                }
            }
            String strEnd = fp.getDateTimeInputString(INPUT_ENDDATE_PREFIX);
            String strEndScheduled = fp.getDateTimeInputString(INPUT_ENDDATE_PREFIX);
            Date start = fp.getDateTime(INPUT_STARTDATE_PREFIX);
            Date end = null;
            v.addValidation(INPUT_STARTDATE_PREFIX, 21);
            v.alwaysExecuteLastValidation(INPUT_STARTDATE_PREFIX);
            if (!strEndScheduled.isEmpty()) {
                v.addValidation(INPUT_ENDDATE_PREFIX, 21);
                v.alwaysExecuteLastValidation(INPUT_ENDDATE_PREFIX);
            }
            HashMap errors = v.validate();
            if (!(strEnd.isEmpty() || errors.containsKey(INPUT_STARTDATE_PREFIX) || errors.containsKey(INPUT_ENDDATE_PREFIX))) {
                end = fp.getDateTime(INPUT_ENDDATE_PREFIX);
                if (!fp.getString("startDate").equals(fp.getString("endDate"))) {
                    if (end.before(start)) {
                        Validator.addError((HashMap)errors, (String)INPUT_ENDDATE_PREFIX, (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
                    }
                } else if (fp.timeEntered(INPUT_STARTDATE_PREFIX) && fp.timeEntered(INPUT_ENDDATE_PREFIX) && (end.before(start) || end.equals(start))) {
                    Validator.addError((HashMap)errors, (String)INPUT_ENDDATE_PREFIX, (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
                }
            }
            if (!errors.isEmpty()) {
                this.setInputMessages(errors);
                String[] prefixes = new String[]{INPUT_STARTDATE_PREFIX, INPUT_ENDDATE_PREFIX};
                fp.setCurrentDateTimeValuesAsPreset(prefixes);
                this.setPresetValues(fp.getPresetValues());
                studyEvent.setLocation(fp.getString(INPUT_LOCATION));
                this.request.setAttribute("changeDate", (Object)fp.getString("changeDate"));
                this.request.setAttribute(EVENT_BEAN, (Object)studyEvent);
                this.forwardPage(Page.UPDATE_STUDY_EVENT);
            } else if (studyEvent.getSubjectEventStatus().isSigned()) {
                this.request.setAttribute(STUDY_SUBJECT_ID, (Object)new Integer(studySubjectId).toString());
                if (fp.getString("startHour").equals("-1") && fp.getString("startMinute").equals("-1") && fp.getString("startHalf").isEmpty()) {
                    studyEvent.setStartTimeFlag(false);
                } else {
                    studyEvent.setStartTimeFlag(true);
                }
                studyEvent.setDateStarted(start);
                if (!strEnd.isEmpty()) {
                    studyEvent.setDateEnded(end);
                    if (fp.getString("endHour").equals("-1") && fp.getString("endMinute").equals("-1") && fp.getString("endHalf").isEmpty()) {
                        studyEvent.setEndTimeFlag(false);
                    } else {
                        studyEvent.setEndTimeFlag(true);
                    }
                } else {
                    studyEvent.setDateEnded(end);
                }
                studyEvent.setLocation(fp.getString(INPUT_LOCATION));
                studyEvent.setStudyEventDefinition(sed);
                ssdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean ssb = ssdao.findByPK(studyEvent.getStudySubjectId());
                ecdao = new EventCRFDAO(this.sm.getDataSource());
                eventCRFs = ecdao.findAllByStudyEvent(studyEvent);
                StudyBean study = sdao.findByPK(ssb.getStudyId());
                ArrayList eventDefinitionCRFs = edcdao.findAllActiveByEventDefinitionId(study, studyEvent.getStudyEventDefinitionId());
                ArrayList uncompletedEventDefinitionCRFs = this.getUncompletedCRFs(eventDefinitionCRFs, eventCRFs);
                this.populateUncompletedCRFsWithCRFAndVersions(uncompletedEventDefinitionCRFs);
                ArrayList displayEventCRFs = ViewStudySubjectServlet.getDisplayEventCRFs((DataSource)this.sm.getDataSource(), (ArrayList)eventCRFs, (ArrayList)eventDefinitionCRFs, (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole, (SubjectEventStatus)studyEvent.getSubjectEventStatus(), (StudyBean)study);
                this.request.setAttribute("studySubject", (Object)ssb);
                this.request.setAttribute("uncompletedEventDefinitionCRFs", (Object)uncompletedEventDefinitionCRFs);
                this.request.setAttribute("displayEventCRFs", (Object)displayEventCRFs);
                this.request.setAttribute(EVENT_BEAN, (Object)studyEvent);
                this.session.setAttribute("eventSigned", (Object)studyEvent);
                DiscrepancyNoteUtil discNoteUtil = new DiscrepancyNoteUtil();
                DisplayStudyEventBean displayEvBean = new DisplayStudyEventBean();
                ArrayList<DisplayStudyEventBean> displayEvents = new ArrayList<DisplayStudyEventBean>();
                displayEvBean.setStudyEvent(studyEvent);
                displayEvents.add(displayEvBean);
                discNoteUtil.injectParentDiscNotesIntoDisplayStudyEvents(displayEvents, new HashSet(), this.sm.getDataSource(), 0);
                Map discNoteByEventCRFid = discNoteUtil.createDiscNoteMapByEventCRF(displayEvents);
                this.request.setAttribute("discNoteByEventCRFid", (Object)discNoteByEventCRFid);
                this.forwardPage(Page.UPDATE_STUDY_EVENT_SIGNED);
            } else {
                logger.debug("no validation error");
                if (fp.getString("startHour").equals("-1") && fp.getString("startMinute").equals("-1") && fp.getString("startHalf").isEmpty()) {
                    studyEvent.setStartTimeFlag(false);
                } else {
                    studyEvent.setStartTimeFlag(true);
                }
                studyEvent.setDateStarted(start);
                if (!strEnd.isEmpty()) {
                    studyEvent.setDateEnded(end);
                    if (fp.getString("endHour").equals("-1") && fp.getString("endMinute").equals("-1") && fp.getString("endHalf").isEmpty()) {
                        studyEvent.setEndTimeFlag(false);
                    } else {
                        studyEvent.setEndTimeFlag(true);
                    }
                } else {
                    studyEvent.setDateEnded(end);
                }
                studyEvent.setLocation(fp.getString(INPUT_LOCATION));
                logger.debug("update study event...");
                studyEvent.setUpdater(this.ub);
                studyEvent.setUpdatedDate(new Date());
                sedao.update(studyEvent);
                FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
                DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                AddNewSubjectServlet.saveFieldNotes((String)INPUT_LOCATION, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEvent.getId(), (String)EVENT_BEAN, (StudyBean)this.currentStudy);
                AddNewSubjectServlet.saveFieldNotes((String)INPUT_STARTDATE_PREFIX, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEvent.getId(), (String)EVENT_BEAN, (StudyBean)this.currentStudy);
                AddNewSubjectServlet.saveFieldNotes((String)INPUT_ENDDATE_PREFIX, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEvent.getId(), (String)EVENT_BEAN, (StudyBean)this.currentStudy);
                this.addPageMessage(respage.getString("study_event_updated"));
                this.request.setAttribute("id", (Object)new Integer(studySubjectId).toString());
                this.session.removeAttribute("fdnotes");
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            }
        } else if (action.equalsIgnoreCase("confirm")) {
            String username = this.request.getParameter("j_user");
            String password = this.request.getParameter("j_pass");
            SecurityManager securityManager = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
            UserAccountBean ub = (UserAccountBean)this.session.getAttribute("userBean");
            StudyEventBean seb = (StudyEventBean)this.session.getAttribute("eventSigned");
            if (securityManager.verifyPassword(password, this.getUserDetails()) && ub.getName().equals(username)) {
                seb.setUpdater(ub);
                seb.setUpdatedDate(new Date());
                sedao.update(seb);
                ArrayList studyEvents = sedao.findAllByStudySubject(ssub);
                boolean allSigned = true;
                for (StudyEventBean temp : studyEvents) {
                    if (temp.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED)) continue;
                    allSigned = false;
                    break;
                }
                if (allSigned) {
                    logger.debug("Signing StudySubject [{}]", (Object)ssub.getSubjectId());
                    ssub.setStatus(Status.SIGNED);
                    ssub.setUpdater(ub);
                    ssdao.update(ssub);
                }
                FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
                DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                AddNewSubjectServlet.saveFieldNotes((String)INPUT_LOCATION, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEvent.getId(), (String)EVENT_BEAN, (StudyBean)this.currentStudy);
                AddNewSubjectServlet.saveFieldNotes((String)INPUT_STARTDATE_PREFIX, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEvent.getId(), (String)EVENT_BEAN, (StudyBean)this.currentStudy);
                AddNewSubjectServlet.saveFieldNotes((String)INPUT_ENDDATE_PREFIX, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEvent.getId(), (String)EVENT_BEAN, (StudyBean)this.currentStudy);
                this.session.removeAttribute("eventSigned");
                this.request.setAttribute("id", (Object)new Integer(studySubjectId).toString());
                this.addPageMessage(respage.getString("study_event_updated"));
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            } else {
                this.request.setAttribute(STUDY_SUBJECT_ID, (Object)new Integer(studySubjectId).toString());
                this.request.setAttribute(EVENT_BEAN, (Object)seb);
                ssdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean ssb = ssdao.findByPK(studyEvent.getStudySubjectId());
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                ArrayList eventCRFs = ecdao.findAllByStudyEvent(studyEvent);
                StudyBean study = sdao.findByPK(ssb.getStudyId());
                ArrayList eventDefinitionCRFs = edcdao.findAllActiveByEventDefinitionId(study, studyEvent.getStudyEventDefinitionId());
                ArrayList uncompletedEventDefinitionCRFs = this.getUncompletedCRFs(eventDefinitionCRFs, eventCRFs);
                this.populateUncompletedCRFsWithCRFAndVersions(uncompletedEventDefinitionCRFs);
                ArrayList displayEventCRFs = ViewStudySubjectServlet.getDisplayEventCRFs((DataSource)this.sm.getDataSource(), (ArrayList)eventCRFs, (ArrayList)eventDefinitionCRFs, (UserAccountBean)ub, (StudyUserRoleBean)this.currentRole, (SubjectEventStatus)studyEvent.getSubjectEventStatus(), (StudyBean)study);
                this.request.setAttribute("studySubject", (Object)ssb);
                this.request.setAttribute("uncompletedEventDefinitionCRFs", (Object)uncompletedEventDefinitionCRFs);
                this.request.setAttribute("displayEventCRFs", (Object)displayEventCRFs);
                this.request.setAttribute(EVENT_BEAN, this.session.getAttribute("eventSigned"));
                this.addPageMessage(restext.getString("password_match"));
                this.forwardPage(Page.UPDATE_STUDY_EVENT_SIGNED);
            }
        } else {
            logger.debug("no action, go to update page");
            DiscrepancyNoteDAO discrepancyNoteDAO = new DiscrepancyNoteDAO(this.sm.getDataSource());
            StudySubjectBean studySubjectBean = ssdao.findByPK(studyEvent.getStudySubjectId());
            int studyId = studySubjectBean.getStudyId();
            boolean subjectStudyIsCurrentStudy = studyId == this.currentStudy.getId();
            boolean isParentStudy = studyBean.getParentStudyId() < 1;
            ArrayList allNotesForSubjectAndEvent = new ArrayList();
            if (subjectStudyIsCurrentStudy && isParentStudy) {
                allNotesForSubjectAndEvent = discrepancyNoteDAO.findAllStudyEventByStudyAndId(this.currentStudy, studySubjectBean.getId());
            } else if (!isParentStudy) {
                StudyBean stParent = sdao.findByPK(studyBean.getParentStudyId());
                allNotesForSubjectAndEvent = discrepancyNoteDAO.findAllStudyEventByStudiesAndSubjectId(stParent, studyBean, studySubjectBean.getId());
            } else {
                allNotesForSubjectAndEvent = discrepancyNoteDAO.findAllStudyEventByStudiesAndSubjectId(this.currentStudy, studyBean, studySubjectBean.getId());
            }
            if (!allNotesForSubjectAndEvent.isEmpty()) {
                this.setRequestAttributesForNotes((List)allNotesForSubjectAndEvent, studyEventId);
            }
            HashMap<String, Object> presetValues = new HashMap<String, Object>();
            if (studyEvent.getStartTimeFlag()) {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(studyEvent.getDateStarted());
                presetValues.put("startHour", new Integer(c.get(11)));
                presetValues.put("startMinute", new Integer(c.get(12)));
                switch (c.get(9)) {
                    case 0: {
                        presetValues.put("startHalf", "am");
                        break;
                    }
                    case 1: {
                        presetValues.put("startHalf", "pm");
                        break;
                    }
                    default: {
                        presetValues.put("startHalf", "");
                        break;
                    }
                }
            } else {
                presetValues.put("startHour", new Integer(-1));
                presetValues.put("startMinute", new Integer(-1));
                presetValues.put("startHalf", "");
            }
            String dateValue = this.local_df.format(studyEvent.getDateStarted());
            presetValues.put("startDate", dateValue);
            presetValues.put("endHour", new Integer(-1));
            presetValues.put("endMinute", new Integer(-1));
            presetValues.put("endHalf", "");
            if (studyEvent.getDateEnded() != null) {
                if (studyEvent.getEndTimeFlag()) {
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTime(studyEvent.getDateEnded());
                    presetValues.put("endHour", new Integer(c.get(11)));
                    presetValues.put("endMinute", new Integer(c.get(12)));
                    switch (c.get(9)) {
                        case 0: {
                            presetValues.put("endHalf", "am");
                            break;
                        }
                        case 1: {
                            presetValues.put("endHalf", "pm");
                            break;
                        }
                        default: {
                            presetValues.put("endHalf", "");
                        }
                    }
                }
                presetValues.put("endDate", this.local_df.format(studyEvent.getDateEnded()));
            }
            this.setPresetValues(presetValues);
            this.request.setAttribute(EVENT_BEAN, (Object)studyEvent);
            this.request.setAttribute("studySubject", (Object)studySubjectBean);
            discNotes = new FormDiscrepancyNotes();
            this.session.setAttribute("fdnotes", (Object)discNotes);
            this.forwardPage(Page.UPDATE_STUDY_EVENT);
        }
    }

    private ArrayList<DisplayEventDefinitionCRFBean> getUncompletedCRFs(ArrayList<EventDefinitionCRFBean> eventDefinitionCRFs, ArrayList<EventCRFBean> eventCRFs) {
        HashMap<Integer, Boolean> completed = new HashMap<Integer, Boolean>();
        HashMap<Integer, EventCRFBean> startedButIncompleted = new HashMap<Integer, EventCRFBean>();
        ArrayList<DisplayEventDefinitionCRFBean> answer = new ArrayList<DisplayEventDefinitionCRFBean>();
        for (EventDefinitionCRFBean edcrf : eventDefinitionCRFs) {
            completed.put(new Integer(edcrf.getCrfId()), Boolean.FALSE);
            startedButIncompleted.put(new Integer(edcrf.getCrfId()), new EventCRFBean());
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        for (EventCRFBean ecrf : eventCRFs) {
            int crfId = cvdao.getCRFIdFromCRFVersionId(ecrf.getCRFVersionId());
            ArrayList idata = iddao.findAllByEventCRFId(ecrf.getId());
            if (!idata.isEmpty()) {
                completed.put(new Integer(crfId), Boolean.TRUE);
                continue;
            }
            startedButIncompleted.put(new Integer(crfId), ecrf);
        }
        for (EventDefinitionCRFBean edcrf : eventDefinitionCRFs) {
            DisplayEventDefinitionCRFBean dedc = new DisplayEventDefinitionCRFBean();
            dedc.setEdc(edcrf);
            Boolean b = (Boolean)completed.get(new Integer(edcrf.getCrfId()));
            EventCRFBean ev = (EventCRFBean)startedButIncompleted.get(new Integer(edcrf.getCrfId()));
            if (b != null && b.booleanValue()) continue;
            dedc.setEventCRF(ev);
            answer.add(dedc);
        }
        return answer;
    }

    private void populateUncompletedCRFsWithCRFAndVersions(ArrayList<DisplayEventDefinitionCRFBean> uncompletedEventDefinitionCRFs) {
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        for (int i = 0; i < uncompletedEventDefinitionCRFs.size(); ++i) {
            DisplayEventDefinitionCRFBean dedcrf = uncompletedEventDefinitionCRFs.get(i);
            CRFBean cb = cdao.findByPK(dedcrf.getEdc().getCrfId());
            if (cb.getStatus().equals((Term)Status.AVAILABLE)) {
                dedcrf.getEdc().setCrf(cb);
                ArrayList versions = cvdao.findAllActiveByCRF(dedcrf.getEdc().getCrfId());
                dedcrf.getEdc().setVersions(versions);
                if (versions != null && !versions.isEmpty()) {
                    boolean isLocked = false;
                    for (CRFVersionBean crfvb : versions) {
                        logger.debug("...checking versions...{}", (Object)crfvb.getName());
                        if (crfvb.getStatus().equals((Term)Status.AVAILABLE)) continue;
                        logger.debug("found a non active crf version");
                        isLocked = true;
                    }
                    logger.debug("re-set event def, line 240: {}", (Object)isLocked);
                    if (isLocked) {
                        dedcrf.setStatus(Status.LOCKED);
                        dedcrf.getEventCRF().setStage(DataEntryStage.LOCKED);
                    }
                    uncompletedEventDefinitionCRFs.set(i, dedcrf);
                    continue;
                }
                dedcrf.setStatus(Status.LOCKED);
                dedcrf.getEventCRF().setStage(DataEntryStage.LOCKED);
                uncompletedEventDefinitionCRFs.set(i, dedcrf);
                continue;
            }
            dedcrf.getEdc().setCrf(cb);
            logger.debug("_found a non active crf _");
            dedcrf.setStatus(Status.LOCKED);
            dedcrf.getEventCRF().setStage(DataEntryStage.LOCKED);
            dedcrf.getEdc().getCrf().setStatus(Status.LOCKED);
            uncompletedEventDefinitionCRFs.set(i, dedcrf);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    private void setRequestAttributesForNotes(List<DiscrepancyNoteBean> discBeans, int currentEventId) {
        for (DiscrepancyNoteBean discrepancyNoteBean : discBeans) {
            if (discrepancyNoteBean.getEntityId() != currentEventId) continue;
            if (INPUT_LOCATION.equalsIgnoreCase(discrepancyNoteBean.getColumn())) {
                this.request.setAttribute(STATUS_DN_LOCATION, (Object)discrepancyNoteBean.getResolutionStatusId());
                this.request.setAttribute(HAS_LOCATION_NOTE, (Object)"yes");
                continue;
            }
            if ("start_date".equalsIgnoreCase(discrepancyNoteBean.getColumn())) {
                this.request.setAttribute(STATUS_DN_START_DATE, (Object)discrepancyNoteBean.getResolutionStatusId());
                this.request.setAttribute(HAS_START_DATE_NOTE, (Object)"yes");
                continue;
            }
            if (!"end_date".equalsIgnoreCase(discrepancyNoteBean.getColumn())) continue;
            this.request.setAttribute(STATUS_DN_END_DATE, (Object)discrepancyNoteBean.getResolutionStatusId());
            this.request.setAttribute(HAS_END_DATE_NOTE, (Object)"yes");
        }
    }
}

