/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewEventDefinitionServlet
extends SecureController {
    private static final long serialVersionUID = -3060882927286640506L;
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest() throws Exception {
        StudyEventDefinitionDAO sdao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int defId = fp.getInt("id", true);
        if (defId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_definition_to_view"));
            this.forwardPage(Page.LIST_DEFINITION_SERVLET);
        } else {
            StudyEventDefinitionBean sed = sdao.findByPK(defId);
            if (this.currentStudy.getId() != sed.getStudyId()) {
                this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                this.forwardPage(Page.MENU_SERVLET);
                return;
            }
            this.checkRoleByUserAndStudy(this.ub, sed.getStudyId(), 0);
            EventDefinitionCRFDAO edao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            ArrayList eventDefinitionCRFs = edao.findAllByDefinition(this.currentStudy, defId);
            CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
                EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
                ArrayList versions = cvdao.findAllByCRF(edc.getCrfId());
                edc.setVersions(versions);
                CRFBean crf = cdao.findByPK(edc.getCrfId());
                edc.setCrfName(crf.getName());
                if (crf.getStatus().equals((Term)Status.AVAILABLE)) {
                    edc.setOwner(crf.getOwner());
                }
                CRFVersionBean defaultVersion = cvdao.findByPK(edc.getDefaultVersionId());
                edc.setDefaultVersionName(defaultVersion.getName());
                CRFBean cBean = cdao.findByPK(edc.getCrfId());
                String crfPath = sed.getOid() + "." + cBean.getOid();
                edc.setOffline(this.getEventDefinitionCrfTagService().getEventDefnCrfOfflineStatus(2, crfPath, true));
            }
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            this.request.setAttribute("definition", (Object)sed);
            this.request.setAttribute("eventDefinitionCRFs", (Object)eventDefinitionCRFs);
            this.request.setAttribute("defSize", (Object)new Integer(eventDefinitionCRFs.size()));
            this.forwardPage(Page.VIEW_EVENT_DEFINITION);
        }
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

