/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewItemAuditLogServlet
extends SecureController {
    private static final long serialVersionUID = 4681699989521984006L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
        throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        AuditDAO adao = new AuditDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String auditTable = fp.getString("auditTable");
        if (auditTable.equalsIgnoreCase("studysub")) {
            auditTable = "study_subject";
        } else if (auditTable.equalsIgnoreCase("eventcrf")) {
            auditTable = "event_crf";
        } else if (auditTable.equalsIgnoreCase("studyevent")) {
            auditTable = "study_event";
        } else if (auditTable.equalsIgnoreCase("itemdata")) {
            auditTable = "item_data";
        }
        int entityId = fp.getInt("entityId");
        ArrayList itemAuditEvents = adao.findItemAuditEvents(entityId, auditTable);
        this.request.setAttribute("itemAudits", (Object)itemAuditEvents);
        this.forwardPage(Page.AUDIT_LOGS_ITEMS);
    }
}

