/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.DisplayTableOfContentsBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.BeanFactory;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSectionDataEntryPreview
extends DataEntryServlet {
    private static final long serialVersionUID = -354876433251037369L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewSectionDataEntryPreview.class);
    public static String SECTION_TITLE = "section_title";
    public static String SECTION_LABEL = "section_label";
    public static String SECTION_SUBTITLE = "subtitle";
    public static String INSTRUCTIONS = "instructions";
    public static String BORDERS = "borders";

    public void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        if (ub.isSysAdmin()) {
            return;
        }
        if (currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || currentRole.getRole().equals((Term)Role.COORDINATOR) || currentRole.getRole().equals((Term)Role.INVESTIGATOR) || currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"), request);
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FormProcessor fp = new FormProcessor(request);
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        SectionBean sb = (SectionBean)request.getAttribute("section_bean");
        int crfid = fp.getInt("crfId");
        int tabNum = fp.getInt("tabId");
        HttpSession session = request.getSession();
        request.setAttribute("crfId", (Object)crfid);
        String crfName = "";
        String verNumber = "";
        Map crfMap = (Map)session.getAttribute("preview_crf");
        if (crfMap == null) {
            String msg = respage.getString("preview_data_has_timed_out");
            this.addPageMessage(msg, request);
            LOGGER.debug("The session attribute \"preview_crf\" has expired or gone out of scope in: " + this.getClass().getName());
            this.forwardPage(Page.CRF_LIST_SERVLET, request, response);
        }
        Map crfIdnameInfo = null;
        if (crfMap != null) {
            crfIdnameInfo = (Map)crfMap.get("crf_info");
        }
        if (crfIdnameInfo != null) {
            Map.Entry mapEnt = null;
            for (Map.Entry element : crfIdnameInfo.entrySet()) {
                mapEnt = element;
                if (((String)mapEnt.getKey()).equalsIgnoreCase("crf_name")) {
                    crfName = (String)mapEnt.getValue();
                }
                if (!((String)mapEnt.getKey()).equalsIgnoreCase("version")) continue;
                verNumber = (String)mapEnt.getValue();
            }
        }
        EventCRFBean ebean = new EventCRFBean();
        CRFVersionBean crfverBean = new CRFVersionBean();
        crfverBean.setName(verNumber);
        CRFBean crfbean = new CRFBean();
        crfbean.setId(crfid);
        crfbean.setName(crfName);
        ebean.setCrf(crfbean);
        ecb = ebean;
        Map groupsMap = null;
        if (crfMap != null) {
            groupsMap = (Map)crfMap.get("groups");
        }
        boolean hasGroups = false;
        Map sectionsMap = null;
        if (crfMap != null) {
            sectionsMap = (Map)crfMap.get("sections");
        }
        Map itemsMap = null;
        if (crfMap != null) {
            itemsMap = (Map)crfMap.get("items");
        }
        BeanFactory beanFactory = new BeanFactory();
        Map.Entry me = null;
        SectionBean secbean = null;
        ArrayList<SectionBean> allSectionBeans = new ArrayList<SectionBean>();
        String name_str = "";
        String pageNum = "";
        Map secMap = null;
        NumberFormat numFormatter = NumberFormat.getInstance();
        numFormatter.setMaximumFractionDigits(0);
        if (sectionsMap != null) {
            for (Map.Entry element : sectionsMap.entrySet()) {
                secbean = new SectionBean();
                me = element;
                secMap = (Map)me.getValue();
                name_str = (String)secMap.get("section_label");
                secbean.setName(name_str);
                secbean.setTitle((String)secMap.get("section_title"));
                secbean.setInstructions((String)secMap.get("instructions"));
                secbean.setSubtitle((String)secMap.get("subtitle"));
                pageNum = (String)secMap.get("page_number");
                try {
                    pageNum = numFormatter.format(Double.parseDouble(pageNum));
                }
                catch (NumberFormatException nfe) {
                    pageNum = "";
                }
                secbean.setPageNumberLabel(pageNum);
                secbean.setNumItems(this.getNumberOfItems(itemsMap, secbean.getName()));
                allSectionBeans.add(secbean);
            }
        }
        DisplayTableOfContentsBean dtocBean = new DisplayTableOfContentsBean();
        dtocBean.setSections(allSectionBeans);
        request.setAttribute("toc", (Object)dtocBean);
        request.setAttribute("sectionNum", (Object)(allSectionBeans.size() + ""));
        sb = (SectionBean)allSectionBeans.get(0);
        request.setAttribute("event", (Object)ecb);
        request.setAttribute("section_bean", (Object)sb);
        this.setupStudyBean(request);
        tabNum = tabNum == 0 ? 1 : tabNum;
        String sectionTitle = this.getSectionColumnBySecNum(sectionsMap, tabNum, SECTION_TITLE);
        String secLabel = this.getSectionColumnBySecNum(sectionsMap, tabNum, SECTION_LABEL);
        String secSubtitle = this.getSectionColumnBySecNum(sectionsMap, tabNum, SECTION_SUBTITLE);
        String instructions = this.getSectionColumnBySecNum(sectionsMap, tabNum, INSTRUCTIONS);
        int secBorders = this.getSectionBordersBySecNum(sectionsMap, tabNum, BORDERS);
        DisplaySectionBean displaySection = beanFactory.createDisplaySectionBean(itemsMap, sectionTitle, secLabel, secSubtitle, instructions, crfName, secBorders);
        ArrayList disBeans = displaySection.getItems();
        hasGroups = false;
        for (DisplayItemBean diBean : disBeans) {
            ItemFormMetadataBean metaBean = diBean.getMetadata();
            String groupLabel = metaBean.getGroupLabel();
            if (groupLabel == null || groupLabel.length() <= 0) continue;
            hasGroups = true;
            break;
        }
        List disFormGroupBeans = null;
        if (hasGroups) {
            disFormGroupBeans = beanFactory.createGroupBeans(itemsMap, groupsMap, secLabel, crfName);
            displaySection.setDisplayFormGroups(disFormGroupBeans);
        }
        displaySection.setCrfVersion(crfverBean);
        displaySection.setCrf(crfbean);
        displaySection.setEventCRF(ebean);
        SectionBean aSecBean = new SectionBean();
        request.setAttribute("section", (Object)displaySection);
        request.setAttribute("sec", (Object)aSecBean);
        request.setAttribute("EventCRFBean", (Object)ebean);
        try {
            request.setAttribute("tabId", (Object)Integer.toString(tabNum));
        }
        catch (NumberFormatException nfe) {
            request.setAttribute("tabId", (Object)new Integer("1"));
        }
        if (hasGroups) {
            LOGGER.debug("has group, new_table is true");
            request.setAttribute("new_table", (Object)true);
        }
        this.forwardPage(Page.CREATE_CRF_VERSION_CONFIRM, request, response);
    }

    private String getSectionColumnBySecNum(Map sectionsMap, int sectionNum, String sectionColumn) {
        if (sectionsMap == null || sectionColumn == null || sectionColumn.length() < 1) {
            return "";
        }
        Map innerMap = (Map)sectionsMap.get(sectionNum);
        return (String)innerMap.get(sectionColumn);
    }

    private int getSectionBordersBySecNum(Map sectionsMap, int sectionNum, String sectionColumn) {
        if (sectionsMap == null || sectionColumn == null || sectionColumn.length() < 1) {
            return 0;
        }
        Map innerMap = (Map)sectionsMap.get(sectionNum);
        String tempBorder = (String)innerMap.get(sectionColumn);
        if (tempBorder != null && tempBorder.length() < 1) {
            return 0;
        }
        if (tempBorder != null) {
            return new Integer(tempBorder);
        }
        return 0;
    }

    private int getNumberOfItems(Map itemsMap, String sectionLabel) {
        if (itemsMap == null) {
            return 0;
        }
        int itemCount = 0;
        Map itemVals = null;
        Map.Entry me3 = null;
        Map.Entry me22 = null;
        String columnName = "";
        String val = "";
        for (Map.Entry me3 : itemsMap.entrySet()) {
            itemVals = (Map)me3.getValue();
            for (Map.Entry me22 : itemVals.entrySet()) {
                columnName = (String)me22.getKey();
                val = (String)me22.getValue();
                if (!columnName.equalsIgnoreCase("section_label") || !val.equalsIgnoreCase(sectionLabel)) continue;
                ++itemCount;
            }
        }
        return itemCount;
    }

    private void setupStudyBean(HttpServletRequest request) {
        StudyDAO studydao;
        StudyBean study;
        String age = "";
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        StudySubjectDAO ssdao = new StudySubjectDAO(this.getDataSource());
        StudySubjectBean sub = ssdao.findByPK(ecb.getStudySubjectId());
        SubjectDAO subjectDao = new SubjectDAO(this.getDataSource());
        int subjectId = sub.getSubjectId();
        int studyId = sub.getStudyId();
        SubjectBean subject = subjectDao.findByPK(subjectId);
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
            StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
            StudyEventBean se = sedao.findByPK(ecb.getStudyEventId());
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.getDataSource());
            StudyEventDefinitionBean sed = seddao.findByPK(se.getStudyEventDefinitionId());
            se.setStudyEventDefinition(sed);
            request.setAttribute("studyEvent", (Object)se);
            age = Utils.getInstacne().processAge(sub.getEnrollmentDate(), subject.getDateOfBirth());
        }
        if ((study = (studydao = new StudyDAO(this.getDataSource())).findByPK(studyId)).getParentStudyId() > 0) {
            StudyBean parentStudy = studydao.findByPK(study.getParentStudyId());
            request.setAttribute("studyTitle", (Object)(parentStudy.getName() + " - " + study.getName()));
        } else {
            request.setAttribute("studyTitle", (Object)study.getName());
        }
        request.setAttribute("studySubject", (Object)sub);
        request.setAttribute("subject", (Object)subject);
        request.setAttribute("age", (Object)age);
    }

    protected Status getBlankItemStatus() {
        return Status.AVAILABLE;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        return edcb.isDoubleEntry() ? Status.PENDING : Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getAnnotations();
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setAnnotations(annotations);
    }

    protected Page getJSPPage() {
        return Page.VIEW_SECTION_DATA_ENTRY;
    }

    protected String getServletPage(HttpServletRequest request) {
        return Page.VIEW_SECTION_DATA_ENTRY_SERVLET.getFileName();
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        dib = this.loadFormValue(dib, request);
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA) || rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        return formGroups;
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        return true;
    }

    protected boolean shouldRunRules() {
        return false;
    }

    protected boolean isAdministrativeEditing() {
        return false;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        return false;
    }
}

