/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.core.GroupClassType;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewSubjectGroupClassServlet
extends SecureController {
    private static final long serialVersionUID = -842052669736496090L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + "\n" + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int classId = fp.getInt("id");
        if (classId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_group_class_to_view"));
            this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
        } else {
            StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
            StudyDAO studyDao = new StudyDAO(this.sm.getDataSource());
            StudyGroupClassBean sgcb = sgcdao.findByPK(classId);
            StudyBean study = studyDao.findByPK(sgcb.getStudyId());
            this.checkRoleByUserAndStudy(this.ub, sgcb.getStudyId(), study.getParentStudyId());
            sgcb.setGroupClassTypeName(GroupClassType.get((int)sgcb.getGroupClassTypeId()).getName());
            ArrayList groups = sgdao.findAllByGroupClass(sgcb);
            ArrayList<StudyGroupBean> studyGroups = new ArrayList<StudyGroupBean>();
            for (int i = 0; i < groups.size(); ++i) {
                StudyGroupBean sg = (StudyGroupBean)groups.get(i);
                ArrayList subjectMaps = sgmdao.findAllByStudyGroupClassAndGroup(sgcb.getId(), sg.getId());
                sg.setSubjectMaps(subjectMaps);
                studyGroups.add(sg);
            }
            this.request.setAttribute("group", (Object)sgcb);
            this.request.setAttribute("studyGroups", studyGroups);
            this.forwardPage(Page.VIEW_SUBJECT_GROUP_CLASS);
        }
    }
}

