/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.AddNewSubjectServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CreateNewStudyEventServlet
extends SecureController {
    private static final long serialVersionUID = -2900729097178000327L;
    Locale locale;
    public static final String INPUT_STUDY_EVENT_DEFINITION = "studyEventDefinition";
    public static final String INPUT_STUDY_SUBJECT = "studySubject";
    public static final String INPUT_STUDY_SUBJECT_LABEL = "studySubjectLabel";
    public static final String INPUT_STUDY_SUBJECT_ID_FROM_VIEWSUBJECT = "studySubjectId";
    public static final String INPUT_EVENT_DEF_ID_FROM_VIEWSUBJECT = "eventDefId";
    public static final String INPUT_STARTDATE_PREFIX = "start";
    public static final String INPUT_ENDDATE_PREFIX = "end";
    public static final String INPUT_REQUEST_STUDY_SUBJECT = "requestStudySubject";
    public static final String INPUT_LOCATION = "location";
    private FormProcessor fp;
    public static final String[] INPUT_STUDY_EVENT_DEFINITION_SCHEDULED = new String[]{"studyEventDefinitionScheduled0", "studyEventDefinitionScheduled1", "studyEventDefinitionScheduled2", "studyEventDefinitionScheduled3"};
    public static final String[] INPUT_SCHEDULED_LOCATION = new String[]{"locationScheduled0", "locationScheduled1", "locationScheduled2", "locationScheduled3"};
    public static final String[] INPUT_STARTDATE_PREFIX_SCHEDULED = new String[]{"startScheduled0", "startScheduled1", "startScheduled2", "startScheduled3"};
    public static final String[] INPUT_ENDDATE_PREFIX_SCHEDULED = new String[]{"endScheduled0", "endScheduled1", "endScheduled2", "endScheduled3"};
    public static final String[] DISPLAY_SCHEDULED = new String[]{"display0", "display1", "display2", "display3"};
    public static final int ADDITIONAL_SCHEDULED_NUM = 4;

    protected void processRequest() throws Exception {
        StudySubjectBean ssb;
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        this.panel.setStudyInfoShown(false);
        this.fp = new FormProcessor(this.request);
        FormDiscrepancyNotes discNotes = null;
        int studySubjectId = this.fp.getInt("studySubjectId");
        int studyEventDefinitionId = this.fp.getInt("studyEventDefinition");
        StudySubjectDAO sdao = new StudySubjectDAO(this.sm.getDataSource());
        if (studySubjectId <= 0) {
            ssb = (StudySubjectBean)this.request.getAttribute("studySubject");
        } else {
            ssb = sdao.findByPK(studySubjectId);
            Status s = ssb.getStatus();
            if ("removed".equalsIgnoreCase(s.getName()) || "auto-removed".equalsIgnoreCase(s.getName())) {
                this.addPageMessage(resword.getString("study_event") + resterm.getString("could_not_be") + resterm.getString("added") + "." + respage.getString("study_subject_has_been_deleted"));
                this.request.setAttribute("id", (Object)new Integer(studySubjectId).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            }
            this.request.setAttribute("requestStudySubject", (Object)"no");
        }
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyBean studyWithEventDefinitions = this.currentStudy;
        if (this.currentStudy.getParentStudyId() > 0) {
            studyWithEventDefinitions = new StudyBean();
            studyWithEventDefinitions.setId(this.currentStudy.getParentStudyId());
        }
        ArrayList eventDefinitions = seddao.findAllActiveByStudy(studyWithEventDefinitions);
        Collections.sort(eventDefinitions);
        ArrayList eventDefinitionsScheduled = eventDefinitions;
        if (!this.fp.isSubmitted()) {
            HashMap<String, Object> presetValues = new HashMap<String, Object>();
            presetValues.put("startHour", new Integer(-1));
            presetValues.put("startMinute", new Integer(-1));
            presetValues.put("startHalf", new String(""));
            presetValues.put("endHour", new Integer(-1));
            presetValues.put("endMinute", new Integer(-1));
            presetValues.put("endHalf", new String(""));
            for (int i = 0; i < 4; ++i) {
                presetValues.put(INPUT_STARTDATE_PREFIX_SCHEDULED[i] + "Hour", new Integer(-1));
                presetValues.put(INPUT_STARTDATE_PREFIX_SCHEDULED[i] + "Minute", new Integer(-1));
                presetValues.put(INPUT_STARTDATE_PREFIX_SCHEDULED[i] + "Half", new String(""));
                presetValues.put(INPUT_ENDDATE_PREFIX_SCHEDULED[i] + "Hour", new Integer(-1));
                presetValues.put(INPUT_ENDDATE_PREFIX_SCHEDULED[i] + "Minute", new Integer(-1));
                presetValues.put(INPUT_ENDDATE_PREFIX_SCHEDULED[i] + "Half", new String(""));
            }
            String dateValue = this.local_df.format(new Date(System.currentTimeMillis()));
            presetValues.put("startDate", dateValue);
            for (int i = 0; i < 4; ++i) {
                presetValues.put(INPUT_STARTDATE_PREFIX_SCHEDULED[i] + "Date", dateValue);
                presetValues.put(INPUT_SCHEDULED_LOCATION[i], this.currentStudy.getFacilityCity());
                presetValues.put(DISPLAY_SCHEDULED[i], "none");
            }
            presetValues.put("location", this.currentStudy.getFacilityCity());
            if (ssb != null && ssb.isActive()) {
                presetValues.put("studySubject", ssb);
                String requestStudySubject = (String)this.request.getAttribute("requestStudySubject");
                if (requestStudySubject != null) {
                    presetValues.put("requestStudySubject", requestStudySubject);
                    dateValue = this.local_df.format(new Date());
                    presetValues.put("startDate", dateValue);
                }
            }
            if (studyEventDefinitionId > 0) {
                StudyEventDefinitionBean sed = seddao.findByPK(studyEventDefinitionId);
                presetValues.put("studyEventDefinition", sed);
            }
            logger.debug("set preset values: " + presetValues.toString());
            logger.debug("found def.w.CRF list, size " + eventDefinitions.size());
            this.setPresetValues(presetValues);
            this.setupBeans(eventDefinitions);
            discNotes = new FormDiscrepancyNotes();
            this.session.setAttribute("fdnotes", (Object)discNotes);
            this.request.setAttribute("eventDefinitionsScheduled", (Object)eventDefinitionsScheduled);
            this.setInputMessages(new HashMap());
            this.forwardPage(Page.CREATE_NEW_STUDY_EVENT);
        } else {
            int i;
            String dateCheck2 = this.request.getParameter("startDate");
            String endCheck2 = this.request.getParameter("endDate");
            logger.debug(dateCheck2 + "; " + endCheck2);
            String strEnd = this.fp.getDateTimeInputString("end");
            String[] strEndScheduled = new String[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                strEndScheduled[i2] = this.fp.getDateTimeInputString(INPUT_ENDDATE_PREFIX_SCHEDULED[i2]);
            }
            Date start = this.getInputStartDate();
            Date end = null;
            Date[] startScheduled = new Date[4];
            for (int i3 = 0; i3 < 4; ++i3) {
                startScheduled[i3] = this.getInputStartDateScheduled(i3);
            }
            Date[] endScheduled = new Date[4];
            discNotes = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
            if (discNotes == null) {
                discNotes = new FormDiscrepancyNotes();
                this.session.setAttribute("fdnotes", (Object)discNotes);
            }
            DiscrepancyValidator v = new DiscrepancyValidator(this.request, discNotes);
            v.addValidation("start", 21);
            v.alwaysExecuteLastValidation("start");
            if (!strEnd.equals("")) {
                v.addValidation("end", 21);
                v.alwaysExecuteLastValidation("end");
            }
            v.addValidation("studyEventDefinition", 19, (AuditableEntityDAO)seddao, studyWithEventDefinitions);
            v.addValidation("studySubjectLabel", 1);
            v.addValidation("location", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
            if (this.currentStudy.getStudyParameterConfig().getEventLocationRequired().equalsIgnoreCase("required")) {
                v.addValidation("location", 1);
            }
            v.alwaysExecuteLastValidation("location");
            boolean hasScheduledEvent = false;
            for (int i4 = 0; i4 < 4; ++i4) {
                String studyEventDef = this.fp.getString(INPUT_STUDY_EVENT_DEFINITION_SCHEDULED[i4]);
                if (studyEventDef != null && !studyEventDef.trim().isEmpty()) {
                    v.addValidation(INPUT_STUDY_EVENT_DEFINITION_SCHEDULED[i4], 19, (AuditableEntityDAO)seddao, studyWithEventDefinitions);
                    if (this.currentStudy.getStudyParameterConfig().getEventLocationRequired().equalsIgnoreCase("required")) {
                        v.addValidation(INPUT_SCHEDULED_LOCATION[i4], 1);
                        v.addValidation(INPUT_SCHEDULED_LOCATION[i4], 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
                        v.alwaysExecuteLastValidation(INPUT_SCHEDULED_LOCATION[i4]);
                    }
                    v.addValidation(INPUT_STARTDATE_PREFIX_SCHEDULED[i4], 21);
                    v.alwaysExecuteLastValidation(INPUT_STARTDATE_PREFIX_SCHEDULED[i4]);
                    if (!strEndScheduled[i4].equals("")) {
                        v.addValidation(INPUT_ENDDATE_PREFIX_SCHEDULED[i4], 21);
                        v.alwaysExecuteLastValidation(INPUT_ENDDATE_PREFIX_SCHEDULED[i4]);
                    }
                    hasScheduledEvent = true;
                    this.fp.addPresetValue(DISPLAY_SCHEDULED[i4], "all");
                    continue;
                }
                this.fp.addPresetValue(DISPLAY_SCHEDULED[i4], "none");
            }
            HashMap errors = v.validate();
            String location = resword.getString("location");
            String inputLocation = this.fp.getString("location");
            if (inputLocation != null && !inputLocation.trim().isEmpty() && inputLocation.equalsIgnoreCase(location)) {
                Validator.addError((HashMap)errors, (String)"location", (String)restext.getString("not_a_valid_location"));
            }
            StudyEventDefinitionBean definition = seddao.findByPK(this.fp.getInt("studyEventDefinition"));
            StudySubjectBean studySubject = sdao.findByLabelAndStudy(this.fp.getString("studySubjectLabel"), this.currentStudy);
            if (this.request.getAttribute("studySubject") != null) {
                studySubject = (StudySubjectBean)this.request.getAttribute("studySubject");
            }
            if (studySubject.getLabel() == "") {
                Validator.addError((HashMap)errors, (String)"studySubject", (String)respage.getString("must_enter_subject_ID_for_identifying"));
            }
            if (!CreateNewStudyEventServlet.subjectMayReceiveStudyEvent((DataSource)this.sm.getDataSource(), (StudyEventDefinitionBean)definition, (StudySubjectBean)studySubject)) {
                Validator.addError((HashMap)errors, (String)"studyEventDefinition", (String)restext.getString("not_added_since_event_not_repeating"));
            }
            ArrayList<StudyEventDefinitionBean> definitionScheduleds = new ArrayList<StudyEventDefinitionBean>();
            int[] scheduledDefinitionIds = new int[4];
            if (hasScheduledEvent) {
                for (int i5 = 0; i5 < 4; ++i5) {
                    int pk = this.fp.getInt(INPUT_STUDY_EVENT_DEFINITION_SCHEDULED[i5]);
                    if (pk > 0) {
                        StudyEventDefinitionBean sedb = seddao.findByPK(pk);
                        logger.debug("scheduled def:" + pk + " " + INPUT_STUDY_EVENT_DEFINITION_SCHEDULED[i5] + " " + sedb.getName());
                        definitionScheduleds.add(sedb);
                        scheduledDefinitionIds[i5] = pk;
                        if (CreateNewStudyEventServlet.subjectMayReceiveStudyEvent((DataSource)this.sm.getDataSource(), (StudyEventDefinitionBean)sedb, (StudySubjectBean)studySubject)) continue;
                        Validator.addError((HashMap)errors, (String)INPUT_STUDY_EVENT_DEFINITION_SCHEDULED[i5], (String)restext.getString("not_added_since_event_not_repeating"));
                        continue;
                    }
                    definitionScheduleds.add(new StudyEventDefinitionBean());
                }
            }
            if (!("".equals(strEnd) || errors.containsKey("start") || errors.containsKey("end"))) {
                end = this.getInputEndDate();
                if (!this.fp.getString("startDate").equals(this.fp.getString("endDate"))) {
                    if (end.before(start)) {
                        Validator.addError((HashMap)errors, (String)"end", (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
                    }
                } else if (this.fp.timeEntered("start") && this.fp.timeEntered("end") && (end.before(start) || end.equals(start))) {
                    Validator.addError((HashMap)errors, (String)"end", (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
                }
            }
            String prevStartPrefix = "start";
            TreeSet<Integer> pickedSeds = new TreeSet<Integer>();
            pickedSeds.add(studyEventDefinitionId);
            HashMap<Integer, Integer> scheduledSeds = new HashMap<Integer, Integer>();
            scheduledSeds.put(studyEventDefinitionId, -1);
            for (i = 0; i < 4; ++i) {
                String prevEndPrefix;
                if (scheduledDefinitionIds[i] <= 0 || errors.containsKey(INPUT_STARTDATE_PREFIX_SCHEDULED[i]) || errors.containsKey(INPUT_ENDDATE_PREFIX_SCHEDULED[i])) continue;
                if (scheduledSeds.containsKey(scheduledDefinitionIds[i])) {
                    Date prevStartDate;
                    int prevStart = (Integer)scheduledSeds.get(scheduledDefinitionIds[i]);
                    prevStartPrefix = prevStart == -1 ? "start" : INPUT_STARTDATE_PREFIX_SCHEDULED[prevStart];
                    Date date = prevStartDate = prevStart == -1 ? this.getInputStartDate() : this.getInputStartDateScheduled(Integer.parseInt(prevStartPrefix.charAt(prevStartPrefix.length() - 1) + ""));
                    if (this.fp.getString(INPUT_STARTDATE_PREFIX_SCHEDULED[i] + "Date").equals(this.fp.getString(prevStartPrefix + "Date"))) {
                        boolean schStartTime = this.fp.timeEntered(INPUT_STARTDATE_PREFIX_SCHEDULED[i]);
                        boolean startTime = this.fp.timeEntered(prevStartPrefix);
                        if (schStartTime && startTime && startScheduled[i].before(prevStartDate)) {
                            Validator.addError((HashMap)errors, (String)INPUT_STARTDATE_PREFIX_SCHEDULED[i], (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
                        }
                    } else if (startScheduled[i].before(prevStartDate)) {
                        Validator.addError((HashMap)errors, (String)INPUT_STARTDATE_PREFIX_SCHEDULED[i], (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
                    }
                }
                scheduledSeds.put(scheduledDefinitionIds[i], i);
                if (strEndScheduled[i].equals("")) continue;
                endScheduled[i] = this.fp.getDateTime(INPUT_ENDDATE_PREFIX_SCHEDULED[i]);
                String string = prevEndPrefix = i > 0 ? INPUT_ENDDATE_PREFIX_SCHEDULED[i - 1] : "end";
                if (!this.fp.getString(INPUT_STARTDATE_PREFIX_SCHEDULED[i] + "Date").equals(this.fp.getString(prevEndPrefix + "Date"))) {
                    if (!endScheduled[i].before(startScheduled[i])) continue;
                    Validator.addError((HashMap)errors, (String)INPUT_ENDDATE_PREFIX_SCHEDULED[i], (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
                    continue;
                }
                if (!this.fp.timeEntered(INPUT_STARTDATE_PREFIX_SCHEDULED[i]) || !this.fp.timeEntered(INPUT_ENDDATE_PREFIX_SCHEDULED[i]) || !endScheduled[i].before(startScheduled[i]) && !endScheduled[i].equals(startScheduled[i])) continue;
                Validator.addError((HashMap)errors, (String)INPUT_ENDDATE_PREFIX_SCHEDULED[i], (String)resexception.getString("input_provided_not_occure_after_previous_start_date_time"));
            }
            logger.error("we have errors; number of this; " + errors.size());
            if (!errors.isEmpty()) {
                int i6;
                logger.debug("we have errors; number of this; " + errors.size());
                logger.error("found request study subject: " + this.fp.getString("requestStudySubject"));
                this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                this.setInputMessages(errors);
                this.fp.addPresetValue("studyEventDefinition", (EntityBean)definition);
                this.fp.addPresetValue("studySubject", (EntityBean)studySubject);
                this.fp.addPresetValue("studySubjectLabel", this.fp.getString("studySubjectLabel"));
                this.fp.addPresetValue("requestStudySubject", this.fp.getString("requestStudySubject"));
                this.fp.addPresetValue("location", inputLocation);
                for (i = 0; i < 4; ++i) {
                    this.fp.addPresetValue(INPUT_SCHEDULED_LOCATION[i], this.fp.getString(INPUT_SCHEDULED_LOCATION[i]));
                }
                String[] prefixes = new String[10];
                prefixes[0] = "start";
                prefixes[1] = "end";
                int b = 6;
                for (i6 = 2; i6 < b; ++i6) {
                    prefixes[i6] = INPUT_STARTDATE_PREFIX_SCHEDULED[i6 - 2];
                }
                for (i6 = b; i6 < 4 + b; ++i6) {
                    prefixes[i6] = INPUT_ENDDATE_PREFIX_SCHEDULED[i6 - b];
                }
                this.fp.setCurrentDateTimeValuesAsPreset(prefixes);
                if (hasScheduledEvent) {
                    for (i6 = 0; i6 < 4; ++i6) {
                        this.fp.addPresetValue(INPUT_STUDY_EVENT_DEFINITION_SCHEDULED[i6], (EntityBean)definitionScheduleds.get(i6));
                    }
                }
                this.setPresetValues(this.fp.getPresetValues());
                this.setupBeans(eventDefinitions);
                this.request.setAttribute("eventDefinitionsScheduled", (Object)eventDefinitionsScheduled);
                this.forwardPage(Page.CREATE_NEW_STUDY_EVENT);
            } else {
                String[] eventFields;
                logger.debug("error is empty");
                StudyEventDAO sed = new StudyEventDAO(this.sm.getDataSource());
                StudyEventBean studyEvent = new StudyEventBean();
                studyEvent.setStudyEventDefinitionId(definition.getId());
                studyEvent.setStudySubjectId(studySubject.getId());
                if ("-1".equals(this.getInputStartHour()) && "-1".equals(this.getInputStartMinute()) && "".equals(this.getInputStartHalf())) {
                    studyEvent.setStartTimeFlag(false);
                } else {
                    studyEvent.setStartTimeFlag(true);
                }
                studyEvent.setDateStarted(start);
                logger.debug("found start date: " + this.local_df.format(start));
                Date[] startScheduled2 = new Date[4];
                for (int i7 = 0; i7 < 4; ++i7) {
                    startScheduled2[i7] = this.getInputStartDateScheduled(i7);
                }
                if (!"".equals(strEnd)) {
                    if ("-1".equals(this.getInputEndHour()) && "-1".equals(this.getInputEndMinute()) && "".equals(this.getInputEndHalf())) {
                        studyEvent.setEndTimeFlag(false);
                    } else {
                        studyEvent.setEndTimeFlag(true);
                    }
                    studyEvent.setDateEnded(end);
                }
                studyEvent.setOwner(this.ub);
                studyEvent.setStatus(Status.AVAILABLE);
                studyEvent.setLocation(inputLocation);
                studyEvent.setSubjectEventStatus(SubjectEventStatus.SCHEDULED);
                studyEvent.setSampleOrdinal(sed.getMaxSampleOrdinal(definition, studySubject) + 1);
                studyEvent = sed.create(studyEvent);
                if (!studyEvent.isActive()) {
                    throw new OpenClinicaException(restext.getString("event_not_created_in_database"), "2");
                }
                this.addPageMessage(restext.getString("X_event_wiht_definition") + definition.getName() + restext.getString("X_and_subject") + studySubject.getName() + respage.getString("X_was_created_succesfully"));
                FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
                DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                for (String element : eventFields = new String[]{"location", "start", "end"}) {
                    AddNewSubjectServlet.saveFieldNotes((String)element, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEvent.getId(), (String)"studyEvent", (StudyBean)this.currentStudy);
                }
                if (hasScheduledEvent) {
                    for (int i8 = 0; i8 < 4; ++i8) {
                        if (scheduledDefinitionIds[i8] <= 0) continue;
                        if (CreateNewStudyEventServlet.subjectMayReceiveStudyEvent((DataSource)this.sm.getDataSource(), (StudyEventDefinitionBean)((StudyEventDefinitionBean)definitionScheduleds.get(i8)), (StudySubjectBean)studySubject)) {
                            StudyEventBean studyEventScheduled = new StudyEventBean();
                            studyEventScheduled.setStudyEventDefinitionId(scheduledDefinitionIds[i8]);
                            studyEventScheduled.setStudySubjectId(studySubject.getId());
                            if ("-1".equals(this.fp.getString(INPUT_STARTDATE_PREFIX_SCHEDULED[i8] + "Hour")) && "-1".equals(this.fp.getString(INPUT_STARTDATE_PREFIX_SCHEDULED[i8] + "Minute")) && "".equals(this.fp.getString(INPUT_STARTDATE_PREFIX_SCHEDULED[i8] + "Half"))) {
                                studyEventScheduled.setStartTimeFlag(false);
                            } else {
                                studyEventScheduled.setStartTimeFlag(true);
                            }
                            studyEventScheduled.setDateStarted(startScheduled[i8]);
                            if (!"".equals(strEndScheduled[i8])) {
                                endScheduled[i8] = this.fp.getDateTime(INPUT_ENDDATE_PREFIX_SCHEDULED[i8]);
                                if ("-1".equals(this.fp.getString(INPUT_ENDDATE_PREFIX_SCHEDULED[i8] + "Hour")) && "-1".equals(this.fp.getString(INPUT_ENDDATE_PREFIX_SCHEDULED[i8] + "Minute")) && "".equals(this.fp.getString(INPUT_ENDDATE_PREFIX_SCHEDULED[i8] + "Half"))) {
                                    studyEventScheduled.setEndTimeFlag(false);
                                } else {
                                    studyEventScheduled.setEndTimeFlag(true);
                                }
                            }
                            studyEventScheduled.setDateEnded(endScheduled[i8]);
                            studyEventScheduled.setOwner(this.ub);
                            studyEventScheduled.setStatus(Status.AVAILABLE);
                            studyEventScheduled.setLocation(this.fp.getString(INPUT_SCHEDULED_LOCATION[i8]));
                            studyEvent.setSubjectEventStatus(SubjectEventStatus.SCHEDULED);
                            studyEventScheduled.setSampleOrdinal(sed.getMaxSampleOrdinal((StudyEventDefinitionBean)definitionScheduleds.get(i8), studySubject) + 1);
                            studyEventScheduled = sed.create(studyEventScheduled);
                            if (!studyEventScheduled.isActive()) {
                                throw new OpenClinicaException(restext.getString("scheduled_event_not_created_in_database"), "2");
                            }
                            AddNewSubjectServlet.saveFieldNotes((String)INPUT_SCHEDULED_LOCATION[i8], (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEventScheduled.getId(), (String)"studyEvent", (StudyBean)this.currentStudy);
                            AddNewSubjectServlet.saveFieldNotes((String)INPUT_STARTDATE_PREFIX_SCHEDULED[i8], (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEventScheduled.getId(), (String)"studyEvent", (StudyBean)this.currentStudy);
                            AddNewSubjectServlet.saveFieldNotes((String)INPUT_ENDDATE_PREFIX_SCHEDULED[i8], (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)studyEventScheduled.getId(), (String)"studyEvent", (StudyBean)this.currentStudy);
                            continue;
                        }
                        this.addPageMessage(restext.getString("scheduled_event_definition") + ((StudyEventDefinitionBean)definitionScheduleds.get(i8)).getName() + restext.getString("X_and_subject") + studySubject.getName() + restext.getString("not_created_since_event_not_repeating") + restext.getString("event_type_already_exists"));
                    }
                }
                this.session.removeAttribute("fdnotes");
                this.request.setAttribute("eventId", (Object)String.valueOf(studyEvent.getId()));
                ArrayList pMessage = ClassCastHelper.asArrayList((Object)this.request.getAttribute("pageMessages"), String.class);
                String url = this.response.encodeRedirectURL("EnterDataForStudyEvent?eventId=" + studyEvent.getId() + "&alertmessage=" + URLEncoder.encode((String)pMessage.get(0), "UTF-8"));
                this.response.sendRedirect(url);
                return;
            }
        }
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        String exceptionName = resexception.getString("no_permission_to_add_new_study_event");
        String noAccessMessage = respage.getString("not_create_new_event") + " " + respage.getString("change_study_contact_sysadmin");
        if (SubmitDataServlet.maySubmitData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(noAccessMessage);
        throw new InsufficientPermissionException(Page.MENU_SERVLET, exceptionName, "1");
    }

    public static boolean subjectMayReceiveStudyEvent(DataSource ds, StudyEventDefinitionBean studyEventDefinition, StudySubjectBean studySubject) {
        if (studyEventDefinition.isRepeating()) {
            return true;
        }
        StudyEventDAO sedao = new StudyEventDAO(ds);
        ArrayList allEvents = sedao.findAllByDefinitionAndSubject(studyEventDefinition, studySubject);
        return allEvents.size() <= 0;
    }

    private void setupBeans(ArrayList<?> eventDefinitions) throws Exception {
        this.addEntityList("eventDefinitions", eventDefinitions, restext.getString("cannot_create_event_because_no_event_definitions"), Page.LIST_STUDY_SUBJECTS_SERVLET);
    }

    private Date getInputStartDate() {
        return this.fp.getDateTime("start");
    }

    private Date getInputStartDateScheduled(int i) {
        return this.fp.getDateTime(INPUT_STARTDATE_PREFIX_SCHEDULED[i]);
    }

    private Date getInputEndDate() {
        return this.fp.getDateTime("end");
    }

    private String getInputStartHour() {
        return this.fp.getString("startHour");
    }

    private String getInputStartMinute() {
        return this.fp.getString("startMinute");
    }

    private String getInputStartHalf() {
        return this.fp.getString("startHalf");
    }

    private String getInputEndHour() {
        return this.fp.getString("endHour");
    }

    private String getInputEndMinute() {
        return this.fp.getString("endMinute");
    }

    private String getInputEndHalf() {
        return this.fp.getString("endHalf");
    }
}

