/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.AuditBean;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.AuditableEntityBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.NullValue;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplayItemWithGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.DisplayTableOfContentsBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.bean.submit.SCDItemDisplayInfo;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.CoreSecureController;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.RuleValidator;
import org.akaza.openclinica.control.form.ScoreItemValidator;
import org.akaza.openclinica.control.form.Validation;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.AddNewSubjectServlet;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.control.submit.TableOfContentsServlet;
import org.akaza.openclinica.control.submit.VariableSubstitutionHelper;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.domain.rule.action.RuleActionRunBean;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.logic.expressionTree.ExpressionTreeHelper;
import org.akaza.openclinica.logic.rulerunner.MessageContainer;
import org.akaza.openclinica.logic.score.ScoreCalculator;
import org.akaza.openclinica.service.DiscrepancyNoteThread;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.service.crfdata.DynamicsMetadataService;
import org.akaza.openclinica.service.crfdata.InstantOnChangeService;
import org.akaza.openclinica.service.crfdata.SimpleConditionalDisplayService;
import org.akaza.openclinica.service.crfdata.front.InstantOnChangeFrontStrParcel;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.view.form.DataEntryInputGenerator;
import org.akaza.openclinica.view.form.FormBeanUtil;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public abstract class DataEntryServlet
extends CoreSecureController {
    private static final long serialVersionUID = -7746736869624506259L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataEntryServlet.class);
    Locale locale;
    public static final String INPUT_EVENT_CRF_ID = "eventCRFId";
    public static final String INPUT_SECTION_ID = "sectionId";
    public static final String INPUT_EVENT_CRF = "event";
    public static final String INPUT_SECTION = "section";
    public static final String INPUT_IGNORE_PARAMETERS = "ignore";
    public static final String INPUT_CHECK_INPUTS = "checkInputs";
    public static final String INPUT_ANNOTATIONS = "annotations";
    public static final String BEAN_ANNOTATIONS = "annotations";
    public static final String RESUME_LATER = "submittedResume";
    public static final String GO_PREVIOUS = "submittedPrev";
    public static final String GO_NEXT = "submittedNext";
    public static final String BEAN_DISPLAY = "section";
    public static final String TOC_DISPLAY = "toc";
    public static final String INPUT_INTERVIEWER = "interviewer";
    public static final String INPUT_INTERVIEW_DATE = "interviewDate";
    public static final String INTERVIEWER_NAME_NOTE = "InterviewerNameNote";
    public static final String INTERVIEWER_DATE_NOTE = "InterviewerDateNote";
    public static final String INPUT_TAB = "tabId";
    public static final String INPUT_MARK_COMPLETE = "markComplete";
    public static final String VALUE_YES = "Yes";
    public static final String INPUT_EVENT_DEFINITION_CRF_ID = "eventDefinitionCRFId";
    public static final String INPUT_CRF_VERSION_ID = "crfVersionId";
    public static final String INPUT_STUDY_EVENT_ID = "studyEventId";
    public static final String INPUT_SUBJECT_ID = "subjectId";
    public static final String GO_EXIT = "submittedExit";
    public static final String GROUP_HAS_DATA = "groupHasData";
    public static final String HAS_DATA_FLAG = "hasDataFlag";
    public static final String DDE_PROGESS = "doubleDataProgress";
    public static final String INTERVIEWER_NAME = "interviewer_name";
    public static final String DATE_INTERVIEWED = "date_interviewed";
    public static final String NOTE_SUBMITTED = "note_submitted";
    public static final String SECTION_BEAN = "section_bean";
    public static final String ALL_SECTION_BEANS = "all_section_bean";
    public static final String EVENT_DEF_CRF_BEAN = "event_def_crf_bean";
    public static final String ALL_ITEMS_LIST = "all_items_list";
    public static final String CV_INSTANT_META = "cvInstantMeta";
    private DataSource dataSource;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            ServletContext context = this.getServletContext();
            SessionManager sm = new SessionManager(SpringServletAccess.getApplicationContext((ServletContext)context));
            this.dataSource = sm.getDataSource();
        }
        catch (Exception ne) {
            LOGGER.error("Servlet context is not working properly: ", (Throwable)ne);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected abstract void mayProceed(HttpServletRequest var1, HttpServletResponse var2) throws InsufficientPermissionException;

    private String getSectionFirstFieldId(int sectionId) {
        ItemDAO itemDAO = new ItemDAO(this.getDataSource());
        ArrayList items = itemDAO.findAllBySectionId(sectionId);
        if (!items.isEmpty()) {
            return new Integer(((ItemBean)items.get(0)).getId()).toString();
        }
        return "";
    }

    private void logMe(String message) {
        LOGGER.trace(message);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String interviewDate;
        ItemFormMetadataBean ifmb;
        DisplayItemBean dib;
        HashMap newUploadedFiles;
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        SectionBean sb = (SectionBean)request.getAttribute(SECTION_BEAN);
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        HttpSession session = request.getSession();
        StudyBean currentStudy = (StudyBean)session.getAttribute("study");
        boolean isSubmitted = false;
        boolean hasGroup = false;
        EventCRFDAO ecdao = null;
        FormProcessor fp = new FormProcessor(request);
        this.logMe("Enterting DataEntry Servlet" + System.currentTimeMillis());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.getDataSource());
        this.panel.setStudyInfoShown(false);
        String age = "";
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        String instantAtt = CV_INSTANT_META + ecb.getCRFVersionId();
        int isFirstTimeOnSection = fp.getInt("isFirstTimeOnSection");
        request.setAttribute("isFirstTimeOnSection", (Object)(isFirstTimeOnSection + ""));
        if (this.getCrfLocker().isLocked(ecb.getId())) {
            int userId = this.getCrfLocker().getLockOwner(ecb.getId());
            UserAccountDAO udao = new UserAccountDAO(this.getDataSource());
            UserAccountBean ubean = udao.findByPK(userId);
            if (ubean.getId() != ub.getId()) {
                this.addPageMessage(resword.getString("CRF_unavailable") + " " + ubean.getName() + " " + resword.getString("Currently_entering_data") + " " + resword.getString("Leave_the_CRF"), request);
                this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET, request, response);
            }
        } else {
            this.getCrfLocker().lock(ecb.getId(), ub.getId());
        }
        if (!ecb.isActive()) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("event_not_exists"));
        }
        this.logMe("Enterting DataEntry Get the status/number of item discrepancy notes" + System.currentTimeMillis());
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
        ArrayList allNotes = new ArrayList();
        ArrayList eventCrfNotes = new ArrayList();
        List noteThreads = new ArrayList();
        dndao = new DiscrepancyNoteDAO(this.getDataSource());
        allNotes = dndao.findAllTopNotesByEventCRF(ecb.getId());
        eventCrfNotes = dndao.findOnlyParentEventCRFDNotesFromEventCRF(ecb);
        if (!eventCrfNotes.isEmpty()) {
            allNotes.addAll(eventCrfNotes);
        }
        this.logMe("Entering DataEntry Create disc note threads out of the various notes" + System.currentTimeMillis());
        DiscrepancyNoteUtil dNoteUtil = new DiscrepancyNoteUtil();
        noteThreads = dNoteUtil.createThreadsOfParents((List)allNotes, this.getDataSource(), currentStudy, null, -1, true);
        int updatedNum = 0;
        int openNum = 0;
        int closedNum = 0;
        int resolvedNum = 0;
        int notAppNum = 0;
        for (DiscrepancyNoteThread dnThread : noteThreads) {
            DiscrepancyNoteBean tempBean = (DiscrepancyNoteBean)dnThread.getLinkedNoteList().getLast();
            if (tempBean == null) continue;
            if (ResolutionStatus.UPDATED.equals((Term)tempBean.getResStatus())) {
                ++updatedNum;
                continue;
            }
            if (ResolutionStatus.OPEN.equals((Term)tempBean.getResStatus())) {
                ++openNum;
                continue;
            }
            if (ResolutionStatus.CLOSED.equals((Term)tempBean.getResStatus())) {
                ++closedNum;
                continue;
            }
            if (ResolutionStatus.RESOLVED.equals((Term)tempBean.getResStatus())) {
                ++resolvedNum;
                continue;
            }
            if (!ResolutionStatus.NOT_APPLICABLE.equals((Term)tempBean.getResStatus())) continue;
            ++notAppNum;
        }
        this.logMe("Entering DataEntry Create disc note threads out of the various notes DONE" + System.currentTimeMillis());
        request.setAttribute("updatedNum", (Object)(updatedNum + ""));
        request.setAttribute("openNum", (Object)(openNum + ""));
        request.setAttribute("closedNum", (Object)(closedNum + ""));
        request.setAttribute("resolvedNum", (Object)(resolvedNum + ""));
        request.setAttribute("notAppNum", (Object)(notAppNum + ""));
        String fromViewNotes = fp.getString("fromViewNotes");
        if (fromViewNotes != null && "1".equals(fromViewNotes)) {
            request.setAttribute("fromViewNotes", (Object)fromViewNotes);
        }
        this.logMe("Entering Create studySubjDao.. ++++stuff" + System.currentTimeMillis());
        StudySubjectDAO ssdao = new StudySubjectDAO(this.getDataSource());
        StudySubjectBean ssb = ssdao.findByPK(ecb.getStudySubjectId());
        Status s = ssb.getStatus();
        if ("removed".equalsIgnoreCase(s.getName()) || "auto-removed".equalsIgnoreCase(s.getName())) {
            this.addPageMessage(respage.getString("you_may_not_perform_data_entry_on_a_CRF") + respage.getString("study_subject_has_been_deleted"), request);
            request.setAttribute("id", (Object)new Integer(ecb.getStudySubjectId()).toString());
            session.removeAttribute(instantAtt);
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET, request, response);
        }
        if ((newUploadedFiles = ClassCastHelper.asHashMap((Object)session.getAttribute("newUploadedFiles"), String.class, String.class)) == null) {
            newUploadedFiles = new HashMap();
        }
        request.setAttribute("newUploadedFiles", newUploadedFiles);
        if (!fp.getString("exitTo").equals("")) {
            request.setAttribute("exitTo", (Object)fp.getString("exitTo"));
        }
        this.logMe("Entering some EVENT CRF CHECK" + System.currentTimeMillis());
        if (!fp.getString(GO_EXIT).equals("")) {
            session.removeAttribute(GROUP_HAS_DATA);
            session.removeAttribute("to_create_crf");
            session.removeAttribute("mayProcessUploading");
            if (this.getCrfLocker().isLocked(ecb.getId()) && this.getCrfLocker().getLockOwner(ecb.getId()).intValue() == ub.getId()) {
                this.getCrfLocker().unlock(ecb.getId());
            }
            if (newUploadedFiles.size() > 0 && !this.unloadFiles(newUploadedFiles)) {
                String missed = newUploadedFiles.keySet().stream().collect(Collectors.joining(" "));
                this.addPageMessage(respage.getString("uploaded_files_not_deleted_or_not_exist") + ": " + missed, request);
            }
            session.removeAttribute("newUploadedFiles");
            this.addPageMessage(respage.getString("exit_without_saving"), request);
            if (fromViewNotes != null && "1".equals(fromViewNotes)) {
                String viewNotesURL = (String)session.getAttribute("viewNotesURL");
                if (viewNotesURL != null && viewNotesURL.length() > 0) {
                    response.sendRedirect(response.encodeRedirectURL(viewNotesURL));
                }
                return;
            }
            String fromResolvingNotes = fp.getString("fromResolvingNotes", true);
            String winLocation = (String)session.getAttribute("window_location");
            session.removeAttribute(instantAtt);
            if (fromResolvingNotes != null && !fromResolvingNotes.trim().isEmpty() && winLocation != null && !winLocation.trim().isEmpty()) {
                response.sendRedirect(response.encodeRedirectURL(winLocation));
            } else if (!fp.getString("exitTo").equals("")) {
                response.sendRedirect(response.encodeRedirectURL(fp.getString("exitTo")));
            } else {
                response.sendRedirect(response.encodeRedirectURL("ListStudySubjects"));
            }
            return;
        }
        this.logMe("Entering some EVENT CRF CHECK DONE" + System.currentTimeMillis());
        hasGroup = this.checkGroups(fp, ecb);
        Boolean b = (Boolean)request.getAttribute(INPUT_IGNORE_PARAMETERS);
        isSubmitted = fp.isSubmitted() && b == null;
        int eventDefinitionCRFId = 0;
        if (fp != null) {
            eventDefinitionCRFId = fp.getInt(INPUT_EVENT_DEFINITION_CRF_ID);
        }
        StudyBean study = (StudyBean)session.getAttribute("study");
        this.logMe("Entering some EVENT DEF CRF CHECK " + System.currentTimeMillis());
        if (eventDefinitionCRFId <= 0) {
            EventDefinitionCRFBean edcBean = edcdao.findByStudyEventIdAndCRFVersionId(study, ecb.getStudyEventId(), ecb.getCRFVersionId());
            eventDefinitionCRFId = edcBean.getId();
        }
        this.logMe("Entering some EVENT DEF CRF CHECK DONE " + System.currentTimeMillis());
        this.logMe("Entering some Study EVENT DEF CRF CHECK  " + System.currentTimeMillis());
        StudyEventDAO seDao = new StudyEventDAO(this.getDataSource());
        EventDefinitionCRFBean edcBean = (EventDefinitionCRFBean)edcdao.findByPK(eventDefinitionCRFId);
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)edcdao.findByPK(eventDefinitionCRFId);
        request.setAttribute(EVENT_DEF_CRF_BEAN, (Object)edcb);
        StudyEventBean studyEventBean = seDao.findByPK(ecb.getStudyEventId());
        edcBean.setId(eventDefinitionCRFId);
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.getDataSource());
        StudyEventDefinitionBean studyEventDefinition = seddao.findByPK(edcBean.getStudyEventDefinitionId());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.getDataSource());
        CRFVersionBean crfVersionBean = cvdao.findByPK(ecb.getCRFVersionId());
        RuleActionRunBean.Phase phase2 = RuleActionRunBean.Phase.INITIAL_DATA_ENTRY;
        if (this.getServletPage(request).startsWith(Page.DOUBLE_DATA_ENTRY_SERVLET.getFileName())) {
            phase2 = RuleActionRunBean.Phase.DOUBLE_DATA_ENTRY;
        } else if (this.getServletPage(request).startsWith(Page.ADMIN_EDIT_SERVLET.getFileName())) {
            phase2 = RuleActionRunBean.Phase.ADMIN_EDITING;
        }
        this.logMe("Entering ruleSets::: CreateAndInitializeRuleSet:::" + Thread.currentThread());
        this.logMe("Entering ruleSets::: CreateAndInitializeRuleSet:::" + Thread.currentThread() + "currentStudy?" + currentStudy + "studyEventDefinition" + studyEventDefinition + "crfVersionBean" + crfVersionBean + "studyEventBean" + studyEventBean + "ecb" + ecb);
        this.logMe("Entering getDisplayBean:::::Thread::::" + Thread.currentThread());
        DisplaySectionBean section = this.getDisplayBean(hasGroup, false, request, isSubmitted);
        VariableSubstitutionHelper.replaceVariables((DisplaySectionBean)section, (StudyBean)study, (StudySubjectBean)ssb, (StudyEventDefinitionBean)studyEventDefinition, (StudyEventBean)studyEventBean, (DataSource)this.dataSource);
        if (section.getSection().hasSCDItem()) {
            SimpleConditionalDisplayService cds0 = (SimpleConditionalDisplayService)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("simpleConditionalDisplayService");
            section = cds0.initConditionalDisplays(section);
        }
        this.logMe("Entering  Find out the id of the section's first field " + System.currentTimeMillis());
        String firstFieldId = this.getSectionFirstFieldId(section.getSection().getId());
        request.setAttribute("formFirstField", (Object)firstFieldId);
        this.logMe("Entering  displayItemWithGroups " + System.currentTimeMillis());
        List displayItemWithGroups = this.createItemWithGroups(section, hasGroup, eventDefinitionCRFId, request, isSubmitted);
        this.logMe("Entering  displayItemWithGroups end " + System.currentTimeMillis());
        this.getItemMetadataService().updateGroupDynamicsInSection(displayItemWithGroups, section.getSection().getId(), ecb);
        section.setDisplayItemGroups(displayItemWithGroups);
        DisplayTableOfContentsBean toc = TableOfContentsServlet.getDisplayBeanWithShownSections((DataSource)this.getDataSource(), (DisplayTableOfContentsBean)((DisplayTableOfContentsBean)request.getAttribute(TOC_DISPLAY)), (DynamicsMetadataService)((DynamicsMetadataService)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("dynamicsMetadataService")));
        request.setAttribute(TOC_DISPLAY, (Object)toc);
        LinkedList sectionIdsInToc = TableOfContentsServlet.sectionIdsInToc((DisplayTableOfContentsBean)toc);
        this.logMe("Entering  displayItemWithGroups sdao.findPrevious  " + System.currentTimeMillis());
        int sIndex = TableOfContentsServlet.sectionIndexInToc((SectionBean)section.getSection(), (DisplayTableOfContentsBean)toc, (LinkedList)sectionIdsInToc);
        SectionBean previousSec = this.prevSection(section.getSection(), ecb, toc, sIndex);
        this.logMe("Entering  displayItemWithGroups sdao.findPrevious  end " + System.currentTimeMillis());
        SectionBean nextSec = this.nextSection(section.getSection(), ecb, toc, sIndex);
        section.setFirstSection(!previousSec.isActive());
        section.setLastSection(!nextSec.isActive());
        SubjectDAO subjectDao = new SubjectDAO(this.getDataSource());
        StudyDAO studydao = new StudyDAO(this.getDataSource());
        SubjectBean subject = subjectDao.findByPK(ssb.getSubjectId());
        this.logMe("Entering  Get the study then the parent study   " + System.currentTimeMillis());
        if (study.getParentStudyId() > 0) {
            StudyBean parentStudy = studydao.findByPK(study.getParentStudyId());
            request.setAttribute("studyTitle", (Object)parentStudy.getName());
            request.setAttribute("siteTitle", (Object)study.getName());
        } else {
            request.setAttribute("studyTitle", (Object)study.getName());
        }
        this.logMe("Entering  Get the study then the parent study end  " + System.currentTimeMillis());
        if (currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
            Date enrollmentDate = ssb.getEnrollmentDate();
            age = Utils.getInstacne().processAge(enrollmentDate, subject.getDateOfBirth());
        }
        request.setAttribute("studySubject", (Object)ssb);
        request.setAttribute("subject", (Object)subject);
        request.setAttribute("eventCRF", (Object)ecb);
        request.setAttribute("age", (Object)age);
        request.setAttribute("decryptedPassword", (Object)((SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("securityManager")).encryptPassword("root", false));
        fp.addPresetValue(INPUT_INTERVIEWER, ecb.getInterviewerName());
        if (ecb.getDateInterviewed() != null) {
            SimpleDateFormat local_df = new SimpleDateFormat(resformat.getString("date_format_string"), ResourceBundleProvider.getLocale());
            String idateFormatted = local_df.format(ecb.getDateInterviewed());
            fp.addPresetValue(INPUT_INTERVIEW_DATE, idateFormatted);
        } else {
            fp.addPresetValue(INPUT_INTERVIEW_DATE, "");
        }
        this.setPresetValues(fp.getPresetValues(), request);
        this.logMe("Entering Checks !submitted  " + System.currentTimeMillis());
        if (!isSubmitted) {
            this.logMe("Entering Checks !submitted entered  " + System.currentTimeMillis());
            long t = System.currentTimeMillis();
            request.setAttribute("section", (Object)section);
            request.setAttribute("annotations", (Object)this.getEventCRFAnnotations(request));
            session.setAttribute("shouldRunValidation", null);
            session.setAttribute("rulesErrors", null);
            session.setAttribute(NOTE_SUBMITTED, null);
            FormDiscrepancyNotes discNotes = new FormDiscrepancyNotes();
            section = this.populateNotesWithDBNoteCounts(discNotes, section, request);
            this.populateInstantOnChange(request.getSession(), ecb, section);
            LOGGER.debug("+++ just ran populateNotes, printing field notes: " + discNotes.getFieldNotes().toString());
            LOGGER.debug("found disc notes: " + discNotes.getNumExistingFieldNotes().toString());
            session.setAttribute("fdnotes", (Object)discNotes);
            if (section.getSection().hasSCDItem()) {
                section = SCDItemDisplayInfo.generateSCDDisplayInfo((DisplaySectionBean)section, (Boolean)(this.getServletPage(request).equals(Page.INITIAL_DATA_ENTRY) || this.getServletPage(request).equals(Page.ADMIN_EDIT_SERVLET) && !this.isAdminForcedReasonForChange(request) ? 1 : 0));
            }
            int keyId = ecb.getId();
            session.removeAttribute("countValidate" + keyId);
            this.setUpPanel(section);
            if (newUploadedFiles.size() > 0 && !this.unloadFiles(newUploadedFiles)) {
                String missed = newUploadedFiles.keySet().stream().collect(Collectors.joining(" "));
                this.addPageMessage(respage.getString("uploaded_files_not_deleted_or_not_exist") + ": " + missed, request);
            }
            this.logMe("Entering Checks !submitted entered end forwarding page " + System.currentTimeMillis());
            this.logMe("Time Took for this block" + (System.currentTimeMillis() - t));
            this.forwardPage(this.getJSPPage(), request, response);
            return;
        }
        this.logMe("Entering Checks !submitted not entered  " + System.currentTimeMillis());
        boolean validate = fp.getBoolean(INPUT_CHECK_INPUTS) && this.validateInputOnFirstRound();
        this.errors = new HashMap();
        FormDiscrepancyNotes discNotes = (FormDiscrepancyNotes)session.getAttribute("fdnotes");
        if (discNotes == null) {
            discNotes = new FormDiscrepancyNotes();
        }
        List allItems = section.getDisplayItemGroups();
        String attachedFilePath = Utils.getAttachedFilePath((StudyBean)currentStudy);
        DiscrepancyValidator v = new DiscrepancyValidator(request, discNotes);
        RuleValidator ruleValidator = new RuleValidator(request);
        LOGGER.debug("SZE 1  :: " + allItems.size());
        this.logMe("Looping inside !submitted  " + System.currentTimeMillis());
        for (int i = 0; i < allItems.size(); ++i) {
            String itemName;
            LOGGER.trace("===itering through items: " + i);
            DisplayItemWithGroupBean diwg = (DisplayItemWithGroupBean)allItems.get(i);
            if (diwg.isInGroup()) {
                DisplayItemGroupBean dgb = diwg.getItemGroup();
                List dbGroups = diwg.getDbItemGroups();
                List formGroups = new ArrayList();
                LOGGER.debug("got db item group size " + dbGroups.size());
                if (validate) {
                    LOGGER.debug("===IF VALIDATE NOT A SINGLE ITEM: got to this part in the validation loop: " + dgb.getGroupMetaBean().getName());
                    formGroups = this.validateDisplayItemGroupBean(v, dgb, dbGroups, formGroups, request, response);
                    LOGGER.debug("form group size after validation " + formGroups.size());
                } else {
                    LOGGER.debug("+++ELSE NOT A SINGLE ITEM: got to this part in the validation loop: " + dgb.getGroupMetaBean().getName());
                    formGroups = this.loadFormValueForItemGroup(dgb, dbGroups, formGroups, eventDefinitionCRFId, request);
                    LOGGER.debug("form group size without validation " + formGroups.size());
                }
                diwg.setItemGroup(dgb);
                diwg.setItemGroups(formGroups);
                allItems.set(i, diwg);
                continue;
            }
            dib = diwg.getSingleItem();
            if (validate) {
                itemName = this.getInputName(dib);
                dib = this.validateDisplayItemBean(v, dib, "", request);
                LOGGER.debug("&&& found name: " + itemName);
                LOGGER.debug("input VALIDATE " + itemName + ": " + fp.getString(itemName));
                LOGGER.debug("input " + itemName + " has a response set of " + dib.getMetadata().getResponseSet().getOptions().size() + " options");
            } else {
                itemName = this.getInputName(dib);
                LOGGER.debug("input NONVALIDATE " + itemName + ": " + fp.getString(itemName));
                dib = this.loadFormValue(dib, request);
            }
            ArrayList children = dib.getChildren();
            for (int j = 0; j < children.size(); ++j) {
                DisplayItemBean child = (DisplayItemBean)children.get(j);
                String itemName2 = this.getInputName(child);
                child.loadFormValue(fp.getString(itemName2));
                child = validate ? this.validateDisplayItemBean(v, child, itemName2, request) : this.loadFormValue(child, request);
                LOGGER.debug("Checking child value for " + itemName2 + ": " + child.getData().getValue());
                children.set(j, child);
            }
            dib.setChildren(children);
            diwg.setSingleItem(this.runDynamicsItemCheck(dib, null, request));
            LOGGER.debug(" I : " + i);
            allItems.set(i, diwg);
        }
        this.logMe("Loop ended  " + System.currentTimeMillis());
        ArrayList<ItemBean> itemBeansWithSCDShown = new ArrayList<ItemBean>();
        if (validate && section.getSection().hasSCDItem()) {
            this.logMe(" Validate and Loop  " + System.currentTimeMillis());
            for (int i = 0; i < allItems.size(); ++i) {
                dib = ((DisplayItemWithGroupBean)allItems.get(i)).getSingleItem();
                ItemFormMetadataBean ifmb2 = dib.getMetadata();
                if (ifmb2.getParentId() != 0) continue;
                if (dib.getScdData().getScdSetsForControl().size() > 0) {
                    section.setShowSCDItemIds(SimpleConditionalDisplayService.conditionalDisplayToBeShown((DisplayItemBean)dib, (Set)section.getShowSCDItemIds()));
                }
                if (dib.getScdData().getScdItemMetadataBean().getScdItemFormMetadataId() > 0) {
                    dib.setIsSCDtoBeShown(section.getShowSCDItemIds().contains(dib.getMetadata().getItemId()));
                    if (dib.getIsSCDtoBeShown()) {
                        itemBeansWithSCDShown.add(dib.getItem());
                    }
                    this.validateSCDItemBean(v, dib);
                }
                ArrayList children = dib.getChildren();
                for (int j = 0; j < children.size(); ++j) {
                    DisplayItemBean child = (DisplayItemBean)children.get(j);
                    if (child.getScdData().getScdSetsForControl().size() > 0) {
                        section.setShowSCDItemIds(SimpleConditionalDisplayService.conditionalDisplayToBeShown((DisplayItemBean)child, (Set)section.getShowSCDItemIds()));
                    }
                    if (child.getScdData().getScdItemMetadataBean().getScdItemFormMetadataId() <= 0) continue;
                    child.setIsSCDtoBeShown(section.getShowSCDItemIds().contains(child.getMetadata().getItemId()));
                    if (child.getIsSCDtoBeShown()) {
                        itemBeansWithSCDShown.add(dib.getItem());
                    }
                    this.validateSCDItemBean(v, child);
                }
            }
            this.logMe(" Validate and Loop end  " + System.currentTimeMillis());
        }
        this.logMe(" Validate and Loop end  " + System.currentTimeMillis());
        List ruleSets = this.createAndInitializeRuleSet(currentStudy, studyEventDefinition, crfVersionBean, studyEventBean, ecb, Boolean.valueOf(true), request, response, itemBeansWithSCDShown);
        boolean shouldRunRules = this.getRuleSetService(request).shouldRunRulesForRuleSets(ruleSets, phase2);
        HashMap groupOrdinalPLusItemOid = null;
        groupOrdinalPLusItemOid = this.runRules(allItems, ruleSets, Boolean.valueOf(true), Boolean.valueOf(shouldRunRules), MessageContainer.MessageType.ERROR, phase2, ecb, request);
        this.logMe("allItems  Loop begin  " + System.currentTimeMillis());
        for (int i = 0; i < allItems.size(); ++i) {
            DisplayItemWithGroupBean diwg = (DisplayItemWithGroupBean)allItems.get(i);
            if (diwg.isInGroup()) {
                DisplayItemGroupBean dgb = diwg.getItemGroup();
                List dbGroups = diwg.getDbItemGroups();
                List formGroups = new ArrayList();
                if (validate) {
                    formGroups = this.validateDisplayItemGroupBean(v, dgb, dbGroups, formGroups, ruleValidator, groupOrdinalPLusItemOid, request, response);
                    LOGGER.debug("*** form group size after validation " + formGroups.size());
                }
                diwg.setItemGroup(dgb);
                diwg.setItemGroups(formGroups);
                allItems.set(i, diwg);
                continue;
            }
            DisplayItemBean dib2 = diwg.getSingleItem();
            if (validate) {
                dib2 = this.validateDisplayItemBean(v, dib2, "", ruleValidator, groupOrdinalPLusItemOid, Boolean.valueOf(false), null, request);
            }
            ArrayList children = dib2.getChildren();
            for (int j = 0; j < children.size(); ++j) {
                DisplayItemBean child = (DisplayItemBean)children.get(j);
                String itemName = this.getInputName(child);
                child.loadFormValue(fp.getString(itemName));
                if (validate) {
                    child = this.validateDisplayItemBean(v, child, "", ruleValidator, groupOrdinalPLusItemOid, Boolean.valueOf(false), null, request);
                }
                children.set(j, child);
                LOGGER.debug(" J (children): " + j);
            }
            dib2.setChildren(children);
            diwg.setSingleItem(this.runDynamicsItemCheck(dib2, null, request));
            LOGGER.debug(" I : " + i);
            allItems.set(i, diwg);
        }
        this.logMe("allItems  Loop end  " + System.currentTimeMillis());
        HashMap scoreItems = new HashMap();
        HashMap scoreItemdata = new HashMap();
        HashMap oldItemdata = this.prepareSectionItemdataObject(sb.getId(), request);
        TreeSet<String> changedItems = new TreeSet<String>();
        ArrayList<DisplayItemBean> changedItemsList = new ArrayList<DisplayItemBean>();
        HashMap<Object, DisplayItemGroupBean> changedItemsMap = new HashMap<Object, DisplayItemGroupBean>();
        HashMap itemOrdinals = this.prepareItemdataOrdinals(request);
        this.updateDataOrdinals(allItems);
        section.setDisplayItemGroups(allItems);
        scoreItems = this.prepareScoreItems(request);
        scoreItemdata = this.prepareScoreItemdata(request);
        this.logMe("allItems 2 Loop begin  " + System.currentTimeMillis());
        for (int i = 0; i < allItems.size(); ++i) {
            DisplayItemWithGroupBean diwb = (DisplayItemWithGroupBean)allItems.get(i);
            if (diwb.isInGroup()) {
                DisplayItemGroupBean digb = diwb.getItemGroup();
                List dbGroups = diwb.getDbItemGroups();
                for (int j = 0; j < dbGroups.size(); ++j) {
                    DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dbGroups.get(j);
                    List items = displayGroup.getItems();
                    if (!"remove".equalsIgnoreCase(displayGroup.getEditFlag())) continue;
                    for (DisplayItemBean displayItem : items) {
                        if (!displayItem.getMetadata().isShowItem() || !digb.getGroupMetaBean().isShowGroup()) continue;
                        int itemId = displayItem.getItem().getId();
                        int ordinal = displayItem.getData().getOrdinal();
                        if (itemOrdinals.containsKey(itemId)) {
                            ((TreeSet)itemOrdinals.get(itemId)).remove(ordinal);
                        }
                        if (scoreItemdata.containsKey(itemId + "_" + ordinal)) {
                            scoreItemdata.remove(itemId + "_" + ordinal);
                        }
                        changedItems.add(displayItem.getItem().getName());
                        changedItemsList.add(displayItem);
                        Object formName = displayItem.getItem().getName();
                        if (displayGroup.isAuto()) {
                            formName = this.getGroupItemInputName(displayGroup, displayGroup.getFormInputOrdinal(), displayItem);
                            LOGGER.debug("GET: changed formName to " + (String)formName);
                        } else {
                            formName = this.getGroupItemManualInputName(displayGroup, displayGroup.getFormInputOrdinal(), displayItem);
                            LOGGER.debug("GET-MANUAL: changed formName to " + (String)formName);
                        }
                        changedItemsMap.put(formName, displayGroup);
                        LOGGER.debug("adding to changed items map: " + (String)formName);
                    }
                }
                List dgbs = diwb.getItemGroups();
                HashMap<Integer, Integer> maxOrdinals = new HashMap<Integer, Integer>();
                boolean first = true;
                for (int j = 0; j < dgbs.size(); ++j) {
                    DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dgbs.get(j);
                    List items = displayGroup.getItems();
                    boolean isAdd = "add".equalsIgnoreCase(displayGroup.getEditFlag());
                    for (DisplayItemBean displayItem : items) {
                        ItemBean ib = displayItem.getItem();
                        String itemName = ib.getName();
                        int itemId = ib.getId();
                        if (first) {
                            maxOrdinals.put(itemId, iddao.getMaxOrdinalForGroup(ecb, sb, displayGroup.getItemGroupBean()));
                        }
                        ItemDataBean idb = displayItem.getData();
                        String value = idb.getValue();
                        scoreItems.put(itemName, ib);
                        int ordinal = displayItem.getData().getOrdinal();
                        if (isAdd && scoreItemdata.containsKey(itemId + "_" + ordinal)) {
                            int dbMax;
                            int formMax = 1;
                            if (maxOrdinals.containsKey(itemId)) {
                                formMax = (Integer)maxOrdinals.get(itemId);
                            }
                            ordinal = ordinal >= (dbMax = iddao.getMaxOrdinalForGroup(ecb, sb, displayGroup.getItemGroupBean())) ? formMax + 1 : ordinal;
                            maxOrdinals.put(itemId, ordinal);
                            displayItem.getData().setOrdinal(ordinal);
                            scoreItemdata.put(itemId + "_" + ordinal, value);
                        } else {
                            scoreItemdata.put(itemId + "_" + ordinal, value);
                        }
                        if (itemOrdinals.containsKey(itemId)) {
                            ((TreeSet)itemOrdinals.get(itemId)).add(ordinal);
                        } else {
                            TreeSet<Integer> ordinalSet = new TreeSet<Integer>();
                            ordinalSet.add(ordinal);
                            itemOrdinals.put(itemId, ordinalSet);
                        }
                        if (!this.isChanged(displayItem, oldItemdata, attachedFilePath)) continue;
                        changedItems.add(itemName);
                        changedItemsList.add(displayItem);
                        String formName = displayItem.getItem().getName();
                        if (displayGroup.isAuto()) {
                            formName = this.getGroupItemInputName(displayGroup, displayGroup.getFormInputOrdinal(), displayItem);
                            LOGGER.debug("RESET: formName group-item-input:" + formName);
                        } else {
                            formName = this.getGroupItemManualInputName(displayGroup, displayGroup.getFormInputOrdinal(), displayItem);
                            LOGGER.debug("RESET: formName group-item-input-manual:" + formName);
                        }
                        changedItemsMap.put(formName, displayGroup);
                        LOGGER.debug("adding to changed items map: " + formName);
                    }
                    first = false;
                }
                continue;
            }
            DisplayItemBean dib3 = diwb.getSingleItem();
            ItemBean ib = dib3.getItem();
            ItemDataBean idb = dib3.getData();
            int itemId = ib.getId();
            String itemName = ib.getName();
            String value = idb.getValue();
            scoreItems.put(itemName, ib);
            TreeSet<Integer> ordinalset = new TreeSet<Integer>();
            ordinalset.add(1);
            itemOrdinals.put(itemId, ordinalset);
            scoreItemdata.put(itemId + "_" + 1, value);
            if (this.isChanged(idb, oldItemdata, dib3, attachedFilePath)) {
                changedItems.add(itemName);
                changedItemsList.add(dib3);
            }
            ArrayList children = dib3.getChildren();
            for (int j = 0; j < children.size(); ++j) {
                DisplayItemBean child = (DisplayItemBean)children.get(j);
                ItemBean cib = child.getItem();
                scoreItems.put(cib.getName(), cib);
                TreeSet<Integer> cordinalset = new TreeSet<Integer>();
                cordinalset.add(1);
                itemOrdinals.put(itemId, cordinalset);
                scoreItemdata.put(cib.getId() + "_" + 1, child.getData().getValue());
                if (!this.isChanged(child.getData(), oldItemdata, child, attachedFilePath)) continue;
                changedItems.add(itemName);
                changedItemsList.add(child);
            }
        }
        this.logMe("allItems 2 Loop end  " + System.currentTimeMillis());
        ScoreItemValidator sv = new ScoreItemValidator(request, discNotes);
        SessionManager sm = (SessionManager)request.getSession().getAttribute("sm");
        ScoreCalculator sc = new ScoreCalculator(sm, ecb, ub);
        this.logMe("allItems 3 Loop begin  " + System.currentTimeMillis());
        for (int i = 0; i < allItems.size(); ++i) {
            DisplayItemWithGroupBean diwb = (DisplayItemWithGroupBean)allItems.get(i);
            if (diwb.isInGroup()) {
                List dgbs = diwb.getItemGroups();
                for (int j = 0; j < dgbs.size(); ++j) {
                    DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dgbs.get(j);
                    List items = displayGroup.getItems();
                    for (DisplayItemBean displayItem : items) {
                        ifmb = displayItem.getMetadata();
                        int responseTypeId = ifmb.getResponseSet().getResponseTypeId();
                        if (responseTypeId != 8 && responseTypeId != 9) continue;
                        StringBuffer err = new StringBuffer();
                        ResponseOptionBean robBean = (ResponseOptionBean)ifmb.getResponseSet().getOptions().get(0);
                        String value = "";
                        String inputName = "";
                        if (displayGroup.isAuto()) {
                            inputName = this.getGroupItemInputName(displayGroup, displayGroup.getFormInputOrdinal(), displayItem);
                            LOGGER.debug("returning input name: " + inputName);
                        } else {
                            inputName = this.getGroupItemManualInputName(displayGroup, displayGroup.getFormInputOrdinal(), displayItem);
                            LOGGER.debug("returning input name: " + inputName);
                        }
                        if (robBean.getValue().startsWith("func: getexternalvalue") || robBean.getValue().startsWith("func: getExternalValue")) {
                            value = fp.getString(inputName);
                            LOGGER.debug("*** just set " + fp.getString(inputName) + " for line 815 " + displayItem.getItem().getName() + " with input name " + inputName);
                        } else {
                            value = sc.doCalculation(displayItem, scoreItems, scoreItemdata, itemOrdinals, err, displayItem.getData().getOrdinal());
                        }
                        displayItem.loadFormValue(value);
                        if (this.isChanged(displayItem, oldItemdata, attachedFilePath)) {
                            changedItems.add(displayItem.getItem().getName());
                            changedItemsList.add(displayItem);
                        }
                        request.setAttribute(inputName, (Object)value);
                        if (!validate) continue;
                        displayItem = this.validateCalcTypeDisplayItemBean(sv, displayItem, inputName, request);
                        if (err.length() <= 0) continue;
                        Validation validation = new Validation(32);
                        validation.setErrorMessage(err.toString());
                        sv.addValidation(inputName, validation);
                    }
                }
                continue;
            }
            DisplayItemBean dib4 = diwb.getSingleItem();
            ItemFormMetadataBean ifmb3 = dib4.getMetadata();
            int responseTypeId = ifmb3.getResponseSet().getResponseTypeId();
            if (responseTypeId == 8 || responseTypeId == 9) {
                StringBuffer err = new StringBuffer();
                ResponseOptionBean robBean = (ResponseOptionBean)ifmb3.getResponseSet().getOptions().get(0);
                String value = "";
                if (robBean.getValue().startsWith("func: getexternalvalue") || robBean.getValue().startsWith("func: getExternalValue")) {
                    String itemName = this.getInputName(dib4);
                    value = fp.getString(itemName);
                    LOGGER.debug("just set " + fp.getString(itemName) + " for " + dib4.getItem().getName());
                    LOGGER.debug("found in fp: " + fp.getString(dib4.getItem().getName()));
                } else {
                    value = sc.doCalculation(dib4, scoreItems, scoreItemdata, itemOrdinals, err, 1);
                }
                dib4.loadFormValue(value);
                if (this.isChanged(dib4.getData(), oldItemdata, dib4, attachedFilePath)) {
                    changedItems.add(dib4.getItem().getName());
                    changedItemsList.add(dib4);
                }
                String inputName = this.getInputName(dib4);
                request.setAttribute(inputName, (Object)value);
                if (validate) {
                    dib4 = this.validateCalcTypeDisplayItemBean(sv, dib4, "", request);
                    if (err.length() > 0) {
                        Validation validation = new Validation(32);
                        validation.setErrorMessage(err.toString());
                        sv.addValidation(inputName, validation);
                    }
                }
            }
            ArrayList children = dib4.getChildren();
            for (int j = 0; j < children.size(); ++j) {
                DisplayItemBean child = (DisplayItemBean)children.get(j);
                ItemFormMetadataBean cifmb = child.getMetadata();
                int resTypeId = cifmb.getResponseSet().getResponseTypeId();
                if (resTypeId == 8 || resTypeId == 9) {
                    StringBuffer cerr = new StringBuffer();
                    child.getDbData().setValue(child.getData().getValue());
                    ResponseOptionBean crobBean = (ResponseOptionBean)cifmb.getResponseSet().getOptions().get(0);
                    String cvalue = "";
                    if (crobBean.getValue().startsWith("func: getexternalvalue") || crobBean.getValue().startsWith("func: getExternalValue")) {
                        String itemName = this.getInputName(child);
                        cvalue = fp.getString(itemName);
                        LOGGER.debug("just set " + fp.getString(itemName) + " for " + child.getItem().getName());
                    } else {
                        cvalue = sc.doCalculation(child, scoreItems, scoreItemdata, itemOrdinals, cerr, 1);
                    }
                    child.loadFormValue(cvalue);
                    if (this.isChanged(child.getData(), oldItemdata, child, attachedFilePath)) {
                        changedItems.add(child.getItem().getName());
                        changedItemsList.add(child);
                    }
                    String cinputName = this.getInputName(child);
                    request.setAttribute(cinputName, (Object)cvalue);
                    if (validate) {
                        child = this.validateCalcTypeDisplayItemBean(sv, child, "", request);
                        if (cerr.length() > 0) {
                            Validation cvalidation = new Validation(32);
                            cvalidation.setErrorMessage(cerr.toString());
                            sv.addValidation(cinputName, cvalidation);
                        }
                    }
                }
                children.set(j, child);
            }
        }
        this.logMe("allItems 3 Loop end  " + System.currentTimeMillis());
        section.setDisplayItemGroups(allItems);
        section = this.populateNotesWithDBNoteCounts(discNotes, section, request);
        this.populateInstantOnChange(request.getSession(), ecb, section);
        if (currentStudy.getStudyParameterConfig().getInterviewerNameRequired().equals("yes")) {
            v.addValidation(INPUT_INTERVIEWER, 1);
        }
        if (currentStudy.getStudyParameterConfig().getInterviewDateRequired().equals("yes")) {
            v.addValidation(INPUT_INTERVIEW_DATE, 1);
        }
        if ((interviewDate = fp.getString(INPUT_INTERVIEW_DATE)) != null && !interviewDate.trim().isEmpty()) {
            v.addValidation(INPUT_INTERVIEW_DATE, 4);
            v.alwaysExecuteLastValidation(INPUT_INTERVIEW_DATE);
        }
        if (section.getSection().hasSCDItem()) {
            section = SCDItemDisplayInfo.generateSCDDisplayInfo((DisplaySectionBean)section, (Boolean)(this.getServletPage(request).equals(Page.INITIAL_DATA_ENTRY) || this.getServletPage(request).equals(Page.ADMIN_EDIT_SERVLET) && !this.isAdminForcedReasonForChange(request) ? 1 : 0));
        }
        this.errors = v.validate();
        if (this.isAdminForcedReasonForChange(request) && this.isAdministrativeEditing() && this.errors.isEmpty()) {
            String error = respage.getString("reason_for_change_error");
            int nonforcedChanges = 0;
            if (changedItemsList.size() > 0) {
                LOGGER.debug("found admin force reason for change: changed items " + changedItems.toString() + " and changed items list: " + changedItemsList.toString() + " changed items map: " + changedItemsMap.toString());
                this.logMe("DisplayItemBean  Loop begin  " + System.currentTimeMillis());
                block19: for (DisplayItemBean displayItem : changedItemsList) {
                    Object formName = this.getInputName(displayItem);
                    ItemDataBean idb = displayItem.getData();
                    ItemBean item_bean = displayItem.getItem();
                    ifmb = displayItem.getMetadata();
                    LOGGER.debug("-- found group label " + ifmb.getGroupLabel());
                    if (!ifmb.getGroupLabel().equalsIgnoreCase("Ungrouped") && !ifmb.getGroupLabel().equalsIgnoreCase("")) {
                        for (Map.Entry pairs : changedItemsMap.entrySet()) {
                            String formName2 = (String)pairs.getKey();
                            DisplayItemGroupBean dgb = (DisplayItemGroupBean)pairs.getValue();
                            String testFormName = "";
                            testFormName = dgb.isAuto() ? this.getGroupItemInputName(dgb, dgb.getFormInputOrdinal(), displayItem) : this.getGroupItemManualInputName(dgb, dgb.getFormInputOrdinal(), displayItem);
                            LOGGER.debug("found test form name: " + testFormName);
                            if (!testFormName.equals(formName2)) continue;
                            formName = formName2;
                            this.setReasonForChangeError(ecb, item_bean, idb, (String)formName, error, request);
                            changedItemsMap.remove(formName2);
                            LOGGER.debug("form name changed: " + (String)formName);
                            continue block19;
                        }
                        continue;
                    }
                    this.setReasonForChangeError(ecb, item_bean, idb, (String)formName, error, request);
                    LOGGER.debug("form name added: " + (String)formName);
                }
                this.logMe("DisplayItemBean  Loop end  " + System.currentTimeMillis());
            }
            if (nonforcedChanges > 0) {
                // empty if block
            }
        }
        LOGGER.debug("errors here: " + this.errors.toString());
        this.logMe("error check  Loop begin  " + System.currentTimeMillis());
        if (this.errors.isEmpty() && shouldRunRules) {
            LOGGER.debug("Errors was empty");
            if (session.getAttribute("rulesErrors") != null) {
                HashMap h = ruleValidator.validate();
                Set a = (Set)session.getAttribute("rulesErrors");
                Set ba = h.keySet();
                Boolean showErrors = false;
                for (Object key : ba) {
                    if (a.contains(key)) continue;
                    showErrors = true;
                }
                if (showErrors.booleanValue()) {
                    this.errors = h;
                    if (this.errors.size() > 0) {
                        session.setAttribute("shouldRunValidation", (Object)"1");
                        session.setAttribute("rulesErrors", this.errors.keySet());
                    } else {
                        session.setAttribute("shouldRunValidation", null);
                        session.setAttribute("rulesErrors", null);
                    }
                } else {
                    session.setAttribute("shouldRunValidation", null);
                    session.setAttribute("rulesErrors", null);
                }
            } else if (session.getAttribute("shouldRunValidation") != null && session.getAttribute("shouldRunValidation").toString().equals("1")) {
                session.setAttribute("shouldRunValidation", null);
                session.setAttribute("rulesErrors", null);
            } else {
                this.errors = ruleValidator.validate();
                if (this.errors.size() > 0) {
                    session.setAttribute("shouldRunValidation", (Object)"1");
                    session.setAttribute("rulesErrors", this.errors.keySet());
                }
            }
        }
        if (!this.errors.isEmpty()) {
            LOGGER.debug("threw an error with data entry...");
            String[] textFields = new String[]{INPUT_INTERVIEWER, INPUT_INTERVIEW_DATE};
            fp.setCurrentStringValuesAsPreset(textFields);
            this.setPresetValues(fp.getPresetValues(), request);
            this.logMe("!errors if  Loop begin  " + System.currentTimeMillis());
            HashMap siErrors = sv.validate();
            if (siErrors != null && !siErrors.isEmpty()) {
                for (String fieldName : siErrors.keySet()) {
                    this.errors.put(fieldName, siErrors.get(fieldName));
                }
            }
            for (String fieldName : this.errors.keySet()) {
                LOGGER.debug("found error " + fieldName);
            }
            this.errors = this.reshuffleErrorGroupNamesKK(this.errors, allItems, request);
            this.reshuffleReasonForChangeHashAndDiscrepancyNotes(allItems, request, ecb);
            for (String fieldName : this.errors.keySet()) {
                LOGGER.debug("found error after shuffle " + fieldName);
            }
            request.setAttribute(INPUT_MARK_COMPLETE, (Object)fp.getString(INPUT_MARK_COMPLETE));
            request.setAttribute("section", (Object)section);
            request.setAttribute("annotations", (Object)fp.getString("annotations"));
            this.setInputMessages(this.errors, request);
            this.addPageMessage(respage.getString("errors_in_submission_see_below"), request);
            request.setAttribute("hasError", (Object)"true");
            session.setAttribute("fdnotes", (Object)discNotes);
            this.setUpPanel(section);
            this.forwardPage(this.getJSPPage(), request, response);
        } else {
            DataEntryStage stage;
            LOGGER.debug("Do we hit this in save ?????");
            this.logMe("Do we hit this in save ????  " + System.currentTimeMillis());
            boolean success = true;
            boolean temp = true;
            ecb.setInterviewerName(fp.getString(INPUT_INTERVIEWER));
            if (interviewDate != null && !interviewDate.trim().isEmpty()) {
                ecb.setDateInterviewed(fp.getDate(INPUT_INTERVIEW_DATE));
            } else {
                ecb.setDateInterviewed(null);
            }
            if (ecdao == null) {
                ecdao = new EventCRFDAO(this.getDataSource());
            }
            if ((stage = ecb.getStage()).equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
                ecb.setValidatorId(ub.getId());
            }
            if (studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED) && changedItemsList.size() > 0) {
                studyEventBean.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
                studyEventBean.setUpdater(ub);
                studyEventBean.setUpdatedDate(new Date());
                seDao.update(studyEventBean);
            }
            LOGGER.debug("Status of Study Subject {}", (Object)ssb.getStatus().getName());
            if (ssb.getStatus() == Status.SIGNED && changedItemsList.size() > 0) {
                LOGGER.debug("Status of Study Subject is Signed we are updating");
                StudySubjectDAO studySubjectDao = new StudySubjectDAO(this.getDataSource());
                ssb.setStatus(Status.AVAILABLE);
                ssb.setUpdater(ub);
                ssb.setUpdatedDate(new Date());
                studySubjectDao.update(ssb);
            }
            if (ecb.isSdvStatus() && changedItemsList.size() > 0) {
                LOGGER.debug("Status of Study Subject is SDV we are updating");
                StudySubjectDAO studySubjectDao = new StudySubjectDAO(this.getDataSource());
                ssb.setStatus(Status.AVAILABLE);
                ssb.setUpdater(ub);
                ssb.setUpdatedDate(new Date());
                studySubjectDao.update(ssb);
                ecb.setSdvStatus(false);
                ecb.setSdvUpdateId(ub.getId());
            }
            ecb = ecdao.update(ecb);
            FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)session.getAttribute("fdnotes");
            dndao = new DiscrepancyNoteDAO(this.getDataSource());
            AddNewSubjectServlet.saveFieldNotes((String)INPUT_INTERVIEWER, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)ecb.getId(), (String)"EventCRF", (StudyBean)currentStudy);
            AddNewSubjectServlet.saveFieldNotes((String)INPUT_INTERVIEW_DATE, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)ecb.getId(), (String)"EventCRF", (StudyBean)currentStudy);
            allItems = section.getDisplayItemGroups();
            int nextOrdinal = 0;
            LOGGER.debug("all items before saving into DB" + allItems.size());
            this.output(allItems);
            this.logMe("DisplayItemWithGroupBean allitems4 " + System.currentTimeMillis());
            for (int i = 0; i < allItems.size(); ++i) {
                DisplayItemWithGroupBean diwb = (DisplayItemWithGroupBean)allItems.get(i);
                if (diwb.isInGroup()) {
                    List items;
                    DisplayItemGroupBean displayGroup;
                    int j;
                    List dgbs = diwb.getItemGroups();
                    List dbGroups = diwb.getDbItemGroups();
                    LOGGER.debug("item group size: " + dgbs.size());
                    LOGGER.debug("item db-group size: " + dbGroups.size());
                    for (j = 0; j < dgbs.size(); ++j) {
                        displayGroup = (DisplayItemGroupBean)dgbs.get(j);
                        items = displayGroup.getItems();
                        boolean undelete = false;
                        for (DisplayItemBean displayItem : items) {
                            String currItemVal = displayItem.getData().getValue();
                            if (currItemVal == null || currItemVal.equals("")) continue;
                            undelete = true;
                            break;
                        }
                        for (DisplayItemBean displayItem : items) {
                            String fileName = this.addAttachedFilePath(displayItem, attachedFilePath);
                            boolean writeDN = true;
                            displayItem.setEditFlag(displayGroup.getEditFlag());
                            LOGGER.debug("group item value: " + displayItem.getData().getValue());
                            writeDN = this.writeDN(displayItem);
                            nextOrdinal = displayItem.getData().getOrdinal();
                            temp = this.writeToDB(displayItem, iddao, nextOrdinal, request);
                            LOGGER.debug("just executed writeToDB - 1");
                            LOGGER.debug("next ordinal: " + nextOrdinal);
                            if (undelete && displayItem.getDbData() != null && displayItem.getDbData().isDeleted()) {
                                iddao.undelete(displayItem.getDbData().getId(), ub.getId());
                            }
                            if (temp && newUploadedFiles.containsKey(fileName)) {
                                newUploadedFiles.remove(fileName);
                            }
                            String inputName = this.getGroupItemInputName(displayGroup, j, displayItem);
                            if (!displayGroup.isAuto()) {
                                LOGGER.trace("not auto");
                                inputName = this.getGroupItemManualInputName(displayGroup, j, displayItem);
                            }
                            LOGGER.trace("&&& we get previous looking at input name: " + inputName);
                            inputName = displayItem.getFieldName();
                            if (writeDN) {
                                AddNewSubjectServlet.saveFieldNotes((String)inputName, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)displayItem.getData().getId(), (String)"itemData", (StudyBean)currentStudy, (int)ecb.getId());
                            }
                            success = success && temp;
                        }
                    }
                    for (j = 0; j < dbGroups.size(); ++j) {
                        displayGroup = (DisplayItemGroupBean)dbGroups.get(j);
                        if (!"remove".equalsIgnoreCase(displayGroup.getEditFlag())) continue;
                        items = displayGroup.getItems();
                        for (DisplayItemBean displayItem : items) {
                            String fileName = this.addAttachedFilePath(displayItem, attachedFilePath);
                            displayItem.setEditFlag(displayGroup.getEditFlag());
                            LOGGER.debug("group item value: " + displayItem.getData().getValue());
                            temp = this.writeToDB(displayItem, iddao, 0, request);
                            LOGGER.debug("just executed writeToDB - 2");
                            if (temp && newUploadedFiles.containsKey(fileName)) {
                                newUploadedFiles.remove(fileName);
                            }
                            success = success && temp;
                        }
                    }
                    continue;
                }
                DisplayItemBean dib5 = diwb.getSingleItem();
                String fileName = this.addAttachedFilePath(dib5, attachedFilePath);
                boolean writeDN = this.writeDN(dib5);
                temp = this.writeToDB(dib5, iddao, 1, request);
                LOGGER.debug("just executed writeToDB - 3");
                if (temp && (newUploadedFiles.containsKey(dib5.getItem().getId() + "") || newUploadedFiles.containsKey(fileName))) {
                    newUploadedFiles.remove(dib5.getItem().getId() + "");
                    newUploadedFiles.remove(fileName);
                }
                String inputName = this.getInputName(dib5);
                LOGGER.trace("3 - found input name: " + inputName);
                if (writeDN) {
                    AddNewSubjectServlet.saveFieldNotes((String)inputName, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)dib5.getData().getId(), (String)"itemData", (StudyBean)currentStudy, (int)ecb.getId());
                }
                success = success && temp;
                ArrayList childItems = dib5.getChildren();
                for (int j = 0; j < childItems.size(); ++j) {
                    DisplayItemBean child = (DisplayItemBean)childItems.get(j);
                    this.addAttachedFilePath(child, attachedFilePath);
                    writeDN = this.writeDN(child);
                    temp = this.writeToDB(child, iddao, 1, request);
                    LOGGER.debug("just executed writeToDB - 4");
                    if (temp && newUploadedFiles.containsKey(child.getItem().getId() + "")) {
                        newUploadedFiles.remove(child.getItem().getId() + "");
                    }
                    inputName = this.getInputName(child);
                    if (writeDN) {
                        AddNewSubjectServlet.saveFieldNotes((String)inputName, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)child.getData().getId(), (String)"itemData", (StudyBean)currentStudy, (int)ecb.getId());
                    }
                    success = success && temp;
                }
            }
            this.logMe("DisplayItemWithGroupBean allitems4 end " + System.currentTimeMillis());
            LOGGER.debug("running rules: " + phase2.name());
            ArrayList prevShownDynItemDataIds = shouldRunRules ? this.getItemMetadataService().getDynamicsItemFormMetadataDao().findShowItemDataIdsInSection(section.getSection().getId(), ecb.getCRFVersionId(), ecb.getId()) : new ArrayList();
            this.logMe("DisplayItemWithGroupBean dryrun  start" + System.currentTimeMillis());
            HashMap rulesPostDryRun = this.runRules(allItems, ruleSets, Boolean.valueOf(false), Boolean.valueOf(shouldRunRules), MessageContainer.MessageType.WARNING, phase2, ecb, request);
            HashMap errorsPostDryRun = new HashMap();
            this.logMe("DisplayItemWithGroupBean dryrun  end" + System.currentTimeMillis());
            boolean inSameSection = false;
            this.logMe("DisplayItemWithGroupBean allitems4 " + System.currentTimeMillis());
            if (!rulesPostDryRun.isEmpty()) {
                for (String fieldName : rulesPostDryRun.keySet()) {
                    LOGGER.debug("found oid after post dry run " + fieldName);
                    int ordinal = -1;
                    String newFieldName = fieldName;
                    String[] fieldNames = fieldName.split("\\.");
                    if (fieldNames.length == 2) {
                        newFieldName = fieldNames[1];
                        if (fieldNames[0].contains("[")) {
                            int p1 = fieldNames[0].indexOf("[");
                            int p2 = fieldNames[0].indexOf("]");
                            try {
                                ordinal = Integer.valueOf(fieldNames[0].substring(p1 + 1, p2));
                            }
                            catch (NumberFormatException e) {
                                ordinal = -1;
                            }
                            fieldNames[0] = fieldNames[0].substring(0, p1);
                        }
                    }
                    List displayGroupsWithItems = section.getDisplayItemGroups();
                    for (int i = 0; i < displayGroupsWithItems.size(); ++i) {
                        DisplayItemWithGroupBean itemWithGroup = (DisplayItemWithGroupBean)displayGroupsWithItems.get(i);
                        if (itemWithGroup.isInGroup()) {
                            LOGGER.debug("found group: " + fieldNames[0]);
                            List digbs = itemWithGroup.getItemGroups();
                            LOGGER.debug("digbs size: " + digbs.size());
                            for (int j = 0; j < digbs.size(); ++j) {
                                DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)digbs.get(j);
                                if (!displayGroup.getItemGroupBean().getOid().equals(fieldNames[0]) || displayGroup.getOrdinal() != ordinal - 1) continue;
                                List items = displayGroup.getItems();
                                for (int k = 0; k < items.size(); ++k) {
                                    DisplayItemBean dib6 = (DisplayItemBean)items.get(k);
                                    if (dib6.getItem().getOid().equals(newFieldName)) {
                                        if (!dib6.getMetadata().isShowItem()) {
                                            LOGGER.debug("found item in group " + this.getGroupItemInputName(displayGroup, j, dib6) + " vs. " + fieldName + " and is show item: " + dib6.getMetadata().isShowItem());
                                            dib6.getMetadata().setShowItem(true);
                                        }
                                        if (prevShownDynItemDataIds == null || !prevShownDynItemDataIds.contains(dib6.getData().getId())) {
                                            inSameSection = true;
                                            errorsPostDryRun.put(this.getGroupItemInputName(displayGroup, j, dib6), rulesPostDryRun.get(fieldName));
                                        }
                                    }
                                    items.set(k, dib6);
                                }
                                displayGroup.setItems(items);
                                digbs.set(j, displayGroup);
                            }
                            itemWithGroup.setItemGroups(digbs);
                        } else {
                            DisplayItemBean displayItemBean = itemWithGroup.getSingleItem();
                            ItemBean itemBean = displayItemBean.getItem();
                            if (newFieldName.equals(itemBean.getOid()) && !displayItemBean.getMetadata().isShowItem()) {
                                LOGGER.debug("found item " + this.getInputName(displayItemBean) + " vs. " + fieldName + " and is show item: " + displayItemBean.getMetadata().isShowItem());
                                displayItemBean.getMetadata().setShowItem(true);
                                if (prevShownDynItemDataIds == null || !prevShownDynItemDataIds.contains(displayItemBean.getData().getId())) {
                                    inSameSection = true;
                                    errorsPostDryRun.put(this.getInputName(displayItemBean), rulesPostDryRun.get(fieldName));
                                }
                            }
                            itemWithGroup.setSingleItem(displayItemBean);
                        }
                        displayGroupsWithItems.set(i, itemWithGroup);
                    }
                    this.logMe("DisplayItemWithGroupBean allitems4  end,begin" + System.currentTimeMillis());
                    List itemGroups = section.getDisplayItemGroups();
                    for (Object itemGroup : itemGroups) {
                        DisplayItemGroupBean displayGroup = itemGroup.getItemGroup();
                        if (!newFieldName.equals(displayGroup.getItemGroupBean().getOid()) || displayGroup.getGroupMetaBean().isShowGroup()) continue;
                        inSameSection = true;
                        LOGGER.debug("found itemgroup " + displayGroup.getItemGroupBean().getOid() + " vs. " + fieldName + " and is show item: " + displayGroup.getGroupMetaBean().isShowGroup());
                        errorsPostDryRun.put(displayGroup.getItemGroupBean().getOid(), rulesPostDryRun.get(fieldName));
                        displayGroup.getGroupMetaBean().setShowGroup(true);
                        this.loadItemsWithGroupRows((DisplayItemWithGroupBean)itemGroup, sb, edcb, ecb, request);
                    }
                    this.logMe("DisplayItemWithGroupBean allitems4  end,end" + System.currentTimeMillis());
                    section.setDisplayItemGroups(displayGroupsWithItems);
                    this.populateInstantOnChange(request.getSession(), ecb, section);
                }
                this.getItemMetadataService().updateGroupDynamicsInSection(displayItemWithGroups, section.getSection().getId(), ecb);
                toc = TableOfContentsServlet.getDisplayBeanWithShownSections((DataSource)this.getDataSource(), (DisplayTableOfContentsBean)((DisplayTableOfContentsBean)request.getAttribute(TOC_DISPLAY)), (DynamicsMetadataService)((DynamicsMetadataService)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("dynamicsMetadataService")));
                request.setAttribute(TOC_DISPLAY, (Object)toc);
                sectionIdsInToc = TableOfContentsServlet.sectionIdsInToc((DisplayTableOfContentsBean)toc);
                sIndex = TableOfContentsServlet.sectionIndexInToc((SectionBean)section.getSection(), (DisplayTableOfContentsBean)toc, (LinkedList)sectionIdsInToc);
                previousSec = this.prevSection(section.getSection(), ecb, toc, sIndex);
                nextSec = this.nextSection(section.getSection(), ecb, toc, sIndex);
                section.setFirstSection(!previousSec.isActive());
                section.setLastSection(!nextSec.isActive());
                LOGGER.debug(" in same section: " + inSameSection);
                if (inSameSection) {
                    String[] textFields = new String[]{INPUT_INTERVIEWER, INPUT_INTERVIEW_DATE};
                    fp.setCurrentStringValuesAsPreset(textFields);
                    this.setPresetValues(fp.getPresetValues(), request);
                    request.setAttribute("section", (Object)section);
                    request.setAttribute("annotations", (Object)fp.getString("annotations"));
                    this.setInputMessages(errorsPostDryRun, request);
                    this.addPageMessage(respage.getString("your_answers_activated_hidden_items"), request);
                    request.setAttribute("hasError", (Object)"true");
                    request.setAttribute("hasShown", (Object)"true");
                    session.setAttribute("fdnotes", (Object)discNotes);
                    this.setUpPanel(section);
                    this.forwardPage(this.getJSPPage(), request, response);
                }
            }
            if (!inSameSection) {
                ArrayList updateFailedItems = sc.redoCalculations(scoreItems, scoreItemdata, changedItems, itemOrdinals, sb.getId());
                success = updateFailedItems.size() <= 0;
                boolean markComplete = fp.getString(INPUT_MARK_COMPLETE).equals(VALUE_YES);
                boolean markSuccessfully = false;
                if (markComplete && section.isLastSection()) {
                    LOGGER.debug("need to mark CRF as complete");
                    markSuccessfully = this.markCRFComplete(request);
                    LOGGER.debug("...marked CRF as complete: " + markSuccessfully);
                    if (!markSuccessfully) {
                        request.setAttribute("section", (Object)section);
                        request.setAttribute("annotations", (Object)fp.getString("annotations"));
                        this.setUpPanel(section);
                        this.forwardPage(this.getJSPPage(), request, response);
                        return;
                    }
                }
                String annotations = fp.getString("annotations");
                this.setEventCRFAnnotations(annotations, request);
                Date now = new Date();
                ecb.setUpdatedDate(now);
                ecb.setUpdater(ub);
                ecb = ecdao.update(ecb);
                success = success && ecb.isActive();
                StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
                StudyEventBean seb = sedao.findByPK(ecb.getStudyEventId());
                seb.setUpdatedDate(now);
                seb.setUpdater(ub);
                seb = sedao.update(seb);
                success = success && seb.isActive();
                request.setAttribute(INPUT_IGNORE_PARAMETERS, (Object)Boolean.TRUE);
                if (newUploadedFiles.size() > 0 && !this.unloadFiles(newUploadedFiles)) {
                    String missed = newUploadedFiles.keySet().stream().collect(Collectors.joining(" "));
                    this.addPageMessage(respage.getString("uploaded_files_not_deleted_or_not_exist") + ": " + missed, request);
                }
                if (!success) {
                    if (updateFailedItems.size() > 0) {
                        String mess = "";
                        for (String ss : updateFailedItems) {
                            mess = mess + ss + ", ";
                        }
                        mess = mess.substring(0, mess.length() - 2);
                        this.addPageMessage(resexception.getString("item_save_failed_because_database_error") + mess, request);
                    } else {
                        this.addPageMessage(resexception.getString("database_error"), request);
                    }
                    request.setAttribute("section", (Object)section);
                    session.removeAttribute(GROUP_HAS_DATA);
                    session.removeAttribute(HAS_DATA_FLAG);
                    session.removeAttribute(DDE_PROGESS);
                    session.removeAttribute("fdnotes");
                    LOGGER.debug("try to remove to_create_crf");
                    session.removeAttribute("to_create_crf");
                    session.removeAttribute(instantAtt);
                    this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET, request, response);
                } else {
                    boolean forwardingSucceeded = false;
                    if (!fp.getString(GO_PREVIOUS).equals("")) {
                        if (previousSec.isActive()) {
                            forwardingSucceeded = true;
                            request.setAttribute(INPUT_EVENT_CRF, (Object)ecb);
                            request.setAttribute("section", (Object)previousSec);
                            int tabNum = 0;
                            tabNum = fp.getString("tab") == null ? 1 : fp.getInt("tab");
                            request.setAttribute("tab", (Object)new Integer(tabNum - 1).toString());
                            this.getServletContext().getRequestDispatcher(this.getServletPage(request)).forward((ServletRequest)request, (ServletResponse)response);
                        }
                    } else if (!fp.getString(GO_NEXT).equals("") && nextSec.isActive()) {
                        forwardingSucceeded = true;
                        request.setAttribute(INPUT_EVENT_CRF, (Object)ecb);
                        request.setAttribute("section", (Object)nextSec);
                        int tabNum = 0;
                        tabNum = fp.getString("tab") == null ? 1 : fp.getInt("tab");
                        request.setAttribute("tab", (Object)new Integer(tabNum + 1).toString());
                        this.getServletContext().getRequestDispatcher(this.getServletPage(request)).forward((ServletRequest)request, (ServletResponse)response);
                    }
                    if (!forwardingSucceeded) {
                        if (markSuccessfully) {
                            this.addPageMessage(respage.getString("data_saved_CRF_marked_complete"), request);
                            session.removeAttribute("fdnotes");
                            session.removeAttribute(GROUP_HAS_DATA);
                            session.removeAttribute(HAS_DATA_FLAG);
                            session.removeAttribute(DDE_PROGESS);
                            session.removeAttribute("to_create_crf");
                            request.setAttribute("eventId", (Object)new Integer(ecb.getStudyEventId()).toString());
                            this.forwardPage(Page.ENTER_DATA_FOR_STUDY_EVENT_SERVLET, request, response);
                        } else {
                            this.addPageMessage(respage.getString("data_saved_continue_entering_edit_later"), request);
                            request.setAttribute(INPUT_EVENT_CRF, (Object)ecb);
                            request.setAttribute(INPUT_EVENT_CRF_ID, (Object)new Integer(ecb.getId()).toString());
                            if (!section.isLastSection()) {
                                request.setAttribute("section", (Object)nextSec);
                                request.setAttribute(INPUT_SECTION_ID, (Object)new Integer(nextSec.getId()).toString());
                                session.removeAttribute("mayProcessUploading");
                            } else if (section.isLastSection()) {
                                session.removeAttribute(GROUP_HAS_DATA);
                                session.removeAttribute(HAS_DATA_FLAG);
                                session.removeAttribute(DDE_PROGESS);
                                session.removeAttribute("to_create_crf");
                                session.removeAttribute("mayProcessUploading");
                                request.setAttribute("eventId", (Object)new Integer(ecb.getStudyEventId()).toString());
                                if (fromViewNotes != null && "1".equals(fromViewNotes)) {
                                    String viewNotesPageFileName = (String)session.getAttribute("viewNotesPageFileName");
                                    session.removeAttribute("viewNotesPageFileName");
                                    session.removeAttribute("viewNotesURL");
                                    if (viewNotesPageFileName != null && viewNotesPageFileName.length() > 0) {
                                        this.getServletContext().getRequestDispatcher(viewNotesPageFileName).forward((ServletRequest)request, (ServletResponse)response);
                                    }
                                }
                                session.removeAttribute(instantAtt);
                                this.forwardPage(Page.ENTER_DATA_FOR_STUDY_EVENT_SERVLET, request, response);
                                return;
                            }
                            int tabNum = 0;
                            tabNum = fp.getString("tab") == null ? 1 : fp.getInt("tab");
                            if (!section.isLastSection()) {
                                request.setAttribute("tab", (Object)new Integer(tabNum + 1).toString());
                            }
                            this.getServletContext().getRequestDispatcher(this.getServletPage(request)).forward((ServletRequest)request, (ServletResponse)response);
                        }
                    }
                }
            }
        }
    }

    protected boolean writeDN(DisplayItemBean displayItem) {
        boolean writeDN = true;
        if (StringUtils.isBlank((String)displayItem.getEditFlag())) {
            writeDN = !displayItem.getData().isActive();
        } else if ("add".equalsIgnoreCase(displayItem.getEditFlag())) {
            writeDN = true;
        } else if ("edit".equalsIgnoreCase(displayItem.getEditFlag())) {
            writeDN = displayItem.getData().getId() == 0;
        }
        return writeDN;
    }

    protected void setReasonForChangeError(EventCRFBean ecb, ItemBean item_bean, ItemDataBean idb, String formName, String error, HttpServletRequest request) {
        HttpSession session = request.getSession();
        HashMap noteSubmitted = ClassCastHelper.asHashMap((Object)session.getAttribute(NOTE_SUBMITTED), String.class, Boolean.class);
        String key_for_rfc = String.valueOf(ecb.getId() + "_" + formName);
        boolean isRFCFiled = false;
        if (noteSubmitted != null && noteSubmitted.get(key_for_rfc) != null) {
            isRFCFiled = true;
        }
        if (!isRFCFiled) {
            this.addErrorMessage(formName, error);
        } else {
            LOGGER.debug("has a note in db: entered an error here: " + formName + ": " + this.errors.toString());
        }
    }

    protected void getInputBeans(HttpServletRequest request) throws InsufficientPermissionException {
        int tabId;
        HttpSession session = request.getSession();
        StudyBean currentStudy = (StudyBean)session.getAttribute("study");
        FormProcessor fp = new FormProcessor(request);
        EventCRFDAO ecdao = new EventCRFDAO(this.getDataSource());
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        if (ecb == null) {
            int eventCRFId = fp.getInt(INPUT_EVENT_CRF_ID, true);
            LOGGER.debug("found event crf id: " + eventCRFId);
            if (eventCRFId > 0) {
                LOGGER.debug("***NOTE*** that we didnt have to create an event crf because we already have one: " + eventCRFId);
                ecb = ecdao.findByPK(eventCRFId);
                int studyEventId = fp.getInt(INPUT_STUDY_EVENT_ID);
                request.setAttribute(INPUT_EVENT_CRF, (Object)ecb);
                if (studyEventId > 0) {
                    StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
                    StudyEventBean sEvent = sedao.findByPK(studyEventId);
                    ecb = this.updateECB(sEvent, request);
                }
                request.setAttribute(INPUT_EVENT_CRF, (Object)ecb);
            } else {
                String toCreateCRF = (String)session.getAttribute("to_create_crf");
                if (toCreateCRF == null || toCreateCRF.trim().isEmpty() || "0".equals(toCreateCRF)) {
                    session.setAttribute("to_create_crf", (Object)"1");
                }
                try {
                    LOGGER.debug("Initial: to create an event CRF.");
                    String toCreateCRF1 = (String)session.getAttribute("to_create_crf");
                    if (toCreateCRF1 != null && !toCreateCRF1.trim().isEmpty() && "1".equals(toCreateCRF1)) {
                        ecb = this.createEventCRF(request, fp);
                        session.setAttribute("ecb", (Object)ecb);
                        request.setAttribute(INPUT_EVENT_CRF, (Object)ecb);
                        session.setAttribute("to_create_crf", (Object)"0");
                    } else {
                        ecb = (EventCRFBean)session.getAttribute("ecb");
                    }
                }
                catch (InconsistentStateException ie) {
                    LOGGER.error("permission is not sufficient: ", (Throwable)ie);
                    this.addPageMessage(ie.getOpenClinicaMessage(), request);
                    throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, ie.getOpenClinicaMessage(), "1");
                }
                catch (NullPointerException ne) {
                    LOGGER.error("crf not created correctly: ", (Throwable)ne);
                    this.addPageMessage(ne.getMessage(), request);
                    throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, ne.getMessage(), "1");
                }
            }
        }
        DisplayTableOfContentsBean displayBean = new DisplayTableOfContentsBean();
        displayBean = TableOfContentsServlet.getDisplayBean((EventCRFBean)ecb, (DataSource)this.getDataSource(), (StudyBean)currentStudy);
        displayBean.getStudyEventDefinition().setName(StringEscapeUtils.escapeJavaScript((String)displayBean.getStudyEventDefinition().getName()));
        request.setAttribute(TOC_DISPLAY, (Object)displayBean);
        int sectionId = fp.getInt(INPUT_SECTION_ID, true);
        if (sectionId <= 0) {
            StudyEventDAO studyEventDao = new StudyEventDAO(this.getDataSource());
            int maximumSampleOrdinal = studyEventDao.getMaxSampleOrdinal(displayBean.getStudyEventDefinition(), displayBean.getStudySubject());
            request.setAttribute("maximumSampleOrdinal", (Object)maximumSampleOrdinal);
            ArrayList sections = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
            Iterator iterator = sections.iterator();
            if (iterator.hasNext()) {
                SectionBean sb = (SectionBean)iterator.next();
                sectionId = sb.getId();
            }
        }
        SectionBean sb = new SectionBean();
        if (sectionId > 0) {
            sb = sdao.findByPK(sectionId);
        }
        if ((tabId = fp.getInt("tab", true)) <= 0) {
            tabId = sb != null && sb.getOrdinal() > 0 ? sb.getOrdinal() : 1;
        }
        request.setAttribute(INPUT_TAB, (Object)new Integer(tabId));
        request.setAttribute(SECTION_BEAN, (Object)sb);
    }

    protected boolean checkGroups(FormProcessor fp, EventCRFBean ecb) {
        ItemGroupDAO igdao;
        ItemGroupBean itemGroup;
        ArrayList sections;
        Iterator iterator;
        int sectionId = fp.getInt(INPUT_SECTION_ID, true);
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        if (sectionId <= 0 && (iterator = (sections = sdao.findAllByCRFVersionId(ecb.getCRFVersionId())).iterator()).hasNext()) {
            SectionBean sb = (SectionBean)iterator.next();
            sectionId = sb.getId();
        }
        if ((itemGroup = (igdao = new ItemGroupDAO(this.getDataSource())).findTopOneGroupBySectionId(sectionId)) != null && itemGroup.getId() > 0) {
            LOGGER.trace("This section has group");
            return true;
        }
        return false;
    }

    private EventCRFBean createEventCRF(HttpServletRequest request, FormProcessor fp) throws InconsistentStateException {
        AuditableEntityBean aeb;
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        EventCRFDAO ecdao = new EventCRFDAO(this.getDataSource());
        int crfVersionId = fp.getInt(INPUT_CRF_VERSION_ID);
        LOGGER.trace("***FOUND*** crfversionid: " + crfVersionId);
        int studyEventId = fp.getInt(INPUT_STUDY_EVENT_ID);
        int eventDefinitionCRFId = fp.getInt(INPUT_EVENT_DEFINITION_CRF_ID);
        int subjectId = fp.getInt(INPUT_SUBJECT_ID);
        int eventCRFId = fp.getInt(INPUT_EVENT_CRF_ID);
        LOGGER.trace("look specifically wrt event crf id: " + eventCRFId);
        LOGGER.trace("Creating event CRF.  Study id: " + currentStudy.getId() + "; CRF Version id: " + crfVersionId + "; Study Event id: " + studyEventId + "; Event Definition CRF id: " + eventDefinitionCRFId + "; Subject: " + subjectId);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.getDataSource());
        StudySubjectBean ssb = ssdao.findBySubjectIdAndStudy(subjectId, currentStudy);
        if (ssb.getId() <= 0) {
            LOGGER.trace("throwing ISE with study subject bean id of " + ssb.getId());
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("begin_data_entry_without_event_but_subject"));
        }
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.getDataSource());
        StudyEventDefinitionBean sedb = seddao.findByEventDefinitionCRFId(eventDefinitionCRFId);
        if (sedb.getId() <= 0) {
            this.addPageMessage(resexception.getString("begin_data_entry_without_event_but_study"), request);
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("begin_data_entry_without_event_but_study"));
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(this.getDataSource());
        CRFVersionBean eb = cvdao.findByPK(crfVersionId);
        if (eb.getId() <= 0) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("begin_data_entry_without_event_but_CRF"));
        }
        StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
        StudyEventBean sEvent = sedao.findByPK(studyEventId);
        StudyBean studyWithSED = currentStudy;
        if (currentStudy.getParentStudyId() > 0) {
            studyWithSED = new StudyBean();
            studyWithSED.setId(currentStudy.getParentStudyId());
        }
        if ((aeb = (AuditableEntityBean)sedao.findByPKAndStudy(studyEventId, studyWithSED)).getId() <= 0) {
            this.addPageMessage(resexception.getString("begin_data_entry_without_event_but_especified_event"), request);
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("begin_data_entry_without_event_but_especified_event"));
        }
        EventCRFBean ecb = new EventCRFBean();
        if (eventCRFId == 0) {
            ArrayList ecList = ecdao.findByEventSubjectVersion(sEvent, ssb, eb);
            if (ecList.size() > 0) {
                ecb = (EventCRFBean)ecList.get(0);
            } else {
                ecb.setAnnotations("");
                ecb.setCreatedDate(new Date());
                ecb.setCRFVersionId(crfVersionId);
                if (currentStudy.getStudyParameterConfig().getInterviewerNameDefault().equals("blank")) {
                    ecb.setInterviewerName("");
                } else {
                    ecb.setInterviewerName(sEvent.getOwner().getName());
                }
                if (!currentStudy.getStudyParameterConfig().getInterviewDateDefault().equals("blank")) {
                    if (sEvent.getDateStarted() != null) {
                        ecb.setDateInterviewed(sEvent.getDateStarted());
                    } else {
                        ecb.setDateInterviewed(null);
                    }
                } else {
                    ecb.setDateInterviewed(null);
                }
                ecb.setOwner(ub);
                ecb.setStatus(Status.AVAILABLE);
                ecb.setCompletionStatusId(1);
                ecb.setStudySubjectId(ssb.getId());
                ecb.setStudyEventId(studyEventId);
                ecb.setValidateString("");
                ecb.setValidatorAnnotations("");
                ecb = ecdao.create(ecb);
                LOGGER.debug("*********CREATED EVENT CRF");
            }
        } else {
            ecb = ecdao.findByPK(eventCRFId);
            ecb.setCRFVersionId(crfVersionId);
            ecb.setUpdatedDate(new Date());
            ecb.setUpdater(ub);
            ecb = this.updateECB(sEvent, request);
            ecb = ecdao.update(ecb);
        }
        if (ecb.getId() <= 0) {
            this.addPageMessage(resexception.getString("new_event_CRF_not_created"), request);
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("new_event_CRF_not_created"));
        }
        if (sEvent.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED)) {
            sEvent.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
            sEvent.setUpdater(ub);
            sEvent.setUpdatedDate(new Date());
            sedao.update(sEvent);
        } else {
            sEvent.setSubjectEventStatus(SubjectEventStatus.DATA_ENTRY_STARTED);
            sEvent.setUpdater(ub);
            sEvent.setUpdatedDate(new Date());
            sedao.update(sEvent);
        }
        return ecb;
    }

    protected DisplayItemBean loadFormValue(DisplayItemBean dib, HttpServletRequest request) {
        String inputName = this.getInputName(dib);
        FormProcessor fp = new FormProcessor(request);
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI) || rt.equals((Term)ResponseType.SELECT)) {
            dib.loadFormValue(fp.getStringArray(inputName));
        } else if (rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            dib.loadFormValue(dib.getData().getValue());
            ResponseOptionBean rob = (ResponseOptionBean)dib.getMetadata().getResponseSet().getOptions().get(0);
            LOGGER.trace("test print of options for coding: " + rob.getValue());
        } else {
            LOGGER.trace("test print: " + inputName + ": " + fp.getString(inputName));
            dib.loadFormValue(fp.getString(inputName));
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> loadFormValueForItemGroup(DisplayItemGroupBean digb, List<DisplayItemGroupBean> dbGroups, List<DisplayItemGroupBean> formGroups, int eventDefCRFId, HttpServletRequest request) {
        int j;
        int i;
        SectionBean sb = (SectionBean)request.getAttribute(SECTION_BEAN);
        int repeatMax = digb.getGroupMetaBean().getRepeatMax();
        FormProcessor fp = new FormProcessor(request);
        ItemDAO idao = new ItemDAO(this.getDataSource());
        List itBeans = idao.findAllItemsByGroupId(digb.getItemGroupBean().getId(), sb.getCRFVersionId());
        LOGGER.debug("+++ starting to review groups: " + repeatMax);
        long timeCheck = System.currentTimeMillis();
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        FormBeanUtil formBeanUtil = new FormBeanUtil();
        List nullValuesList = new ArrayList();
        nullValuesList = formBeanUtil.getNullValuesByEventCRFDefId(eventDefCRFId, this.getDataSource());
        long two = System.currentTimeMillis() - timeCheck;
        int firstLoopBreak = 0;
        int secondLoopBreak = 0;
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        int maxOrdinal = iddao.getMaxOrdinalForGroup(ecb, sb, digb.getItemGroupBean());
        repeatMax = repeatMax < maxOrdinal ? maxOrdinal : repeatMax;
        for (i = 0; i < repeatMax; ++i) {
            DisplayItemGroupBean formGroup = new DisplayItemGroupBean();
            formGroup.setItemGroupBean(digb.getItemGroupBean());
            formGroup.setGroupMetaBean(this.runDynamicsCheck(digb.getGroupMetaBean(), request));
            ItemGroupBean igb = digb.getItemGroupBean();
            boolean firstLoopOIDInput = fp.getStartsWith(igb.getOid() + "_manual" + i + "input");
            boolean firstLoopSkip = !firstLoopOIDInput;
            String firstLoopOIDNew = fp.getString(igb.getOid() + "_manual" + i + ".newRow");
            boolean bl = firstLoopSkip = firstLoopSkip && (firstLoopOIDNew == null || firstLoopOIDNew.trim().isEmpty());
            if (firstLoopSkip) {
                if (++firstLoopBreak <= 14) continue;
                LOGGER.debug("break first loop");
                break;
            }
            List dibs = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)this.getDataSource(), (EventCRFBean)ecb, (int)sb.getId(), nullValuesList, (ServletContext)this.getServletContext());
            if (firstLoopOIDInput) {
                formGroup.setOrdinal(i);
                formGroup.setFormInputOrdinal(i);
                formGroup.setAuto(false);
                formGroup.setInputId(igb.getOid() + "_manual" + i);
                LOGGER.debug("1: set auto to false for " + igb.getOid() + " " + i);
                dibs = this.processInputForGroupItem(fp, dibs, i, digb, false);
                formGroup.setItems(dibs);
                formGroups.add(formGroup);
                continue;
            }
            if (firstLoopOIDNew == null || firstLoopOIDNew.trim().isEmpty()) continue;
            formGroup.setOrdinal(i);
            formGroup.setFormInputOrdinal(i);
            formGroup.setInputId(igb.getOid() + "_manual" + i + ".newRow");
            formGroup.setAuto(false);
            LOGGER.debug("2: set auto to false for " + igb.getOid() + " " + i);
            dibs = this.processInputForGroupItem(fp, dibs, i, digb, false);
            formGroup.setItems(dibs);
            formGroups.add(formGroup);
        }
        LOGGER.trace("+++ starting to review groups 3: " + repeatMax);
        two = System.currentTimeMillis() - timeCheck;
        LOGGER.trace("time 3: " + two + "ms");
        for (i = 0; i < repeatMax; ++i) {
            ItemGroupBean igb = digb.getItemGroupBean();
            boolean secondLoopSkip = !fp.getStartsWith(igb.getOid() + "_" + i + "input");
            String secondLoopOIDNew = fp.getString(igb.getOid() + "_" + i + ".newRow");
            boolean bl = secondLoopSkip = secondLoopSkip && (secondLoopOIDNew == null || secondLoopOIDNew.trim().isEmpty());
            if (secondLoopSkip) {
                if (++secondLoopBreak <= 14) continue;
                LOGGER.debug("break second loop");
                break;
            }
            DisplayItemGroupBean formGroup = new DisplayItemGroupBean();
            formGroup.setItemGroupBean(digb.getItemGroupBean());
            formGroup.setGroupMetaBean(this.runDynamicsCheck(digb.getGroupMetaBean(), request));
            List dibs = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)this.getDataSource(), (EventCRFBean)ecb, (int)sb.getId(), nullValuesList, (ServletContext)this.getServletContext());
            LOGGER.trace("+++count for dibs after deep copy: " + dibs.size());
            two = System.currentTimeMillis() - timeCheck;
            if (fp.getStartsWith(igb.getOid() + "_" + i + "input")) {
                formGroup.setInputId(igb.getOid() + "_" + i);
                if (i == 0) {
                    formGroup.setOrdinal(i);
                } else {
                    formGroup.setFormInputOrdinal(i);
                }
                formGroup.setAuto(true);
                LOGGER.debug("1: set auto to TRUE for " + igb.getOid() + " " + i);
                dibs = this.processInputForGroupItem(fp, dibs, i, digb, true);
                LOGGER.trace("+++ group ordinal: " + i + " igb name " + igb.getName());
                formGroup.setItems(dibs);
                formGroups.add(formGroup);
            } else if (secondLoopOIDNew != null && !secondLoopOIDNew.trim().isEmpty()) {
                formGroup.setInputId(igb.getOid() + "_" + i);
                if (i == 0) {
                    formGroup.setOrdinal(i);
                } else {
                    formGroup.setFormInputOrdinal(i);
                }
                formGroup.setAuto(true);
                LOGGER.debug("2: set auto to TRUE for " + igb.getOid() + " " + i);
                dibs = this.processInputForGroupItem(fp, dibs, i, digb, true);
                LOGGER.trace("+++ group ordinal: " + i + " igb name " + igb.getName());
                formGroup.setItems(dibs);
                formGroups.add(formGroup);
            } else {
                ++secondLoopBreak;
            }
            if (secondLoopBreak <= 14) continue;
            LOGGER.debug("break second loop");
            break;
        }
        LOGGER.debug("first loop: " + firstLoopBreak);
        LOGGER.debug("second loop: " + secondLoopBreak);
        LOGGER.trace("+++ starting to review groups 4: " + repeatMax);
        two = System.currentTimeMillis() - timeCheck;
        LOGGER.trace("time 4: " + two + "ms");
        int manualRows = this.getManualRows(formGroups);
        LOGGER.debug(" manual rows " + manualRows + " formGroup size " + formGroups.size());
        request.setAttribute("manualRows", (Object)new Integer(manualRows));
        for (int j2 = 0; j2 < formGroups.size(); ++j2) {
            DisplayItemGroupBean formItemGroup = formGroups.get(j2);
            if (!formItemGroup.isAuto() || formItemGroup.getFormInputOrdinal() <= 0) continue;
            LOGGER.trace("+++ formInputOrdinal() " + formItemGroup.getFormInputOrdinal());
            formItemGroup.setOrdinal(formItemGroup.getFormInputOrdinal() + manualRows);
        }
        LOGGER.trace("+++ starting to review groups 5: " + repeatMax);
        two = System.currentTimeMillis() - timeCheck;
        LOGGER.trace("time 5: " + two + "ms");
        Collections.sort(formGroups);
        LOGGER.trace("group row size:" + formGroups.size());
        int previous = -1;
        for (j = 0; j < formGroups.size(); ++j) {
            DisplayItemGroupBean formItemGroup = formGroups.get(j);
            LOGGER.trace("formGroup Ordinal:" + formItemGroup.getOrdinal());
            if (formItemGroup.getOrdinal() == previous) {
                LOGGER.debug("found a match btw previous and ordinal");
                formItemGroup.setEditFlag("edit");
                formItemGroup.setOrdinal(previous + 1);
            }
            if (formItemGroup.getOrdinal() > dbGroups.size() - 1) {
                formItemGroup.setEditFlag("add");
            } else {
                for (int i2 = 0; i2 < dbGroups.size(); ++i2) {
                    DisplayItemGroupBean dbItemGroup = dbGroups.get(i2);
                    if (formItemGroup.getOrdinal() != i2) continue;
                    if ("initial".equalsIgnoreCase(dbItemGroup.getEditFlag())) {
                        formItemGroup.setEditFlag("add");
                        break;
                    }
                    dbItemGroup.setEditFlag("edit");
                    block5: for (DisplayItemBean dib : dbItemGroup.getItems()) {
                        ItemDataBean data = dib.getData();
                        for (DisplayItemBean formDib : formItemGroup.getItems()) {
                            if (formDib.getItem().getId() != dib.getItem().getId()) continue;
                            formDib.getData().setId(data.getId());
                            formDib.setDbData(dib.getData());
                            LOGGER.debug("+++ +++ form dib get data set id " + data.getId());
                            continue block5;
                        }
                    }
                    formItemGroup.setEditFlag("edit");
                    break;
                }
            }
            previous = formItemGroup.getOrdinal();
        }
        LOGGER.trace("+++ === DB group row:" + dbGroups.size());
        LOGGER.trace("+++ === DB group contents: " + dbGroups.toString());
        for (int i3 = 0; i3 < dbGroups.size(); ++i3) {
            DisplayItemGroupBean dbItemGroup = dbGroups.get(i3);
            LOGGER.trace("+++ found edit flag of " + dbItemGroup.getEditFlag() + " for #" + dbItemGroup.getOrdinal());
            if ("edit".equalsIgnoreCase(dbItemGroup.getEditFlag()) || "initial".equalsIgnoreCase(dbItemGroup.getEditFlag()) || !dbItemGroup.getGroupMetaBean().isShowGroup()) continue;
            LOGGER.trace("+++ one row removed, edit flag was " + dbItemGroup.getEditFlag());
            LOGGER.debug("+++ one row removed, edit flag was " + dbItemGroup.getEditFlag());
            dbItemGroup.setEditFlag("remove");
        }
        LOGGER.debug("+++ about to return form groups: " + formGroups.toString());
        for (j = 0; j < formGroups.size(); ++j) {
            DisplayItemGroupBean formGroup = formGroups.get(j);
            formGroup.setIndex(j);
        }
        return formGroups;
    }

    protected abstract boolean validateInputOnFirstRound();

    protected abstract DisplayItemBean validateDisplayItemBean(DiscrepancyValidator var1, DisplayItemBean var2, String var3, HttpServletRequest var4);

    protected void validateSCDItemBean(DiscrepancyValidator v, DisplayItemBean dib) {
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataBean idb = dib.getData();
        String idbValue = idb.getValue();
        if (idbValue == null || idbValue.trim().isEmpty()) {
            if (ibMeta.isRequired() && dib.getIsSCDtoBeShown()) {
                v.addValidation(this.getInputName(dib), 26);
            }
        } else {
            this.validateShownSCDToBeHiddenSingle(v, dib);
        }
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, Boolean fireRuleValidation, ArrayList<String> messages, HttpServletRequest request) {
        return dib;
    }

    protected abstract List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator var1, DisplayItemGroupBean var2, List<DisplayItemGroupBean> var3, List<DisplayItemGroupBean> var4, HttpServletRequest var5, HttpServletResponse var6);

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean dib, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, HttpServletRequest request, HttpServletResponse response) {
        return digbs;
    }

    private ItemGroupMetadataBean runDynamicsCheck(ItemGroupMetadataBean metadataBean, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        try {
            if (!metadataBean.isShowGroup()) {
                boolean showGroup = this.getItemMetadataService().isGroupShown(metadataBean.getId(), ecb);
                if (this.getServletPage(request).equals(Page.DOUBLE_DATA_ENTRY_SERVLET)) {
                    showGroup = this.getItemMetadataService().hasGroupPassedDDE(metadataBean.getId(), ecb.getId());
                }
                metadataBean.setShowGroup(showGroup);
            }
        }
        catch (OpenClinicaException oce) {
            LOGGER.debug("throws an OCE for " + metadataBean.getId());
        }
        return metadataBean;
    }

    private DisplayItemBean runDynamicsItemCheck(DisplayItemBean dib, Object newParam, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        try {
            LOGGER.debug("trying run dynamics item check: item id " + dib.getItem().getId() + " item data id " + dib.getData().getId());
            if (!dib.getMetadata().isShowItem()) {
                boolean showItem = this.getItemMetadataService().isShown(Integer.valueOf(dib.getItem().getId()), ecb, dib.getData());
                dib.getMetadata().setShowItem(showItem);
            }
        }
        catch (NullPointerException npe) {
            LOGGER.debug("found NPE! item id " + dib.getItem().getId());
        }
        return dib;
    }

    protected DisplayItemBean validateCalcTypeDisplayItemBean(ScoreItemValidator sv, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        dib = this.validateDisplayItemBeanText((DiscrepancyValidator)sv, dib, inputName, request);
        return dib;
    }

    protected DisplayItemBean validateDisplayItemBeanText(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        FormProcessor fp = new FormProcessor(request);
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute(EVENT_DEF_CRF_BEAN);
        if (inputName == null || inputName.trim().isEmpty()) {
            inputName = this.getInputName(dib);
        }
        ItemBean ib = dib.getItem();
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataType idt = ib.getDataType();
        ItemDataBean idb = dib.getData();
        boolean isNull = false;
        ArrayList nullValues = edcb.getNullValuesList();
        for (int i = 0; i < nullValues.size(); ++i) {
            NullValue nv = (NullValue)nullValues.get(i);
            if (!nv.getName().equals(fp.getString(inputName))) continue;
            isNull = true;
        }
        if (!isNull) {
            String idbValue = idb.getValue();
            if (idbValue == null || idbValue.trim().isEmpty()) {
                if (ibMeta.isRequired() && ibMeta.isShowItem()) {
                    v.addValidation(inputName, 26);
                }
            } else {
                if (idt.equals((Term)ItemDataType.ST)) {
                    v.addValidation(inputName, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 3999);
                } else if (idt.equals((Term)ItemDataType.INTEGER)) {
                    v.addValidation(inputName, 10);
                    v.alwaysExecuteLastValidation(inputName);
                } else if (idt.equals((Term)ItemDataType.REAL)) {
                    v.addValidation(inputName, 2);
                    v.alwaysExecuteLastValidation(inputName);
                } else if (!idt.equals((Term)ItemDataType.BL) && !idt.equals((Term)ItemDataType.BN)) {
                    if (idt.equals((Term)ItemDataType.SET)) {
                        v.addValidation(inputName, 24, dib.getMetadata().getResponseSet());
                    } else if (idt.equals((Term)ItemDataType.DATE)) {
                        v.addValidation(inputName, 4);
                        v.alwaysExecuteLastValidation(inputName);
                    } else if (idt.equals((Term)ItemDataType.PDATE)) {
                        v.addValidation(inputName, 34);
                        v.alwaysExecuteLastValidation(inputName);
                    }
                }
                if (ibMeta.getWidthDecimal().length() > 0) {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add(0, idt.getName());
                    params.add(1, ibMeta.getWidthDecimal());
                    v.addValidation(inputName, 35, params);
                    v.alwaysExecuteLastValidation(inputName);
                }
                this.customValidation(v, dib, inputName);
            }
        }
        return dib;
    }

    protected DisplayItemBean validateDisplayItemBeanSingleCV(RuleValidator v, DisplayItemBean dib, String inputName, ArrayList<String> messages) {
        if (inputName == null || inputName.trim().isEmpty()) {
            inputName = this.getInputName(dib);
        }
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataBean idb = dib.getData();
        String idbValue = idb.getValue();
        if (idbValue == null || idbValue.trim().isEmpty()) {
            if (ibMeta.isRequired() && ibMeta.isShowItem()) {
                v.addValidation(inputName, 26);
            }
            v.addValidation(inputName, 33, messages);
        } else {
            v.addValidation(inputName, 33, messages);
        }
        return dib;
    }

    protected DisplayItemBean validateDisplayItemBeanSingleCV(DiscrepancyValidator v, DisplayItemBean dib, String inputName) {
        if (inputName == null || inputName.trim().isEmpty()) {
            inputName = this.getInputName(dib);
        }
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataBean idb = dib.getData();
        String idbValue = idb.getValue();
        if (idbValue == null || idbValue.trim().isEmpty()) {
            if (ibMeta.isRequired() && ibMeta.isShowItem()) {
                v.addValidation(inputName, 26);
            }
        } else {
            v.addValidation(inputName, 24, dib.getMetadata().getResponseSet());
        }
        this.customValidation(v, dib, inputName);
        return dib;
    }

    protected void validateShownSCDToBeHiddenSingle(DiscrepancyValidator v, DisplayItemBean dib) {
        boolean hasDN;
        String value = dib.getData().getValue();
        boolean bl = hasDN = dib.getDiscrepancyNotes() != null && dib.getDiscrepancyNotes().size() > 0;
        if (value != null && value.length() > 0 && !dib.getIsSCDtoBeShown() && !hasDN) {
            String message = dib.getScdData().getScdItemMetadataBean().getMessage();
            Validation vl = new Validation(37);
            vl.setErrorMessage(message);
            v.addValidation(this.getInputName(dib), vl);
        }
    }

    protected DisplayItemBean validateDisplayItemBeanMultipleCV(DiscrepancyValidator v, DisplayItemBean dib, String inputName) {
        if (inputName == null || inputName.trim().isEmpty()) {
            inputName = this.getInputName(dib);
        }
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataBean idb = dib.getData();
        String idbValue = idb.getValue();
        if (idbValue == null || idbValue.trim().isEmpty()) {
            if (ibMeta.isRequired() && ibMeta.isShowItem()) {
                v.addValidation(inputName, 26);
            }
        } else {
            v.addValidation(inputName, 23, dib.getMetadata().getResponseSet());
        }
        this.customValidation(v, dib, inputName);
        return dib;
    }

    public final String getInputName(DisplayItemBean dib) {
        ItemBean ib = dib.getItem();
        String inputName = "input" + ib.getId();
        return inputName;
    }

    public final String getGroupItemInputName(DisplayItemGroupBean digb, int rowCount, int manualRows, DisplayItemBean dib) {
        int ordinal = rowCount - manualRows;
        String inputName = digb.getItemGroupBean().getOid() + "_" + ordinal + this.getInputName(dib);
        LOGGER.debug("===returning: " + inputName);
        return inputName;
    }

    public final String getGroupItemInputName(DisplayItemGroupBean digb, int ordinal, DisplayItemBean dib) {
        String inputName = digb.getItemGroupBean().getOid() + "_" + ordinal + this.getInputName(dib);
        LOGGER.debug("+++returning: " + inputName);
        return inputName;
    }

    protected boolean writeToDB(DisplayItemBean dib, ItemDataDAO iddao, int ordinal, HttpServletRequest request) {
        ItemDataBean idb = dib.getData();
        EventCRFBean ecb = (EventCRFBean)ClassCastHelper.getAsType((Object)request.getAttribute(INPUT_EVENT_CRF), EventCRFBean.class);
        if (dib.getEditFlag() != null && "remove".equalsIgnoreCase(dib.getEditFlag()) && this.getItemMetadataService().isShown(Integer.valueOf(idb.getItemId()), ecb, idb)) {
            this.getItemMetadataService().hideItem(dib.getMetadata(), ecb, idb);
        } else if (this.getServletPage(request).equals(Page.DOUBLE_DATA_ENTRY_SERVLET)) {
            if (!dib.getMetadata().isShowItem() && dib.getScdData().getScdItemMetadataBean().getScdItemFormMetadataId() <= 0 && idb.getValue().equals("") && !this.getItemMetadataService().hasPassedDDE(dib.getMetadata(), ecb, idb)) {
                LOGGER.debug("*** not shown - not writing for idb id " + dib.getData().getId() + " and item id " + dib.getItem().getId());
                return true;
            }
        } else if (!dib.getMetadata().isShowItem() && idb.getValue().equals("") && !this.getItemMetadataService().isShown(Integer.valueOf(dib.getItem().getId()), ecb, dib.getData()) && dib.getScdData().getScdItemMetadataBean().getScdItemFormMetadataId() <= 0) {
            LOGGER.debug("*** not shown - not writing for idb id " + dib.getData().getId() + " and item id " + dib.getItem().getId());
            return true;
        }
        return this.writeToDB(idb, dib, iddao, ordinal, request);
    }

    protected boolean writeToDB(ItemDataBean itemData, DisplayItemBean dib, ItemDataDAO iddao, int ordinal, HttpServletRequest request) {
        ItemDataBean idb = itemData;
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        idb.setItemId(dib.getItem().getId());
        idb.setEventCRFId(ecb.getId());
        if (idb.getValue().equals("")) {
            idb.setStatus(this.getBlankItemStatus());
        } else {
            idb.setStatus(this.getNonBlankItemStatus(request));
        }
        if (StringUtils.isBlank((String)dib.getEditFlag())) {
            if (!idb.isActive()) {
                idb.setOrdinal(ordinal);
                idb.setCreatedDate(new Date());
                idb.setOwner(ub);
                idb = iddao.create(idb);
            } else {
                idb.setUpdater(ub);
                LOGGER.debug("update item update_id " + idb.getUpdater().getId());
                idb = (ItemDataBean)iddao.updateValue((EntityBean)idb);
            }
        } else if ("add".equalsIgnoreCase(dib.getEditFlag())) {
            idb.setOrdinal(ordinal);
            idb.setCreatedDate(new Date());
            idb.setOwner(ub);
            LOGGER.debug("create a new item data" + idb.getItemId() + idb.getValue());
            idb.setUpdater(ub);
            idb = (ItemDataBean)iddao.upsert((EntityBean)idb);
        } else if ("edit".equalsIgnoreCase(dib.getEditFlag())) {
            idb.setUpdater(ub);
            LOGGER.debug("update item update_id " + idb.getUpdater().getId());
            if (idb.getId() != 0) {
                idb.setUpdatedDate(new Date());
                idb = (ItemDataBean)iddao.updateValue((EntityBean)idb);
            } else {
                idb.setCreatedDate(new Date());
                idb.setOrdinal(ordinal);
                idb.setOwner(ub);
                idb = (ItemDataBean)iddao.upsert((EntityBean)idb);
                LOGGER.debug("just ran upsert! " + idb.getId());
            }
        }
        return idb.isActive();
    }

    protected String addAttachedFilePath(DisplayItemBean dib, String attachedFilePath) {
        String fileName = "";
        ItemDataBean idb = dib.getData();
        String itemDataValue = idb.getValue();
        String dbValue = dib.getDbData().getValue();
        ResponseSetBean rsb = dib.getMetadata().getResponseSet();
        ResponseType rt = rsb.getResponseType();
        if (rt.equals((Term)ResponseType.FILE) && itemDataValue.length() > 0) {
            File file = new File(itemDataValue);
            fileName = file.getName();
            if (itemDataValue.length() > fileName.length()) {
                idb.setValue(itemDataValue);
            } else {
                File f = new File(dbValue);
                fileName = f.getName();
                if (fileName.equals(itemDataValue) && dbValue.length() > itemDataValue.length()) {
                    idb.setValue(dbValue);
                } else {
                    idb.setValue(attachedFilePath + itemDataValue);
                    fileName = itemDataValue;
                }
            }
        }
        return fileName;
    }

    protected abstract Status getBlankItemStatus();

    protected abstract Status getNonBlankItemStatus(HttpServletRequest var1);

    protected abstract String getEventCRFAnnotations(HttpServletRequest var1);

    protected abstract void setEventCRFAnnotations(String var1, HttpServletRequest var2);

    protected DisplaySectionBean getDisplayBean(boolean hasGroup, boolean includeUngroupedItems, HttpServletRequest request, boolean isSubmitted) throws Exception {
        DisplaySectionBean section = new DisplaySectionBean();
        FormProcessor fp = new FormProcessor(request);
        HttpSession session = request.getSession();
        Locale loc = this.locale == null ? LocaleResolver.getLocale((HttpServletRequest)request) : this.locale;
        StudyBean study = (StudyBean)session.getAttribute("study");
        SessionManager sm = (SessionManager)request.getSession().getAttribute("sm");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        SectionBean sb = (SectionBean)request.getAttribute(SECTION_BEAN);
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute(EVENT_DEF_CRF_BEAN);
        boolean hasUngroupedItems = false;
        int eventDefinitionCRFId = fp.getInt(INPUT_EVENT_DEFINITION_CRF_ID);
        if (eventDefinitionCRFId <= 0) {
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.getDataSource());
            EventDefinitionCRFBean edcBean = edcdao.findByStudyEventIdAndCRFVersionId(study, ecb.getStudyEventId(), ecb.getCRFVersionId());
            eventDefinitionCRFId = edcBean.getId();
        }
        LOGGER.trace("eventDefinitionCRFId " + eventDefinitionCRFId);
        FormBeanUtil formBeanUtil = new FormBeanUtil();
        List itemGroups = new ArrayList();
        if (hasGroup) {
            DisplaySectionBean newDisplayBean = new DisplaySectionBean();
            newDisplayBean = includeUngroupedItems ? formBeanUtil.createDisplaySectionBWithFormGroups(sb.getId(), ecb.getCRFVersionId(), this.getDataSource(), eventDefinitionCRFId, ecb, this.getServletContext()) : formBeanUtil.createDisplaySectionWithItemGroups(study, sb.getId(), ecb, ecb.getStudyEventId(), sm, eventDefinitionCRFId, this.getServletContext());
            itemGroups = newDisplayBean.getDisplayFormGroups();
            LOGGER.trace("found item group size: " + itemGroups.size() + " and to string: " + itemGroups.toString());
            section.setDisplayFormGroups(itemGroups);
        }
        hasUngroupedItems = formBeanUtil.sectionHasUngroupedItems(this.getDataSource(), sb.getId(), itemGroups);
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        sb.setHasSCDItem(hasUngroupedItems ? sdao.hasSCDItem(Integer.valueOf(sb.getId())) : false);
        section.setEventCRF(ecb);
        if (sb.getParentId() > 0) {
            SectionBean parent = sdao.findByPK(sb.getParentId());
            sb.setParent(parent);
        }
        section.setSection(sb);
        CRFVersionDAO cvdao = new CRFVersionDAO(this.getDataSource());
        CRFVersionBean cvb = cvdao.findByPK(ecb.getCRFVersionId());
        section.setCrfVersion(cvb);
        CRFDAO cdao = new CRFDAO(this.getDataSource());
        CRFBean cb = cdao.findByPK(cvb.getCrfId());
        section.setCrf(cb);
        section.setEventDefinitionCRF(edcb);
        ItemDAO idao = new ItemDAO(this.getDataSource());
        ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), loc);
        this.logMe("Entering getParentDisplayItems::: Thread is? " + Thread.currentThread());
        ArrayList displayItems = this.getParentDisplayItems(hasGroup, sb, edcb, idao, ifmdao, iddao, hasUngroupedItems, request);
        this.logMe("Entering getParentDisplayItems::: Done and Thread is? " + Thread.currentThread());
        LOGGER.debug("just ran get parent display, has group " + hasGroup + " has ungrouped " + hasUngroupedItems);
        Collections.sort(displayItems);
        for (int i = 0; i < displayItems.size(); ++i) {
            DisplayItemBean dib = (DisplayItemBean)displayItems.get(i);
            dib.setChildren(this.getChildrenDisplayItems(dib, edcb, request));
            if (ecb.getStage() == DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE || ecb.getStage() == DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) {
                if (this.shouldLoadDBValues(dib) && !isSubmitted) {
                    dib.loadDBValue();
                }
            } else if (this.shouldLoadDBValues(dib)) {
                LOGGER.trace("should load db values is true, set value");
                dib.loadDBValue();
                LOGGER.trace("just got data loaded: " + dib.getData().getValue());
            }
            displayItems.set(i, dib);
        }
        section.setItems(displayItems);
        return section;
    }

    protected ArrayList<DisplaySectionBean> getAllDisplayBeans(HttpServletRequest request) throws Exception {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        ArrayList<DisplaySectionBean> sections = new ArrayList<DisplaySectionBean>();
        HttpSession session = request.getSession();
        StudyBean study = (StudyBean)session.getAttribute("study");
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        ArrayList allSectionBeans = ClassCastHelper.asArrayList((Object)request.getAttribute(ALL_SECTION_BEANS), SectionBean.class);
        for (int j = 0; j < allSectionBeans.size(); ++j) {
            SectionBean sb = (SectionBean)allSectionBeans.get(j);
            DisplaySectionBean section = new DisplaySectionBean();
            section.setEventCRF(ecb);
            if (sb.getParentId() > 0) {
                SectionBean parent = sdao.findByPK(sb.getParentId());
                sb.setParent(parent);
            }
            section.setSection(sb);
            CRFVersionDAO cvdao = new CRFVersionDAO(this.getDataSource());
            CRFVersionBean cvb = cvdao.findByPK(ecb.getCRFVersionId());
            section.setCrfVersion(cvb);
            CRFDAO cdao = new CRFDAO(this.getDataSource());
            CRFBean cb = cdao.findByPK(cvb.getCrfId());
            section.setCrf(cb);
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.getDataSource());
            EventDefinitionCRFBean edcb = edcdao.findByStudyEventIdAndCRFVersionId(study, ecb.getStudyEventId(), cvb.getId());
            section.setEventDefinitionCRF(edcb);
            ItemDAO idao = new ItemDAO(this.getDataSource());
            ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.getDataSource());
            iddao = new ItemDataDAO(this.getDataSource(), this.locale);
            ArrayList displayItems = this.getParentDisplayItems(false, sb, edcb, idao, ifmdao, iddao, false, request);
            LOGGER.debug("222 just ran get parent display, has group  FALSE has ungrouped FALSE");
            Collections.sort(displayItems);
            for (int i = 0; i < displayItems.size(); ++i) {
                DisplayItemBean dib = (DisplayItemBean)displayItems.get(i);
                dib.setChildren(this.getChildrenDisplayItems(dib, edcb, request));
                if (this.shouldLoadDBValues(dib)) {
                    LOGGER.trace("should load db values is true, set value");
                    dib.loadDBValue();
                }
                displayItems.set(i, dib);
            }
            section.setItems(displayItems);
            sections.add(section);
        }
        return sections;
    }

    private ArrayList<DisplayItemBean> getParentDisplayItems(boolean hasGroup, SectionBean sb, EventDefinitionCRFBean edcb, ItemDAO idao, ItemFormMetadataDAO ifmdao, ItemDataDAO iddao, boolean hasUngroupedItems, HttpServletRequest request) throws Exception {
        DisplayItemBean dib;
        ArrayList<DisplayItemBean> answer = new ArrayList<DisplayItemBean>();
        EventCRFBean ecb = (EventCRFBean)ClassCastHelper.getAsType((Object)request.getAttribute(INPUT_EVENT_CRF), EventCRFBean.class);
        HashMap<Integer, DisplayItemBean> displayItems = new HashMap<Integer, DisplayItemBean>();
        ArrayList items = new ArrayList();
        ArrayList itemsUngrped = new ArrayList();
        if (hasGroup && hasUngroupedItems) {
            itemsUngrped = idao.findAllUngroupedParentsBySectionId(sb.getId(), sb.getCRFVersionId());
        }
        LOGGER.trace("no item groups");
        items = idao.findAllNonRepeatingParentsBySectionId(sb.getId());
        items.addAll(itemsUngrped);
        LOGGER.debug("items size" + items.size());
        for (int i = 0; i < items.size(); ++i) {
            DisplayItemBean dib2 = new DisplayItemBean();
            dib2.setEventDefinitionCRF(edcb);
            ItemBean ib = (ItemBean)items.get(i);
            dib2.setItem(ib);
            displayItems.put(new Integer(dib2.getItem().getId()), dib2);
        }
        ArrayList data = iddao.findAllBySectionIdAndEventCRFId(sb.getId(), ecb.getId());
        for (int i = 0; i < data.size(); ++i) {
            ItemDataBean idb = (ItemDataBean)data.get(i);
            DisplayItemBean dib3 = (DisplayItemBean)displayItems.get(new Integer(idb.getItemId()));
            if (dib3 == null) continue;
            dib3.setData(idb);
            dib3.setDbData((ItemDataBean)BeanUtils.cloneBean((Object)idb));
            displayItems.put(new Integer(idb.getItemId()), dib3);
        }
        ArrayList metadata = ifmdao.findAllBySectionId(sb.getId());
        for (int i = 0; i < metadata.size(); ++i) {
            ItemFormMetadataBean ifmb = (ItemFormMetadataBean)metadata.get(i);
            dib = (DisplayItemBean)displayItems.get(new Integer(ifmb.getItemId()));
            if (dib == null) continue;
            this.logMe("Entering thread before getting ItemMetadataService:::" + Thread.currentThread());
            boolean showItem = this.getItemMetadataService().isShown(Integer.valueOf(ifmb.getItemId()), ecb, dib.getData());
            if (this.getServletPage(request).equals(Page.DOUBLE_DATA_ENTRY_SERVLET)) {
                showItem = this.getItemMetadataService().hasPassedDDE(ifmb, ecb, dib.getData());
            }
            boolean passedDDE = this.getItemMetadataService().hasPassedDDE(ifmb, ecb, dib.getData());
            if (showItem) {
                LOGGER.debug("set show item " + ifmb.getItemId() + " idb " + dib.getData().getId() + " show item " + showItem + " passed dde " + passedDDE);
                ifmb.setShowItem(true);
            } else {
                LOGGER.debug("DID NOT set show item " + ifmb.getItemId() + " idb " + dib.getData().getId() + " show item " + showItem + " passed dde " + passedDDE + " value " + dib.getData().getValue());
            }
            dib.setMetadata(ifmb);
            displayItems.put(new Integer(ifmb.getItemId()), dib);
        }
        for (Integer key : displayItems.keySet()) {
            dib = (DisplayItemBean)displayItems.get(key);
            answer.add(dib);
            LOGGER.debug("*** getting with key: " + key + " display item bean with value: " + dib.getData().getValue());
        }
        LOGGER.debug("*** test of the display items: " + displayItems.toString());
        return answer;
    }

    private ArrayList<DisplayItemBean> getChildrenDisplayItems(DisplayItemBean parent, EventDefinitionCRFBean edcb, HttpServletRequest request) {
        ArrayList<DisplayItemBean> answer = new ArrayList<DisplayItemBean>();
        EventCRFBean ecb = (EventCRFBean)ClassCastHelper.getAsType((Object)request.getAttribute(INPUT_EVENT_CRF), EventCRFBean.class);
        int parentId = parent.getItem().getId();
        ItemDAO idao = new ItemDAO(this.getDataSource());
        ArrayList childItemBeans = idao.findAllByParentIdAndCRFVersionId(parentId, ecb.getCRFVersionId());
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.getDataSource());
        for (int i = 0; i < childItemBeans.size(); ++i) {
            ItemBean child = (ItemBean)childItemBeans.get(i);
            ItemDataBean data = iddao.findByItemIdAndEventCRFId(child.getId(), ecb.getId());
            ItemFormMetadataBean metadata = ifmdao.findByItemIdAndCRFVersionId(child.getId(), ecb.getCRFVersionId());
            DisplayItemBean dib = new DisplayItemBean();
            dib.setEventDefinitionCRF(edcb);
            dib.setItem(child);
            if (!this.getServletPage(request).equals(Page.DOUBLE_DATA_ENTRY_SERVLET)) {
                dib.setData(data);
            }
            dib.setDbData(data);
            boolean showItem = this.getItemMetadataService().isShown(Integer.valueOf(metadata.getItemId()), ecb, data);
            if (this.getServletPage(request).equals(Page.DOUBLE_DATA_ENTRY_SERVLET)) {
                showItem = this.getItemMetadataService().hasPassedDDE(metadata, ecb, data);
            }
            if (showItem) {
                LOGGER.debug("set show item: " + metadata.getItemId() + " data " + data.getId());
                metadata.setShowItem(true);
            }
            dib.setMetadata(metadata);
            if (this.shouldLoadDBValues(dib)) {
                LOGGER.trace("should load db values is true, set value");
                dib.loadDBValue();
                LOGGER.trace("just loaded the child value: " + dib.getData().getValue());
            }
            answer.add(dib);
        }
        Collections.sort(answer);
        return answer;
    }

    public DynamicsMetadataService getItemMetadataService() {
        DynamicsMetadataService itemMetadataService = null;
        itemMetadataService = itemMetadataService != null ? itemMetadataService : (DynamicsMetadataService)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("dynamicsMetadataService");
        return itemMetadataService;
    }

    protected abstract Page getJSPPage();

    protected abstract String getServletPage(HttpServletRequest var1);

    protected abstract boolean shouldLoadDBValues(DisplayItemBean var1);

    protected void setUpPanel(DisplaySectionBean section) {
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
    }

    protected DisplaySectionBean populateNotesWithDBNoteCounts(FormDiscrepancyNotes discNotes, DisplaySectionBean section, HttpServletRequest request) {
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        ArrayList ecNotes = dndao.findEventCRFDNotesFromEventCRF(ecb);
        ArrayList<DiscrepancyNoteBean> existingNameNotes = new ArrayList<DiscrepancyNoteBean>();
        ArrayList<DiscrepancyNoteBean> existingIntrvDateNotes = new ArrayList<DiscrepancyNoteBean>();
        long t = System.currentTimeMillis();
        this.logMe("Method:populateNotesWithDBNoteCounts" + t);
        for (int i = 0; i < ecNotes.size(); ++i) {
            DiscrepancyNoteBean dn = (DiscrepancyNoteBean)ecNotes.get(i);
            if (INTERVIEWER_NAME.equalsIgnoreCase(dn.getColumn())) {
                discNotes.setNumExistingFieldNotes(INPUT_INTERVIEWER, 1);
                request.setAttribute("hasNameNote", (Object)"yes");
                request.setAttribute(INTERVIEWER_NAME_NOTE, (Object)dn);
                if (dn.getParentDnId() == 0) {
                    existingNameNotes.add(dn);
                }
            }
            if (!DATE_INTERVIEWED.equalsIgnoreCase(dn.getColumn())) continue;
            discNotes.setNumExistingFieldNotes(INPUT_INTERVIEW_DATE, 1);
            request.setAttribute("hasDateNote", (Object)"yes");
            request.setAttribute(INTERVIEWER_DATE_NOTE, (Object)dn);
            if (dn.getParentDnId() != 0) continue;
            existingIntrvDateNotes.add(dn);
        }
        this.logMe("Method:populateNotesWithDBNoteCounts before calling setToolTipEventNotes" + System.currentTimeMillis() + "time took:" + (System.currentTimeMillis() - t));
        this.setToolTipEventNotes(request);
        request.setAttribute("nameNoteResStatus", (Object)this.getDiscrepancyNoteResolutionStatus(existingNameNotes));
        request.setAttribute("IntrvDateNoteResStatus", (Object)this.getDiscrepancyNoteResolutionStatus(existingIntrvDateNotes));
        request.setAttribute("existingNameNotes", existingNameNotes);
        request.setAttribute("existingIntrvDateNotes", existingIntrvDateNotes);
        List allItems = section.getDisplayItemGroups();
        LOGGER.debug("start to populate notes: " + section.getDisplayItemGroups().size());
        this.output(allItems);
        this.logMe("Looping through allItems time:" + System.currentTimeMillis() + "time took from the begining" + (System.currentTimeMillis() - t));
        for (int k = 0; k < allItems.size(); ++k) {
            DisplayItemWithGroupBean itemWithGroup = (DisplayItemWithGroupBean)allItems.get(k);
            if (itemWithGroup.isInGroup()) {
                LOGGER.debug("group item DNote...");
                List digbs = itemWithGroup.getItemGroups();
                LOGGER.trace("digbs size: " + digbs.size());
                for (int i = 0; i < digbs.size(); ++i) {
                    DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)digbs.get(i);
                    List items = displayGroup.getItems();
                    for (int j = 0; j < items.size(); ++j) {
                        DisplayItemBean dib = (DisplayItemBean)items.get(j);
                        int itemDataId = dib.getData().getId();
                        int numNotes = dndao.findNumExistingNotesForItem(itemDataId);
                        int numNotes1 = dndao.findNumOfActiveExistingNotesForItemData(itemDataId);
                        String inputName = this.getGroupItemInputName(displayGroup, displayGroup.getFormInputOrdinal(), dib);
                        if (!displayGroup.isAuto()) {
                            inputName = this.getGroupItemManualInputName(displayGroup, i, dib);
                        }
                        discNotes.setNumExistingFieldNotes(inputName, numNotes1);
                        ArrayList notes = discNotes.getNotes(inputName);
                        dib.setNumDiscrepancyNotes(numNotes + notes.size());
                        dib.setDiscrepancyNoteStatus(this.getDiscrepancyNoteResolutionStatus(itemDataId, notes));
                        dib = this.setTotals(dib, itemDataId, notes, ecb.getId());
                        LOGGER.debug("dib note size:" + dib.getNumDiscrepancyNotes() + " " + dib.getData().getId() + " " + inputName);
                        items.set(j, dib);
                    }
                    displayGroup.setItems(items);
                    digbs.set(i, displayGroup);
                }
                itemWithGroup.setItemGroups(digbs);
            } else {
                LOGGER.trace("single item db note");
                DisplayItemBean dib = itemWithGroup.getSingleItem();
                try {
                    ResponseOptionBean rob = (ResponseOptionBean)dib.getMetadata().getResponseSet().getOptions().get(0);
                    LOGGER.trace("test print of options for coding: " + rob.getValue());
                }
                catch (NullPointerException npe) {
                    LOGGER.debug("found NPE ", (Throwable)npe);
                }
                int itemDataId = dib.getData().getId();
                int itemId = dib.getItem().getId();
                int numNotes = dndao.findNumExistingNotesForItem(itemDataId);
                int numNotes1 = dndao.findNumOfActiveExistingNotesForItemData(itemDataId);
                String inputFieldName = "input" + itemId;
                discNotes.setNumExistingFieldNotes(inputFieldName, numNotes1);
                dib.setNumDiscrepancyNotes(numNotes + discNotes.getNotes(inputFieldName).size());
                dib.setDiscrepancyNoteStatus(this.getDiscrepancyNoteResolutionStatus(itemDataId, discNotes.getNotes(inputFieldName)));
                dib = this.setTotals(dib, itemDataId, discNotes.getNotes(inputFieldName), ecb.getId());
                ArrayList childItems = dib.getChildren();
                for (int j = 0; j < childItems.size(); ++j) {
                    DisplayItemBean child = (DisplayItemBean)childItems.get(j);
                    int childItemDataId = child.getData().getId();
                    int childItemId = child.getItem().getId();
                    int childNumNotes = dndao.findNumExistingNotesForItem(childItemDataId);
                    String childInputFieldName = "input" + childItemId;
                    LOGGER.debug("*** setting " + childInputFieldName);
                    discNotes.setNumExistingFieldNotes(childInputFieldName, childNumNotes);
                    child.setNumDiscrepancyNotes(childNumNotes + discNotes.getNotes(childInputFieldName).size());
                    child.setDiscrepancyNoteStatus(this.getDiscrepancyNoteResolutionStatus(childItemDataId, discNotes.getNotes(childInputFieldName)));
                    child = this.setTotals(child, childItemDataId, discNotes.getNotes(childInputFieldName), ecb.getId());
                    childItems.set(j, child);
                }
                dib.setChildren(childItems);
                itemWithGroup.setSingleItem(this.runDynamicsItemCheck(dib, null, request));
            }
            allItems.set(k, itemWithGroup);
        }
        section.setDisplayItemGroups(allItems);
        return section;
    }

    private void setToolTipEventNotes(HttpServletRequest request) {
        long t = System.currentTimeMillis();
        this.logMe("Method:setToolTipEventNotes" + t);
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        ArrayList ecNotes = dndao.findEventCRFDNotesToolTips(ecb);
        ArrayList<DiscrepancyNoteBean> nameNotes = new ArrayList<DiscrepancyNoteBean>();
        ArrayList<DiscrepancyNoteBean> dateNotes = new ArrayList<DiscrepancyNoteBean>();
        for (int i = 0; i < ecNotes.size(); ++i) {
            DiscrepancyNoteBean dn = (DiscrepancyNoteBean)ecNotes.get(i);
            if (INTERVIEWER_NAME.equalsIgnoreCase(dn.getColumn())) {
                nameNotes.add(dn);
            }
            if (!DATE_INTERVIEWED.equalsIgnoreCase(dn.getColumn())) continue;
            dateNotes.add(dn);
        }
        request.setAttribute("nameNotes", nameNotes);
        request.setAttribute("intrvDates", dateNotes);
        this.logMe("existing Method:setToolTipEventNotes, time took" + (System.currentTimeMillis() - t));
    }

    private DisplayItemBean setTotals(DisplayItemBean dib, int itemDataId, ArrayList<DiscrepancyNoteBean> notes, int ecbId) {
        long t = System.currentTimeMillis();
        this.logMe("Method::::::setTotals" + t);
        int totNew = 0;
        int totRes = 0;
        int totClosed = 0;
        int totUpdated = 0;
        int totNA = 0;
        boolean hasOtherThread = false;
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
        ArrayList existingNotes = dndao.findExistingNotesForToolTip(itemDataId);
        dib.setDiscrepancyNotes(existingNotes);
        for (Object obj : dib.getDiscrepancyNotes()) {
            Object note = obj;
            if (note.getParentDnId() != 0) continue;
            ++totNew;
        }
        ArrayList parentNotes = dndao.findExistingNotesForItemData(itemDataId);
        for (Object obj : parentNotes) {
            DiscrepancyNoteBean note = (DiscrepancyNoteBean)obj;
            if (note.getParentDnId() != 0) continue;
            if (hasOtherThread) {
                ++totNew;
            }
            hasOtherThread = true;
        }
        this.logMe("time taken thus far, before audit log check" + (System.currentTimeMillis() - t));
        long t1 = System.currentTimeMillis();
        AuditDAO adao = new AuditDAO(this.getDataSource());
        ArrayList itemAuditEvents = adao.checkItemAuditEventsExist(dib.getItem().getId(), "item_data", ecbId);
        if (itemAuditEvents.size() > 0) {
            AuditBean itemFirstAudit = (AuditBean)itemAuditEvents.get(0);
            String firstRFC = itemFirstAudit.getReasonForChange();
            String oldValue = itemFirstAudit.getOldValue();
            if (firstRFC != null && "initial value".equalsIgnoreCase(firstRFC) && (oldValue == null || oldValue.isEmpty())) {
                dib.getData().setAuditLog(false);
            } else {
                dib.getData().setAuditLog(true);
            }
        }
        this.logMe("time taken thus far, after audit log check" + (System.currentTimeMillis() - t));
        this.logMe("Only for audit check::" + (System.currentTimeMillis() - t1));
        dib.setTotNew(totNew);
        dib.setTotRes(totRes);
        dib.setTotUpdated(totUpdated);
        dib.setTotClosed(totClosed);
        dib.setTotNA(totNA);
        this.logMe("returning back..time taken" + (System.currentTimeMillis() - t));
        return dib;
    }

    protected boolean markCRFComplete(HttpServletRequest request) throws Exception {
        boolean canSave;
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        HttpSession session = request.getSession();
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute(EVENT_DEF_CRF_BEAN);
        EventCRFDAO ecdao = new EventCRFDAO(this.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        this.getEventCRFBean(request);
        this.getEventDefinitionCRFBean(request);
        DataEntryStage stage = ecb.getStage();
        LOGGER.trace("inout_event_crf_id:" + ecb.getId());
        if (stage.equals((Term)DataEntryStage.UNCOMPLETED) || stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) || stage.equals((Term)DataEntryStage.LOCKED)) {
            this.addPageMessage(respage.getString("not_mark_CRF_complete1"), request);
            return false;
        }
        if ((stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) && !edcb.isDoubleEntry()) {
            this.addPageMessage(respage.getString("not_mark_CRF_complete2"), request);
            return false;
        }
        if (!this.isEachRequiredFieldFillout(request)) {
            this.addPageMessage(respage.getString("not_mark_CRF_complete4"), request);
            return false;
        }
        Status newStatus = ecb.getStatus();
        boolean ide = true;
        if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && edcb.isDoubleEntry()) {
            newStatus = Status.PENDING;
            ecb.setUpdater(ub);
            ecb.setUpdatedDate(new Date());
            ecb.setDateCompleted(new Date());
        } else if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && !edcb.isDoubleEntry()) {
            newStatus = Status.UNAVAILABLE;
            ecb.setUpdater(ub);
            ecb.setUpdatedDate(new Date());
            ecb.setDateCompleted(new Date());
            ecb.setDateValidateCompleted(new Date());
        } else if (stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) && edcb.isDoubleEntry()) {
            newStatus = Status.UNAVAILABLE;
            ecb.setUpdater(ub);
            ecb.setUpdatedDate(new Date());
            ecb.setDateCompleted(new Date());
            ecb.setDateValidateCompleted(new Date());
            ide = false;
        } else if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
            newStatus = Status.UNAVAILABLE;
            ecb.setDateValidateCompleted(new Date());
            ecb.setUpdater(ub);
            ide = false;
        }
        if (!this.isEachSectionReviewedOnce(request) && !(canSave = this.saveItemsToMarkComplete(newStatus, request))) {
            this.addPageMessage(respage.getString("not_mark_CRF_complete3"), request);
            return false;
        }
        ecb.setStatus(newStatus);
        if (edcb.isElectronicSignature()) {
            ecb.setElectronicSignatureStatus(true);
        }
        ecb = ecdao.update(ecb);
        ecdao.markComplete(ecb, ide);
        iddao.updateStatusByEventCRF(ecb, newStatus);
        StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
        StudyEventBean seb = sedao.findByPK(ecb.getStudyEventId());
        seb.setUpdatedDate(new Date());
        seb.setUpdater(ub);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.getDataSource());
        ArrayList allCRFs = ecdao.findAllByStudyEventAndStatus(seb, Status.UNAVAILABLE);
        StudyBean study = (StudyBean)ClassCastHelper.getAsType((Object)session.getAttribute("study"), StudyBean.class);
        ArrayList allEDCs = edcdao.findAllActiveByEventDefinitionId(study, seb.getStudyEventDefinitionId());
        if (allCRFs.size() == allEDCs.size()) {
            seb.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
        }
        seb = sedao.update(seb);
        request.setAttribute(INPUT_EVENT_CRF, (Object)ecb);
        request.setAttribute(EVENT_DEF_CRF_BEAN, (Object)edcb);
        return true;
    }

    private void getEventCRFBean(HttpServletRequest request) {
        FormProcessor fp = new FormProcessor(request);
        int eventCRFId = fp.getInt(INPUT_EVENT_CRF_ID);
        EventCRFDAO ecdao = new EventCRFDAO(this.getDataSource());
        ecdao.findByPK(eventCRFId);
    }

    protected boolean isEachRequiredFieldFillout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        ItemFormMetadataDAO itemFormMetadataDao = new ItemFormMetadataDAO(this.getDataSource());
        ArrayList shownRequiredAllItemsInCrfVersion = itemFormMetadataDao.findAllItemsRequiredAndShownByCrfVersionId(ecb.getCRFVersionId());
        ArrayList hiddenRequiredAllItemsInCrfVersion = itemFormMetadataDao.findAllItemsRequiredAndHiddenByCrfVersionId(ecb.getCRFVersionId());
        ItemGroupMetadataDAO igdao = new ItemGroupMetadataDAO(this.dataSource);
        ArrayList itemdatas = null;
        for (ItemFormMetadataBean shownItemMeta : shownRequiredAllItemsInCrfVersion) {
            ItemDataBean itemdata2;
            ItemGroupMetadataBean igBean = igdao.findByItemAndCrfVersion(Integer.valueOf(shownItemMeta.getItemId()), Integer.valueOf(ecb.getCRFVersionId()));
            if (igBean != null && igBean.isShowGroup()) {
                itemdatas = iddao.findAllByEventCRFIdAndItemId(ecb.getId(), shownItemMeta.getItemId());
                if (itemdatas == null || itemdatas.size() == 0) {
                    return false;
                }
                for (ItemDataBean itemdata2 : itemdatas) {
                    LOGGER.debug(itemdata2.getItemId() + "  :  " + itemdata2.getValue());
                    if (itemdata2.getValue() != null && !itemdata2.getValue().equals("") && itemdata2.getValue().trim().length() != 0 || dndao.findNumExistingNotesForItem(itemdata2.getId()) >= 1) continue;
                    return false;
                }
            }
            ArrayList dynamicsItemFormMetadataBeans = null;
            itemdata2 = hiddenRequiredAllItemsInCrfVersion.iterator();
            while (itemdata2.hasNext()) {
                ItemFormMetadataBean hiddenItemMeta = (ItemFormMetadataBean)itemdata2.next();
                itemdatas = iddao.findAllByEventCRFIdAndItemId(ecb.getId(), hiddenItemMeta.getItemId());
                dynamicsItemFormMetadataBeans = this.getItemMetadataService().getDynamicsItemFormMetadataDao().findByItemAndEventCrfShown(ecb, hiddenItemMeta.getItemId());
                if (itemdatas.size() == 0 && dynamicsItemFormMetadataBeans.size() > 0) {
                    return false;
                }
                for (ItemDataBean itemdata3 : itemdatas) {
                    if (itemdata3.getValue() != null && !itemdata3.getValue().equals("") && itemdata3.getValue().trim().length() != 0 || dndao.findNumExistingNotesForItem(itemdata3.getId()) >= 1 || dynamicsItemFormMetadataBeans.size() <= 0) continue;
                    return false;
                }
            }
        }
        ArrayList allFilled = iddao.findAllBlankRequiredByEventCRFId(ecb.getId(), ecb.getCRFVersionId());
        int numNotes = 0;
        if (!allFilled.isEmpty()) {
            LOGGER.trace("allFilled is not empty");
            FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)ClassCastHelper.getAsType((Object)session.getAttribute("fdnotes"), FormDiscrepancyNotes.class);
            HashMap idNotes = fdn.getIdNotes();
            for (int i = 0; i < allFilled.size(); ++i) {
                ItemDataBean idb = (ItemDataBean)allFilled.get(i);
                int exsitingNotes = dndao.findNumExistingNotesForItem(idb.getId());
                if (exsitingNotes > 0) {
                    LOGGER.trace("has existing note");
                    ++numNotes;
                    continue;
                }
                if (!idNotes.containsKey(idb.getId())) continue;
                LOGGER.trace("has note in session");
                ++numNotes;
            }
            LOGGER.trace("numNotes allFilled.size:" + numNotes + " " + allFilled.size());
            if (numNotes >= allFilled.size()) {
                LOGGER.trace("all required are filled out");
                return true;
            }
            LOGGER.debug("numNotes < allFilled.size() " + numNotes + ": " + allFilled.size());
            return false;
        }
        return true;
    }

    private boolean saveItemsToMarkComplete(Status completeStatus, HttpServletRequest request) throws Exception {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        ArrayList sections = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
        UserAccountBean ub = (UserAccountBean)ClassCastHelper.getAsType((Object)request.getSession().getAttribute("userBean"), UserAccountBean.class);
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        ItemDAO idao = new ItemDAO(this.getDataSource());
        for (int i = 0; i < sections.size(); ++i) {
            SectionBean sb = (SectionBean)sections.get(i);
            if (this.isCreateItemReqd(sb, request)) continue;
            ArrayList items = idao.findAllBySectionId(sb.getId());
            for (int j = 0; j < items.size(); ++j) {
                ItemBean item = (ItemBean)items.get(j);
                ArrayList itemBean = iddao.findAllByEventCRFIdAndItemIdNoStatus(ecb.getId(), item.getId());
                ItemDataBean idb = new ItemDataBean();
                idb.setItemId(item.getId());
                idb.setEventCRFId(ecb.getId());
                idb.setCreatedDate(new Date());
                idb.setOrdinal(1);
                idb.setOwner(ub);
                if (completeStatus != null) {
                    idb.setStatus(completeStatus);
                } else {
                    idb.setStatus(Status.UNAVAILABLE);
                }
                idb.setValue("");
                boolean save = true;
                if (itemBean.size() > 0) {
                    save = false;
                }
                if (!save) continue;
                iddao.create(idb);
            }
        }
        return true;
    }

    protected boolean isSectionReviewedOnce(SectionBean sb, HttpServletRequest request) {
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute(EVENT_DEF_CRF_BEAN);
        DataEntryStage stage = ecb.getStage();
        HashMap numItemsHM = sdao.getNumItemsBySectionId();
        HashMap numItemsPendingHM = sdao.getNumItemsPendingBySectionId(ecb);
        HashMap numItemsCompletedHM = sdao.getNumItemsCompletedBySectionId(ecb);
        HashMap numItemsBlankHM = sdao.getNumItemsBlankBySectionId(ecb);
        Integer key = new Integer(sb.getId());
        int numItems = TableOfContentsServlet.getIntById((HashMap)numItemsHM, (Integer)key);
        int numItemsPending = TableOfContentsServlet.getIntById((HashMap)numItemsPendingHM, (Integer)key);
        int numItemsCompleted = TableOfContentsServlet.getIntById((HashMap)numItemsCompletedHM, (Integer)key);
        int numItemsBlank = TableOfContentsServlet.getIntById((HashMap)numItemsBlankHM, (Integer)key);
        LOGGER.debug(" for " + key + " num items " + numItems + " num items blank " + numItemsBlank + " num items pending " + numItemsPending + " completed " + numItemsCompleted);
        if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && edcb.isDoubleEntry()) {
            if (numItemsPending == 0 && numItems > 0) {
                LOGGER.debug("returns false on ide loop " + key);
                return false;
            }
        } else if (numItemsCompleted == 0 && numItems > 0) {
            LOGGER.debug("returns false on other loop " + key);
            return false;
        }
        return true;
    }

    protected boolean isCreateItemReqd(SectionBean sb, HttpServletRequest request) {
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute(EVENT_DEF_CRF_BEAN);
        DataEntryStage stage = ecb.getStage();
        HashMap numItemsHM = sdao.getNumItemsBySectionId();
        HashMap numItemsPendingHM = sdao.getNumItemsPendingBySectionId(ecb);
        HashMap numItemsCompletedHM = sdao.getNumItemsCompletedBySection(ecb);
        HashMap numItemsBlankHM = sdao.getNumItemsBlankBySectionId(ecb);
        Integer key = new Integer(sb.getId());
        int numItems = TableOfContentsServlet.getIntById((HashMap)numItemsHM, (Integer)key);
        int numItemsPending = TableOfContentsServlet.getIntById((HashMap)numItemsPendingHM, (Integer)key);
        int numItemsCompleted = TableOfContentsServlet.getIntById((HashMap)numItemsCompletedHM, (Integer)key);
        int numItemsBlank = TableOfContentsServlet.getIntById((HashMap)numItemsBlankHM, (Integer)key);
        LOGGER.debug(" for " + key + " num items " + numItems + " num items blank " + numItemsBlank + " num items pending " + numItemsPending + " completed " + numItemsCompleted);
        return !(stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && edcb.isDoubleEntry() ? numItemsPending == 0 && numItems > 0 : numItemsCompleted < numItems);
    }

    protected boolean isEachSectionReviewedOnce(HttpServletRequest request) {
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        DataEntryStage stage = ecb.getStage();
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute(EVENT_DEF_CRF_BEAN);
        ArrayList sections = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
        HashMap numItemsHM = sdao.getNumItemsBySectionId();
        HashMap numItemsPendingHM = sdao.getNumItemsPendingBySectionId(ecb);
        HashMap numItemsCompletedHM = sdao.getNumItemsCompletedBySectionId(ecb);
        for (int i = 0; i < sections.size(); ++i) {
            SectionBean sb = (SectionBean)sections.get(i);
            Integer key = new Integer(sb.getId());
            int numItems = TableOfContentsServlet.getIntById((HashMap)numItemsHM, (Integer)key);
            int numItemsPending = TableOfContentsServlet.getIntById((HashMap)numItemsPendingHM, (Integer)key);
            int numItemsCompleted = TableOfContentsServlet.getIntById((HashMap)numItemsCompletedHM, (Integer)key);
            if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && edcb.isDoubleEntry()) {
                if (numItemsPending != 0 || numItems <= 0) continue;
                return false;
            }
            if (numItemsCompleted == 0 && numItems > 0) {
                return false;
            }
            if (numItemsCompleted >= numItems) continue;
            return false;
        }
        return true;
    }

    protected void getEventDefinitionCRFBean(HttpServletRequest request) {
        HttpSession session = request.getSession();
        EventCRFBean ecb = (EventCRFBean)ClassCastHelper.getAsType((Object)request.getAttribute(INPUT_EVENT_CRF), EventCRFBean.class);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.getDataSource());
        StudyBean study = (StudyBean)ClassCastHelper.getAsType((Object)session.getAttribute("study"), StudyBean.class);
        edcdao.findByStudyEventIdAndCRFVersionId(study, ecb.getStudyEventId(), ecb.getCRFVersionId());
    }

    protected List<DisplayItemWithGroupBean> createItemWithGroups(DisplaySectionBean dsb, boolean hasItemGroup, int eventCRFDefId, HttpServletRequest request, boolean isSubmitted) {
        HttpSession session = request.getSession();
        ArrayList<DisplayItemWithGroupBean> displayItemWithGroups = new ArrayList<DisplayItemWithGroupBean>();
        EventCRFBean ecb = (EventCRFBean)ClassCastHelper.getAsType((Object)request.getAttribute(INPUT_EVENT_CRF), EventCRFBean.class);
        ItemDAO idao = new ItemDAO(this.getDataSource());
        SectionBean sb = (SectionBean)ClassCastHelper.getAsType((Object)request.getAttribute(SECTION_BEAN), SectionBean.class);
        ArrayList items = dsb.getItems();
        FormBeanUtil formBeanUtil = new FormBeanUtil();
        List nullValuesList = formBeanUtil.getNullValuesByEventCRFDefId(eventCRFDefId, this.getDataSource());
        LOGGER.trace("single items size: " + items.size());
        for (int i = 0; i < items.size(); ++i) {
            DisplayItemBean item = (DisplayItemBean)items.get(i);
            DisplayItemWithGroupBean newOne = new DisplayItemWithGroupBean();
            newOne.setSingleItem(this.runDynamicsItemCheck(item, null, request));
            newOne.setOrdinal(item.getMetadata().getOrdinal());
            newOne.setInGroup(false);
            newOne.setPageNumberLabel(item.getMetadata().getPageNumberLabel());
            displayItemWithGroups.add(newOne);
        }
        if (hasItemGroup) {
            ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
            ArrayList data = iddao.findAllBySectionIdAndEventCRFId(sb.getId(), ecb.getId());
            HashMap dataMap = this.getAllActive((List)data);
            if (data != null && data.size() > 0) {
                session.setAttribute(HAS_DATA_FLAG, (Object)true);
            }
            LOGGER.trace("found data: " + data.size());
            LOGGER.trace("data.toString: " + data.toString());
            for (DisplayItemGroupBean itemGroup : dsb.getDisplayFormGroups()) {
                LOGGER.debug("found one itemGroup");
                DisplayItemWithGroupBean newOne = new DisplayItemWithGroupBean();
                DisplayItemBean firstItem = (DisplayItemBean)itemGroup.getItems().get(0);
                newOne.setPageNumberLabel(firstItem.getMetadata().getPageNumberLabel());
                newOne.setItemGroup(itemGroup);
                newOne.setInGroup(true);
                newOne.setOrdinal(itemGroup.getGroupMetaBean().getOrdinal().intValue());
                List itBeans = idao.findAllItemsByGroupIdOrdered(itemGroup.getItemGroupBean().getId(), sb.getCRFVersionId());
                List dibs = new ArrayList();
                boolean hasData = false;
                if (data.size() > 0) {
                    hasData = true;
                }
                newOne = this.buildMatrixForRepeatingGroups(newOne, itemGroup, ecb, sb, itBeans, (Map)dataMap, nullValuesList, isSubmitted);
                if (hasData) {
                    session.setAttribute(GROUP_HAS_DATA, (Object)Boolean.TRUE);
                } else {
                    session.setAttribute(GROUP_HAS_DATA, (Object)Boolean.FALSE);
                    if (nullValuesList != null && nullValuesList.size() > 0) {
                        LOGGER.trace("set with nullValuesList of : " + nullValuesList);
                    }
                    dibs = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)this.getDataSource(), (EventCRFBean)ecb, (int)sb.getId(), (List)nullValuesList, (ServletContext)this.getServletContext());
                    DisplayItemGroupBean digb2 = new DisplayItemGroupBean();
                    digb2.setItems(dibs);
                    digb2.setEditFlag("initial");
                }
                displayItemWithGroups.add(newOne);
            }
        }
        Collections.sort(displayItemWithGroups);
        return displayItemWithGroups;
    }

    private HashMap<String, ItemDataBean> getAllActive(List<ItemDataBean> al) {
        HashMap<String, ItemDataBean> returnMap = new HashMap<String, ItemDataBean>();
        for (ItemDataBean itBean : al) {
            if (itBean == null) continue;
            returnMap.put(new String(itBean.getItemId() + "," + itBean.getOrdinal()), itBean);
        }
        return returnMap;
    }

    protected DisplayItemWithGroupBean buildMatrixForRepeatingGroups(DisplayItemWithGroupBean diwgb, DisplayItemGroupBean itemGroup, EventCRFBean ecb, SectionBean sb, List<ItemBean> itBeans, Map<String, ItemDataBean> dataMap, List<String> nullValuesList, boolean isSubmitted) {
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        int maxOrdinal = iddao.getMaxOrdinalForGroup(ecb, sb, itemGroup.getItemGroupBean());
        if (maxOrdinal == 0) {
            maxOrdinal = 1;
        }
        ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.getDataSource());
        ArrayList<DisplayItemGroupBean> itemGroups = new ArrayList<DisplayItemGroupBean>();
        boolean groupHasData = false;
        for (int i = 1; i <= maxOrdinal; ++i) {
            ArrayList<DisplayItemBean> displayItemBeans = new ArrayList<DisplayItemBean>();
            DisplayItemGroupBean dig = new DisplayItemGroupBean();
            for (ItemBean itBean : itBeans) {
                DisplayItemBean displayItemBean = new DisplayItemBean();
                ItemFormMetadataBean ifm = ifmdao.findByItemIdAndCRFVersionId(itBean.getId(), ecb.getCRFVersionId());
                displayItemBean.setMetadata(ifm);
                displayItemBean.setItem(itBean);
                ItemDataBean itemData = dataMap.get(itBean.getId() + "," + i);
                if (itemData != null) {
                    groupHasData = true;
                    displayItemBean.setIsNewItem(false);
                }
                if (itemData == null) {
                    itemData = displayItemBean.getData();
                    itemData.setValue("");
                    itemData.setOrdinal(i);
                }
                this.addNullValues(displayItemBean, nullValuesList);
                displayItemBean.setData(itemData);
                if (ecb.getStage() == DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE || ecb.getStage() == DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) {
                    if (this.shouldLoadDBValues(displayItemBean) && !isSubmitted) {
                        displayItemBean.loadDBValue();
                    }
                } else if (this.shouldLoadDBValues(displayItemBean)) {
                    LOGGER.trace("should load db values is true, set value");
                    displayItemBean.loadDBValue();
                    LOGGER.trace("just got data loaded: " + displayItemBean.getData().getValue());
                }
                displayItemBeans.add(displayItemBean);
            }
            Collections.sort(displayItemBeans);
            dig.setItems(displayItemBeans);
            dig.setHasData(groupHasData);
            itemGroups.add(dig);
        }
        diwgb.setItemGroups(itemGroups);
        diwgb.setDbItemGroups(itemGroups);
        return diwgb;
    }

    private void addNullValues(DisplayItemBean displayItemBean, List<String> nullValuesList) {
        boolean hasNullValues;
        boolean bl = hasNullValues = nullValuesList != null && !nullValuesList.isEmpty();
        if (!hasNullValues) {
            return;
        }
        String tmpVal = "";
        String responseName = displayItemBean.getMetadata().getResponseSet().getResponseType().getName();
        ArrayList respOptions = displayItemBean.getMetadata().getResponseSet().getOptions();
        if (respOptions != null && ("checkbox".equalsIgnoreCase(responseName) || "radio".equalsIgnoreCase(responseName) || "single-select".equalsIgnoreCase(responseName) || "multi-select".equalsIgnoreCase(responseName))) {
            for (String val : nullValuesList) {
                ResponseOptionBean respBean = new ResponseOptionBean();
                tmpVal = (String)DataEntryInputGenerator.NULL_VALUES_LONGVERSION.get(val);
                if (tmpVal != null && tmpVal.length() > 0) {
                    respBean.setText(tmpVal);
                } else {
                    respBean.setText(val);
                }
                respBean.setValue(val);
                displayItemBean.getMetadata().getResponseSet().addOption(respBean);
            }
        }
    }

    protected void loadItemsWithGroupRows(DisplayItemWithGroupBean itemWithGroup, SectionBean sb, EventDefinitionCRFBean edcb, EventCRFBean ecb, HttpServletRequest request) {
        DisplayItemBean firstItem;
        ItemDAO idao = new ItemDAO(this.getDataSource());
        FormBeanUtil formBeanUtil = new FormBeanUtil();
        List nullValuesList = new ArrayList();
        nullValuesList = formBeanUtil.getNullValuesByEventCRFDefId(edcb.getId(), this.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        ArrayList data = iddao.findAllActiveBySectionIdAndEventCRFId(sb.getId(), ecb.getId());
        DisplayItemGroupBean itemGroup = itemWithGroup.getItemGroup();
        DisplayItemBean checkItem = firstItem = (DisplayItemBean)itemGroup.getItems().get(0);
        boolean noNeedToSwitch = false;
        for (int i = 0; i < data.size(); ++i) {
            ItemDataBean idb = (ItemDataBean)data.get(i);
            if (idb.getItemId() != firstItem.getItem().getId()) continue;
            noNeedToSwitch = true;
        }
        if (!noNeedToSwitch) {
            checkItem = (DisplayItemBean)itemGroup.getItems().get(itemGroup.getItems().size() - 1);
        }
        itemWithGroup.setPageNumberLabel(firstItem.getMetadata().getPageNumberLabel());
        itemWithGroup.setItemGroup(itemGroup);
        itemWithGroup.setInGroup(true);
        itemWithGroup.setOrdinal(itemGroup.getGroupMetaBean().getOrdinal().intValue());
        List itBeans = idao.findAllItemsByGroupId(itemGroup.getItemGroupBean().getId(), sb.getCRFVersionId());
        boolean hasData = false;
        int checkAllColumns = 0;
        for (int i = 0; i < data.size(); ++i) {
            ItemDataBean idb = (ItemDataBean)data.get(i);
            LOGGER.debug("check all columns: " + checkAllColumns);
            if (idb.getItemId() != checkItem.getItem().getId()) continue;
            hasData = true;
            LOGGER.debug("set has data to --TRUE--");
            checkAllColumns = 0;
            LOGGER.debug("has data set to true");
            DisplayItemGroupBean digb = new DisplayItemGroupBean();
            List dibs = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)this.getDataSource(), (EventCRFBean)ecb, (int)sb.getId(), (EventDefinitionCRFBean)edcb, (int)0, (ServletContext)this.getServletContext());
            digb.setItems(dibs);
            LOGGER.trace("set with dibs list of : " + dibs.size());
            digb.setGroupMetaBean(this.runDynamicsCheck(itemGroup.getGroupMetaBean(), request));
            digb.setItemGroupBean(itemGroup.getItemGroupBean());
            itemWithGroup.getItemGroups().add(digb);
            itemWithGroup.getDbItemGroups().add(digb);
        }
        List groupRows = itemWithGroup.getItemGroups();
        LOGGER.trace("how many group rows:" + groupRows.size());
        LOGGER.trace("how big is the data:" + data.size());
        if (hasData) {
            for (int i = 0; i < groupRows.size(); ++i) {
                DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)groupRows.get(i);
                block3: for (DisplayItemBean dib : displayGroup.getItems()) {
                    for (int j = 0; j < data.size(); ++j) {
                        ItemDataBean idb = (ItemDataBean)data.get(j);
                        if (idb.getItemId() != dib.getItem().getId() || idb.isSelected()) continue;
                        idb.setSelected(true);
                        dib.setData(idb);
                        LOGGER.debug("--> set data " + idb.getId() + ": " + idb.getValue());
                        if (!this.shouldLoadDBValues(dib)) continue block3;
                        LOGGER.debug("+++should load db values is true, set value");
                        dib.loadDBValue();
                        LOGGER.debug("+++data loaded: " + idb.getName() + ": " + idb.getOrdinal() + " " + idb.getValue());
                        LOGGER.debug("+++try dib OID: " + dib.getItem().getOid());
                        continue block3;
                    }
                }
            }
        } else {
            DisplayItemGroupBean digb2 = new DisplayItemGroupBean();
            List dibs = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)this.getDataSource(), (EventCRFBean)ecb, (int)sb.getId(), nullValuesList, (ServletContext)this.getServletContext());
            digb2.setItems(dibs);
            LOGGER.trace("set with nullValuesList of : " + nullValuesList);
            digb2.setEditFlag("initial");
            digb2.setGroupMetaBean(itemGroup.getGroupMetaBean());
            digb2.setItemGroupBean(itemGroup.getItemGroupBean());
            itemWithGroup.getItemGroups().add(digb2);
            itemWithGroup.getDbItemGroups().add(digb2);
        }
    }

    private List<DisplayItemBean> processInputForGroupItem(FormProcessor fp, List<DisplayItemBean> dibs, int i, DisplayItemGroupBean digb, boolean isAuto) {
        for (int j = 0; j < dibs.size(); ++j) {
            DisplayItemBean displayItem = dibs.get(j);
            String inputName = "";
            ResponseType rt = displayItem.getMetadata().getResponseSet().getResponseType();
            if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
                inputName = isAuto ? this.getGroupItemInputName(digb, i, displayItem) : this.getGroupItemManualInputName(digb, i, displayItem);
                ArrayList valueArray = fp.getStringArray(inputName);
                displayItem.setFieldName(inputName);
                displayItem.loadFormValue(valueArray);
                continue;
            }
            inputName = isAuto ? this.getGroupItemInputName(digb, i, displayItem) : this.getGroupItemManualInputName(digb, i, displayItem);
            displayItem.setFieldName(inputName);
            displayItem.loadFormValue(fp.getString(inputName));
            if (!rt.equals((Term)ResponseType.SELECT)) continue;
            this.ensureSelectedOption(displayItem);
        }
        return dibs;
    }

    public final String getGroupItemManualInputName(DisplayItemGroupBean digb, int ordinal, DisplayItemBean dib) {
        String inputName = digb.getItemGroupBean().getOid() + "_manual" + ordinal + this.getInputName(dib);
        LOGGER.debug("+++ returning manual: " + inputName);
        return inputName;
    }

    private EventCRFBean updateECB(StudyEventBean sEvent, HttpServletRequest request) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        if (!currentStudy.getStudyParameterConfig().getInterviewerNameDefault().equals("blank") && ("".equals(ecb.getInterviewerName()) || ecb.getInterviewerName() == null)) {
            ecb.setInterviewerName(sEvent.getOwner().getName());
        }
        if (!currentStudy.getStudyParameterConfig().getInterviewDateDefault().equals("blank") && (ecb.getDateInterviewed() == null || "".equals(ecb.getDateInterviewed().toString()))) {
            if (sEvent.getDateStarted() != null) {
                ecb.setDateInterviewed(sEvent.getDateStarted());
            } else {
                ecb.setDateInterviewed(null);
            }
        }
        return ecb;
    }

    protected HashMap<String, ItemBean> prepareScoreItems(HttpServletRequest request) {
        HashMap<String, ItemBean> scoreItems = new HashMap<String, ItemBean>();
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        ItemDAO idao = new ItemDAO(this.getDataSource());
        ArrayList ibs = idao.findAllItemsByVersionId(ecb.getCRFVersionId());
        for (ItemBean ib : ibs) {
            scoreItems.put(ib.getName(), ib);
        }
        return scoreItems;
    }

    protected HashMap<String, String> prepareScoreItemdata(HttpServletRequest request) {
        HashMap<String, String> scoreItemdata = new HashMap<String, String>();
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        ArrayList sbs = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
        for (SectionBean section : sbs) {
            HashMap data = this.prepareSectionItemDataBeans(section.getId(), request);
            if (data == null || data.size() <= 0) continue;
            scoreItemdata.putAll(data);
        }
        return scoreItemdata;
    }

    protected HashMap<String, String> prepareSectionItemDataBeans(int sectionId, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)ClassCastHelper.getAsType((Object)request.getAttribute(INPUT_EVENT_CRF), EventCRFBean.class);
        HashMap<String, String> scoreItemdata = new HashMap<String, String>();
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        ArrayList idbs = iddao.findAllActiveBySectionIdAndEventCRFId(sectionId, ecb.getId());
        for (ItemDataBean idb : idbs) {
            if (idb.getId() <= 0) continue;
            int ordinal = idb.getOrdinal();
            ordinal = ordinal > 0 ? ordinal : 1;
            scoreItemdata.put(idb.getItemId() + "_" + ordinal, idb.getValue().length() > 0 ? idb.getValue() : "");
        }
        return scoreItemdata;
    }

    protected HashMap<Integer, TreeSet<Integer>> prepareItemdataOrdinals(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        HashMap<Integer, TreeSet<Integer>> ordinals = new HashMap<Integer, TreeSet<Integer>>();
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        ArrayList sbs = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        for (SectionBean section : sbs) {
            ArrayList idbs = iddao.findAllActiveBySectionIdAndEventCRFId(section.getId(), ecb.getId());
            if (idbs == null || idbs.size() <= 0) continue;
            for (ItemDataBean idb : idbs) {
                int itemId = idb.getItemId();
                TreeSet<Integer> os = ordinals.get(itemId);
                if (os == null) {
                    os = new TreeSet();
                }
                os.add(idb.getOrdinal());
                ordinals.put(itemId, os);
            }
        }
        return ordinals;
    }

    protected HashMap<Integer, Integer> prepareGroupSizes(HashMap<String, ItemBean> scoreItems, HttpServletRequest request) {
        HashMap<Integer, Integer> groupSizes = new HashMap<Integer, Integer>();
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        for (String key : scoreItems.keySet()) {
            int itemId = scoreItems.get(key).getId();
            groupSizes.put(itemId, 1);
        }
        ArrayList sbs = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
        for (SectionBean section : sbs) {
            ArrayList idbs = iddao.findAllActiveBySectionIdAndEventCRFId(section.getId(), ecb.getId());
            for (ItemDataBean idb : idbs) {
                int itemId = idb.getItemId();
                if (groupSizes == null || !groupSizes.containsKey(itemId)) continue;
                int groupsize = iddao.getGroupSize(itemId, ecb.getId());
                groupsize = groupsize > 0 ? groupsize : 1;
                groupSizes.put(itemId, groupsize);
            }
        }
        return groupSizes;
    }

    protected HashMap<Integer, String> prepareSectionItemdata(int sectionId, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        HashMap<Integer, String> itemdata = new HashMap<Integer, String>();
        ArrayList idbs = iddao.findAllActiveBySectionIdAndEventCRFId(sectionId, ecb.getId());
        for (ItemDataBean idb : idbs) {
            itemdata.put(idb.getId(), idb.getValue());
        }
        return itemdata;
    }

    protected HashMap<String, ItemDataBean> prepareSectionItemdataObject(int sectionId, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute(INPUT_EVENT_CRF);
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource(), this.locale);
        HashMap<String, ItemDataBean> itemdata = new HashMap<String, ItemDataBean>();
        ArrayList idbs = iddao.findAllActiveBySectionIdAndEventCRFId(sectionId, ecb.getId());
        for (ItemDataBean idb : idbs) {
            itemdata.put(idb.getItemId() + "," + idb.getOrdinal(), idb);
        }
        return itemdata;
    }

    protected boolean isChanged(ItemDataBean idb, HashMap<Integer, String> oldItemdata) {
        String value = idb.getValue();
        if (!oldItemdata.containsKey(idb.getId())) {
            return true;
        }
        String oldValue = oldItemdata.get(idb.getId());
        if (oldValue != null) {
            if (value == null) {
                return true;
            }
            if (!oldValue.equals(value)) {
                return true;
            }
        } else {
            if (value.isEmpty()) {
                return false;
            }
            if (value != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean isChanged(DisplayItemBean dib, HashMap<String, ItemDataBean> oldItemdata, String attachedFilePath) {
        ItemDataBean idb = dib.getData();
        String value = idb.getValue();
        int ordinal = idb.getOrdinal();
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        if (rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            return false;
        }
        String tempKey = idb.getItemId() + "," + idb.getOrdinal();
        if (!oldItemdata.containsKey(tempKey)) {
            return value == null || !value.isEmpty();
        }
        ItemDataBean existingItemData = oldItemdata.get(tempKey);
        String oldValue = existingItemData.getValue();
        int oldOrdinal = existingItemData.getOrdinal();
        if (oldValue != null) {
            if (value == null) {
                if (ordinal == oldOrdinal) {
                    return true;
                }
            } else {
                if (dib.getItem().getDataType().getId() == 11) {
                    String theOldValue = oldValue.split("(/|\\\\)")[oldValue.split("(/|\\\\)").length - 1].trim();
                    return !value.equals(theOldValue);
                }
                if (!oldValue.equals(value) && ordinal == oldOrdinal) {
                    return true;
                }
            }
        } else {
            if (value != null && value.isEmpty()) {
                return false;
            }
            if (value != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean isChanged(ItemDataBean idb, HashMap<String, ItemDataBean> oldItemdata, DisplayItemBean dib, String attachedFilePath) {
        return this.isChanged(dib, oldItemdata, attachedFilePath);
    }

    protected void output(List<DisplayItemWithGroupBean> displayItemWithGroups) {
        for (int i = 0; i < displayItemWithGroups.size(); ++i) {
            DisplayItemWithGroupBean diwb = displayItemWithGroups.get(i);
            if (!diwb.isInGroup()) continue;
            List dbGroups = diwb.getDbItemGroups();
            LOGGER.trace("+++++++ DB ITEM GROUPS ++++++++");
            for (int j = 0; j < dbGroups.size(); ++j) {
                DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dbGroups.get(j);
                List items = displayGroup.getItems();
                for (DisplayItemBean displayItem : items) {
                    int itemId = displayItem.getItem().getId();
                    int ordinal = displayItem.getData().getOrdinal();
                    if ("initial".equalsIgnoreCase(displayGroup.getEditFlag())) {
                        LOGGER.trace("* found initial: " + itemId + " " + ordinal);
                        continue;
                    }
                    LOGGER.trace("** found NOT initial: " + itemId + " " + ordinal);
                }
            }
            List dgbs = diwb.getItemGroups();
            LOGGER.trace("+++++++++ ITEM GROUPS ++++++++++");
            for (int j = 0; j < dgbs.size(); ++j) {
                DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dgbs.get(j);
                List oItems = displayGroup.getItems();
                String editFlag = displayGroup.getEditFlag();
                for (DisplayItemBean displayItem : oItems) {
                    int itemId = displayItem.getItem().getId();
                    LOGGER.trace("*** found edit Flag " + itemId + ": " + editFlag);
                }
            }
        }
    }

    protected void updateDataOrdinals(List<DisplayItemWithGroupBean> displayItemWithGroups) {
        for (int i = 0; i < displayItemWithGroups.size(); ++i) {
            DisplayItemWithGroupBean diwb = displayItemWithGroups.get(i);
            HashMap<Integer, String> editFlags = new HashMap<Integer, String>();
            HashMap<Integer, Integer> nextOrdinals = new HashMap<Integer, Integer>();
            if (!diwb.isInGroup()) continue;
            List dbGroups = diwb.getDbItemGroups();
            for (int j = 0; j < dbGroups.size(); ++j) {
                DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dbGroups.get(j);
                List items = displayGroup.getItems();
                for (DisplayItemBean displayItem : items) {
                    int itemId = displayItem.getItem().getId();
                    int ordinal = displayItem.getData().getOrdinal();
                    if ("initial".equalsIgnoreCase(displayGroup.getEditFlag())) {
                        nextOrdinals.put(itemId, 1);
                    } else if (nextOrdinals.containsKey(itemId)) {
                        int max = (Integer)nextOrdinals.get(itemId);
                        nextOrdinals.put(itemId, ordinal > max ? ordinal + 1 : max);
                    } else {
                        nextOrdinals.put(itemId, ordinal + 1);
                    }
                    editFlags.put(displayItem.getData().getId(), displayGroup.getEditFlag());
                }
            }
            List dgbs = diwb.getItemGroups();
            int nextOrdinal = 0;
            for (int j = 0; j < dgbs.size(); ++j) {
                DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dgbs.get(j);
                List oItems = displayGroup.getItems();
                String editFlag = displayGroup.getEditFlag();
                for (DisplayItemBean displayItem : oItems) {
                    int itemId = displayItem.getItem().getId();
                    nextOrdinal = (Integer)nextOrdinals.get(itemId);
                    int ordinal = 0;
                    String editflag = "add".equalsIgnoreCase(editFlag) ? editFlag : (String)editFlags.get(displayItem.getData().getId());
                    if (editflag.length() <= 0) continue;
                    if ("add".equalsIgnoreCase(editflag)) {
                        ordinal = (Integer)nextOrdinals.get(itemId);
                        displayItem.getData().setOrdinal(ordinal);
                        nextOrdinals.put(itemId, nextOrdinal + 1);
                        continue;
                    }
                    if (!"edit".equalsIgnoreCase(editflag)) continue;
                    displayItem.getData().setOrdinal(displayItem.getDbData().getOrdinal());
                }
            }
        }
    }

    private void customValidation(DiscrepancyValidator v, DisplayItemBean dib, String inputName) {
        String customValidationString = dib.getMetadata().getRegexp();
        if (customValidationString != null && !customValidationString.trim().isEmpty()) {
            Validation customValidation = null;
            if (customValidationString.startsWith("func:")) {
                try {
                    customValidation = Validator.processCRFValidationFunction((String)customValidationString);
                }
                catch (Exception e) {
                    LOGGER.error("CRF func: validation is failed: ", (Throwable)e);
                }
            } else if (customValidationString.startsWith("regexp:")) {
                try {
                    customValidation = Validator.processCRFValidationRegex((String)customValidationString);
                }
                catch (Exception e) {
                    LOGGER.error("CRF regexp: validation is failed: ", (Throwable)e);
                }
            }
            if (customValidation != null) {
                customValidation.setErrorMessage(dib.getMetadata().getRegexpErrorMsg());
                v.addValidation(inputName, customValidation);
            }
        }
    }

    private String ifValueIsDate(ItemBean itemBean, String value, boolean dryRun) {
        String dateFormat = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
        String dateRegexp = ResourceBundleProvider.getFormatBundle().getString("date_regexp");
        String theFinalValue = value;
        theFinalValue = value != null && itemBean.getDataType() == ItemDataType.DATE && dryRun ? ExpressionTreeHelper.ifValidDateFormatAsyyyyMMdd((String)value, (String)dateFormat, (String)dateRegexp) : ExpressionTreeHelper.isValidDateMMddyyyy((String)value);
        return theFinalValue;
    }

    private Container populateRuleSpecificHashMaps(List<DisplayItemWithGroupBean> allItems, Container c, Boolean dryRun) {
        for (DisplayItemWithGroupBean displayItemWithGroupBean : allItems) {
            if (displayItemWithGroupBean.getSingleItem() != null) {
                if (displayItemWithGroupBean.getSingleItem().getItem().getOid() != null) {
                    c.grouped.put(displayItemWithGroupBean.getSingleItem().getItem().getOid(), 1);
                    c.variableAndValue.put(displayItemWithGroupBean.getSingleItem().getItem().getOid(), this.ifValueIsDate(displayItemWithGroupBean.getSingleItem().getItem(), displayItemWithGroupBean.getSingleItem().getData().getValue(), dryRun.booleanValue()));
                    LOGGER.debug("Type : " + displayItemWithGroupBean.getSingleItem().getItem().getItemDataTypeId());
                    for (Object displayItemBean : displayItemWithGroupBean.getSingleItem().getChildren()) {
                        String oid = ((DisplayItemBean)displayItemBean).getItem().getOid();
                        String value = this.ifValueIsDate(((DisplayItemBean)displayItemBean).getItem(), ((DisplayItemBean)displayItemBean).getData().getValue(), dryRun.booleanValue());
                        LOGGER.debug("Type : " + ((DisplayItemBean)displayItemBean).getItem().getItemDataTypeId());
                        c.grouped.put(oid, 1);
                        c.variableAndValue.put(oid, value);
                    }
                }
                LOGGER.debug("Item Name : {} , Item Value : {} , Item Data Ordinal : {} , Item OID : {} ", new Object[]{displayItemWithGroupBean.getSingleItem().getItem().getName(), displayItemWithGroupBean.getSingleItem().getData().getValue(), displayItemWithGroupBean.getSingleItem().getData().getOrdinal(), displayItemWithGroupBean.getSingleItem().getItem().getOid()});
            }
            for (DisplayItemGroupBean itemGroupBean : displayItemWithGroupBean.getItemGroups()) {
                LOGGER.debug("Item Group Name : {} , Item Group OID : {} , Ordinal : {} ", new Object[]{itemGroupBean.getItemGroupBean().getName(), itemGroupBean.getItemGroupBean().getOid(), itemGroupBean.getIndex()});
                for (DisplayItemBean displayItemBean : itemGroupBean.getItems()) {
                    String key1 = itemGroupBean.getItemGroupBean().getOid() + "[" + (itemGroupBean.getIndex() + 1) + "]." + displayItemBean.getItem().getOid();
                    String key = itemGroupBean.getItemGroupBean().getOid() + "." + displayItemBean.getItem().getOid();
                    c.variableAndValue.put(key1, this.ifValueIsDate(displayItemBean.getItem(), displayItemBean.getData().getValue(), dryRun.booleanValue()));
                    if (c.grouped.containsKey(key)) {
                        c.grouped.put(key, (Integer)c.grouped.get(key) + 1);
                    } else {
                        c.grouped.put(key, 1);
                    }
                    LOGGER.debug("Item Name : {} , Item Value : {} , Item OID : {} ", new Object[]{displayItemBean.getItem().getName(), displayItemBean.getData().getValue(), displayItemBean.getItem().getOid()});
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            for (String key : c.grouped.keySet()) {
                LOGGER.debug("key : {} , value : {}", (Object)key, c.grouped.get(key));
            }
            for (String key : c.variableAndValue.keySet()) {
                LOGGER.debug("key : {} , value : {}", (Object)key, c.variableAndValue.get(key));
            }
        }
        return c;
    }

    private List<RuleSetBean> createAndInitializeRuleSet(StudyBean currentStudy, StudyEventDefinitionBean studyEventDefinition, CRFVersionBean crfVersionBean, StudyEventBean studyEventBean, EventCRFBean eventCrfBean, Boolean shouldRunRules, HttpServletRequest request, HttpServletResponse response, List<ItemBean> itemBeansWithSCDShown) {
        if (shouldRunRules.booleanValue()) {
            this.logMe("Current Thread:::" + Thread.currentThread());
            List ruleSets = this.getRuleSetService(request).getRuleSetsByCrfStudyAndStudyEventDefinition(currentStudy, studyEventDefinition, crfVersionBean);
            this.logMe("Current Thread:::" + Thread.currentThread() + "RuleSet Now?" + ruleSets);
            if (ruleSets != null && ruleSets.size() > 0) {
                ruleSets = this.getRuleSetService(request).filterByStatusEqualsAvailable(ruleSets);
                ruleSets = this.getRuleSetService(request).filterRuleSetsByStudyEventOrdinal(ruleSets, studyEventBean, crfVersionBean, studyEventDefinition);
                ruleSets = this.getRuleSetService(request).filterRuleSetsByHiddenItems(ruleSets, eventCrfBean, crfVersionBean, itemBeansWithSCDShown);
            }
            return ruleSets != null && ruleSets.size() > 0 ? ruleSets : new ArrayList();
        }
        return new ArrayList<RuleSetBean>();
    }

    private HashMap<String, ArrayList<String>> runRules(List<DisplayItemWithGroupBean> allItems, List<RuleSetBean> ruleSets, Boolean dryRun, Boolean shouldRunRules, MessageContainer.MessageType mt, RuleActionRunBean.Phase phase, EventCRFBean ecb, HttpServletRequest request) {
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (shouldRunRules.booleanValue()) {
            Container c = new Container(this);
            try {
                c = this.populateRuleSpecificHashMaps(allItems, c, dryRun);
                ruleSets = this.getRuleSetService(request).filterRuleSetsBySectionAndGroupOrdinal(ruleSets, c.grouped);
                ruleSets = this.getRuleSetService(request).solidifyGroupOrdinalsUsingFormProperties(ruleSets, c.grouped);
            }
            catch (NullPointerException npe) {
                LOGGER.debug("found NPE ", (Throwable)npe);
            }
            LOGGER.debug("running rules ... rule sets size is " + ruleSets.size());
            return this.getRuleSetService(request).runRulesInDataEntry(ruleSets, dryRun, currentStudy, ub, c.variableAndValue, phase, ecb, request).getByMessageType(mt);
        }
        return new HashMap<String, ArrayList<String>>();
    }

    protected abstract boolean shouldRunRules();

    protected abstract boolean isAdministrativeEditing();

    protected abstract boolean isAdminForcedReasonForChange(HttpServletRequest var1);

    private RuleSetServiceInterface getRuleSetService(HttpServletRequest request) {
        RuleSetServiceInterface ruleSetService = null;
        ruleSetService = ruleSetService != null ? ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("ruleSetService");
        ruleSetService.setContextPath(this.getContextPath(request));
        ruleSetService.setMailSender((JavaMailSenderImpl)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("mailSender"));
        ruleSetService.setRequestURLMinusServletPath(this.getRequestURLMinusServletPath(request));
        return ruleSetService;
    }

    private void ensureSelectedOption(DisplayItemBean displayItemBean) {
        if (displayItemBean == null || displayItemBean.getData() == null) {
            return;
        }
        ItemDataBean itemDataBean = displayItemBean.getData();
        String dataValue = itemDataBean.getValue();
        if ("".equalsIgnoreCase(dataValue)) {
            return;
        }
        ArrayList responseOptionBeans = new ArrayList();
        ResponseSetBean responseSetBean = displayItemBean.getMetadata().getResponseSet();
        if (responseSetBean == null) {
            return;
        }
        responseOptionBeans = responseSetBean.getOptions();
        String tempVal = "";
        for (ResponseOptionBean responseOptionBean : responseOptionBeans) {
            tempVal = responseOptionBean.getValue();
            if (tempVal == null || !tempVal.equalsIgnoreCase(dataValue)) continue;
            responseOptionBean.setSelected(true);
        }
    }

    protected boolean unloadFiles(HashMap<String, String> newUploadedFiles) {
        boolean success = true;
        for (String itemId : newUploadedFiles.keySet()) {
            String filename = newUploadedFiles.get(itemId);
            File f = new File(filename);
            if (f.exists()) {
                if (f.delete()) {
                    newUploadedFiles.remove("filename");
                    continue;
                }
                success = false;
                continue;
            }
            newUploadedFiles.remove("filename");
        }
        return success;
    }

    public int getManualRows(List<DisplayItemGroupBean> formGroups) {
        int manualRows = 0;
        for (int j = 0; j < formGroups.size(); ++j) {
            DisplayItemGroupBean formItemGroup = formGroups.get(j);
            LOGGER.debug("begin formGroup Ordinal:" + formItemGroup.getOrdinal());
            if (formItemGroup.isAuto()) continue;
            ++manualRows;
        }
        LOGGER.debug("+++ returning manual rows: " + manualRows + " from a form group size of " + formGroups.size());
        return manualRows;
    }

    private HashMap<String, ArrayList<String>> reshuffleErrorGroupNamesKK(HashMap<String, ArrayList<String>> errors, List<DisplayItemWithGroupBean> allItems, HttpServletRequest request) {
        int manualRows = 0;
        if (errors == null || errors.size() < 1) {
            return errors;
        }
        for (int i = 0; i < allItems.size(); ++i) {
            DisplayItemWithGroupBean diwb = allItems.get(i);
            if (!diwb.isInGroup()) continue;
            List dgbs = diwb.getItemGroups();
            for (int j = 0; j < dgbs.size(); ++j) {
                String replacementKey;
                String intendedKey;
                DisplayItemGroupBean digb = (DisplayItemGroupBean)dgbs.get(j);
                List dibs = digb.getItems();
                if (j == 0) {
                    for (DisplayItemBean dib : dibs) {
                        intendedKey = digb.getInputId() + this.getInputName(dib);
                        replacementKey = digb.getItemGroupBean().getOid() + "_" + j + this.getInputName(dib);
                        if (replacementKey.equals(intendedKey) || !errors.containsKey(intendedKey)) continue;
                        errors.put(replacementKey, errors.get(intendedKey));
                        errors.remove(intendedKey);
                        LOGGER.debug("removing: " + intendedKey + " and replacing it with " + replacementKey);
                    }
                    continue;
                }
                ++manualRows;
                for (DisplayItemBean dib : dibs) {
                    intendedKey = digb.getInputId() + this.getInputName(dib);
                    replacementKey = digb.getItemGroupBean().getOid() + "_manual" + j + this.getInputName(dib);
                    if (replacementKey.equals(intendedKey) || !errors.containsKey(intendedKey)) continue;
                    errors.put(replacementKey, errors.get(intendedKey));
                    errors.remove(intendedKey);
                    LOGGER.debug("removing: " + intendedKey + " and replacing it with " + replacementKey);
                }
            }
        }
        request.setAttribute("manualRows", (Object)new Integer(manualRows));
        return errors;
    }

    private void reshuffleReasonForChangeHashAndDiscrepancyNotes(List<DisplayItemWithGroupBean> allItems, HttpServletRequest request, EventCRFBean ecb) {
        HashMap noteSubmitted = ClassCastHelper.asHashMap((Object)request.getSession().getAttribute(NOTE_SUBMITTED), String.class, Boolean.class);
        FormDiscrepancyNotes noteTree = (FormDiscrepancyNotes)request.getSession().getAttribute("flagDNRFC");
        ArrayList fieldNote = null;
        String intendedKey = null;
        String replacementKey = null;
        if (!(noteSubmitted != null && noteSubmitted.size() >= 1 || noteTree != null && noteTree.getFieldNotes() != null && noteTree.getFieldNotes().size() >= 1)) {
            return;
        }
        for (int i = 0; i < allItems.size(); ++i) {
            DisplayItemWithGroupBean diwb = allItems.get(i);
            if (!diwb.isInGroup()) continue;
            List dgbs = diwb.getItemGroups();
            for (int j = 0; j < dgbs.size(); ++j) {
                DisplayItemGroupBean digb = (DisplayItemGroupBean)dgbs.get(j);
                List dibs = digb.getItems();
                if (j == 0) {
                    for (DisplayItemBean dib : dibs) {
                        intendedKey = ecb.getId() + "_" + digb.getInputId() + this.getInputName(dib);
                        replacementKey = ecb.getId() + "_" + digb.getItemGroupBean().getOid() + "_" + j + this.getInputName(dib);
                        if (replacementKey.equals(intendedKey)) continue;
                        if (noteSubmitted.containsKey(intendedKey)) {
                            noteSubmitted.put(replacementKey, Boolean.TRUE);
                            noteSubmitted.remove(intendedKey);
                        }
                        if (noteTree.getNotes(intendedKey) == null || (fieldNote = noteTree.getNotes(intendedKey)) == null || fieldNote.size() <= 0) continue;
                        noteTree.getFieldNotes().put(replacementKey, fieldNote);
                        noteTree.getFieldNotes().remove(intendedKey);
                    }
                } else {
                    for (DisplayItemBean dib : dibs) {
                        intendedKey = ecb.getId() + "_" + digb.getInputId() + this.getInputName(dib);
                        replacementKey = ecb.getId() + "_" + digb.getItemGroupBean().getOid() + "_manual" + j + this.getInputName(dib);
                        if (replacementKey.equals(intendedKey)) continue;
                        if (noteSubmitted != null && noteSubmitted.containsKey(intendedKey)) {
                            noteSubmitted.put(replacementKey, Boolean.TRUE);
                            noteSubmitted.remove(intendedKey);
                        }
                        if (noteTree == null || noteTree.getNotes(intendedKey) == null || (fieldNote = noteTree.getNotes(intendedKey)) == null || fieldNote.size() <= 0) continue;
                        noteTree.getFieldNotes().put(replacementKey, fieldNote);
                        noteTree.getFieldNotes().remove(intendedKey);
                    }
                }
                LOGGER.debug("removing: " + intendedKey + " and replacing it with " + replacementKey);
            }
        }
        request.getSession().setAttribute(NOTE_SUBMITTED, (Object)noteSubmitted);
    }

    private int getDiscrepancyNoteResolutionStatus(int itemDataId, ArrayList<DiscrepancyNoteBean> formNotes) {
        int resolutionStatus = 0;
        boolean hasOtherThread = false;
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
        ArrayList existingNotes = dndao.findExistingNotesForItemData(itemDataId);
        for (DiscrepancyNoteBean note : existingNotes) {
            if (note.getParentDnId() != 0) continue;
            if (hasOtherThread) {
                if (resolutionStatus > note.getResolutionStatusId()) {
                    resolutionStatus = note.getResolutionStatusId();
                }
            } else {
                resolutionStatus = note.getResolutionStatusId();
            }
            hasOtherThread = true;
        }
        if (formNotes == null || formNotes.isEmpty()) {
            return resolutionStatus;
        }
        for (DiscrepancyNoteBean note : formNotes) {
            if (note.getParentDnId() != 0) continue;
            if (hasOtherThread) {
                if (resolutionStatus > note.getResolutionStatusId()) {
                    resolutionStatus = note.getResolutionStatusId();
                }
            } else {
                resolutionStatus = note.getResolutionStatusId();
            }
            hasOtherThread = true;
        }
        return resolutionStatus;
    }

    private int getDiscrepancyNoteResolutionStatus(List<DiscrepancyNoteBean> existingNotes) {
        int resolutionStatus = 0;
        boolean hasOtherThread = false;
        for (DiscrepancyNoteBean note : existingNotes) {
            if (note.getParentDnId() != 0) continue;
            if (hasOtherThread) {
                if (resolutionStatus > note.getResolutionStatusId()) {
                    resolutionStatus = note.getResolutionStatusId();
                }
            } else {
                resolutionStatus = note.getResolutionStatusId();
            }
            hasOtherThread = true;
        }
        return resolutionStatus;
    }

    protected void updateDisplaySectionPlace(DisplaySectionBean displaySectionBean, DisplayTableOfContentsBean toc, HttpServletRequest request) {
        ArrayList sectionBeans;
        if (toc != null && (sectionBeans = toc.getSections()) != null && sectionBeans.size() > 0) {
            int sid = displaySectionBean.getSection().getId();
            displaySectionBean.setFirstSection(sid == ((SectionBean)sectionBeans.get(0)).getId());
            displaySectionBean.setLastSection(sid == ((SectionBean)sectionBeans.get(sectionBeans.size() - 1)).getId());
        }
    }

    protected SectionBean prevSection(SectionBean sb, EventCRFBean ecb, DisplayTableOfContentsBean toc, int sbPos) {
        SectionBean p = new SectionBean();
        ArrayList sectionBeans = new ArrayList();
        if (toc != null) {
            sectionBeans = toc.getSections();
            if (sbPos > 0) {
                p = (SectionBean)sectionBeans.get(sbPos - 1);
            }
        }
        return p != null && p.getId() > 0 ? p : new SectionBean();
    }

    protected SectionBean nextSection(SectionBean sb, EventCRFBean ecb, DisplayTableOfContentsBean toc, int sbPos) {
        SectionBean n = new SectionBean();
        ArrayList sectionBeans = new ArrayList();
        if (toc != null) {
            sectionBeans = toc.getSections();
            int size = sectionBeans.size();
            if (sbPos >= 0 && size > 1 && sbPos < size - 1) {
                n = (SectionBean)sectionBeans.get(sbPos + 1);
            }
        }
        return n != null && n.getId() > 0 ? n : new SectionBean();
    }

    public void mayAccess(HttpServletRequest request) throws InsufficientPermissionException {
        FormProcessor fp = new FormProcessor(request);
        EventCRFDAO edao = new EventCRFDAO(this.getDataSource());
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        int eventCRFId = fp.getInt("ecId", true);
        if (eventCRFId == 0) {
            eventCRFId = fp.getInt(INPUT_EVENT_CRF_ID, true);
        }
        if (eventCRFId > 0 && !this.entityIncluded(eventCRFId, ub.getName(), (AuditableEntityDAO)edao, this.getDataSource())) {
            this.addPageMessage(respage.getString("required_event_CRF_belong"), request);
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("entity_not_belong_studies"), "1");
        }
    }

    protected void populateInstantOnChange(HttpSession session, EventCRFBean ecb, DisplaySectionBean section) {
        int cvId = ecb.getCRFVersionId();
        int sectionId = section.getSection().getId();
        InstantOnChangeService ins = (InstantOnChangeService)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("instantOnChangeService");
        InstantOnChangeFrontStrParcel strsInSec = new InstantOnChangeFrontStrParcel();
        HashMap nonRepOri = null;
        HashMap grpOri = null;
        HashMap instantOnChangeFrontStrParcels = ClassCastHelper.asHashMap((Object)session.getAttribute(CV_INSTANT_META + cvId), Integer.class, InstantOnChangeFrontStrParcel.class);
        if (instantOnChangeFrontStrParcels != null && instantOnChangeFrontStrParcels.containsKey(sectionId)) {
            strsInSec = (InstantOnChangeFrontStrParcel)instantOnChangeFrontStrParcels.get(sectionId);
            nonRepOri = (HashMap)strsInSec.getNonRepOrigins();
            grpOri = (HashMap)strsInSec.getRepOrigins();
        } else if ((instantOnChangeFrontStrParcels == null || instantOnChangeFrontStrParcels.size() == 0) && (instantOnChangeFrontStrParcels = (HashMap)ins.instantOnChangeFrontStrParcelInCrfVersion(Integer.valueOf(cvId))).size() > 0) {
            session.setAttribute(CV_INSTANT_META + cvId, (Object)instantOnChangeFrontStrParcels);
            if (instantOnChangeFrontStrParcels.containsKey(sectionId) && (strsInSec = (InstantOnChangeFrontStrParcel)instantOnChangeFrontStrParcels.get(sectionId)) != null) {
                grpOri = (HashMap)strsInSec.getRepOrigins();
                nonRepOri = (HashMap)strsInSec.getNonRepOrigins();
            }
        }
        if (grpOri != null && grpOri.size() > 0) {
            ins.itemGroupsInstantUpdate(section.getDisplayItemGroups(), (Map)grpOri);
        }
        if (nonRepOri != null && nonRepOri.size() > 0) {
            ins.itemsInstantUpdate(section.getDisplayItemGroups(), nonRepOri);
        }
    }
}

