/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.AuditableEntityBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.DisplayEventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ViewStudySubjectServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.crfdata.HideCRFManager;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class EnterDataForStudyEventServlet
extends SecureController {
    private static final long serialVersionUID = -3152159894339737423L;
    private Locale locale;
    public static final String INPUT_EVENT_ID = "eventId";
    public static final String BEAN_STUDY_EVENT = "studyEvent";
    public static final String BEAN_STUDY_SUBJECT = "studySubject";
    public static final String BEAN_UNCOMPLETED_EVENTDEFINITIONCRFS = "uncompletedEventDefinitionCRFs";
    public static final String BEAN_DISPLAY_EVENT_CRFS = "displayEventCRFs";
    public static final String HAS_LOCATION_NOTE = "hasLocationNote";
    public static final String HAS_START_DATE_NOTE = "hasStartDateNote";
    public static final String HAS_END_DATE_NOTE = "hasEndDateNote";
    public static final String STATUS_DN_LOCATION = "statusDnLocation";
    public static final String STATUS_DN_START_DATE = "statusDnStartDate";
    public static final String STATUS_DN_END_DATE = "statusDnEndDate";

    private StudyEventBean getStudyEvent(int eventId) throws Exception {
        AuditableEntityBean aeb;
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyBean studyWithSED = this.currentStudy;
        if (this.currentStudy.getParentStudyId() > 0) {
            studyWithSED = new StudyBean();
            studyWithSED.setId(this.currentStudy.getParentStudyId());
        }
        if (!(aeb = (AuditableEntityBean)sedao.findByPKAndStudy(eventId, studyWithSED)).isActive()) {
            this.addPageMessage(respage.getString("study_event_to_enter_data_not_belong_study"));
            throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("study_event_not_belong_study"), "1");
        }
        StudyEventBean seb = (StudyEventBean)aeb;
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sedb = seddao.findByPK(seb.getStudyEventDefinitionId());
        seb.setStudyEventDefinition(sedb);
        if (!this.currentRole.isDirector() && !this.currentRole.isCoordinator() && seb.getSubjectEventStatus().isLocked()) {
            seb.setEditable(false);
        }
        return seb;
    }

    protected void processRequest() throws Exception {
        ArrayList allNotesForSubjectAndEvent;
        this.getCrfLocker().unlockAllForUser(this.ub.getId());
        FormProcessor fp = new FormProcessor(this.request);
        int eventId = fp.getInt(INPUT_EVENT_ID, true);
        this.request.setAttribute(INPUT_EVENT_ID, (Object)(eventId + ""));
        StudyEventBean seb = this.getStudyEvent(eventId);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        StudySubjectBean studySubjectBean = ssdao.findByPK(seb.getStudySubjectId());
        int studyId = studySubjectBean.getStudyId();
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = studydao.findByPK(studyId);
        boolean subjectStudyIsCurrentStudy = studyId == this.currentStudy.getId();
        boolean isParentStudy = study.getParentStudyId() < 1;
        DiscrepancyNoteDAO discrepancyNoteDAO = new DiscrepancyNoteDAO(this.sm.getDataSource());
        if (subjectStudyIsCurrentStudy && isParentStudy) {
            allNotesForSubjectAndEvent = discrepancyNoteDAO.findAllStudyEventByStudyAndId(this.currentStudy, studySubjectBean.getId());
        } else if (!isParentStudy) {
            StudyBean stParent = studydao.findByPK(study.getParentStudyId());
            allNotesForSubjectAndEvent = discrepancyNoteDAO.findAllStudyEventByStudiesAndSubjectId(stParent, study, studySubjectBean.getId());
        } else {
            allNotesForSubjectAndEvent = discrepancyNoteDAO.findAllStudyEventByStudiesAndSubjectId(this.currentStudy, study, studySubjectBean.getId());
        }
        if (!allNotesForSubjectAndEvent.isEmpty()) {
            this.setRequestAttributesForNotes((List)allNotesForSubjectAndEvent, eventId);
        }
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ArrayList eventCRFs = ecdao.findAllByStudyEvent(seb);
        ArrayList doRuleSetsExist = new ArrayList();
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList eventDefinitionCRFs = edcdao.findAllActiveByEventDefinitionId(study, seb.getStudyEventDefinitionId());
        ArrayList uncompletedEventDefinitionCRFs = this.getUncompletedCRFs(eventDefinitionCRFs, eventCRFs);
        this.populateUncompletedCRFsWithCRFAndVersions(uncompletedEventDefinitionCRFs);
        this.populateUncompletedCRFsWithAnOwner((List)uncompletedEventDefinitionCRFs);
        ArrayList displayEventCRFs = ViewStudySubjectServlet.getDisplayEventCRFs((DataSource)this.sm.getDataSource(), (ArrayList)eventCRFs, (ArrayList)eventDefinitionCRFs, (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole, (SubjectEventStatus)seb.getSubjectEventStatus(), (StudyBean)study);
        if (this.currentStudy.getParentStudyId() > 0) {
            HideCRFManager hideCRFManager = HideCRFManager.createHideCRFManager();
            uncompletedEventDefinitionCRFs = hideCRFManager.removeHiddenEventDefinitionCRFBeans((List)uncompletedEventDefinitionCRFs);
            displayEventCRFs = hideCRFManager.removeHiddenEventCRFBeans((List)displayEventCRFs);
        }
        this.request.setAttribute(BEAN_STUDY_EVENT, (Object)seb);
        this.request.setAttribute("doRuleSetsExist", doRuleSetsExist);
        this.request.setAttribute(BEAN_STUDY_SUBJECT, (Object)studySubjectBean);
        this.request.setAttribute(BEAN_UNCOMPLETED_EVENTDEFINITIONCRFS, (Object)uncompletedEventDefinitionCRFs);
        this.request.setAttribute(BEAN_DISPLAY_EVENT_CRFS, (Object)displayEventCRFs);
        ArrayList beans = ViewStudySubjectServlet.getDisplayStudyEventsForStudySubject((StudySubjectBean)studySubjectBean, (DataSource)this.sm.getDataSource(), (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole);
        this.request.setAttribute("beans", (Object)beans);
        EventCRFBean ecb = new EventCRFBean();
        ecb.setStudyEventId(eventId);
        this.request.setAttribute("eventCRF", (Object)ecb);
        this.request.setAttribute("study", (Object)this.currentStudy);
        this.forwardPage(Page.ENTER_DATA_FOR_STUDY_EVENT);
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        String exceptionName = resexception.getString("no_permission_to_submit_data");
        String noAccessMessage = respage.getString("may_not_enter_data_for_this_study");
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(noAccessMessage);
        throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, exceptionName, "1");
    }

    private ArrayList<DisplayEventDefinitionCRFBean> getUncompletedCRFs(ArrayList<EventDefinitionCRFBean> eventDefinitionCRFs, ArrayList<EventCRFBean> eventCRFs) {
        HashMap<Integer, Boolean> completed = new HashMap<Integer, Boolean>();
        HashMap<Integer, EventCRFBean> startedButIncompleted = new HashMap<Integer, EventCRFBean>();
        ArrayList<DisplayEventDefinitionCRFBean> answer = new ArrayList<DisplayEventDefinitionCRFBean>();
        for (EventDefinitionCRFBean edcrf : eventDefinitionCRFs) {
            completed.put(new Integer(edcrf.getCrfId()), Boolean.FALSE);
            startedButIncompleted.put(new Integer(edcrf.getCrfId()), new EventCRFBean());
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        for (EventCRFBean ecrf : eventCRFs) {
            int crfId = cvdao.getCRFIdFromCRFVersionId(ecrf.getCRFVersionId());
            ArrayList idata = iddao.findAllByEventCRFId(ecrf.getId());
            if (!idata.isEmpty()) {
                completed.put(new Integer(crfId), Boolean.TRUE);
                continue;
            }
            startedButIncompleted.put(new Integer(crfId), ecrf);
        }
        for (EventDefinitionCRFBean edcrf : eventDefinitionCRFs) {
            DisplayEventDefinitionCRFBean dedc = new DisplayEventDefinitionCRFBean();
            dedc.setEdc(edcrf);
            Boolean b = (Boolean)completed.get(new Integer(edcrf.getCrfId()));
            EventCRFBean ev = (EventCRFBean)startedButIncompleted.get(new Integer(edcrf.getCrfId()));
            if (b != null && b.booleanValue()) continue;
            dedc.setEventCRF(ev);
            answer.add(dedc);
        }
        return answer;
    }

    private void populateUncompletedCRFsWithAnOwner(List<DisplayEventDefinitionCRFBean> displayEventDefinitionCRFBeans) {
        if (displayEventDefinitionCRFBeans == null || displayEventDefinitionCRFBeans.isEmpty()) {
            return;
        }
        UserAccountDAO userAccountDAO = new UserAccountDAO(this.sm.getDataSource());
        for (DisplayEventDefinitionCRFBean dedcBean : displayEventDefinitionCRFBeans) {
            int ownerId;
            UserAccountBean userAccountBean;
            EventCRFBean eventCRFBean = dedcBean.getEventCRF();
            if (eventCRFBean != null && eventCRFBean.getOwner() == null && eventCRFBean.getOwnerId() > 0) {
                userAccountBean = userAccountDAO.findByPK(eventCRFBean.getOwnerId());
                eventCRFBean.setOwner(userAccountBean);
            }
            if (eventCRFBean == null || eventCRFBean.getOwner() != null || (ownerId = dedcBean.getEdc().getOwnerId()) <= 0) continue;
            userAccountBean = userAccountDAO.findByPK(ownerId);
            eventCRFBean.setOwner(userAccountBean);
        }
    }

    private void populateUncompletedCRFsWithCRFAndVersions(ArrayList<DisplayEventDefinitionCRFBean> uncompletedEventDefinitionCRFs) {
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        for (int i = 0; i < uncompletedEventDefinitionCRFs.size(); ++i) {
            DisplayEventDefinitionCRFBean dedcrf = uncompletedEventDefinitionCRFs.get(i);
            CRFBean cb = cdao.findByPK(dedcrf.getEdc().getCrfId());
            if (cb.getStatus().equals((Term)Status.AVAILABLE)) {
                dedcrf.getEdc().setCrf(cb);
                ArrayList theVersions = cvdao.findAllActiveByCRF(dedcrf.getEdc().getCrfId());
                ArrayList versions = new ArrayList();
                HashMap<String, CRFVersionBean> crfVersionIds = new HashMap<String, CRFVersionBean>();
                for (CRFVersionBean crfVersion : theVersions) {
                    crfVersionIds.put(String.valueOf(crfVersion.getId()), crfVersion);
                }
                if (!dedcrf.getEdc().getSelectedVersionIds().isEmpty()) {
                    String[] kk = dedcrf.getEdc().getSelectedVersionIds().split(",");
                    for (String string : kk) {
                        if (crfVersionIds.get(string) == null) continue;
                        versions.add(crfVersionIds.get(string));
                    }
                } else {
                    versions = theVersions;
                }
                dedcrf.getEdc().setVersions(versions);
                if (!versions.isEmpty()) {
                    boolean isLocked = false;
                    for (CRFVersionBean crfvb : versions) {
                        logger.debug("...checking versions...{}", (Object)crfvb.getName());
                        if (crfvb.getStatus().equals((Term)Status.AVAILABLE)) continue;
                        logger.debug("found a non active crf version");
                        isLocked = true;
                    }
                    logger.debug("re-set event def, line 240: {}", (Object)isLocked);
                    if (isLocked) {
                        dedcrf.setStatus(Status.LOCKED);
                        dedcrf.getEventCRF().setStage(DataEntryStage.LOCKED);
                    }
                    uncompletedEventDefinitionCRFs.set(i, dedcrf);
                    continue;
                }
                dedcrf.setStatus(Status.LOCKED);
                dedcrf.getEventCRF().setStage(DataEntryStage.LOCKED);
                uncompletedEventDefinitionCRFs.set(i, dedcrf);
                continue;
            }
            dedcrf.getEdc().setCrf(cb);
            logger.debug("_found a non active crf _");
            dedcrf.setStatus(Status.LOCKED);
            dedcrf.getEventCRF().setStage(DataEntryStage.LOCKED);
            dedcrf.getEdc().getCrf().setStatus(Status.LOCKED);
            uncompletedEventDefinitionCRFs.set(i, dedcrf);
        }
    }

    public static ArrayList<DisplayEventCRFBean> getDisplayEventCRFs(StudyEventBean studyEvent, EventCRFDAO ecdao, EventDefinitionCRFDAO edcdao, CRFVersionDAO crfvdao, UserAccountBean user, StudyUserRoleBean surb) {
        ArrayList<DisplayEventCRFBean> answer = new ArrayList<DisplayEventCRFBean>();
        HashMap<Integer, Integer> indexByCRFId = new HashMap<Integer, Integer>();
        ArrayList eventCRFs = ecdao.findAllByStudyEvent(studyEvent);
        ArrayList eventDefinitionCRFs = edcdao.findAllByEventDefinitionId(studyEvent.getStudyEventDefinitionId());
        ArrayList crfVersions = crfvdao.findAll();
        HashMap<Integer, Integer> crfIdByCRFVersionId = new HashMap<Integer, Integer>();
        for (CRFVersionBean cvb : crfVersions) {
            crfIdByCRFVersionId.put(new Integer(cvb.getId()), new Integer(cvb.getCrfId()));
        }
        for (EventDefinitionCRFBean edcb : eventDefinitionCRFs) {
            DisplayEventCRFBean decb = new DisplayEventCRFBean();
            decb.setEventDefinitionCRF(edcb);
            answer.add(decb);
            indexByCRFId.put(new Integer(edcb.getCrfId()), new Integer(answer.size() - 1));
        }
        for (EventCRFBean ecb : eventCRFs) {
            int index;
            Integer indexObj;
            Integer crfId;
            Integer crfVersionId = new Integer(ecb.getCRFVersionId());
            if (!crfIdByCRFVersionId.containsKey(crfVersionId) || (crfId = (Integer)crfIdByCRFVersionId.get(crfVersionId)) == null || !indexByCRFId.containsKey(crfId) || (indexObj = (Integer)indexByCRFId.get(crfId)) == null || (index = indexObj.intValue()) <= 0 || index >= answer.size()) continue;
            DisplayEventCRFBean decb = answer.get(index);
            decb.setEventCRF(ecb);
            answer.set(index, decb);
        }
        for (int i = 0; i < answer.size(); ++i) {
            DisplayEventCRFBean decb = answer.get(i);
            decb.setFlags(decb.getEventCRF(), user, surb, decb.getEventDefinitionCRF().isDoubleEntry());
            answer.set(i, decb);
        }
        return answer;
    }

    private void setRequestAttributesForNotes(List<DiscrepancyNoteBean> discBeans, int currentEventId) {
        for (DiscrepancyNoteBean discrepancyNoteBean : discBeans) {
            if (discrepancyNoteBean.getEntityId() != currentEventId) continue;
            if ("location".equalsIgnoreCase(discrepancyNoteBean.getColumn())) {
                this.request.setAttribute(STATUS_DN_LOCATION, (Object)discrepancyNoteBean.getResolutionStatusId());
                this.request.setAttribute(HAS_LOCATION_NOTE, (Object)"yes");
                continue;
            }
            if ("start_date".equalsIgnoreCase(discrepancyNoteBean.getColumn())) {
                this.request.setAttribute(STATUS_DN_START_DATE, (Object)discrepancyNoteBean.getResolutionStatusId());
                this.request.setAttribute(HAS_START_DATE_NOTE, (Object)"yes");
                continue;
            }
            if (!"end_date".equalsIgnoreCase(discrepancyNoteBean.getColumn())) continue;
            this.request.setAttribute(STATUS_DN_END_DATE, (Object)discrepancyNoteBean.getResolutionStatusId());
            this.request.setAttribute(HAS_END_DATE_NOTE, (Object)"yes");
        }
    }
}

