/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.submit.ListDiscNotesForCRFTableFactory;
import org.akaza.openclinica.control.submit.ListDiscNotesForCRFTableToolbar;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.ListDiscNotesForCRFFilter;
import org.akaza.openclinica.dao.managestudy.ListDiscNotesForCRFSort;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.HtmlBuilder;
import org.jmesa.view.html.toolbar.Toolbar;

public class ListDiscNotesForCRFTableFactory
extends AbstractTableFactory {
    private StudyEventDefinitionDAO studyEventDefinitionDao;
    private StudySubjectDAO studySubjectDAO;
    private SubjectDAO subjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyDAO studyDAO;
    private StudyGroupDAO studyGroupDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private DiscrepancyNoteDAO discrepancyNoteDAO;
    private CRFDAO crfDAO;
    private StudyBean studyBean;
    private String[] columnNames = new String[0];
    private ArrayList<StudyEventDefinitionBean> studyEventDefinitions;
    private ArrayList<CRFBean> crfBeans;
    private ArrayList<EventDefinitionCRFBean> eventDefinitionCrfs;
    private StudyUserRoleBean currentRole;
    private UserAccountBean currentUser;
    private ResourceBundle resword = ResourceBundleProvider.getWordsBundle();
    private ResourceBundle resformat = ResourceBundleProvider.getFormatBundle();
    private StudyEventDefinitionBean selectedStudyEventDefinition;
    private String module;
    private Integer resolutionStatus;
    private Integer discNoteType;
    private Boolean studyHasDiscNotes;
    private Set<Integer> resolutionStatusIds;
    final HashMap<Integer, String> imageIconPaths = new HashMap(8);
    final HashMap<Integer, String> crfColumnImageIconPaths = new HashMap(8);
    final HashMap<Integer, String> discNoteIconPaths = new HashMap(8);

    public ListDiscNotesForCRFTableFactory() {
        this.imageIconPaths.put(1, "images/icon_Scheduled.gif");
        this.imageIconPaths.put(2, "images/icon_NotStarted.gif");
        this.imageIconPaths.put(3, "images/icon_InitialDE.gif");
        this.imageIconPaths.put(4, "images/icon_DEcomplete.gif");
        this.imageIconPaths.put(5, "images/icon_Stopped.gif");
        this.imageIconPaths.put(6, "images/icon_Skipped.gif");
        this.imageIconPaths.put(7, "images/icon_Locked.gif");
        this.imageIconPaths.put(8, "images/icon_Signed.gif");
        this.crfColumnImageIconPaths.put(0, "images/icon_Invalid.gif");
        this.crfColumnImageIconPaths.put(1, "images/icon_NotStarted.gif");
        this.crfColumnImageIconPaths.put(2, "images/icon_InitialDE.gif");
        this.crfColumnImageIconPaths.put(3, "images/icon_DEcomplete.gif");
        this.crfColumnImageIconPaths.put(4, "images/icon_DDE.gif");
        this.crfColumnImageIconPaths.put(5, "images/icon_DEcomplete.gif");
        this.crfColumnImageIconPaths.put(6, "images/icon_DEcomplete.gif");
        this.crfColumnImageIconPaths.put(7, "images/icon_Locked.gif");
        this.discNoteIconPaths.put(1, "<img name='icon_Note' src='images/icon_Note.gif' border='0' alt='" + this.resword.getString("open") + "' title='" + this.resword.getString("open") + "'/>");
        this.discNoteIconPaths.put(2, "<img name='icon_flagYellow' src='images/icon_flagYellow.gif' border='0' alt='" + this.resword.getString("updated") + "' title='" + this.resword.getString("updated") + "' />");
        this.discNoteIconPaths.put(3, "<img name='icon_flagGreen' src='images/icon_flagGreen.gif' border='0' alt='" + this.resword.getString("resolved") + "' title='" + this.resword.getString("resolved") + "'/>");
        this.discNoteIconPaths.put(4, "<img name='icon_flagBlack' src='images/icon_flagBlack.gif' border='0' alt='" + this.resword.getString("closed") + "' title='" + this.resword.getString("closed") + "'/>");
        this.discNoteIconPaths.put(5, "<img name='icon_flagWhite' src='images/icon_flagWhite.gif' border='0' alt='" + this.resword.getString("not_applicable") + "' title='" + this.resword.getString("not_applicable") + "'/>");
    }

    protected String getTableName() {
        return "listDiscNotesForCRF";
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
        tableFacade.setColumnProperties(this.columnNames);
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn(this.columnNames[0]), this.resword.getString("study_subject_ID"), null, null);
        this.configureColumn(row.getColumn(this.columnNames[1]), this.resword.getString("event_status"), (CellEditor)new EventStatusCellEditor(this, null), (FilterEditor)new SubjectEventStatusDroplistFilterEditor(this, null), true, false);
        this.configureColumn(row.getColumn(this.columnNames[2]), this.resword.getString("event_date"), (CellEditor)new EventStartDateCellEditor(this, null), null);
        for (int i = 3; i < this.columnNames.length - 1; ++i) {
            CRFBean crfBean = (CRFBean)this.crfBeans.get(i - 3);
            this.configureColumn(row.getColumn(this.columnNames[i]), crfBean.getName(), (CellEditor)new EventCrfCellEditor(this, null), (FilterEditor)new SubjectEventCRFStatusDroplistFilterEditor(this, null), false, false);
        }
        String actionsHeader = this.resword.getString("rule_actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn(this.columnNames[this.columnNames.length - 1]), actionsHeader, (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        this.getColumnNamesMap();
        tableFacade.addFilterMatcher(new MatcherKey(Character.class), (FilterMatcher)new CharFilterMatcher(this, null));
        tableFacade.addFilterMatcher(new MatcherKey(Status.class), (FilterMatcher)new StatusFilterMatcher(this));
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "event.status"), (FilterMatcher)new SubjectEventStatusFilterMatcher(this));
        for (int i = 3; i < this.columnNames.length - 1; ++i) {
            tableFacade.addFilterMatcher(new MatcherKey(String.class, this.columnNames[i]), (FilterMatcher)new SubjectEventCRFStatusFilterMatcher(this));
        }
    }

    public void configureTableFacadePostColumnConfiguration(TableFacade tableFacade) {
        ListDiscNotesForCRFTableToolbar toolbar = new ListDiscNotesForCRFTableToolbar(this.getStudyEventDefinitions(), this.selectedStudyEventDefinition);
        toolbar.setStudyHasDiscNotes(this.studyHasDiscNotes.booleanValue());
        toolbar.setDiscNoteType(this.discNoteType.intValue());
        toolbar.setResolutionStatus(this.resolutionStatus.intValue());
        toolbar.setResword(this.resword);
        toolbar.setModule(this.module);
        tableFacade.setToolbar((Toolbar)toolbar);
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        Limit limit = tableFacade.getLimit();
        ListDiscNotesForCRFFilter listDiscNotesForCRF = this.getListEventsForSubjectFilter(limit);
        listDiscNotesForCRF.addFilter("dn.discrepancy_note_type_id", (Object)this.discNoteType);
        StringBuffer constraints = new StringBuffer();
        if (this.discNoteType > 0 && this.discNoteType < 10) {
            constraints.append(" and dn.discrepancy_note_type_id=" + this.discNoteType);
        }
        if (this.resolutionStatusIds != null && this.resolutionStatusIds.size() > 0) {
            String s = " and (";
            for (Integer resolutionStatusId : this.resolutionStatusIds) {
                s = s + "dn.resolution_status_id = " + resolutionStatusId + " or ";
            }
            s = s.substring(0, s.length() - 3) + " )";
            listDiscNotesForCRF.addFilter("dn.resolution_status_id", (Object)s);
            constraints.append(s);
        }
        if (!limit.isComplete()) {
            int totalRows = this.getStudySubjectDAO().getCountWithFilter(listDiscNotesForCRF, this.getStudyBean());
            tableFacade.setTotalRows(totalRows);
        }
        ListDiscNotesForCRFSort eventsForSubjectSort = this.getListEventsForSubjectSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        ArrayList items = this.getStudySubjectDAO().getWithFilterAndSort(this.getStudyBean(), listDiscNotesForCRF, eventsForSubjectSort, rowStart, rowEnd);
        ArrayList theItems = new ArrayList();
        boolean hasDN = false;
        for (StudySubjectBean studySubjectBean : items) {
            HashMap<String, Object> theItem = new HashMap<String, Object>();
            theItem.put("studySubject", studySubjectBean);
            theItem.put("studySubject.label", studySubjectBean.getLabel());
            theItem.put("studySubject.status", studySubjectBean.getStatus());
            SubjectBean subjectBean = this.getSubjectDAO().findByPK(studySubjectBean.getSubjectId());
            theItem.put("subject", subjectBean);
            theItem.put("subject.charGender", Character.valueOf(subjectBean.getGender()));
            ArrayList eventCrfs = this.getEventCRFDAO().findAllByStudySubject(studySubjectBean.getId());
            HashMap<String, EventCRFBean> crfAsKeyEventCrfAsValue = new HashMap<String, EventCRFBean>();
            for (EventCRFBean eventCRFBean : eventCrfs) {
                CRFBean crf = this.getCrfDAO().findByVersionId(eventCRFBean.getCRFVersionId());
                crfAsKeyEventCrfAsValue.put(crf.getId() + "_" + eventCRFBean.getStudyEventId(), eventCRFBean);
            }
            ArrayList eventsForStudySubjectAndEventDefinitions = this.getStudyEventDAO().findAllByDefinitionAndSubject(this.selectedStudyEventDefinition, studySubjectBean);
            ArrayList<DisplayBean> events = new ArrayList<DisplayBean>();
            if (eventsForStudySubjectAndEventDefinitions.size() < 1) {
                DisplayBean d = new DisplayBean(this);
                d.getProps().put("event", null);
                d.getProps().put("event.status", SubjectEventStatus.NOT_SCHEDULED);
                d.getProps().put("event.startDate", null);
                for (int i = 0; i < this.getCrfs(this.selectedStudyEventDefinition).size(); ++i) {
                    CRFBean crf = (CRFBean)this.getCrfs(this.selectedStudyEventDefinition).get(i);
                    HashMap discCounts = new HashMap();
                    d.getProps().put("crf_" + crf.getId(), DataEntryStage.UNCOMPLETED);
                    d.getProps().put("crf_" + crf.getId() + "_eventCrf", null);
                    d.getProps().put("crf_" + crf.getId() + "_crf", crf);
                    d.getProps().put("crf_" + crf.getId() + "_eventDefinitionCrf", this.eventDefinitionCrfs.get(i));
                    d.getProps().put("crf_" + crf.getId() + "_discCounts", discCounts);
                    theItem.put("crf_" + crf.getId(), "");
                }
                events.add(d);
            }
            for (StudyEventBean studyEventBean : eventsForStudySubjectAndEventDefinitions) {
                DisplayBean d = new DisplayBean(this);
                d.getProps().put("event", studyEventBean);
                d.getProps().put("event.status", studyEventBean.getSubjectEventStatus());
                d.getProps().put("event.startDate", studyEventBean.getCreatedDate());
                for (int i = 0; i < this.getCrfs(this.selectedStudyEventDefinition).size(); ++i) {
                    CRFBean crf = (CRFBean)this.getCrfs(this.selectedStudyEventDefinition).get(i);
                    EventCRFBean eventCRFBean = (EventCRFBean)crfAsKeyEventCrfAsValue.get(crf.getId() + "_" + studyEventBean.getId());
                    HashMap<ResolutionStatus, Integer> discCounts = new HashMap<ResolutionStatus, Integer>();
                    if (eventCRFBean != null) {
                        d.getProps().put("crf_" + crf.getId(), eventCRFBean.getStage());
                        d.getProps().put("crf_" + crf.getId() + "_eventCrf", eventCRFBean);
                        ArrayList discs = this.getDiscrepancyNoteDAO().findAllParentItemNotesByEventCRFWithConstraints(eventCRFBean.getId(), constraints);
                        hasDN = !hasDN ? discs != null && discs.size() > 0 : hasDN;
                        for (DiscrepancyNoteBean discrepancyNoteBean : discs) {
                            Integer value = (Integer)discCounts.get(discrepancyNoteBean.getResStatus());
                            if (value != null) {
                                value = value + 1;
                                discCounts.put(discrepancyNoteBean.getResStatus(), value);
                                continue;
                            }
                            discCounts.put(discrepancyNoteBean.getResStatus(), 1);
                        }
                        d.getProps().put("crf_" + crf.getId() + "_discCounts", discCounts);
                    } else {
                        d.getProps().put("crf_" + crf.getId(), DataEntryStage.UNCOMPLETED);
                        d.getProps().put("crf_" + crf.getId() + "_eventCrf", null);
                        d.getProps().put("crf_" + crf.getId() + "_discCounts", discCounts);
                    }
                    d.getProps().put("crf_" + crf.getId() + "_crf", crf);
                    d.getProps().put("crf_" + crf.getId() + "_eventDefinitionCrf", this.eventDefinitionCrfs.get(i));
                    theItem.put("crf_" + crf.getId(), "");
                }
                events.add(d);
            }
            theItem.put("events", events);
            theItem.put("event.status", "");
            theItem.put("event.startDate", "");
            theItems.add(theItem);
        }
        tableFacade.setItems(theItems);
        this.setStudyHasDiscNotes(Boolean.valueOf(hasDN));
    }

    private void getColumnNamesMap() {
        ArrayList<String> columnNamesList = new ArrayList<String>();
        columnNamesList.add("studySubject.label");
        columnNamesList.add("event.status");
        columnNamesList.add("event.startDate");
        for (CRFBean crfBean : this.getCrfs(this.selectedStudyEventDefinition)) {
            columnNamesList.add("crf_" + crfBean.getId());
        }
        columnNamesList.add("actions");
        this.columnNames = columnNamesList.toArray(this.columnNames);
    }

    protected ListDiscNotesForCRFFilter getListEventsForSubjectFilter(Limit limit) {
        ListDiscNotesForCRFFilter listDiscNotesForCRFFilter = new ListDiscNotesForCRFFilter(Integer.valueOf(this.selectedStudyEventDefinition.getId()));
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            listDiscNotesForCRFFilter.addFilter(property, (Object)value);
        }
        return listDiscNotesForCRFFilter;
    }

    protected ListDiscNotesForCRFSort getListEventsForSubjectSort(Limit limit) {
        ListDiscNotesForCRFSort listDiscNotesForCRFSort = new ListDiscNotesForCRFSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            listDiscNotesForCRFSort.addSort(property, order);
        }
        return listDiscNotesForCRFSort;
    }

    private ArrayList<StudyEventDefinitionBean> getStudyEventDefinitions() {
        if (this.studyEventDefinitions == null) {
            if (this.studyBean.getParentStudyId() > 0) {
                StudyBean parentStudy = this.getStudyDAO().findByPK(this.studyBean.getParentStudyId());
                this.studyEventDefinitions = this.getStudyEventDefinitionDao().findAllByStudy(parentStudy);
            } else {
                this.studyEventDefinitions = this.getStudyEventDefinitionDao().findAllByStudy(this.studyBean);
            }
        }
        return this.studyEventDefinitions;
    }

    private ArrayList<CRFBean> getCrfs(StudyEventDefinitionBean eventDefinition) {
        if (this.crfBeans == null) {
            this.crfBeans = new ArrayList();
            this.eventDefinitionCrfs = new ArrayList();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ArrayList edcs = new ArrayList();
            edcs = this.getStudyBean().getParentStudyId() > 0 ? this.getEventDefintionCRFDAO().findAllActiveNonHiddenByEventDefinitionIdAndStudy(eventDefinition.getId(), this.getStudyBean()) : this.getEventDefintionCRFDAO().findAllActiveByEventDefinitionId(eventDefinition.getId());
            if (edcs.size() > 0) {
                for (EventDefinitionCRFBean eventDefinitionCrf : edcs) {
                    CRFBean crf = this.getCrfDAO().findByPK(eventDefinitionCrf.getCrfId());
                    if (ids.contains(crf.getId())) continue;
                    this.crfBeans.add(crf);
                    ids.add(crf.getId());
                    this.eventDefinitionCrfs.add(eventDefinitionCrf);
                }
            }
            return this.crfBeans;
        }
        return this.crfBeans;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        return this.studyEventDefinitionDao;
    }

    public void setStudyEventDefinitionDao(StudyEventDefinitionDAO studyEventDefinitionDao) {
        this.studyEventDefinitionDao = studyEventDefinitionDao;
    }

    public StudyBean getStudyBean() {
        return this.studyBean;
    }

    public void setStudyBean(StudyBean studyBean) {
        this.studyBean = studyBean;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        return this.studySubjectDAO;
    }

    public void setStudySubjectDAO(StudySubjectDAO studySubjectDAO) {
        this.studySubjectDAO = studySubjectDAO;
    }

    public SubjectDAO getSubjectDAO() {
        return this.subjectDAO;
    }

    public void setSubjectDAO(SubjectDAO subjectDAO) {
        this.subjectDAO = subjectDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        return this.studyEventDAO;
    }

    public void setStudyEventDAO(StudyEventDAO studyEventDAO) {
        this.studyEventDAO = studyEventDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        return this.studyGroupClassDAO;
    }

    public void setStudyGroupClassDAO(StudyGroupClassDAO studyGroupClassDAO) {
        this.studyGroupClassDAO = studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        return this.subjectGroupMapDAO;
    }

    public void setSubjectGroupMapDAO(SubjectGroupMapDAO subjectGroupMapDAO) {
        this.subjectGroupMapDAO = subjectGroupMapDAO;
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO;
    }

    public void setStudyDAO(StudyDAO studyDAO) {
        this.studyDAO = studyDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        return this.studyGroupDAO;
    }

    public void setStudyGroupDAO(StudyGroupDAO studyGroupDAO) {
        this.studyGroupDAO = studyGroupDAO;
    }

    public StudyUserRoleBean getCurrentRole() {
        return this.currentRole;
    }

    public void setCurrentRole(StudyUserRoleBean currentRole) {
        this.currentRole = currentRole;
    }

    public EventCRFDAO getEventCRFDAO() {
        return this.eventCRFDAO;
    }

    public void setEventCRFDAO(EventCRFDAO eventCRFDAO) {
        this.eventCRFDAO = eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefintionCRFDAO() {
        return this.eventDefintionCRFDAO;
    }

    public void setEventDefintionCRFDAO(EventDefinitionCRFDAO eventDefintionCRFDAO) {
        this.eventDefintionCRFDAO = eventDefintionCRFDAO;
    }

    public CRFDAO getCrfDAO() {
        return this.crfDAO;
    }

    public void setCrfDAO(CRFDAO crfDAO) {
        this.crfDAO = crfDAO;
    }

    public UserAccountBean getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(UserAccountBean currentUser) {
        this.currentUser = currentUser;
    }

    public StudyEventDefinitionBean getSelectedStudyEventDefinition() {
        return this.selectedStudyEventDefinition;
    }

    public void setSelectedStudyEventDefinition(StudyEventDefinitionBean selectedStudyEventDefinition) {
        this.selectedStudyEventDefinition = selectedStudyEventDefinition;
    }

    public DiscrepancyNoteDAO getDiscrepancyNoteDAO() {
        return this.discrepancyNoteDAO;
    }

    public void setDiscrepancyNoteDAO(DiscrepancyNoteDAO discrepancyNoteDAO) {
        this.discrepancyNoteDAO = discrepancyNoteDAO;
    }

    private String viewStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        if (this.getResolutionStatus() >= 1 && this.getResolutionStatus() <= 5) {
            actionLink.a().href("ViewNotes?viewForOne=y&module=" + this.module + "&id=" + studySubject.getId() + "&resolutionStatus=" + this.resolutionStatus + "&listNotes_f_studySubject.label=" + studySubject.getLabel());
            actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\"");
            actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_View1','images/bt_View.gif');\"").close();
            actionLink.img().name("bt_View1").src("images/bt_View.gif").border("0").alt(this.resword.getString("view")).title(this.resword.getString("view")).append((Object)"hspace=\"2\" style=\"float:left\" align=\"left\"").end().aEnd();
            actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        } else {
            actionLink.a().href("ViewNotes?viewForOne=y&id=" + studySubject.getId() + "&module=" + this.module + "&listNotes_f_studySubject.label=" + studySubject.getLabel());
            actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\"");
            actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_View1','images/bt_View.gif');\"").close();
            actionLink.img().name("bt_View1").src("images/bt_View.gif").border("0").alt(this.resword.getString("view")).title(this.resword.getString("view")).append((Object)"hspace=\"2\" style=\"float:left\" align=\"left\"").end().aEnd();
            actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        }
        return actionLink.toString();
    }

    private String downloadNotesLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        if (this.isStudyHasDiscNotes().booleanValue()) {
            if (this.getResolutionStatus() >= 1 && this.getResolutionStatus() <= 5) {
                actionLink.a().href("javascript:openDocWindow('ChooseDownloadFormat?subjectId=" + studySubject.getId() + "&discNoteType=" + this.discNoteType + "&resolutionStatus=" + this.resolutionStatus + "')");
                actionLink.img().name("bt_View1").src("images/bt_Download.gif").border("0").alt(this.resword.getString("download_discrepancy_notes")).title(this.resword.getString("download_discrepancy_notes")).append((Object)"hspace=\"2\"").end().aEnd();
                actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
            } else {
                actionLink.a().href("javascript:openDocWindow('ChooseDownloadFormat?discNoteType=" + this.discNoteType + "&module=" + this.module + "&subjectId=" + studySubject.getId() + "')");
                actionLink.img().name("bt_View1").src("images/bt_Download.gif").border("0").alt(this.resword.getString("download_discrepancy_notes")).title(this.resword.getString("download_discrepancy_notes")).append((Object)"hspace=\"2\"").end().aEnd();
                actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
            }
        }
        return actionLink.toString();
    }

    private String formatDate(Date date) {
        String format = this.resformat.getString("date_format_string");
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Integer getResolutionStatus() {
        return this.resolutionStatus;
    }

    public void setResolutionStatus(Integer resolutionStatus) {
        this.resolutionStatus = resolutionStatus;
    }

    public Integer getDiscNoteType() {
        return this.discNoteType;
    }

    public void setDiscNoteType(Integer discNoteType) {
        this.discNoteType = discNoteType;
    }

    public Boolean getStudyHasDiscNotes() {
        return this.studyHasDiscNotes;
    }

    public void setStudyHasDiscNotes(Boolean studyHasDiscNotes) {
        this.studyHasDiscNotes = studyHasDiscNotes;
    }

    public Boolean isStudyHasDiscNotes() {
        return this.studyHasDiscNotes;
    }

    public Set<Integer> getResolutionStatusIds() {
        return this.resolutionStatusIds;
    }

    public void setResolutionStatusIds(Set<Integer> resolutionStatusIds) {
        this.resolutionStatusIds = resolutionStatusIds;
    }

    static /* synthetic */ String access$700(ListDiscNotesForCRFTableFactory x0, Date x1) {
        return x0.formatDate(x1);
    }

    static /* synthetic */ String access$800(ListDiscNotesForCRFTableFactory x0, StudySubjectBean x1) {
        return x0.viewStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$900(ListDiscNotesForCRFTableFactory x0, StudySubjectBean x1) {
        return x0.downloadNotesLinkBuilder(x1);
    }
}

