/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.logic.rulerunner.ExecutionMode;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.service.rule.RulesPostImportContainerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class RunRuleServlet
extends SecureController {
    private static final long serialVersionUID = 9116068126651934226L;
    protected final Logger log = LoggerFactory.getLogger(RunRuleServlet.class);
    Locale locale;
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    RuleSetServiceInterface ruleSetService;
    RulesPostImportContainerService rulesPostImportContainerService;

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        String crfId = this.request.getParameter("crfId");
        String ruleSetRuleId = this.request.getParameter("ruleSetRuleId");
        String versionId = this.request.getParameter("versionId");
        if (action == null || action.trim().isEmpty()) {
            this.forwardPage(Page.MENU_SERVLET);
        }
        ExecutionMode executionMode = action == null || "dryRun".equalsIgnoreCase(action) ? ExecutionMode.DRY_RUN : ExecutionMode.SAVE;
        String submitLinkParams = "";
        HashMap result = null;
        if (ruleSetRuleId != null && versionId != null) {
            submitLinkParams = "ruleSetRuleId=" + ruleSetRuleId + "&versionId=" + versionId + "&action=no";
            result = this.getRuleSetService().runRulesInBulk(ruleSetRuleId, versionId, executionMode, this.currentStudy, this.ub);
        } else {
            submitLinkParams = "crfId=" + crfId + "&action=no";
            result = this.getRuleSetService().runRulesInBulk(crfId, executionMode, this.currentStudy, this.ub);
        }
        this.request.setAttribute("result", (Object)result);
        this.request.setAttribute("submitLinkParams", (Object)submitLinkParams);
        if (executionMode == ExecutionMode.SAVE) {
            this.forwardPage(Page.LIST_RULE_SETS_SERVLET);
        } else {
            this.forwardPage(Page.VIEW_EXECUTED_RULES_FROM_CRF);
        }
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        this.ruleSetService.setMailSender((JavaMailSenderImpl)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("mailSender"));
        this.ruleSetService.setContextPath(this.getContextPath());
        this.ruleSetService.setRequestURLMinusServletPath(this.getRequestURLMinusServletPath());
        return this.ruleSetService;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }
}

