/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.extract.ExtractPropertyBean;
import org.akaza.openclinica.controller.ExtractController;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.job.XsltStatefulJob;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.web.table.scheduledjobs.ScheduledJobTableFactory;
import org.akaza.openclinica.web.table.scheduledjobs.ScheduledJobs;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.jmesa.facade.TableFacade;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="ScheduledJobController")
public class ScheduledJobController {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledJobController.class);
    public static final String SCHEDULED_TABLE_ATTRIBUTE = "scheduledTableAttribute";
    @Autowired
    @Qualifier(value="scheduledJobTableFactory")
    private ScheduledJobTableFactory scheduledJobTableFactory;
    public static final String EP_BEAN = "epBean";
    @Autowired
    @Qualifier(value="sdvUtil")
    private SDVUtil sdvUtil;
    @Autowired
    private Scheduler scheduler;

    @RequestMapping(value={"/listCurrentScheduledJobs"})
    public ModelMap listScheduledJobs(HttpServletRequest request, HttpServletResponse response) throws SchedulerException {
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
        ResourceBundleProvider.updateLocale((Locale)locale);
        ModelMap gridMap = new ModelMap();
        boolean showMoreLink = false;
        showMoreLink = request.getParameter("showMoreLink") != null ? Boolean.parseBoolean(request.getParameter("showMoreLink").toString()) : true;
        request.setAttribute("showMoreLink", (Object)(showMoreLink + ""));
        request.setAttribute("imagePathPrefix", (Object)"../");
        ArrayList pageMessages = ClassCastHelper.asArrayList((Object)request.getAttribute("pageMessages"), String.class);
        if (pageMessages == null) {
            pageMessages = new ArrayList();
        }
        request.setAttribute("pageMessages", pageMessages);
        List listCurrentJobs = new ArrayList();
        listCurrentJobs = this.scheduler.getCurrentlyExecutingJobs();
        List currentJobList = listCurrentJobs.stream().map(job -> job.getTrigger().getJobKey()).collect(Collectors.toList());
        List triggerGroups = this.scheduler.getTriggerGroupNames();
        ArrayList<SimpleTrigger> simpleTriggers = new ArrayList<SimpleTrigger>();
        for (Object triggerGroup : triggerGroups) {
            logger.debug("Group: " + (String)triggerGroup + " contains the following triggers");
            Set triggerKeys = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)triggerGroup));
            for (TriggerKey triggerKey : triggerKeys) {
                Trigger.TriggerState state = this.scheduler.getTriggerState(triggerKey);
                logger.debug("- " + triggerKey.getName());
                if (state == Trigger.TriggerState.PAUSED) continue;
                simpleTriggers.add((SimpleTrigger)this.scheduler.getTrigger(triggerKey));
            }
        }
        ArrayList<ScheduledJobs> jobsScheduled = new ArrayList<ScheduledJobs>();
        for (SimpleTrigger st : simpleTriggers) {
            JobKey jobKey = st.getJobKey();
            boolean isExecuting = currentJobList.contains(jobKey);
            ScheduledJobs jobs = new ScheduledJobs();
            ExtractPropertyBean epBean = null;
            if (st.getJobDataMap() != null) {
                epBean = (ExtractPropertyBean)st.getJobDataMap().get((Object)EP_BEAN);
            }
            if (epBean == null) continue;
            StringBuilder checkbox = new StringBuilder();
            checkbox.append("<input style='margin-right: 5px' type='checkbox'/>");
            StringBuilder actions = new StringBuilder("<table><tr><td>");
            if (isExecuting) {
                actions.append("&nbsp;");
            } else {
                String contextPath = request.getContextPath();
                StringBuilder jsCodeString = new StringBuilder("this.form.method='GET'; this.form.action='").append(contextPath).append("/pages/cancelScheduledJob").append("';").append("this.form.theJobName.value='").append(jobKey.getName()).append("';").append("this.form.theJobGroupName.value='").append(jobKey.getGroup()).append("';").append("this.form.theTriggerName.value='").append(jobKey.getName()).append("';").append("this.form.theTriggerGroupName.value='").append(jobKey.getGroup()).append("';").append("this.form.submit();");
                actions.append("<td><input type=\"submit\" class=\"button\" value=\"Cancel Job\" ").append("name=\"cancelJob\" onclick=\"").append(jsCodeString.toString()).append("\" />");
            }
            actions.append("</td></tr></table>");
            jobs.setCheckbox(checkbox.toString());
            jobs.setDatasetId(epBean.getDatasetName());
            String fireTime = st.getStartTime() != null ? this.longFormat(locale).format(st.getStartTime()) : "";
            jobs.setFireTime(fireTime);
            if (st.getNextFireTime() != null) {
                jobs.setScheduledFireTime(this.longFormat(locale).format(st.getNextFireTime()));
            }
            jobs.setExportFileName(epBean.getExportFileName()[0]);
            jobs.setAction(actions.toString());
            jobs.setJobStatus(isExecuting ? "Currently Executing" : "Scheduled");
            jobsScheduled.add(jobs);
        }
        logger.debug("totalRows " + jobsScheduled.size());
        request.setAttribute("totalJobs", (Object)jobsScheduled.size());
        request.setAttribute("jobs", jobsScheduled);
        TableFacade facade = this.scheduledJobTableFactory.createTable(request, response);
        String sdvMatrix = facade.render();
        gridMap.addAttribute(SCHEDULED_TABLE_ATTRIBUTE, (Object)sdvMatrix);
        return gridMap;
    }

    @RequestMapping(value={"/cancelScheduledJob"})
    public String cancelScheduledJob(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="theJobName") String theJobName, @RequestParam(value="theJobGroupName") String theJobGroupName, @RequestParam(value="theTriggerName") String triggerName, @RequestParam(value="theTriggerGroupName") String triggerGroupName, @RequestParam(value="redirection") String redirection, ModelMap model) throws SchedulerException {
        JobKey jobKey = new JobKey(theJobName, theJobGroupName);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        this.scheduler.getJobDetail(jobKey);
        logger.debug("About to pause the job-->" + theJobName + "Job Group Name -->" + theJobGroupName);
        SimpleTrigger oldTrigger = (SimpleTrigger)this.scheduler.getTrigger(triggerKey);
        if (oldTrigger != null) {
            Date startTime = new Date(oldTrigger.getStartTime().getTime() + oldTrigger.getRepeatInterval());
            if (triggerGroupName.equals(ExtractController.TRIGGER_GROUP_NAME)) {
                this.interruptQuartzJob(this.scheduler, theJobName, theJobGroupName);
            }
            this.scheduler.pauseJob(jobKey);
            SimpleTrigger newTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).forJob(jobKey).startAt(startTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(oldTrigger.getRepeatCount()).withIntervalInMilliseconds(oldTrigger.getRepeatInterval()).withMisfireHandlingInstructionNextWithRemainingCount()).withDescription(oldTrigger.getDescription()).usingJobData(oldTrigger.getJobDataMap()).build();
            this.scheduler.unscheduleJob(triggerKey);
            ArrayList<String> pageMessages = new ArrayList<String>();
            if (triggerGroupName.equals(ExtractController.TRIGGER_GROUP_NAME)) {
                this.scheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
                pageMessages.add("The Job " + theJobName + " has been cancelled");
            } else if (triggerGroupName.equals(XsltTriggerService.TRIGGER_GROUP_NAME)) {
                JobDetailFactoryBean jobDetailBean = new JobDetailFactoryBean();
                jobDetailBean.setGroup(XsltTriggerService.TRIGGER_GROUP_NAME);
                jobDetailBean.setName(newTrigger.getKey().getName());
                jobDetailBean.setJobClass(XsltStatefulJob.class);
                jobDetailBean.setJobDataMap(newTrigger.getJobDataMap());
                jobDetailBean.setDurability(true);
                jobDetailBean.afterPropertiesSet();
                this.scheduler.deleteJob(jobKey);
                this.scheduler.scheduleJob(jobDetailBean.getObject(), (Trigger)newTrigger);
                pageMessages.add("The Job " + theJobName + " has been rescheduled");
            }
            request.setAttribute("pageMessages", pageMessages);
            logger.debug("jobDetails>" + this.scheduler.getJobDetail(jobKey));
        }
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    private void interruptQuartzJob(Scheduler scheduler, String jobName, String jobGroup) throws SchedulerException {
        scheduler.interrupt(JobKey.jobKey((String)jobName, (String)jobGroup));
    }

    private String longFormatString() {
        return "EEE MMM dd HH:mm:ss zzz yyyy";
    }

    private SimpleDateFormat longFormat(Locale locale) {
        return new SimpleDateFormat(this.longFormatString(), locale);
    }
}

