/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.BreadcrumbBean;
import org.akaza.openclinica.view.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadcrumbTrail {
    private ArrayList<BreadcrumbBean> trail = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger(BreadcrumbTrail.class);

    public BreadcrumbTrail() {
    }

    public BreadcrumbTrail(ArrayList<BreadcrumbBean> trail) {
        this.trail = trail;
    }

    public ArrayList<BreadcrumbBean> getTrail() {
        return this.trail;
    }

    public void setTrail(ArrayList<BreadcrumbBean> trail) {
        this.trail = trail;
    }

    public ArrayList<BreadcrumbBean> generateTrail(Page jspPage, HttpServletRequest request) {
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
        ResourceBundle resworkflow = ResourceBundleProvider.getWorkflowBundle((Locale)locale);
        try {
            if (jspPage.equals((Object)Page.CREATE_DATASET_1)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("create_dataset_instructions"), "CreateDataset" + this.generateURLString(request), Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("select_items_event"), "CreateDataset", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("define_temporal_scope"), "CreateDataset", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("specify_dataset_properties"), "CreateDataset", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("confirm_dataset_properties"), "CreateDataset", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("generate_dataset"), "CreateDataset", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.CREATE_DATASET_2)) {
                this.openBreadcrumbs(2);
                BreadcrumbBean bcb2 = (BreadcrumbBean)this.trail.remove(2);
                bcb2.setStatus(Status.PENDING);
                bcb2.setUrl("CreateDataset" + this.generateURLString(request));
                this.trail.add(2, bcb2);
                this.closeRestOfTrail(2);
            } else if (jspPage.equals((Object)Page.CREATE_DATASET_3)) {
                if (this.trail.size() == 6) {
                    this.openBreadcrumbs(1);
                    ((BreadcrumbBean)this.trail.get(1)).setStatus(Status.UNAVAILABLE);
                    ((BreadcrumbBean)this.trail.get(2)).setStatus(Status.PENDING);
                    ((BreadcrumbBean)this.trail.get(2)).setUrl("CreateDataset" + this.generateURLString(request));
                    this.closeRestOfTrail(2);
                } else {
                    this.openBreadcrumbs(3);
                    BreadcrumbBean bcb2 = (BreadcrumbBean)this.trail.remove(3);
                    bcb2.setStatus(Status.PENDING);
                    bcb2.setUrl("CreateDataset" + this.generateURLString(request));
                    this.trail.add(3, bcb2);
                    this.closeRestOfTrail(3);
                }
            } else if (jspPage.equals((Object)Page.CREATE_DATASET_APPLY_FILTER) || jspPage.equals((Object)Page.APPLY_FILTER)) {
                this.openBreadcrumbs(4);
                BreadcrumbBean bcb2 = (BreadcrumbBean)this.trail.remove(4);
                bcb2.setStatus(Status.PENDING);
                bcb2.setUrl("ApplyFilter" + this.generateURLString(request));
                this.trail.add(4, bcb2);
                this.closeRestOfTrail(4);
            } else if (jspPage.equals((Object)Page.CREATE_DATASET_4)) {
                this.openBreadcrumbs(4);
                BreadcrumbBean bcb2 = (BreadcrumbBean)this.trail.remove(4);
                bcb2.setStatus(Status.PENDING);
                bcb2.setUrl("CreateDataset" + this.generateURLString(request));
                this.trail.add(4, bcb2);
                this.closeRestOfTrail(4);
            } else if (jspPage.equals((Object)Page.CONFIRM_DATASET)) {
                this.openBreadcrumbs(5);
                BreadcrumbBean bcb2 = (BreadcrumbBean)this.trail.remove(5);
                bcb2.setStatus(Status.PENDING);
                bcb2.setUrl("CreateDataset" + this.generateURLString(request));
                this.trail.add(5, bcb2);
                this.closeRestOfTrail(5);
            } else if (jspPage.equals((Object)Page.EXPORT_DATASETS) && this.trail.size() == 7) {
                this.openBreadcrumbs(6);
                BreadcrumbBean bcb2 = (BreadcrumbBean)this.trail.remove(6);
                bcb2.setStatus(Status.PENDING);
                bcb2.setUrl("CreateDataset" + this.generateURLString(request));
                this.trail.add(6, bcb2);
                this.closeRestOfTrail(6);
            } else if (jspPage.equals((Object)Page.EXPORT_DATASETS) && this.trail.size() != 7) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("download_data"), "ExportDataset" + this.generateURLString(request), Status.PENDING));
            } else if (jspPage.equals((Object)Page.CREATE_FILTER_SCREEN_2)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("instructions"), "CreateFiltersOne" + this.generateURLString(request), Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("select_CRF"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("select_section"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("select_parameters"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("specify_criteria"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("export"), "ExportDataset", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.CREATE_FILTER_SCREEN_3)) {
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("select_CRF"), "CreateFiltersTwo" + this.generateURLString(request), Status.PENDING), 2);
                this.closeRestOfTrail(2);
            } else if (jspPage.equals((Object)Page.CREATE_FILTER_SCREEN_3_1)) {
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("select_section"), "CreateFiltersTwo" + this.generateURLString(request), Status.PENDING), 3);
                this.closeRestOfTrail(3);
            } else if (jspPage.equals((Object)Page.CREATE_FILTER_SCREEN_3_2)) {
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("select_parameters"), "CreateFiltersTwo" + this.generateURLString(request), Status.PENDING), 4);
                this.closeRestOfTrail(4);
            } else if (jspPage.equals((Object)Page.CREATE_FILTER_SCREEN_4)) {
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("specify_criteria"), "CreateFiltersTwo" + this.generateURLString(request), Status.PENDING), 5);
                this.closeRestOfTrail(5);
            } else if (jspPage.equals((Object)Page.SUBMIT_DATA)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("submit_data"), "ListStudySubjectsSubmit", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_STUDY_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_subjects"), "ListStudySubject", Status.AVAILABLE));
                if (request.getAttribute("id") != null) {
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("view_study_subject"), "ViewStudySubject?id=" + (String)request.getAttribute("id"), Status.AVAILABLE));
                } else {
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("view_study_subject"), "ViewStudySubject" + this.generateURLString(request), Status.AVAILABLE));
                }
            } else if (jspPage.equals((Object)Page.UPDATE_STUDY_EVENT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_subjects"), "ListStudySubject", Status.AVAILABLE));
                if (request.getAttribute("id") != null) {
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("view_study_subject"), "ViewStudySubject?module=manage&id=" + (String)request.getAttribute("id"), Status.AVAILABLE));
                } else {
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("view_study_subject"), "ViewStudySubject" + this.generateURLString(request), Status.AVAILABLE));
                }
                this.trail.add(new BreadcrumbBean(resworkflow.getString("update_study_event"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.INSTRUCTIONS_ENROLL_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("submit_data"), "ListStudySubjectsSubmit", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("enroll_subject_instructions"), "AddNewSubject?instr=1", Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("enroll_subject"), "AddNewSubject", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("add_new_study_event"), "CreateNewStudyEvent", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("study_event_overview"), "EnterDataForStudyEvent", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("event_CRF_data_submission"), "TableOfContents", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("data_entry"), "InitialDataEntry", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("mark_event_CRF_complete"), "MarkEventCRFComplete", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.ADD_NEW_SUBJECT)) {
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("enroll_subject"), "AddNewSubject", Status.PENDING), 2);
                this.closeRestOfTrail(2);
            } else if (jspPage.equals((Object)Page.CREATE_NEW_STUDY_EVENT)) {
                if (!this.containsServlet("AddNewSubject")) {
                    this.trail = new ArrayList();
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("submit_data"), "ListStudySubjectsSubmit", Status.AVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("add_new_study_event"), "CreateNewStudyEvent", Status.PENDING));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("study_event_overview"), "EnterDataForStudyEvent", Status.UNAVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("event_CRF_data_submission"), "TableOfContents", Status.UNAVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("data_entry"), "InitialDataEntry", Status.UNAVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("mark_event_CRF_complete"), "MarkEventCRFComplete", Status.UNAVAILABLE));
                } else {
                    this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("add_new_study_event"), "CreateNewStudyEvent", Status.PENDING), 3);
                    this.closeRestOfTrail(3);
                }
            } else if (jspPage.equals((Object)Page.ENTER_DATA_FOR_STUDY_EVENT)) {
                int ordinal;
                if (this.containsServlet("AddNewSubject")) {
                    ordinal = 4;
                    this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("study_event_overview"), "EnterDataForStudyEvent" + this.generateURLString(request), Status.PENDING), ordinal);
                } else if (this.containsServlet("CreateNewStudyEvent")) {
                    ordinal = 2;
                    this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("study_event_overview"), "EnterDataForStudyEvent" + this.generateURLString(request), Status.PENDING), ordinal);
                } else {
                    ordinal = 1;
                    this.trail = new ArrayList();
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("submit_data"), "ListStudySubjectsSubmit", Status.AVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("study_event_overview"), "EnterDataForStudyEvent" + this.generateURLString(request), Status.PENDING));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("event_CRF_data_submission"), "TableOfContents", Status.UNAVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("data_entry"), "InitialDataEntry", Status.UNAVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("mark_event_CRF_complete"), "MarkEventCRFComplete", Status.UNAVAILABLE));
                }
                this.closeRestOfTrail(ordinal);
            } else if (jspPage.equals((Object)Page.TABLE_OF_CONTENTS)) {
                int ordinal;
                if (this.containsServlet("EnterDataForStudyEvent")) {
                    ordinal = this.trail.size() - 3;
                    this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("event_CRF_data_submission"), "TableOfContents" + this.generateURLString(request), Status.PENDING), ordinal);
                    this.closeRestOfTrail(ordinal);
                } else {
                    ordinal = 1;
                    this.trail = new ArrayList();
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("submit_data"), "ListStudySubjectsSubmit", Status.AVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("event_CRF_data_submission"), "TableOfContents" + this.generateURLString(request), Status.PENDING));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("data_entry"), "InitialDataEntry", Status.UNAVAILABLE));
                    this.trail.add(new BreadcrumbBean(resworkflow.getString("mark_event_CRF_omplete"), "MarkEventCRFComplete", Status.UNAVAILABLE));
                }
                this.closeRestOfTrail(ordinal);
            } else if (jspPage.equals((Object)Page.INITIAL_DATA_ENTRY)) {
                int ordinal = this.trail.size() - 2;
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("data_entry"), "InitialDataEntry" + this.generateURLString(request), Status.PENDING), ordinal);
                this.closeRestOfTrail(ordinal);
            } else if (jspPage.equals((Object)Page.DOUBLE_DATA_ENTRY)) {
                int ordinal = this.trail.size() - 2;
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("data_entry"), "DoubleDataEntry" + this.generateURLString(request), Status.PENDING), ordinal);
                this.closeRestOfTrail(ordinal);
            } else if (jspPage.equals((Object)Page.MARK_EVENT_CRF_COMPLETE)) {
                int ordinal = this.trail.size() - 1;
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("mark_event_CRF_complete"), "MarkEventCRFComplete" + this.generateURLString(request), Status.PENDING), ordinal);
                this.closeRestOfTrail(ordinal);
            } else if (jspPage.equals((Object)Page.CREATE_STUDY1)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("study_description"), "#", Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("study_status"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("study_design"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("conditions_and_eligibility"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("facility_information"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("related_information"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("confirm_and_submit"), "#", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.CREATE_STUDY2)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("study_status"), "#", Status.PENDING), 1);
                this.closeRestOfTrail(1);
            } else if (jspPage.equals((Object)Page.CREATE_STUDY3) || jspPage.equals((Object)Page.CREATE_STUDY4)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("study_design"), "#", Status.PENDING), 2);
                this.closeRestOfTrail(2);
            } else if (jspPage.equals((Object)Page.CREATE_STUDY5)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("conditions_and_eligibility"), "#", Status.PENDING), 3);
                this.closeRestOfTrail(3);
            } else if (jspPage.equals((Object)Page.CREATE_STUDY6)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("facility_information"), "#", Status.PENDING), 4);
                this.closeRestOfTrail(4);
            } else if (jspPage.equals((Object)Page.CREATE_STUDY7)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("related_information"), "#", Status.PENDING), 5);
                this.closeRestOfTrail(5);
            } else if (jspPage.equals((Object)Page.STUDY_CREATE_CONFIRM)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("confirm_and_submit"), "#", Status.PENDING), 6);
                this.closeRestOfTrail(6);
            } else if (jspPage.equals((Object)Page.UPDATE_STUDY1)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("study_description"), "#", Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("study_status"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("study_design"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("conditions_and_eligibility"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("facility_information"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("related_information"), "#", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("confirm_and_submit"), "#", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.UPDATE_STUDY2)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("study_status"), "#", Status.PENDING), 1);
                this.closeRestOfTrail(1);
            } else if (jspPage.equals((Object)Page.UPDATE_STUDY3) || jspPage.equals((Object)Page.CREATE_STUDY4)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("study_design"), "#", Status.PENDING), 2);
                this.closeRestOfTrail(2);
            } else if (jspPage.equals((Object)Page.UPDATE_STUDY5)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("conditions_and_eligibility"), "#", Status.PENDING), 3);
                this.closeRestOfTrail(3);
            } else if (jspPage.equals((Object)Page.UPDATE_STUDY6)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("facility_information"), "#", Status.PENDING), 4);
                this.closeRestOfTrail(4);
            } else if (jspPage.equals((Object)Page.UPDATE_STUDY7)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("related_information"), "#", Status.PENDING), 5);
                this.closeRestOfTrail(5);
            } else if (jspPage.equals((Object)Page.STUDY_UPDATE_CONFIRM)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("confirm_and_submit"), "#", Status.PENDING), 6);
                this.closeRestOfTrail(6);
            } else if (jspPage.equals((Object)Page.ADMIN_SYSTEM) || jspPage.equals((Object)Page.TECH_ADMIN_SYSTEM)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.ENTERPRISE)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("home"), "MainMenu", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("openclinica_enterprise"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.MANAGE_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.MANAGE_STUDY_BODY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.LIST_USER_IN_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_users"), "ListStudyUser", Status.PENDING));
            } else if (jspPage.equals((Object)Page.LIST_STUDY_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_subjects"), "ListStudySubject", Status.PENDING));
            } else if (jspPage.equals((Object)Page.SITE_LIST)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_sites"), "ListSite", Status.PENDING));
            } else if (jspPage.equals((Object)Page.STUDY_EVENT_DEFINITION_LIST)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.PENDING));
            } else if (jspPage.equals((Object)Page.SUBJECT_GROUP_CLASS_LIST)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_groups"), "ListSubjectGroupClass", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CREATE_SUBJECT_GROUP_CLASS)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_groups"), "ListSubjectGroupClass", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("create_subject_group_class"), "CreateSubjectGroupClass", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CRF_LIST)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.PENDING));
            } else if (jspPage.equals((Object)Page.SUBJECT_LIST)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_subjects"), "ListSubject", Status.PENDING));
            } else if (jspPage.equals((Object)Page.LIST_USER_ACCOUNTS)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_users"), "ListUserAccounts", Status.PENDING));
            } else if (jspPage.equals((Object)Page.STUDY_LIST)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_studies"), "ListStudy", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CREATE_CRF)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("create_a_new_CRF"), "CreateCRF", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CREATE_CRF_VERSION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("upload_spreadsheet"), "#", Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("validate_spreadsheet"), "#", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.CREATE_CRF_VERSION_NODELETE) || jspPage.equals((Object)Page.REMOVE_CRF_VERSION_DEF) || jspPage.equals((Object)Page.REMOVE_CRF_VERSION_CONFIRM)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("upload_spreadsheet"), "#", Status.PENDING), 0);
                this.closeRestOfTrail(0);
            } else if (jspPage.equals((Object)Page.UPLOAD_CRF_VERSION)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("upload_spreadsheet"), "#", Status.PENDING), 1);
                BreadcrumbBean b = (BreadcrumbBean)this.trail.get(0);
                b.setStatus(Status.AVAILABLE);
                this.closeRestOfTrail(2);
            } else if (jspPage.equals((Object)Page.CREATE_CRF_VERSION_CONFIRM)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("validate_spreadsheet"), "#", Status.PENDING), 3);
                this.closeRestOfTrail(3);
            } else if (jspPage.equals((Object)Page.CREATE_CRF_VERSION_CONFIRMSQL)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("review_new_items"), "#", Status.PENDING), 4);
                this.closeRestOfTrail(4);
            } else if (jspPage.equals((Object)Page.CREATE_CRF_VERSION_DONE) || jspPage.equals((Object)Page.CREATE_CRF_VERSION_ERROR)) {
                this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("review_SQL_generated"), "#", Status.PENDING), 5);
                this.closeRestOfTrail(5);
            } else if (jspPage.equals((Object)Page.VIEW_CRF_VERSION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_CRF_version"), "ViewCRFVersion", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_CRF)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_CRF_version"), "ViewCRF", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REMOVE_CRF)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("remove_CRF"), "RemoveCRF", Status.PENDING));
            } else if (jspPage.equals((Object)Page.RESTORE_CRF)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("restore_CRF"), "RestoreCRF", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REMOVE_CRF_VERSION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("remove_CRF"), "RemoveCRFVersion", Status.PENDING));
            } else if (jspPage.equals((Object)Page.RESTORE_CRF_VERSION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("restore_CRF_version"), "RestoreCRFVersion", Status.PENDING));
            } else if (jspPage.equals((Object)Page.UPDATE_CRF)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("update_CRF"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_subjects"), "ListSubject", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_subject"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.UPDATE_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_subjects"), "ListSubject", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("update_subject"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REMOVE_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_subjects"), "ListSubject", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("remove_subject"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.RESTORE_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_subjects"), "ListSubject", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("restore_subject"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_USER_ACCOUNT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_users"), "ListUserAccounts", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_user_account"), "ViewUserAccount" + this.generateURLString(request), Status.PENDING));
            } else if (jspPage.equals((Object)Page.EDIT_ACCOUNT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_system"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_users"), "ListUserAccounts", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("edit_user_account"), "EditUserAccount" + this.generateURLString(request), Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("confirm_user_account_details"), "EditUserAccount", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.EDIT_ACCOUNT_CONFIRM)) {
                this.trail = this.advanceTrail(this.trail, new BreadcrumbBean(resworkflow.getString("confirm_user_account_details"), "EditUserAccount" + this.generateURLString(request), Status.PENDING), 3);
            } else if (jspPage.equals((Object)Page.EDIT_STUDY_USER_ROLE)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_users"), "ListUserAccounts", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("edit_user_role"), "EditStudyUserRole", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CREATE_ACCOUNT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_users"), "ListUserAccounts", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("create_user_account"), "CreateUserAccount", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REASSIGN_STUDY_SUBJECT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_subjects"), "ListStudySubject", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("reassign_study_subject"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.DEFINE_STUDY_EVENT1)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("create_study_event_definition"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.UPDATE_EVENT_DEFINITION1)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("update_study_event_definition"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_EVENT_DEFINITION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_event_definition"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CHANGE_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("home"), "MainMenu", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("change_current_study"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.UPDATE_PROFILE)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("home"), "MainMenu", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("update_user_profile"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CREATE_SUB_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_sites"), "ListSite", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("create_new_site"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_SITE)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_sites"), "ListSite", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_site"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.SET_USER_ROLE_IN_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_users"), "ListStudyUser", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("set_user_role"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.STUDY_USER_LIST)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_users"), "ListStudyUser", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("assign_new_users_to_study"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.LOCK_DEFINITION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("lock_event_definition"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.UNLOCK_DEFINITION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("unlock_event_definition"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_USER_IN_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_users"), "ListStudyUser", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_user_details"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REMOVE_USER_ROLE_IN_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_users"), "ListStudyUser", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("remove_user_role"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REMOVE_DEFINITION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("remove_event_definition"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.RESTORE_DEFINITION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_event_definitions"), "ListEventDefinition", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("restore_event_definition"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_studies"), "ListStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_study_details"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.SET_USER_ROLE)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_users"), "ListUserAccounts", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("set_user_role"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REMOVE_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_studies"), "ListStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("remove_a_study"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.RESTORE_STUDY)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("business_admin"), "AdminSystem", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("administer_studies"), "ListStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("restore_a_study"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.REMOVE_SITE)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_sites"), "ListSite", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("remove_a_site"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.RESTORE_SITE)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_sites"), "ListSite", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("restore_a_site"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.MENU)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("home"), "MainMenu", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_TABLE_OF_CONTENT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_CRF_version_data_entry"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_SECTION_DATA_ENTRY) || jspPage.equals((Object)Page.VIEW_SECTION_DATA_ENTRY_SERVLET)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_CRF_version_section_data"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_EVENT_CRF_CONTENT)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_subjects"), "ListStudySubject", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_study_subject"), "ViewStudySubject" + this.generateURLString(request), Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_event_CRF_data"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_STUDY_EVENTS)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_events"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.DELETE_CRF_VERSION)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_CRFs"), "ListCRF", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("delete_CRF_version"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.MENU)) {
                this.trail = new ArrayList();
            } else if (jspPage.equals((Object)Page.EDIT_DATASET)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("edit_dataset_items_attributes"), "#", Status.PENDING));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("define_temporal_scope"), "CreateDataset", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("specify_dataset_properties"), "CreateDataset", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("confirm_dataset_properties"), "CreateDataset", Status.UNAVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("generate_dataset"), "CreateDataset", Status.UNAVAILABLE));
            } else if (jspPage.equals((Object)Page.EDIT_FILTER)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("edit_filter"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_DATASET_DETAILS)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_dataset_details"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.EXTRACT_DATASETS_MAIN)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("home"), "MainMenu", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_DATASETS)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_dataset"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.CREATE_FILTER_SCREEN_1)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("extract_datasets"), "ExtractDatasetsMain", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("view_filters"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_RULES)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("rule_manage_assignment"), "ViewRuleAssignment", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("rule_manage"), "#", Status.PENDING));
            } else if (jspPage.equals((Object)Page.VIEW_RULE_SETS)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("manage_study"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("rule_manage_assignment"), "ViewRuleAssignment", Status.AVAILABLE));
            } else if (jspPage.equals((Object)Page.IMPORT_RULES)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("import_rules_1"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("import_rules_2"), "ViewRuleAssignment", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("import_rules_3"), "#", Status.AVAILABLE));
            } else if (jspPage.equals((Object)Page.TEST_RULES)) {
                this.trail = new ArrayList();
                this.trail.add(new BreadcrumbBean(resworkflow.getString("test_rules_validate"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("test_rules_test"), "ManageStudy", Status.AVAILABLE));
                this.trail.add(new BreadcrumbBean(resworkflow.getString("test_rules_get_results"), "TestRule", Status.AVAILABLE));
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            logger.error("Error while generating trial: ", (Throwable)ioobe);
            this.trail = new ArrayList();
        }
        return this.trail;
    }

    public String generateURLString(HttpServletRequest request) {
        String newURL = "?";
        FormProcessor fp = new FormProcessor(request);
        Enumeration en = ClassCastHelper.asEnumeration((Object)request.getParameterNames(), String.class);
        while (en.hasMoreElements()) {
            String title = (String)en.nextElement();
            String value = fp.getString(title);
            newURL = newURL + title + "=" + value + "&";
        }
        return newURL;
    }

    public ArrayList<BreadcrumbBean> advanceTrail(ArrayList<BreadcrumbBean> trail, BreadcrumbBean newBean, int ordinal) {
        BreadcrumbBean bcb;
        int previous = ordinal - 1;
        if (previous >= 0 && previous < trail.size()) {
            bcb = trail.remove(previous);
            bcb.setStatus(Status.AVAILABLE);
            trail.add(previous, bcb);
        }
        if (ordinal >= 0 && ordinal < trail.size()) {
            bcb = trail.remove(ordinal);
            trail.add(ordinal, newBean);
        }
        return trail;
    }

    public boolean containsServlet(String servlet) {
        servlet = servlet.toLowerCase();
        for (int i = 0; i < this.trail.size(); ++i) {
            BreadcrumbBean b = (BreadcrumbBean)this.trail.get(i);
            if (b.getUrl().toLowerCase().indexOf(servlet) < 0) continue;
            return true;
        }
        return false;
    }

    private void closeRestOfTrail(int ordinal) {
        if (ordinal < 0) {
            return;
        }
        for (int i = ordinal + 1; i < this.trail.size(); ++i) {
            BreadcrumbBean b = (BreadcrumbBean)this.trail.get(i);
            b.setStatus(Status.UNAVAILABLE);
            this.trail.set(i, b);
        }
    }

    private void openBreadcrumbs(int ordinal) {
        if (ordinal < 0 || ordinal > this.trail.size()) {
            return;
        }
        for (int i = 0; i < ordinal; ++i) {
            BreadcrumbBean b = (BreadcrumbBean)this.trail.get(i);
            b.setStatus(Status.AVAILABLE);
            this.trail.set(i, b);
        }
    }
}

