/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.i18n.util.HtmlUtils;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.form.InputGenerator;
import org.akaza.openclinica.view.form.NbspaceContent;
import org.jdom.Content;
import org.jdom.Element;

public class DataEntryInputGenerator
implements InputGenerator {
    private static Map<String, String> NULL_VALUES_INITVERSION = new HashMap();
    public static Map<String, String> NULL_VALUES_LONGVERSION;
    public static String ONCHANGE_TEXT_INPUT;
    public static String ONCHANGE_TEXT_INPUT_RADIOS;

    public Element createTextInputTag(Element tdCell, Integer itemId, Integer tabNumber, String defaultValue, boolean isDateType, String dbValue, boolean hasSavedData) {
        Element element;
        block16: {
            Date parsedValue;
            String pattn = "";
            pattn = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
            SimpleDateFormat dateFormat = null;
            if (isDateType) {
                dateFormat = new SimpleDateFormat(pattn);
            }
            element = new Element("input");
            element.setAttribute("type", "text");
            element.setAttribute("tabindex", tabNumber.toString());
            element.setAttribute("name", "input" + itemId.toString());
            element.setAttribute("onChange", ONCHANGE_TEXT_INPUT);
            if (dbValue != null && dbValue.length() > 0) {
                if (isDateType) {
                    try {
                        parsedValue = HtmlUtils.parseDateValue((String)dbValue);
                        if (parsedValue != null) {
                            element.setAttribute("value", dateFormat.format(parsedValue));
                            break block16;
                        }
                        element.setAttribute("value", dbValue);
                    }
                    catch (Exception excep) {
                        element.setAttribute("value", dbValue);
                    }
                } else {
                    element.setAttribute("value", dbValue);
                }
            } else if (!hasSavedData) {
                if (isDateType) {
                    try {
                        parsedValue = HtmlUtils.parseDateValue((String)defaultValue);
                        if (parsedValue != null) {
                            element.setAttribute("value", dateFormat.format(parsedValue));
                            break block16;
                        }
                        element.setAttribute("value", defaultValue);
                    }
                    catch (Exception excep) {
                        element.setAttribute("value", defaultValue);
                    }
                } else {
                    element.setAttribute("value", defaultValue);
                }
            } else {
                element.setAttribute("value", "");
            }
        }
        tdCell.addContent((Content)element);
        if (isDateType) {
            Element dateElement = this.getDateWidgetForCell(itemId);
            tdCell.addContent((Content)dateElement);
        }
        return tdCell;
    }

    public Element createCheckboxTag(Element tdCell, Integer itemId, List<ResponseOptionBean> options, Integer tabNumber, boolean includeLabel, String dbValue, String defaultValue, boolean isHorizontal, boolean hasSavedData) {
        String[] arrayOfValues = new String[]{};
        int count = 0;
        if (dbValue != null && dbValue.length() > 0) {
            arrayOfValues = this.handleSplitString(dbValue);
        } else if (!hasSavedData && defaultValue != null && defaultValue.length() > 0) {
            arrayOfValues = this.handleSplitString(defaultValue);
        }
        for (ResponseOptionBean responseOptBean : options) {
            boolean isFirstInGroup = ++count == 1;
            Element element = this.initializeInputElement("checkbox", itemId, tabNumber);
            String value = responseOptBean.getValue();
            String forDefVal = responseOptBean.getText();
            element.setAttribute("value", value);
            if (dbValue != null && dbValue.length() > 0) {
                for (String string : arrayOfValues) {
                    if (!value.equalsIgnoreCase(string)) continue;
                    element.setAttribute("checked", "checked");
                }
            } else if (!hasSavedData && defaultValue != null && defaultValue.length() > 0) {
                for (String string : arrayOfValues) {
                    if (!forDefVal.equalsIgnoreCase(string) && !value.equalsIgnoreCase(string)) continue;
                    element.setAttribute("checked", "checked");
                }
            }
            if (!isHorizontal && isFirstInGroup) {
                tdCell.addContent((Content)new Element("br"));
            }
            tdCell.addContent((Content)element);
            if (includeLabel) {
                tdCell.addContent(responseOptBean.getText());
            }
            if (isHorizontal) continue;
            tdCell.addContent((Content)new Element("br"));
        }
        return tdCell;
    }

    public Element createRadioButtonTag(Element tdCell, Integer itemId, List<ResponseOptionBean> options, Integer tabNumber, boolean includeLabel, String dbValue, String defaultValue, boolean isHorizontal, boolean hasSavedData) {
        if (itemId == 0) {
            Random rand = new Random();
            itemId = rand.nextInt(10000) + 1;
        }
        int count = 0;
        for (ResponseOptionBean responseOptBean : options) {
            boolean isFirstInGroup = ++count == 1;
            Element element = this.initializeInputElement("radio", itemId, tabNumber);
            String value = responseOptBean.getValue();
            String forDefVal = responseOptBean.getText();
            element.setAttribute("value", value);
            if (dbValue != null && dbValue.length() > 0 && value.equalsIgnoreCase(dbValue)) {
                element.setAttribute("checked", "checked");
            }
            if (!hasSavedData && defaultValue != null && (forDefVal.equalsIgnoreCase(defaultValue) || value.equalsIgnoreCase(defaultValue))) {
                element.setAttribute("checked", "checked");
            }
            if (isHorizontal) {
                element.setAttribute("onclick", "if(detectIEWindows(navigator.userAgent)){this.checked=true; unCheckSiblings(this,'horizontal');}");
            } else {
                element.setAttribute("onclick", "if(detectIEWindows(navigator.userAgent)){this.checked=true; unCheckSiblings(this,'vertical');}");
            }
            if (!isHorizontal && isFirstInGroup) {
                tdCell.addContent((Content)new Element("br"));
            }
            tdCell.addContent((Content)element);
            tdCell.addContent(" ");
            if (includeLabel) {
                tdCell.addContent(responseOptBean.getText());
            }
            if (isHorizontal) continue;
            tdCell.addContent((Content)new Element("br"));
        }
        return tdCell;
    }

    public Element createSingleSelectTag(Element tdCell, Integer itemId, List<ResponseOptionBean> options, Integer tabNumber) {
        Element element = new Element("select");
        element.setAttribute("tabindex", tabNumber.toString());
        if (element.getAttribute("name") == null) {
            element.setAttribute("name", "item" + itemId.toString());
        }
        element.setAttribute("onChange", ONCHANGE_TEXT_INPUT);
        element.setAttribute("class", "formfield");
        for (ResponseOptionBean responseOptBean : options) {
            Element optElement = new Element("option");
            String optValue = responseOptBean.getValue();
            String optText = responseOptBean.getText();
            optElement.setAttribute("value", optValue);
            if (responseOptBean.isSelected()) {
                optElement.setAttribute("selected", "selected");
            }
            optElement.addContent(optText);
            element.addContent((Content)optElement);
        }
        tdCell.addContent((Content)element);
        return tdCell;
    }

    public Element createSingleSelectTag(Element tdCell, Integer itemId, List<ResponseOptionBean> options, Integer tabNumber, String defaultValue, String databaseValue, boolean hasSavedData) {
        ResponseOptionBean option;
        int i;
        if (databaseValue != null && databaseValue.length() > 0) {
            Element select = (tdCell = this.createSingleSelectTag(tdCell, itemId, options, tabNumber)).getChild("select");
            if (select != null) {
                List optElements = ClassCastHelper.asList((Object)select.getChildren("option"), Element.class);
                String optVal = "";
                for (Element opts : optElements) {
                    optVal = opts.getAttribute("value").getValue();
                    if (opts.getAttribute("selected") != null) {
                        opts.removeAttribute("selected");
                    }
                    if (!optVal.equalsIgnoreCase(databaseValue)) continue;
                    opts.setAttribute("selected", "selected");
                }
            }
            return tdCell;
        }
        int selectedOption = -1;
        boolean foundMatch = false;
        boolean printDefault = false;
        for (i = 0; i < options.size(); ++i) {
            option = options.get(i);
            if (!option.isSelected()) continue;
            selectedOption = i;
            break;
        }
        if (defaultValue.length() > 0 && !hasSavedData) {
            printDefault = true;
            for (i = 0; i < options.size(); ++i) {
                option = options.get(i);
                if (!defaultValue.equalsIgnoreCase(option.getText()) && !defaultValue.equalsIgnoreCase(option.getValue())) continue;
                if (selectedOption == -1) {
                    selectedOption = i;
                }
                printDefault = false;
                foundMatch = true;
                break;
            }
        }
        ArrayList<ResponseOptionBean> op = new ArrayList<ResponseOptionBean>();
        if (!foundMatch) {
            if (printDefault) {
                ResponseOptionBean ro = new ResponseOptionBean();
                ro.setText(defaultValue);
                ro.setValue("");
                op.add(ro);
                op.addAll(options);
            }
        } else {
            options.get(selectedOption).setSelected(true);
        }
        tdCell = op.size() > 0 ? this.createSingleSelectTag(tdCell, itemId, op, tabNumber) : this.createSingleSelectTag(tdCell, itemId, options, tabNumber);
        return tdCell;
    }

    public Element createMultiSelectTag(Element tdCell, Integer itemId, List<ResponseOptionBean> options, Integer tabNumber, String dbValue, String defaultValue, boolean hasSavedData) {
        String[] arrayOfValues = new String[]{};
        boolean hasDBValue = false;
        boolean hasDefaultValue = false;
        ArrayList<String> dbValues = new ArrayList<String>();
        ArrayList<String> defValues = new ArrayList<String>();
        if (dbValue != null && dbValue.length() > 0) {
            dbValues = new ArrayList();
            for (String subVal : arrayOfValues = this.handleSplitString(dbValue)) {
                dbValues.add(subVal);
            }
            hasDBValue = true;
        }
        if (defaultValue != null && defaultValue.length() > 0 && !hasSavedData) {
            defValues = new ArrayList();
            for (String subVal : arrayOfValues = this.handleSplitString(defaultValue)) {
                defValues.add(subVal);
            }
            hasDefaultValue = true;
        }
        Element element = new Element("select");
        element.setAttribute("tabindex", tabNumber.toString());
        if (element.getAttribute("name") == null) {
            element.setAttribute("name", "item" + itemId.toString());
        }
        element.setAttribute("multiple", "multiple");
        element.setAttribute("size", "2");
        for (ResponseOptionBean responseOptBean : options) {
            Element optElement = new Element("option");
            String optValue = responseOptBean.getValue();
            String optText = responseOptBean.getText();
            optElement.setAttribute("value", optValue);
            if (hasDBValue) {
                if (dbValues.contains(optValue)) {
                    optElement.setAttribute("selected", "selected");
                }
            } else if (hasDefaultValue) {
                if (defValues.contains(optValue) || defValues.contains(optText)) {
                    optElement.setAttribute("selected", "selected");
                }
            } else if (responseOptBean.isSelected()) {
                optElement.setAttribute("selected", "selected");
            }
            optElement.addContent(optText);
            element.addContent((Content)optElement);
        }
        tdCell.addContent((Content)element);
        return tdCell;
    }

    public Element createTextareaTag(Element tdCell, Integer itemId, Integer tabNumber, String dbValue, String defaultValue, boolean hasSavedData) {
        Element element = new Element("textarea");
        element.setAttribute("tabindex", tabNumber.toString());
        if (element.getAttribute("name") == null) {
            element.setAttribute("name", "item" + itemId.toString());
        }
        element.setAttribute("onChange", ONCHANGE_TEXT_INPUT);
        element.setAttribute("rows", "5");
        if (dbValue != null && dbValue.length() > 0) {
            element.addContent(dbValue);
        } else if (defaultValue != null && defaultValue.length() > 0 && !hasSavedData) {
            element.addContent(defaultValue);
        } else {
            element.addContent((Content)new NbspaceContent());
        }
        tdCell.addContent((Content)element);
        return tdCell;
    }

    public Element createFileTag(Element tdCell, String dbValue, boolean forPrinting) {
        if (forPrinting) {
            Element e = new Element("input");
            e.setAttribute("type", "text");
            e.setAttribute("value", dbValue);
            tdCell.addContent((Content)e);
        } else {
            Element element1 = new Element("input");
            element1.setAttribute("type", "text");
            element1.setAttribute("disabled", "disabled");
            element1.setAttribute("class", "disabled");
            tdCell.addContent((Content)element1);
            Element element2 = new Element("input");
            element2.setAttribute("type", "button");
            element2.setAttribute("value", "click to upload file");
            tdCell.addContent((Content)element2);
        }
        return tdCell;
    }

    public Element createCaculationTag(Element tdCell, Integer itemId, ResponseSetBean responseSet, boolean isDateType, String dbValue, boolean hasSavedData) {
        Element element2;
        block16: {
            Element element;
            SimpleDateFormat dateFormat;
            block15: {
                String pattn = "";
                pattn = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
                dateFormat = null;
                if (isDateType) {
                    dateFormat = new SimpleDateFormat(pattn);
                }
                element = new Element("input");
                element.setAttribute("type", "hidden");
                element.setAttribute("name", "input" + itemId.toString());
                if (dbValue != null && dbValue.length() > 0) {
                    if (isDateType) {
                        try {
                            Date parsedValue = HtmlUtils.parseDateValue((String)dbValue);
                            if (parsedValue != null) {
                                element.setAttribute("value", dateFormat.format(parsedValue));
                                break block15;
                            }
                            element.setAttribute("value", dbValue);
                        }
                        catch (Exception excep) {
                            element.setAttribute("value", dbValue);
                        }
                    } else {
                        element.setAttribute("value", dbValue);
                    }
                } else {
                    element.setAttribute("value", "");
                }
            }
            tdCell.addContent((Content)element);
            element2 = new Element("input");
            element2.setAttribute("type", "text");
            element2.setAttribute("disabled", "disabled");
            element2.setAttribute("class", "disabled");
            if (dbValue != null && dbValue.length() > 0) {
                if (isDateType) {
                    try {
                        Date parsedValue = HtmlUtils.parseDateValue((String)dbValue);
                        if (parsedValue != null) {
                            element2.setAttribute("value", dateFormat.format(parsedValue));
                            break block16;
                        }
                        element2.setAttribute("value", dbValue);
                    }
                    catch (Exception excep) {
                        element2.setAttribute("value", dbValue);
                    }
                } else {
                    element2.setAttribute("value", dbValue);
                }
            } else {
                element2.setAttribute("value", "");
            }
        }
        tdCell.addContent((Content)element2);
        return tdCell;
    }

    public Element createInstantTag(Element tdCell, Integer itemId, Integer tabNumber, String dbValue, boolean hasSavedData) {
        Element element = new Element("input");
        element.setAttribute("type", "text");
        element.setAttribute("tabindex", tabNumber.toString());
        element.setAttribute("name", "input" + itemId.toString());
        element.setAttribute("onChange", ONCHANGE_TEXT_INPUT);
        element.setAttribute("value", "");
        if (dbValue != null && dbValue.length() > 0) {
            element.setAttribute("value", dbValue);
        } else {
            element.setAttribute("value", "");
        }
        tdCell.addContent((Content)element);
        return tdCell;
    }

    public Element initializeInputElement(String inputType, Integer itemId, Integer tabNumber) {
        Element element = new Element("input");
        element.setAttribute("type", inputType);
        element.setAttribute("tabindex", tabNumber.toString());
        if (element.getAttribute("name") == null) {
            element.setAttribute("name", "item" + itemId.toString());
        }
        if (!inputType.equalsIgnoreCase("radio")) {
            element.setAttribute("onChange", ONCHANGE_TEXT_INPUT);
        } else {
            element.setAttribute("onChange", ONCHANGE_TEXT_INPUT_RADIOS);
        }
        return element;
    }

    public Element getDateWidgetForCell(Integer itemId) {
        Element href = new Element("a");
        href.setAttribute("href", "#");
        String pattn = "";
        pattn = ResourceBundleProvider.getFormatBundle().getString("date_format_calender");
        StringBuilder sbuilder = new StringBuilder("Calendar.setup({inputField  : getSib(this.previousSibling), ifFormat    :'");
        sbuilder.append(pattn).append("',").append("button     :'anchor").append(itemId).append("'});");
        href.setAttribute("onmouseover", sbuilder.toString());
        href.setAttribute("name", "anchor" + itemId);
        href.setAttribute("id", "anchor" + itemId);
        Element img = new Element("img");
        img.setAttribute("src", "images/bt_Calendar.gif");
        img.setAttribute("alt", ResourceBundleProvider.getWordsBundle().getString("show_calendar"));
        img.setAttribute("title", ResourceBundleProvider.getWordsBundle().getString("show_calendar"));
        img.setAttribute("border", "0");
        href.addContent((Content)img);
        return href;
    }

    public Element createRequiredAlert(Element tdCell) {
        Element alertReq = new Element("span");
        alertReq.setAttribute("class", "alert");
        alertReq.addContent("*");
        tdCell.addContent((Content)alertReq);
        return tdCell;
    }

    public Element createDiscrepancyNoteSymbol(Integer numDiscrepancyNotes, Integer tabNumber, Integer itemDataId, Integer itemId, boolean forPrinting) {
        Element ahref = new Element("a");
        ahref.setAttribute("tabindex", tabNumber + 1000 + "");
        ahref.setAttribute("href", "#");
        StringBuilder clickValue = new StringBuilder("");
        if (forPrinting) {
            clickValue.append("javascript:void 0");
        }
        ahref.setAttribute("onClick", clickValue.toString());
        Element img = new Element("img");
        img.setAttribute("name", "flag_input" + itemId);
        String fileName = numDiscrepancyNotes > 0 ? "icon_Note.gif" : "icon_noNote.gif";
        img.setAttribute("src", "images/" + fileName);
        img.setAttribute("border", "0");
        img.setAttribute("alt", ResourceBundleProvider.getWordsBundle().getString("discrepancy_note"));
        img.setAttribute("title", ResourceBundleProvider.getWordsBundle().getString("discrepancy_note"));
        ahref.addContent((Content)img);
        return ahref;
    }

    public Element createInputErrorMessage(Map<Object, ArrayList<String>> messages, Integer itemId) {
        String key = "input" + itemId;
        ArrayList<String> _messages = messages.get(key);
        String errMsg = "";
        Iterator<String> iterator = _messages.iterator();
        while (iterator.hasNext()) {
            String msg;
            errMsg = msg = iterator.next();
        }
        Element msgSpan = new Element("span");
        msgSpan.setAttribute("id", "spanAlert-" + key);
        msgSpan.setAttribute("class", "alert");
        msgSpan.addContent(errMsg);
        return msgSpan;
    }

    public String[] handleSplitString(String param) {
        if (param == null) {
            return new String[0];
        }
        String[] values = null;
        values = param.indexOf(",") != -1 ? param.split(",") : new String[]{param};
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    static {
        NULL_VALUES_INITVERSION.put("NI", ResourceBundleProvider.getTermsBundle().getString("no_information"));
        NULL_VALUES_INITVERSION.put("NA", ResourceBundleProvider.getTermsBundle().getString("not_applicable"));
        NULL_VALUES_INITVERSION.put("UNK", ResourceBundleProvider.getTermsBundle().getString("unknown"));
        NULL_VALUES_INITVERSION.put("NASK", ResourceBundleProvider.getTermsBundle().getString("not_asked"));
        NULL_VALUES_INITVERSION.put("ASKU", ResourceBundleProvider.getTermsBundle().getString("asked_but_unknown"));
        NULL_VALUES_INITVERSION.put("NAV", ResourceBundleProvider.getTermsBundle().getString("not_available"));
        NULL_VALUES_INITVERSION.put("OTH", ResourceBundleProvider.getTermsBundle().getString("other"));
        NULL_VALUES_INITVERSION.put("PINF", ResourceBundleProvider.getTermsBundle().getString("positive_infinity"));
        NULL_VALUES_INITVERSION.put("NINF", ResourceBundleProvider.getTermsBundle().getString("negative_infinity"));
        NULL_VALUES_INITVERSION.put("MSK", ResourceBundleProvider.getTermsBundle().getString("masked"));
        NULL_VALUES_INITVERSION.put("NP", ResourceBundleProvider.getTermsBundle().getString("not_present"));
        NULL_VALUES_INITVERSION.put("NPE", ResourceBundleProvider.getTermsBundle().getString("not_performed"));
        NULL_VALUES_LONGVERSION = Collections.unmodifiableMap(NULL_VALUES_INITVERSION);
        ONCHANGE_TEXT_INPUT = "this.className='changedField';setImage('DataStatus_top','images/icon_UnsavedData.gif');setImage('DataStatus_bottom','images/icon_UnsavedData.gif');";
        ONCHANGE_TEXT_INPUT_RADIOS = "if(! detectIEWindows(navigator.userAgent)){this.className='changedField';}setImage('DataStatus_top','images/icon_UnsavedData.gif');setImage('DataStatus_bottom','images/icon_UnsavedData.gif');";
    }
}

